/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.pwdpolicy;

import java.util.Collections;
import java.util.List;
import javax.jcr.RepositoryException;
import org.jahia.exceptions.JahiaException;
import org.jahia.exceptions.JahiaInitializationException;
import org.jahia.exceptions.JahiaRuntimeException;
import org.jahia.services.JahiaService;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.pwdpolicy.EvaluationContext;
import org.jahia.services.pwdpolicy.JahiaPasswordPolicy;
import org.jahia.services.pwdpolicy.JahiaPasswordPolicyManager;
import org.jahia.services.pwdpolicy.PasswordHistoryEntry;
import org.jahia.services.pwdpolicy.PolicyEnforcementResult;
import org.jahia.services.pwdpolicy.PolicyEvaluator;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaPasswordPolicyService
extends JahiaService {
    private static Logger logger = LoggerFactory.getLogger(JahiaPasswordPolicyService.class);
    private static JahiaPasswordPolicyService service = new JahiaPasswordPolicyService();
    private JahiaPasswordPolicy defaultPasswordPolicy;
    private JahiaPasswordPolicyManager policyMgr;
    private JahiaUserManagerService userMgrService;
    private boolean policyEnforcementEnabled;

    public static JahiaPasswordPolicyService getInstance() {
        return service;
    }

    private PolicyEnforcementResult enforcePolicy(JCRUserNode user, String username, String password, boolean isUserInitiated, boolean onlyPeriodicalRules) {
        PolicyEnforcementResult evaluationResult = PolicyEnforcementResult.SUCCESS;
        if (user == null && this.isPolicyEnforcementEnabled() || this.isPolicyEnabled(user)) {
            JahiaPasswordPolicy policy = this.getDefaultPolicy();
            if (policy != null) {
                evaluationResult = PolicyEvaluator.evaluate(policy, user != null ? new EvaluationContext(user, password, isUserInitiated) : new EvaluationContext(username, password), onlyPeriodicalRules);
            } else {
                logger.warn("Unable to get the default password policy. Skipping policy enforcement");
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("Policy enforcement not enabled for user " + user.getName() + ". Skipping password policy enforcement.");
        }
        return evaluationResult;
    }

    public PolicyEnforcementResult enforcePolicyOnLogin(JCRUserNode user) {
        return this.enforcePolicy(user, null, null, false, true);
    }

    public PolicyEnforcementResult enforcePolicyOnPasswordChange(JCRUserNode user, String password, boolean isUserInitiated) {
        return this.enforcePolicy(user, null, password, isUserInitiated, false);
    }

    public PolicyEnforcementResult enforcePolicyOnUserCreate(String username, String password) {
        return this.enforcePolicy(null, username, password, false, false);
    }

    public JahiaPasswordPolicy getDefaultPolicy() {
        JahiaPasswordPolicy defPolicy;
        try {
            defPolicy = this.policyMgr.getDefaultPolicy();
        }
        catch (RepositoryException e) {
            throw new JahiaRuntimeException(e);
        }
        if (defPolicy == null) {
            JahiaPasswordPolicy copy = (JahiaPasswordPolicy)this.defaultPasswordPolicy.clone();
            try {
                this.policyMgr.update(copy);
            }
            catch (RepositoryException e) {
                throw new JahiaRuntimeException(e);
            }
            defPolicy = copy;
        }
        return defPolicy;
    }

    public boolean isPolicyEnforcementEnabled() {
        return this.policyEnforcementEnabled;
    }

    public boolean isPolicyEnabled(JCRUserNode user) {
        if (user == null) {
            throw new IllegalArgumentException("The specified user is null");
        }
        return this.isPolicyEnforcementEnabled() && !this.isPasswordReadOnly(user);
    }

    public void setDefaultPasswordPolicy(JahiaPasswordPolicy defaultPasswordPolicy) {
        this.defaultPasswordPolicy = defaultPasswordPolicy;
    }

    public void setPasswordPolicyManager(JahiaPasswordPolicyManager mgr) {
        this.policyMgr = mgr;
    }

    @Override
    public void start() throws JahiaInitializationException {
    }

    @Override
    public void stop() throws JahiaException {
    }

    public void updatePolicy(JahiaPasswordPolicy policy) {
        try {
            this.policyMgr.update(policy);
        }
        catch (RepositoryException e) {
            throw new JahiaRuntimeException(e);
        }
    }

    public boolean isPasswordReadOnly(JCRUserNode user) {
        return user.getProvider().isReadOnly();
    }

    public void setUserManagerService(JahiaUserManagerService userMgrService) {
        this.userMgrService = userMgrService;
    }

    public List<PasswordHistoryEntry> getPasswordHistory(JCRUserNode user) {
        List<PasswordHistoryEntry> passwordHistory;
        try {
            passwordHistory = this.policyMgr.getPasswordHistory(user);
        }
        catch (RepositoryException e) {
            passwordHistory = Collections.emptyList();
            logger.error("Error while retrieving a password history for user: " + user.getName(), (Throwable)e);
        }
        return passwordHistory;
    }

    public void storePasswordHistory(JCRUserNode user) {
        try {
            this.policyMgr.storePasswordHistory(user);
        }
        catch (RepositoryException e) {
            logger.error("Error while storing a password history for user: " + user.getName(), (Throwable)e);
        }
    }

    public void setPolicyEnforcementEnabled(boolean policyEnabled) {
        this.policyEnforcementEnabled = policyEnabled;
    }
}

