/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.importexport.validation;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRStoreProvider;
import org.jahia.services.content.JCRStoreService;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.importexport.validation.ImportValidator;
import org.jahia.services.importexport.validation.ProviderAvailabilityValidatorResult;
import org.jahia.services.importexport.validation.ValidationResult;
import org.xml.sax.Attributes;

public class ProviderAvailabilityValidator
implements ImportValidator {
    private JCRSessionFactory jcrSessionFactory;
    private JCRSessionWrapper currentUserSession;
    private Set<String> visitedPaths = new TreeSet<String>();
    private Set<String> neededStaticProviders = new LinkedHashSet<String>();
    private Set<String> neededDynamicProviders = new LinkedHashSet<String>();
    private Set<String> neededMountPoint = new LinkedHashSet<String>();

    @Override
    public ValidationResult getResult() {
        try {
            Map<String, JCRStoreProvider> providers = this.jcrSessionFactory.getProviders();
            LinkedHashSet<String> unavailableProviders = new LinkedHashSet<String>();
            for (String p : this.neededStaticProviders) {
                if (providers.containsKey(p) && providers.get(p).isAvailable()) continue;
                unavailableProviders.add(p);
            }
            for (String p : this.neededDynamicProviders) {
                String identifier;
                if (this.visitedPaths.contains(p) || this.getCurrentUserSession().nodeExists(p) && providers.containsKey(identifier = this.getCurrentUserSession().getNode(p).getIdentifier()) && providers.get(identifier).isAvailable()) continue;
                unavailableProviders.add(p);
            }
            for (String type : this.neededMountPoint) {
                if (JCRStoreService.getInstance().getProviderFactories().get(type) != null) continue;
                unavailableProviders.add(type);
            }
            return new ProviderAvailabilityValidatorResult(unavailableProviders);
        }
        catch (RepositoryException e) {
            return new ValidationResult.FailedValidationResult((Exception)((Object)e));
        }
    }

    @Override
    public void validate(String decodedLocalName, String decodedQName, String currentPath, Attributes atts) {
        String path = StringUtils.removeStart((String)currentPath, (String)"/content");
        if (StringUtils.isNotBlank((String)path)) {
            this.visitedPaths.add(path);
        }
        String type = atts.getValue("jcr:primaryType");
        try {
            if (type != null && NodeTypeRegistry.getInstance().getNodeType(type).isNodeType("jnt:mountPoint")) {
                this.neededMountPoint.add(type);
            }
        }
        catch (NoSuchNodeTypeException e) {
            // empty catch block
        }
        if (atts.getIndex("j:staticMountPointProviderKey") > -1) {
            this.neededStaticProviders.add(atts.getValue("j:staticMountPointProviderKey"));
        }
        if (atts.getIndex("j:dynamicMountPointProviderPath") > -1) {
            this.neededDynamicProviders.add(atts.getValue("j:dynamicMountPointProviderPath"));
        }
    }

    private JCRSessionWrapper getCurrentUserSession() throws RepositoryException {
        if (this.currentUserSession == null) {
            this.currentUserSession = this.jcrSessionFactory.getCurrentUserSession();
        }
        return this.currentUserSession;
    }

    public void setJcrSessionFactory(JCRSessionFactory jcrSessionFactory) {
        this.jcrSessionFactory = jcrSessionFactory;
    }
}

