/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.importexport.validation;

import java.io.Serializable;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.importexport.validation.ValidationResult;

public class MissingModulesValidationResult
implements ValidationResult,
Serializable {
    private static final long serialVersionUID = 5602829144652574806L;
    private Set<String> missing = new TreeSet<String>();
    private String targetTemplateSet;
    private boolean targetTemplateSetPresent;

    protected MissingModulesValidationResult(MissingModulesValidationResult result1, MissingModulesValidationResult result2) {
        this.targetTemplateSet = result1.getTargetTemplateSet();
        this.targetTemplateSetPresent = result1.isTargetTemplateSetPresent();
        if (this.targetTemplateSetPresent && !result2.isTargetTemplateSetPresent()) {
            this.targetTemplateSet = result2.getTargetTemplateSet();
            this.targetTemplateSetPresent = false;
        }
        this.missing.addAll(result1.getMissingModules());
        this.missing.addAll(result2.getMissingModules());
    }

    public MissingModulesValidationResult(Set<String> missingModules, String targetTemplateSet, boolean targetTemplateSetPresent) {
        if (this.missing != null) {
            this.missing.addAll(missingModules);
        }
        this.targetTemplateSet = targetTemplateSet;
        this.targetTemplateSetPresent = targetTemplateSetPresent;
    }

    public Set<String> getMissingModules() {
        return this.missing;
    }

    public String getTargetTemplateSet() {
        return this.targetTemplateSet;
    }

    @Override
    public boolean isSuccessful() {
        return this.isTargetTemplateSetPresent() && this.missing.isEmpty();
    }

    public boolean isTargetTemplateSetPresent() {
        return this.targetTemplateSet == null || this.targetTemplateSetPresent;
    }

    @Override
    public ValidationResult merge(ValidationResult toBeMergedWith) {
        return toBeMergedWith == null || toBeMergedWith.isSuccessful() || !(toBeMergedWith instanceof MissingModulesValidationResult) ? this : new MissingModulesValidationResult(this, (MissingModulesValidationResult)toBeMergedWith);
    }

    @Override
    public boolean isBlocking() {
        return true;
    }

    public String toString() {
        StringBuilder out = new StringBuilder(128);
        out.append("[").append(StringUtils.substringAfterLast((String)this.getClass().getName(), (String)".")).append("=").append(this.isSuccessful() ? "successful" : "failure");
        if (!this.isSuccessful()) {
            out.append(", targetTemplateSet=").append(this.targetTemplateSet);
            out.append(", targetTemplateSetPresent=").append(this.targetTemplateSetPresent);
            out.append(", missingModules=").append(this.missing);
        }
        out.append("]");
        return out.toString();
    }
}

