/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.importexport.validation;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.importexport.validation.ValidationResult;

public class ConstraintsValidatorResult
implements ValidationResult,
Serializable {
    Map<String, Set<String>> missingMandatoryProperties = new TreeMap<String, Set<String>>();
    Map<String, Set<String>> missingMandatoryI18NProperties = new TreeMap<String, Set<String>>();

    public ConstraintsValidatorResult(Map<String, Set<String>> missingMandatoryProperties, Map<String, Set<String>> missingMandatoryI18NProperties) {
        this.missingMandatoryProperties = missingMandatoryProperties;
        this.missingMandatoryI18NProperties = missingMandatoryI18NProperties;
    }

    public ConstraintsValidatorResult(ConstraintsValidatorResult result1, ConstraintsValidatorResult result2) {
        this.missingMandatoryProperties.putAll(result1.missingMandatoryProperties);
        this.missingMandatoryI18NProperties.putAll(result1.missingMandatoryI18NProperties);
        for (Map.Entry<String, Set<String>> result2MissingPropertiesEntry : result2.missingMandatoryProperties.entrySet()) {
            if (this.missingMandatoryProperties.containsKey(result2MissingPropertiesEntry.getKey())) {
                this.missingMandatoryProperties.get(result2MissingPropertiesEntry.getKey()).addAll((Collection<String>)result2MissingPropertiesEntry.getValue());
                continue;
            }
            this.missingMandatoryProperties.put(result2MissingPropertiesEntry.getKey(), result2MissingPropertiesEntry.getValue());
        }
        for (Map.Entry<String, Set<String>> result2MissingI18NPropertiesEntry : result2.missingMandatoryI18NProperties.entrySet()) {
            if (this.missingMandatoryI18NProperties.containsKey(result2MissingI18NPropertiesEntry.getKey())) {
                this.missingMandatoryI18NProperties.get(result2MissingI18NPropertiesEntry.getKey()).addAll((Collection<String>)result2MissingI18NPropertiesEntry.getValue());
                continue;
            }
            this.missingMandatoryI18NProperties.put(result2MissingI18NPropertiesEntry.getKey(), result2MissingI18NPropertiesEntry.getValue());
        }
    }

    @Override
    public boolean isSuccessful() {
        return this.missingMandatoryProperties.isEmpty() && this.missingMandatoryI18NProperties.isEmpty();
    }

    @Override
    public ValidationResult merge(ValidationResult toBeMergedWith) {
        return toBeMergedWith == null || toBeMergedWith.isSuccessful() || !(toBeMergedWith instanceof ConstraintsValidatorResult) ? this : new ConstraintsValidatorResult(this, (ConstraintsValidatorResult)toBeMergedWith);
    }

    @Override
    public boolean isBlocking() {
        return true;
    }

    public String toString() {
        StringBuilder out = new StringBuilder(128);
        out.append("[").append(StringUtils.substringAfterLast((String)this.getClass().getName(), (String)".")).append("=").append(this.isSuccessful() ? "successful" : "failure");
        if (!this.isSuccessful()) {
            out.append(", missingMandatoryProperties=").append(this.missingMandatoryProperties);
            out.append(", missingMandatoryI18NProperties=").append(this.missingMandatoryI18NProperties);
        }
        out.append("]");
        return out.toString();
    }
}

