/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.importexport;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.util.ISO9075;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.JCRValueWrapper;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferencesHelper {
    private static Logger logger = LoggerFactory.getLogger(ReferencesHelper.class);
    public static final int MAX_BATCH = 1000;

    public static void resolveCrossReferences(JCRSessionWrapper session, Map<String, List<String>> references) throws RepositoryException {
        ReferencesHelper.resolveCrossReferences(session, references, true);
    }

    public static void resolveCrossReferences(JCRSessionWrapper session, Map<String, List<String>> references, boolean useReferencesKeeper) throws RepositoryException {
        ReferencesHelper.resolveCrossReferences(session, references, useReferencesKeeper, false);
    }

    public static void resolveCrossReferences(JCRSessionWrapper session, Map<String, List<String>> references, boolean useReferencesKeeper, boolean keepReferencesForLive) throws RepositoryException {
        JCRSessionWrapper referencesKeeperSession = session;
        if (useReferencesKeeper) {
            referencesKeeperSession = ReferencesHelper.resolveReferencesKeeper(session);
        }
        Map<String, String> uuidMapping = session.getUuidMapping();
        JCRNodeWrapper refRoot = referencesKeeperSession.getNode("/referencesKeeper");
        LinkedList<String> resolvedUUIDStringList = new LinkedList<String>();
        for (String uuid : references.keySet()) {
            List<String> paths = references.get(uuid);
            boolean resolved = true;
            if (uuidMapping.containsKey(uuid)) {
                ReferencesHelper.update(paths, session, uuidMapping.get(uuid));
            } else {
                String pName;
                String refuuid;
                JCRNodeWrapper r;
                try {
                    if (uuid.startsWith("/")) {
                        uuid = ISO9075.decode((String)uuid);
                        for (Map.Entry<String, String> mapping : session.getPathMapping().entrySet()) {
                            if (!uuid.startsWith(mapping.getKey())) continue;
                            uuid = mapping.getValue() + StringUtils.substringAfter((String)uuid, (String)mapping.getKey());
                        }
                        uuid = JCRContentUtils.escapeNodePath(uuid);
                        JCRNodeWrapper node = session.getNode(uuid);
                        ReferencesHelper.update(paths, session, node.getIdentifier());
                    } else {
                        session.getNodeByUUID(uuid);
                        ReferencesHelper.update(paths, session, uuid);
                    }
                }
                catch (PathNotFoundException e) {
                    if (useReferencesKeeper) {
                        for (String path : paths) {
                            r = refRoot.addNode("j:reference" + UUID.randomUUID().toString(), "jnt:reference");
                            refuuid = path.substring(0, path.lastIndexOf("/"));
                            pName = path.substring(path.lastIndexOf("/") + 1);
                            r.setProperty("j:node", refuuid);
                            r.setProperty("j:propertyName", pName);
                            r.setProperty("j:originalUuid", uuid);
                            r.setProperty("j:live", keepReferencesForLive);
                        }
                        logger.warn("Reference to " + uuid + " cannot be resolved, store it in the reference keeper");
                    } else {
                        resolved = false;
                    }
                }
                catch (ItemNotFoundException e) {
                    if (useReferencesKeeper) {
                        for (String path : paths) {
                            r = refRoot.addNode("j:reference" + UUID.randomUUID().toString(), "jnt:reference");
                            refuuid = path.substring(0, path.lastIndexOf("/"));
                            pName = path.substring(path.lastIndexOf("/") + 1);
                            r.setProperty("j:node", refuuid);
                            r.setProperty("j:propertyName", pName);
                            r.setProperty("j:originalUuid", uuid);
                            r.setProperty("j:live", keepReferencesForLive);
                        }
                        logger.warn("Reference to " + uuid + " cannot be resolved, store it in the reference keeper");
                    } else {
                        resolved = false;
                    }
                }
                catch (RepositoryException e) {
                    logger.error("Repository exception", (Throwable)e);
                }
            }
            if (!resolved) continue;
            resolvedUUIDStringList.add(uuid);
        }
        for (String uuid : resolvedUUIDStringList) {
            references.remove(uuid);
        }
        if (useReferencesKeeper && session != referencesKeeperSession) {
            referencesKeeperSession.save();
        }
    }

    public static JCRSessionWrapper resolveReferencesKeeper(JCRSessionWrapper session) throws RepositoryException {
        JCRNodeIteratorWrapper ni = null;
        JCRSessionWrapper referencesKeeperSession = null;
        try {
            referencesKeeperSession = ReferencesHelper.getReferencesKeeperSession(session);
            ni = referencesKeeperSession.getNode("/referencesKeeper").getNodes();
        }
        catch (RepositoryException e) {
            logger.error("Impossible to load the references keeper", (Throwable)e);
            return session;
        }
        if (ni.getSize() > 5000L) {
            logger.warn("You have " + ni.getSize() + " nodes under /referencesKeeper, please consider checking the fine-tuning guide to clean them. Parsing them may take a while.");
        }
        int batchCount = 0;
        Map<String, String> uuidMapping = session.getUuidMapping();
        while (ni.hasNext()) {
            if (++batchCount > 1000) {
                referencesKeeperSession.save();
                batchCount = 0;
            }
            Node refNode = ni.nextNode();
            String refuuid = refNode.getProperty("j:node").getString();
            try {
                String pName;
                JCRNodeWrapper n = session.getNodeByUUID(refuuid);
                String uuid = refNode.getProperty("j:originalUuid").getString();
                if (uuidMapping.containsKey(uuid)) {
                    pName = refNode.getProperty("j:propertyName").getString();
                    ReferencesHelper.updateProperty(session, n, pName, uuidMapping.get(uuid), refNode.hasProperty("j:live") && refNode.getProperty("j:live").getBoolean());
                    refNode.remove();
                    continue;
                }
                if (!uuid.startsWith("/") || !session.itemExists(uuid)) continue;
                pName = refNode.getProperty("j:propertyName").getString();
                ReferencesHelper.updateProperty(session, n, pName, session.getNode(uuid).getIdentifier(), refNode.hasProperty("j:live") && refNode.getProperty("j:live").getBoolean());
                refNode.remove();
            }
            catch (ItemNotFoundException e) {
                refNode.remove();
            }
        }
        if (session != referencesKeeperSession) {
            referencesKeeperSession.save();
        }
        return referencesKeeperSession;
    }

    private static JCRSessionWrapper getReferencesKeeperSession(JCRSessionWrapper session) throws RepositoryException {
        if (session.isSystem()) {
            return session;
        }
        return JCRSessionFactory.getInstance().getCurrentSystemSession(session.getWorkspace().getName(), session.getLocale(), session.getFallbackLocale());
    }

    private static void update(List<String> paths, JCRSessionWrapper session, String value) throws RepositoryException {
        for (String path : paths) {
            try {
                JCRNodeWrapper n = session.getNodeByUUID(path.substring(0, path.lastIndexOf("/")));
                String pName = path.substring(path.lastIndexOf("/") + 1);
                if (pName.startsWith("@")) {
                    JCRNodeWrapper ref = n.addNode(pName.substring(1), "jnt:contentReference");
                    ReferencesHelper.updateProperty(session, ref, "j:node", value, false);
                    continue;
                }
                try {
                    ReferencesHelper.updateProperty(session, n, pName, value, false);
                }
                catch (ItemNotFoundException e) {
                    logger.warn("Item not found: " + pName, (Throwable)e);
                }
            }
            catch (RepositoryException e) {
                logger.warn("Error updating reference: " + path, (Throwable)e);
            }
        }
    }

    private static void updateProperty(JCRSessionWrapper session, JCRNodeWrapper n, String pName, String value, boolean live) throws RepositoryException {
        if (pName.startsWith("[")) {
            int id = Integer.parseInt(StringUtils.substringBetween((String)pName, (String)"[", (String)"]"));
            pName = StringUtils.substringAfter((String)pName, (String)"]");
            if (n.isNodeType("jnt:translation") && n.hasProperty("jcr:language")) {
                pName = pName + "_" + n.getProperty("jcr:language").getString();
                n = n.getParent();
            }
            if (!n.isNodeType("jmix:referencesInField")) {
                n.addMixin("jmix:referencesInField");
            }
            if (logger.isDebugEnabled()) {
                logger.debug("New references : " + value);
            }
            JCRNodeWrapper ref = n.addNode("j:referenceInField_" + pName + "_" + id, "jnt:referenceInField");
            ref.setProperty("j:fieldName", pName);
            ref.setProperty("j:reference", value);
        } else {
            ExtendedPropertyDefinition propertyDefinition = n.getApplicablePropertyDefinition(pName);
            if (propertyDefinition == null) {
                throw new ConstraintViolationException("Couldn't find definition for property " + pName);
            }
            String[] constraints = propertyDefinition.getValueConstraints();
            if (constraints != null && constraints.length > 0) {
                boolean b = false;
                JCRNodeWrapper target = session.getNodeByUUID(value);
                for (int i = 0; i < constraints.length; ++i) {
                    String constraint = constraints[i];
                    b |= target.isNodeType(constraint);
                }
                if (!b) {
                    logger.warn("Cannot set reference to " + target.getPath() + ", constraint on " + n.getPath());
                    return;
                }
            }
            if (propertyDefinition.isMultiple()) {
                Object[] newValues;
                if (n.hasProperty(pName)) {
                    JCRValueWrapper[] oldValues = n.getProperty(pName).getValues();
                    newValues = new Value[oldValues.length + 1];
                    for (JCRValueWrapper oldValue : oldValues) {
                        if (!oldValue.getString().equals(value)) continue;
                        return;
                    }
                    System.arraycopy(oldValues, 0, newValues, 0, oldValues.length);
                } else {
                    newValues = new Value[1];
                }
                newValues[newValues.length - 1] = session.getValueFactory().createValue(value, propertyDefinition.getRequiredType());
                if (!n.hasProperty(pName) || !Arrays.equals(newValues, n.getProperty(pName).getValues())) {
                    session.checkout(n);
                    JCRPropertyWrapper property = n.setProperty(pName, (Value[])newValues);
                    if (live) {
                        try {
                            property.getParent().getCorrespondingNodePath("live");
                            String key = property.getParent().getIdentifier() + "/" + property.getName();
                            if (!session.getResolvedReferences().containsKey(key)) {
                                session.getResolvedReferences().put(key, new HashSet());
                            }
                            ((Set)session.getResolvedReferences().get(key)).add(value);
                        }
                        catch (ItemNotFoundException e) {}
                    }
                }
            } else if (!n.hasProperty(pName) || !value.equals(n.getProperty(pName).getString())) {
                session.checkout(n);
                JCRPropertyWrapper property = n.setProperty(pName, session.getValueFactory().createValue(value, propertyDefinition.getRequiredType()));
                String key = property.getParent().getIdentifier() + "/" + property.getName();
                if (live) {
                    try {
                        property.getParent().getCorrespondingNodePath("live");
                        session.getResolvedReferences().put(key, property.getValue().getString());
                    }
                    catch (ItemNotFoundException e) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public static void updateReferencesInLive(final Map<String, Object> resolvedReferences) throws RepositoryException {
        if (!resolvedReferences.isEmpty()) {
            JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(null, "live", null, new JCRCallback<Object>(){

                @Override
                public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    for (Map.Entry entry : resolvedReferences.entrySet()) {
                        String nodeIdentifier = StringUtils.substringBeforeLast((String)((String)entry.getKey()), (String)"/");
                        String propertyName = StringUtils.substringAfterLast((String)((String)entry.getKey()), (String)"/");
                        try {
                            JCRValueWrapper[] previous;
                            JCRPropertyWrapper property;
                            JCRNodeWrapper node = session.getNodeByIdentifier(nodeIdentifier);
                            ExtendedPropertyDefinition definition = node.getApplicablePropertyDefinition(propertyName);
                            if (definition == null) continue;
                            if (entry.getValue() instanceof String) {
                                if (node.hasProperty(propertyName) && node.getProperty(propertyName).getString().equals(entry.getValue())) continue;
                                node.setProperty(propertyName, session.getValueFactory().createValue((String)entry.getValue(), definition.getRequiredType()));
                                continue;
                            }
                            if (!(entry.getValue() instanceof Set)) continue;
                            Set values = (Set)entry.getValue();
                            if (!node.hasProperty(propertyName)) {
                                property = node.setProperty(propertyName, new Value[0]);
                                for (String value : values) {
                                    property.addValue(session.getValueFactory().createValue(value, definition.getRequiredType()));
                                }
                                continue;
                            }
                            property = node.getProperty(propertyName);
                            for (JCRValueWrapper value : previous = property.getValues()) {
                                values.remove(value.getString());
                            }
                            for (String value : values) {
                                property.addValue(session.getValueFactory().createValue(value, definition.getRequiredType()));
                            }
                        }
                        catch (ItemNotFoundException e) {
                            logger.debug("Node not found in live", (Throwable)e);
                        }
                    }
                    session.save();
                    return null;
                }
            });
            resolvedReferences.clear();
        }
    }
}

