/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.rules;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.decorator.JCRGroupNode;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.content.rules.Group;
import org.jahia.services.content.rules.UserProperty;
import org.jahia.services.usermanager.JahiaGroupManagerService;
import org.jahia.services.usermanager.JahiaUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class User {
    private static Logger log = LoggerFactory.getLogger(User.class);
    private String username;
    private String realm;
    private JCRUserNode user;

    public User(JCRUserNode user) {
        this.user = user;
    }

    public User(String username, String realm) {
        this.username = username;
        this.realm = realm;
    }

    public String getName() {
        if (this.username != null) {
            return this.username;
        }
        if (this.user != null) {
            return this.user.getName();
        }
        return null;
    }

    public String getRealm() {
        if (this.realm != null) {
            return this.realm;
        }
        if (this.user != null) {
            return this.user.getRealm();
        }
        return null;
    }

    public List<UserProperty> getProperties() {
        ArrayList<UserProperty> r = new ArrayList<UserProperty>();
        JCRUserNode jahiaUser = this.getUserNode();
        if (jahiaUser != null) {
            Map<String, String> p = null;
            try {
                p = jahiaUser.getPropertiesAsString();
                for (Map.Entry<String, String> entry : p.entrySet()) {
                    r.add(new UserProperty(this, entry.getKey(), entry.getValue()));
                }
            }
            catch (RepositoryException e) {
                log.error("Error while getting user properties", (Throwable)e);
            }
        }
        return r;
    }

    public List<Group> getGroups() {
        ArrayList<Group> r = new ArrayList<Group>();
        JahiaGroupManagerService grpManager = JahiaGroupManagerService.getInstance();
        JCRUserNode jahiaUser = this.getUserNode();
        if (jahiaUser != null) {
            List<String> groups = grpManager.getMembershipByPath(jahiaUser.getPath());
            for (String groupname : groups) {
                JCRGroupNode group = grpManager.lookupGroupByPath(groupname);
                r.add(new Group(group));
            }
        }
        return r;
    }

    public JCRUserNode getUserNode() {
        if (this.user == null && this.username != null && !this.username.equals(" system ") && !this.username.equals(" guest ")) {
            this.user = ServicesRegistry.getInstance().getJahiaUserManagerService().lookupUser(this.username, this.realm, false);
        }
        return this.user;
    }

    public JahiaUser getJahiaUser() {
        JCRUserNode userNode = this.getUserNode();
        if (userNode != null) {
            return userNode.getJahiaUser();
        }
        return null;
    }
}

