/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.rules;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.jcr.ItemNotFoundException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.drools.compiler.compiler.PackageBuilder;
import org.drools.compiler.compiler.PackageBuilderConfiguration;
import org.drools.compiler.compiler.PackageBuilderErrors;
import org.drools.core.RuleBase;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.RuleBaseFactory;
import org.drools.core.StatelessSession;
import org.drools.core.common.DroolsObjectInputStream;
import org.drools.core.common.DroolsObjectOutputStream;
import org.drools.core.rule.Package;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.osgi.BundleDelegatingClassLoader;
import org.jahia.services.content.DefaultEventListener;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCREventIterator;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRObservationManager;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.content.rules.AddedNodeFact;
import org.jahia.services.content.rules.ChangedPropertyFact;
import org.jahia.services.content.rules.CopiedNodeFact;
import org.jahia.services.content.rules.DeletedNodeFact;
import org.jahia.services.content.rules.DeletedPropertyFact;
import org.jahia.services.content.rules.MovedNodeFact;
import org.jahia.services.content.rules.OperationTypeFact;
import org.jahia.services.content.rules.PublishedNodeFact;
import org.jahia.services.content.rules.Updateable;
import org.jahia.services.content.rules.User;
import org.jahia.settings.SettingsBean;
import org.kie.internal.utils.CompositeClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class RulesListener
extends DefaultEventListener
implements DisposableBean {
    private static Logger logger = LoggerFactory.getLogger(RulesListener.class);
    private static List<RulesListener> instances = new ArrayList<RulesListener>();
    private Timer rulesTimer = new Timer("rules-timer", true);
    private RuleBase ruleBase;
    private long lastRead = 0L;
    private static final int UPDATE_DELAY_FOR_LOCKED_NODE = 2000;
    private Set<String> ruleFiles;
    private ThreadLocal<Boolean> inRules = new ThreadLocal();
    private List<Resource> dslFiles;
    private Map<String, Object> globalObjects;
    private List<String> filesAccepted;
    private Map<String, String> modulePackageNameMap;
    private CompositeClassLoader ruleBaseClassLoader;

    public RulesListener() {
        instances.add(this);
        this.dslFiles = new LinkedList<Resource>();
        this.globalObjects = new LinkedHashMap<String, Object>();
        this.inRules = new ThreadLocal();
        this.modulePackageNameMap = new LinkedHashMap<String, String>();
    }

    public static RulesListener getInstance(String workspace) {
        for (RulesListener instance : instances) {
            if (!instance.workspace.equals(workspace)) continue;
            return instance;
        }
        return null;
    }

    @Override
    public int getEventTypes() {
        return 63;
    }

    private StatelessSession getStatelessSession(Map<String, Object> globals) {
        StatelessSession session = this.ruleBase.newStatelessSession();
        for (Map.Entry<String, Object> entry : globals.entrySet()) {
            session.setGlobal(entry.getKey(), entry.getValue());
        }
        return session;
    }

    public void executeRules(Object fact, Map<String, Object> globals) {
        this.getStatelessSession(globals).execute(fact);
    }

    public void executeRules(Object[] facts, Map<String, Object> globals) {
        this.getStatelessSession(globals).execute(facts);
    }

    public void executeRules(Collection<?> facts, Map<String, Object> globals) {
        this.getStatelessSession(globals).execute(facts);
    }

    public void setRuleFiles(Set<String> ruleFiles) {
        this.ruleFiles = ruleFiles;
    }

    public void start() throws Exception {
        this.initRules();
    }

    private void initRules() throws Exception {
        this.ruleBaseClassLoader = new CompositeClassLoader();
        this.ruleBaseClassLoader.setCachingEnabled(true);
        this.ruleBaseClassLoader.addClassLoader(this.getClass().getClassLoader());
        RuleBaseConfiguration conf = new RuleBaseConfiguration(new ClassLoader[]{this.ruleBaseClassLoader});
        this.ruleBase = RuleBaseFactory.newRuleBase((RuleBaseConfiguration)conf);
        this.dslFiles.add((Resource)new FileSystemResource(SettingsBean.getInstance().getJahiaEtcDiskPath() + "/repository/rules/rules.dsl"));
        for (String s : this.ruleFiles) {
            this.addRules(new File(SettingsBean.getInstance().getJahiaEtcDiskPath() + s));
        }
        this.lastRead = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDslFiles() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        for (Resource dslFile : this.dslFiles) {
            InputStream dslFileInputStream = null;
            try {
                dslFileInputStream = dslFile.getInputStream();
                stringBuilder.append(IOUtils.toString((InputStream)dslFileInputStream, (String)"UTF-8")).append("\n");
            }
            finally {
                IOUtils.closeQuietly((InputStream)dslFileInputStream);
            }
        }
        return stringBuilder.toString();
    }

    public void addRules(File dsrlFile) {
        this.addRules((Resource)(dsrlFile == null ? null : new FileSystemResource(dsrlFile)), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRules(Resource dsrlFile, JahiaTemplatesPackage aPackage) {
        block24: {
            long start = System.currentTimeMillis();
            try {
                PackageBuilderErrors errors;
                block27: {
                    File pkgFile;
                    ClassLoader packageClassLoader;
                    File compiledRulesDir = new File(SettingsBean.getInstance().getJahiaVarDiskPath() + "/compiledRules");
                    compiledRulesDir = aPackage != null ? new File(compiledRulesDir, aPackage.getIdWithVersion()) : new File(compiledRulesDir, "system");
                    if (!compiledRulesDir.exists()) {
                        compiledRulesDir.mkdirs();
                    }
                    ClassLoader classLoader = packageClassLoader = aPackage != null ? aPackage.getClassLoader() : null;
                    if (packageClassLoader != null) {
                        this.ruleBaseClassLoader.addClassLoaderToEnd(packageClassLoader);
                    }
                    if ((pkgFile = new File(compiledRulesDir, StringUtils.substringAfterLast((String)dsrlFile.getURL().getPath(), (String)"/") + ".pkg")).exists() && pkgFile.lastModified() > dsrlFile.lastModified()) {
                        DroolsObjectInputStream ois;
                        block23: {
                            ois = null;
                            try {
                                ois = new DroolsObjectInputStream((InputStream)new FileInputStream(pkgFile), packageClassLoader != null ? packageClassLoader : null);
                                Package pkg = new Package();
                                pkg.readExternal((ObjectInput)ois);
                                if (this.ruleBase.getPackage(pkg.getName()) != null) {
                                    this.ruleBase.removePackage(pkg.getName());
                                }
                                this.ruleBase.addPackage(pkg);
                                if (aPackage == null) break block23;
                                this.modulePackageNameMap.put(aPackage.getName(), pkg.getName());
                            }
                            catch (Throwable throwable) {
                                IOUtils.closeQuietly(ois);
                                throw throwable;
                            }
                        }
                        IOUtils.closeQuietly((InputStream)ois);
                        break block24;
                    }
                    InputStream drlInputStream = dsrlFile.getInputStream();
                    List lines = Collections.emptyList();
                    try {
                        lines = IOUtils.readLines((InputStream)drlInputStream);
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)drlInputStream);
                    }
                    StringBuilder drl = new StringBuilder(4096);
                    for (String line : lines) {
                        if (drl.length() > 0) {
                            drl.append("\n");
                        }
                        if (line.trim().length() > 0 && line.trim().charAt(0) == '#') {
                            drl.append(StringUtils.replaceOnce((String)line, (String)"#", (String)"//"));
                            continue;
                        }
                        drl.append(line);
                    }
                    PackageBuilderConfiguration cfg = packageClassLoader != null ? new PackageBuilderConfiguration(new ClassLoader[]{packageClassLoader}) : new PackageBuilderConfiguration();
                    PackageBuilder builder = new PackageBuilder(cfg);
                    StringReader drlReader = new StringReader(drl.toString());
                    try {
                        builder.addPackageFromDrl((Reader)drlReader, (Reader)new StringReader(this.getDslFiles()));
                    }
                    finally {
                        IOUtils.closeQuietly((Reader)drlReader);
                    }
                    errors = builder.getErrors();
                    if (errors.getErrors().length != 0) break block27;
                    Package pkg = builder.getPackage();
                    DroolsObjectOutputStream oos = null;
                    try {
                        pkgFile.getParentFile().mkdirs();
                        oos = new DroolsObjectOutputStream((OutputStream)new FileOutputStream(pkgFile));
                        pkg.writeExternal((ObjectOutput)oos);
                    }
                    catch (IOException e) {
                        try {
                            logger.error("Error writing rule package to file " + pkgFile, (Throwable)e);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(oos);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((OutputStream)oos);
                    }
                    IOUtils.closeQuietly((OutputStream)oos);
                    if (this.ruleBase.getPackage(pkg.getName()) != null) {
                        this.ruleBase.removePackage(pkg.getName());
                    }
                    this.ruleBase.addPackage(pkg);
                    if (aPackage != null) {
                        this.modulePackageNameMap.put(aPackage.getName(), pkg.getName());
                    }
                    logger.info("Rules for " + pkg.getName() + " updated in " + (System.currentTimeMillis() - start) + "ms.");
                    break block24;
                }
                logger.error("---------------------------------------------------------------------------------");
                logger.error("Errors when compiling rules in " + dsrlFile + " : " + errors.toString());
                logger.error("---------------------------------------------------------------------------------");
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private long lastModified() {
        long last = 0L;
        for (String s : this.ruleFiles) {
            last = Math.max(last, new File(SettingsBean.getInstance().getJahiaEtcDiskPath() + s).lastModified());
        }
        return last;
    }

    public void onEvent(EventIterator eventIterator) {
        final int operationType = ((JCREventIterator)eventIterator).getOperationType();
        final JCRSessionWrapper session = ((JCREventIterator)eventIterator).getSession();
        final String userId = session.getUser() != null ? session.getUser().getName() : null;
        final String userRealm = session.getUser() != null ? session.getUser().getRealm() : null;
        Locale locale = session.getLocale();
        final HashMap eventsMap = new HashMap();
        if (Boolean.TRUE.equals(this.inRules.get())) {
            return;
        }
        if (this.ruleBase == null || SettingsBean.getInstance().isDevelopmentMode() && this.lastModified() > this.lastRead) {
            try {
                this.initRules();
            }
            catch (Exception e) {
                logger.error("Cannot compile rules", (Throwable)e);
            }
            if (this.ruleBase == null) {
                return;
            }
        }
        final ArrayList<Event> events = new ArrayList<Event>();
        while (eventIterator.hasNext()) {
            Event event = eventIterator.nextEvent();
            if (this.isExternal(event)) continue;
            events.add(event);
        }
        if (events.isEmpty()) {
            return;
        }
        try {
            JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(session.getUser(), this.workspace, locale, new JCRCallback<Object>(){
                Map<String, String> copies = null;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object doInJCR(JCRSessionWrapper s) throws RepositoryException {
                    Iterator it = events.iterator();
                    ArrayList<Object> list = new ArrayList<Object>();
                    String nodeFactOperationType = RulesListener.this.getNodeFactOperationType(operationType);
                    while (it.hasNext()) {
                        Event event = (Event)it.next();
                        String path = event.getPath();
                        try {
                            JCRNodeWrapper n;
                            JCRSiteNode resolveSite;
                            JCRSiteNode resolveSite2;
                            if (path.startsWith("/jcr:system/")) continue;
                            String eventUuid = event.getIdentifier();
                            int type = event.getType();
                            if (type == 1) {
                                JCRNodeWrapper n2 = eventUuid != null ? s.getNodeByIdentifier(eventUuid) : s.getNode(path);
                                if (!n2.isNodeType("jmix:observable") || n2.isNodeType("jnt:translation")) continue;
                                String identifier = n2.getIdentifier();
                                AddedNodeFact rn = (AddedNodeFact)eventsMap.get(identifier);
                                if (rn == null) {
                                    rn = this.getFact(n2, session);
                                    rn.setOperationType(nodeFactOperationType);
                                    resolveSite2 = n2.getResolveSite();
                                    if (resolveSite2 != null) {
                                        rn.setInstalledModules(resolveSite2.getAllInstalledModules());
                                    } else {
                                        rn.setInstalledModules(new ArrayList<String>());
                                    }
                                    eventsMap.put(identifier, rn);
                                }
                                list.add(rn);
                                continue;
                            }
                            if (type == 4 || type == 16) {
                                JCRNodeWrapper n3;
                                String propertyName = path.substring(path.lastIndexOf(47) + 1);
                                if (!RulesListener.this.propertiesToIgnore.contains(propertyName)) {
                                    try {
                                        AddedNodeFact rn;
                                        JCRPropertyWrapper p = null;
                                        try {
                                            p = (JCRPropertyWrapper)s.getItem(path);
                                        }
                                        catch (PathNotFoundException e) {
                                            try {
                                                p = s.getNodeByIdentifier(eventUuid).getProperty(propertyName);
                                            }
                                            catch (RepositoryException infe) {
                                                throw e;
                                            }
                                        }
                                        JCRNodeWrapper parent = p.getParent();
                                        if (parent.isNodeType("jnt:translation")) {
                                            parent = parent.getParent();
                                        }
                                        if (!parent.isNodeType("nt:resource") && !parent.isNodeType("jmix:observable")) continue;
                                        if (parent.isNodeType("mix:referenceable")) {
                                            String identifier = parent.getIdentifier();
                                            rn = (AddedNodeFact)eventsMap.get(identifier);
                                            if (rn == null) {
                                                rn = type == 4 ? this.getFact(parent, session) : new AddedNodeFact(parent);
                                                rn.setOperationType(nodeFactOperationType);
                                                JCRSiteNode resolveSite3 = parent.getResolveSite();
                                                if (resolveSite3 != null) {
                                                    rn.setInstalledModules(resolveSite3.getAllInstalledModules());
                                                } else {
                                                    rn.setInstalledModules(new ArrayList<String>());
                                                }
                                                eventsMap.put(identifier, rn);
                                            }
                                        } else {
                                            rn = new AddedNodeFact(parent);
                                            rn.setOperationType(nodeFactOperationType);
                                            resolveSite = parent.getResolveSite();
                                            if (resolveSite != null) {
                                                rn.setInstalledModules(resolveSite.getAllInstalledModules());
                                            } else {
                                                rn.setInstalledModules(new ArrayList<String>());
                                            }
                                        }
                                        list.add(new ChangedPropertyFact(rn, p));
                                    }
                                    catch (PathNotFoundException pnfe) {
                                        if (JCRSessionFactory.getInstance().getProvider(path, false) != null && !logger.isDebugEnabled()) continue;
                                        logger.error("Couldn't access path {}, ignoring it.", (Throwable)pnfe);
                                    }
                                    continue;
                                }
                                if (!propertyName.equals("j:published") || !(n3 = eventUuid != null ? s.getNodeByIdentifier(eventUuid) : s.getNode(path)).isNodeType("jmix:observable") || n3.isNodeType("jnt:translation")) continue;
                                PublishedNodeFact e = new PublishedNodeFact(n3);
                                e.setOperationType(nodeFactOperationType);
                                resolveSite2 = n3.getResolveSite();
                                if (resolveSite2 != null) {
                                    e.setInstalledModules(resolveSite2.getAllInstalledModules());
                                } else {
                                    e.setInstalledModules(new ArrayList<String>());
                                }
                                list.add(e);
                                continue;
                            }
                            if (type == 2) {
                                String parentPath = null;
                                try {
                                    parentPath = StringUtils.substringBeforeLast((String)path, (String)"/");
                                    JCRNodeWrapper parent = s.getNode(parentPath);
                                    String identifier = parent.getIdentifier();
                                    AddedNodeFact w = (AddedNodeFact)eventsMap.get(identifier);
                                    if (w == null) {
                                        w = new AddedNodeFact(parent);
                                        w.setOperationType(nodeFactOperationType);
                                        resolveSite = parent.getResolveSite();
                                        if (resolveSite != null) {
                                            w.setInstalledModules(resolveSite.getAllInstalledModules());
                                        } else {
                                            w.setInstalledModules(new ArrayList<String>());
                                        }
                                        eventsMap.put(identifier, w);
                                    }
                                    DeletedNodeFact e = new DeletedNodeFact(w, path);
                                    e.setIdentifier(eventUuid);
                                    e.setSession(s);
                                    e.setOperationType(nodeFactOperationType);
                                    e.setTypes(JCRObservationManager.getNodeTypesForDeletedNode(event));
                                    list.add(e);
                                }
                                catch (PathNotFoundException e) {}
                                continue;
                            }
                            if (type == 8) {
                                int index = path.lastIndexOf(47);
                                String nodePath = path.substring(0, index);
                                String propertyName = path.substring(index + 1);
                                if (RulesListener.this.propertiesToIgnore.contains(propertyName)) continue;
                                try {
                                    JCRNodeWrapper n4 = s.getNode(nodePath);
                                    String key = n4.isNodeType("mix:referenceable") ? n4.getIdentifier() : n4.getPath();
                                    AddedNodeFact rn = (AddedNodeFact)eventsMap.get(key);
                                    if (rn == null) {
                                        rn = new AddedNodeFact(n4);
                                        rn.setOperationType(nodeFactOperationType);
                                        JCRSiteNode resolveSite4 = n4.getResolveSite();
                                        if (resolveSite4 != null) {
                                            rn.setInstalledModules(resolveSite4.getAllInstalledModules());
                                        } else {
                                            rn.setInstalledModules(new ArrayList<String>());
                                        }
                                        eventsMap.put(key, rn);
                                    }
                                    list.add(new DeletedPropertyFact(rn, propertyName));
                                }
                                catch (PathNotFoundException e) {}
                                continue;
                            }
                            if (type != 32 || !(n = eventUuid != null ? s.getNodeByIdentifier(eventUuid) : s.getNode(path)).isNodeType("jmix:observable") || n.isNodeType("jnt:translation")) continue;
                            MovedNodeFact e = new MovedNodeFact(n, (String)event.getInfo().get("srcAbsPath"));
                            e.setOperationType(nodeFactOperationType);
                            JCRSiteNode resolveSite5 = n.getResolveSite();
                            if (resolveSite5 != null) {
                                e.setInstalledModules(resolveSite5.getAllInstalledModules());
                            } else {
                                e.setInstalledModules(new ArrayList<String>());
                            }
                            list.add(e);
                        }
                        catch (PathNotFoundException pnfe) {
                            logger.debug("Error when executing event. Unable to find node or property for path: " + path, (Throwable)pnfe);
                        }
                        catch (ItemNotFoundException infe) {
                            logger.debug("Error when executing event. Unable to find node or property for item: " + event.getIdentifier(), (Throwable)infe);
                        }
                        catch (Exception e) {
                            logger.error("Error when executing event", (Throwable)e);
                        }
                    }
                    if (!list.isEmpty()) {
                        long time = System.currentTimeMillis();
                        if (logger.isDebugEnabled()) {
                            if (list.size() > 3) {
                                logger.debug("Executing rules for " + list.subList(0, 3) + " ... and " + (list.size() - 3) + " other nodes");
                            } else {
                                logger.debug("Executing rules for " + list);
                            }
                        }
                        ArrayList<Updateable> delayedUpdates = new ArrayList<Updateable>();
                        Map<String, Object> globals = RulesListener.this.getGlobals(userId, userRealm, delayedUpdates);
                        try {
                            RulesListener.this.inRules.set(Boolean.TRUE);
                            list.add(new OperationTypeFact(nodeFactOperationType));
                            RulesListener.this.executeRules(list, globals);
                            if (list.size() > 3) {
                                logger.info("Rules executed for " + RulesListener.this.workspace + " " + list.subList(0, 3) + " ... and " + (list.size() - 3) + " other nodes in " + (System.currentTimeMillis() - time) + "ms");
                            } else {
                                logger.info("Rules executed for " + RulesListener.this.workspace + " " + list + " in " + (System.currentTimeMillis() - time) + "ms");
                            }
                            if (s.hasPendingChanges()) {
                                s.save();
                            }
                        }
                        finally {
                            RulesListener.this.inRules.set(null);
                        }
                        if (!delayedUpdates.isEmpty()) {
                            DelayedUpdatesTimerTask t = new DelayedUpdatesTimerTask(userId, userRealm, delayedUpdates);
                            RulesListener.this.rulesTimer.schedule((TimerTask)t, 2000L);
                        }
                    }
                    return null;
                }

                private AddedNodeFact getFact(JCRNodeWrapper node, JCRSessionWrapper session2) throws RepositoryException {
                    if (this.copies == null) {
                        this.copies = session2.getUuidMapping().isEmpty() ? Collections.emptyMap() : MapUtils.invertMap(session2.getUuidMapping());
                    }
                    String sourceUuid = !this.copies.isEmpty() ? this.copies.get(node.getIdentifier()) : null;
                    return sourceUuid != null ? new CopiedNodeFact(node, sourceUuid, session2.getUuidMapping().containsKey("top-" + sourceUuid)) : new AddedNodeFact(node);
                }
            });
        }
        catch (Exception e) {
            logger.error("Error when executing event", (Throwable)e);
        }
    }

    public Map<String, Object> getGlobals(String username, String userRealm, List<Updateable> delayedUpdates) {
        HashMap<String, Object> globals = new HashMap<String, Object>();
        globals.put("logger", logger);
        globals.put("user", new User(username, userRealm));
        globals.put("workspace", this.workspace);
        globals.put("delayedUpdates", delayedUpdates);
        for (Map.Entry<String, Object> entry : this.globalObjects.entrySet()) {
            globals.put(entry.getKey(), entry.getValue());
        }
        return globals;
    }

    public void addRulesDescriptor(File file) {
        this.dslFiles.add((Resource)(file == null ? null : new FileSystemResource(file)));
    }

    public void addRulesDescriptor(Resource resource) {
        this.dslFiles.add(resource);
    }

    public void addRulesDescriptor(Resource resource, JahiaTemplatesPackage aPackage) {
        ClassLoader packageClassLoader;
        this.dslFiles.add(resource);
        ClassLoader classLoader = packageClassLoader = aPackage != null ? aPackage.getClassLoader() : null;
        if (packageClassLoader != null) {
            this.ruleBaseClassLoader.addClassLoaderToEnd(packageClassLoader);
        }
    }

    public void setGlobalObjects(Map<String, Object> globalObjects) {
        this.globalObjects = globalObjects;
    }

    public void addGlobalObject(String key, Object value) {
        this.globalObjects.put(key, value);
    }

    public void removeGlobalObject(String key) {
        this.globalObjects.remove(key);
    }

    public static List<RulesListener> getInstances() {
        return instances;
    }

    public List<String> getFilesAccepted() {
        return this.filesAccepted;
    }

    public void setFilesAccepted(List<String> fileAccepted) {
        this.filesAccepted = fileAccepted;
    }

    String getNodeFactOperationType(int operationType) {
        if (operationType == 13) {
            return "import";
        }
        if (operationType == 1) {
            return "session";
        }
        if (operationType == 4) {
            return "clone";
        }
        return null;
    }

    public void destroy() throws Exception {
        if (this.rulesTimer != null) {
            try {
                this.rulesTimer.cancel();
            }
            catch (Exception e) {
                logger.warn("Error terminating timer thread", (Throwable)e);
            }
        }
    }

    private void removeRules(String moduleName, boolean forceRebuildOfRuleBase) {
        String pkgName = this.modulePackageNameMap.get(moduleName);
        if (pkgName != null && this.ruleBase.getPackage(pkgName) != null) {
            this.ruleBase.removePackage(pkgName);
            forceRebuildOfRuleBase = true;
        }
        if (forceRebuildOfRuleBase) {
            RuleBaseConfiguration conf = new RuleBaseConfiguration(new ClassLoader[]{this.ruleBaseClassLoader});
            RuleBase ruleBase = RuleBaseFactory.newRuleBase((RuleBaseConfiguration)conf);
            for (Package aPackage : this.ruleBase.getPackages()) {
                ruleBase.addPackage(aPackage);
            }
            this.ruleBase = ruleBase;
        }
    }

    public void removeRules(JahiaTemplatesPackage module) {
        ClassLoader cl = module.getClassLoader();
        if (cl == null) {
            for (ClassLoader classLoader : this.ruleBaseClassLoader.getClassLoaders()) {
                if (!(classLoader instanceof BundleDelegatingClassLoader) || module.getBundle().getBundleId() != ((BundleDelegatingClassLoader)classLoader).getBundle().getBundleId()) continue;
                cl = classLoader;
                break;
            }
        }
        boolean forceRebuildOfRuleBase = false;
        if (cl != null) {
            this.ruleBaseClassLoader.removeClassLoader(cl);
            forceRebuildOfRuleBase = true;
        }
        this.removeRules(module.getName(), forceRebuildOfRuleBase);
    }

    public boolean removeRulesDescriptor(Resource resource) {
        return this.dslFiles.remove(resource);
    }

    public Map<String, String> getModulePackageNameMap() {
        return this.modulePackageNameMap;
    }

    class DelayedUpdatesTimerTask
    extends TimerTask {
        private String username;
        private String userRealm;
        private List<Updateable> updates;
        private int count = 1;

        DelayedUpdatesTimerTask(String username, String userRealm, List<Updateable> updates) {
            this.username = username;
            this.userRealm = userRealm;
            this.updates = updates;
        }

        DelayedUpdatesTimerTask(String username, String userRealm, List<Updateable> updates, int count) {
            this.username = username;
            this.userRealm = userRealm;
            this.updates = updates;
            this.count = count;
        }

        @Override
        public void run() {
            try {
                JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<Object>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Object doInJCR(JCRSessionWrapper s) throws RepositoryException {
                        RulesListener.this.inRules.set(Boolean.TRUE);
                        try {
                            ArrayList<Updateable> newDelayed = new ArrayList<Updateable>();
                            for (Updateable p : DelayedUpdatesTimerTask.this.updates) {
                                p.doUpdate(s, newDelayed);
                            }
                            s.save();
                            if (!newDelayed.isEmpty()) {
                                DelayedUpdatesTimerTask.this.updates = newDelayed;
                                if (DelayedUpdatesTimerTask.this.count < 3) {
                                    RulesListener.this.rulesTimer.schedule((TimerTask)new DelayedUpdatesTimerTask(DelayedUpdatesTimerTask.this.username, DelayedUpdatesTimerTask.this.userRealm, newDelayed, DelayedUpdatesTimerTask.this.count + 1), 2000 * DelayedUpdatesTimerTask.this.count);
                                } else {
                                    logger.error("Node still locked, max count reached, forget pending changes");
                                }
                            }
                        }
                        finally {
                            RulesListener.this.inRules.set(null);
                        }
                        return null;
                    }
                });
            }
            catch (RepositoryException e) {
                logger.error("Cannot set property", (Throwable)e);
            }
        }
    }
}

