/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.nodetypes.initializers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeTypeIterator;
import org.apache.commons.lang.StringUtils;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.content.nodetypes.initializers.ChoiceListInitializer;
import org.jahia.services.content.nodetypes.initializers.ChoiceListValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeTypesChoiceListInitializerImpl
implements ChoiceListInitializer {
    private static transient Logger logger = LoggerFactory.getLogger(NodeTypesChoiceListInitializerImpl.class);

    @Override
    public List<ChoiceListValue> getChoiceListValues(ExtendedPropertyDefinition epd, String param, List<ChoiceListValue> values, Locale locale, Map<String, Object> context) {
        ArrayList<ChoiceListValue> listValues = new ArrayList<ChoiceListValue>();
        if (StringUtils.isEmpty((String)param)) {
            param = "jmix:editorialContent";
        }
        boolean useName = StringUtils.contains((String)param, (String)";useName");
        try {
            NodeTypeIterator nti;
            ArrayList<String> systemIds = null;
            if (StringUtils.contains((String)param, (String)";fromDependencies")) {
                JCRSiteNode site;
                systemIds = new ArrayList<String>();
                JCRNodeWrapper node = (JCRNodeWrapper)context.get("contextNode");
                if (node == null) {
                    node = (JCRNodeWrapper)context.get("contextParent");
                }
                if (node != null && (site = node.getResolveSite()) != null) {
                    JahiaTemplatesPackage templatePackage = site.getTemplatePackage();
                    systemIds.add(templatePackage.getId());
                    for (JahiaTemplatesPackage dependency : templatePackage.getDependencies()) {
                        systemIds.add(dependency.getId());
                    }
                    systemIds.add("system-extension");
                    systemIds.add("system-standard");
                    systemIds.add("system-jahia");
                    systemIds.add("system-system");
                }
            }
            if (param.startsWith("MIXIN")) {
                nti = NodeTypeRegistry.getInstance().getMixinNodeTypes(systemIds);
            } else if (param.startsWith("PRIMARY")) {
                nti = NodeTypeRegistry.getInstance().getPrimaryNodeTypes(systemIds);
            } else if (param.startsWith("ALL")) {
                nti = NodeTypeRegistry.getInstance().getAllNodeTypes(systemIds);
            } else {
                ExtendedNodeType nodeType = NodeTypeRegistry.getInstance().getNodeType(param);
                nti = nodeType.getSubtypes();
            }
            while (nti.hasNext()) {
                ExtendedNodeType type = (ExtendedNodeType)nti.next();
                listValues.add(new ChoiceListValue(useName ? type.getName() : type.getLabel(locale), type.getName()));
            }
        }
        catch (RepositoryException e) {
            logger.error("Cannot get type", (Throwable)e);
        }
        Collections.sort(listValues);
        return listValues;
    }
}

