/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.nodetypes;

import java.util.Map;
import org.apache.commons.collections.BidiMap;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;

public class Name {
    private String localName;
    private String prefix = "";
    private String uri;
    private String preComputedToString;
    private int preComputedHashCode;

    private static String getPrefix(String uri, Map<String, String> namespaceMapping) {
        if (uri == null || uri.length() == 0) {
            return null;
        }
        String p = null;
        if (namespaceMapping instanceof BidiMap) {
            p = (String)((BidiMap)namespaceMapping).getKey((Object)uri);
        } else {
            for (Map.Entry<String, String> entry : namespaceMapping.entrySet()) {
                if (!entry.getValue().equals(uri)) continue;
                p = entry.getKey();
                break;
            }
        }
        return StringUtils.defaultString((String)p);
    }

    public Name(String localName, String prefix, String uri) {
        this.localName = localName;
        this.prefix = StringUtils.defaultString((String)prefix);
        this.uri = uri;
    }

    public Name(String localName, String uri) {
        this(localName, Name.getPrefix(uri, NodeTypeRegistry.getInstance().getNamespaces()), uri);
    }

    public Name(String localName, String uri, Map<String, String> namespaceMapping) {
        this(localName, Name.getPrefix(uri, namespaceMapping), uri);
    }

    public Name(String qualifiedName, Map<String, String> namespaceMapping) {
        if (qualifiedName.startsWith("{")) {
            int endUri = qualifiedName.indexOf("}");
            if (endUri != -1 && qualifiedName.length() > endUri) {
                this.uri = StringUtils.substringBetween((String)qualifiedName, (String)"{", (String)"}");
                this.prefix = Name.getPrefix(this.uri, namespaceMapping);
                this.localName = qualifiedName.substring(endUri + 1);
            } else {
                this.localName = qualifiedName;
                this.uri = namespaceMapping.get("");
            }
        }
        if (this.localName == null) {
            String[] s = StringUtils.split((String)qualifiedName, (String)":");
            if (s.length == 2) {
                this.prefix = s[0];
                this.localName = s[1];
                this.uri = namespaceMapping.get(this.prefix);
            } else {
                this.localName = s[0];
                this.uri = namespaceMapping.get("");
            }
        }
        this.prefix = StringUtils.defaultString((String)this.prefix);
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getUri() {
        return this.uri;
    }

    public String toString() {
        if (this.preComputedToString != null) {
            return this.preComputedToString;
        }
        if (this.prefix == null || this.prefix.length() == 0) {
            this.preComputedToString = this.localName;
            return this.preComputedToString;
        }
        this.preComputedToString = this.prefix + ":" + this.localName;
        return this.preComputedToString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Name name = (Name)o;
        if (this.localName != null ? !this.localName.equals(name.localName) : name.localName != null) {
            return false;
        }
        return !(this.uri != null ? !this.uri.equals(name.uri) : name.uri != null);
    }

    public int hashCode() {
        if (this.preComputedHashCode != 0) {
            return this.preComputedHashCode;
        }
        int result = this.localName != null ? this.localName.hashCode() : 0;
        result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
        this.preComputedHashCode = result = 31 * result + (this.uri != null ? this.uri.hashCode() : 0);
        return this.preComputedHashCode;
    }
}

