/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.nodetypes;

import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import org.jahia.services.content.nodetypes.ParseException;
import org.jahia.utils.ArrayUtils;

public class LexerLegacy {
    public static final char SINGLE_QUOTE = '\'';
    public static final char DOUBLE_QUOTE = '\"';
    public static final char BEGIN_NODE_TYPE_NAME = '[';
    public static final char END_NODE_TYPE_NAME = ']';
    public static final char EXTENDS = '>';
    public static final char LIST_DELIMITER = ',';
    public static final char PROPERTY_DEFINITION = '-';
    public static final char CHILD_NODE_DEFINITION = '+';
    public static final char BEGIN_TYPE = '(';
    public static final char END_TYPE = ')';
    public static final char DEFAULT = '=';
    public static final char CONSTRAINT = '<';
    public static final String[] ABSTRACT = new String[]{"abstract", "abs", "a"};
    public static final String[] ORDERABLE = new String[]{"orderable", "ord", "o"};
    public static final String[] MIXIN = new String[]{"mixin", "mix", "m"};
    public static final String[] VALIDATOR = new String[]{"validator", "val", "v"};
    public static final String[] PRIMARY = new String[]{"primary", "pri", "!"};
    public static final String[] AUTOCREATED = new String[]{"autocreated", "aut", "a"};
    public static final String[] MANDATORY = new String[]{"mandatory", "man", "m"};
    public static final String[] PROTECTED = new String[]{"protected", "pro", "p"};
    public static final String[] INTERNATIONALIZED = new String[]{"internationalized", "i15d", "i"};
    public static final String[] INDEXED = new String[]{"indexed", "ind", "x"};
    public static final String[] SCOREBOOST = new String[]{"scoreboost", "boost", "b"};
    public static final String[] NO = new String[]{"no", "n"};
    public static final String[] YES = new String[]{"yes", "y"};
    public static final String[] TOKENIZED = new String[]{"tokenized", "tok", "t"};
    public static final String[] UNTOKENIZED = new String[]{"untokenized", "untok", "u"};
    public static final String[] ANALYZER = new String[]{"analyzer"};
    public static final String[] SORTABLE = new String[]{"sortable"};
    public static final String[] FACETABLE = new String[]{"facetable"};
    public static final String[] FULLTEXTSEARCHABLE = new String[]{"fulltextsearchable", "fts"};
    public static final String[] MULTIPLE = new String[]{"multiple", "mul", "*"};
    public static final String[] HIDDEN = new String[]{"hidden", "Hidden", "HIDDEN"};
    public static final String[] COPY = new String[]{"copy", "Copy", "COPY"};
    public static final String[] VERSION = new String[]{"version", "Version", "VERSION"};
    public static final String[] INITIALIZE = new String[]{"initialize", "Initialize", "INITIALIZE"};
    public static final String[] COMPUTE = new String[]{"compute", "Compute", "COMPUTE"};
    public static final String[] IGNORE = new String[]{"ignore", "Ignore", "IGNORE"};
    public static final String[] ABORT = new String[]{"abort", "Abort", "ABORT"};
    public static final String[] WORKFLOW = new String[]{"workflow", "Workflow", "WORKFLOW"};
    public static final String[] ATTRIBUTE = ArrayUtils.join(PRIMARY, AUTOCREATED, MANDATORY, PROTECTED, INTERNATIONALIZED, INDEXED, SCOREBOOST, ANALYZER, SORTABLE, FACETABLE, FULLTEXTSEARCHABLE, MULTIPLE, COPY, VERSION, INITIALIZE, COMPUTE, IGNORE, ABORT, WORKFLOW, HIDDEN);
    public static final String[] STRING = new String[]{"string", "String", "STRING"};
    public static final String[] BINARY = new String[]{"binary", "Binary", "BINARY"};
    public static final String[] LONG = new String[]{"long", "Long", "LONG"};
    public static final String[] DOUBLE = new String[]{"double", "Double", "DOUBLE"};
    public static final String[] BOOLEAN = new String[]{"boolean", "Boolean", "BOOLEAN"};
    public static final String[] DATE = new String[]{"date", "Date", "DATE"};
    public static final String[] NAME = new String[]{"name", "Name", "NAME"};
    public static final String[] PATH = new String[]{"path", "Path", "PATH"};
    public static final String[] REFERENCE = new String[]{"reference", "Reference", "REFERENCE"};
    public static final String[] WEAKREFERENCE = new String[]{"WEAKREFERENCE", "WeakReference", "weakreference"};
    public static final String[] URI = new String[]{"URI", "Uri", "uri"};
    public static final String[] DECIMAL = new String[]{"DECIMAL", "Decimal", "decimal"};
    public static final String[] SMALLTEXT = new String[]{"text", "Text", "TEXT"};
    public static final String[] RICHTEXT = new String[]{"richtext", "RichText", "RICHTEXT"};
    public static final String[] CHOICELIST = new String[]{"choicelist", "Choicelist", "CHOICELIST"};
    public static final String[] DATETIMEPICKER = new String[]{"datetimepicker", "DateTimePicker", "DATETIMEPICKER"};
    public static final String[] DATEPICKER = new String[]{"datepicker", "DatePicker", "DATEPICKER"};
    public static final String[] CATEGORY = new String[]{"category", "Category", "CATEGORY"};
    public static final String[] FILEPICKER = new String[]{"file", "File", "FILE"};
    public static final String[] FILEUPLOAD = new String[]{"fileupload", "FileUpload", "FILEUPLOAD"};
    public static final String[] PORTLET = new String[]{"portlet", "Portlet", "PORTLET"};
    public static final String[] PORTLETDEFINITION = new String[]{"portletdefinition", "PortletDefinition", "PORTLETDEFINITION"};
    public static final String[] PAGE = new String[]{"page", "Page", "PAGE"};
    public static final String[] COLOR = new String[]{"color", "Color", "COLOR"};
    public static final String[] CHECKBOX = new String[]{"checkbox", "Checkbox", "CHECKBOX"};
    public static final String[] UNDEFINED = new String[]{"undefined", "Undefined", "UNDEFINED", "*"};
    public static final String[] JAHIA_CONTAINERLIST = new String[]{"containerList"};
    public static final String[] JAHIA_SINGLECONTAINER = new String[]{"singleContainer"};
    public static final String[] JAHIA_SMALLTEXTFIELD = new String[]{"smallText"};
    public static final String[] JAHIA_SHAREDSMALLTEXTFIELD = new String[]{"sharedSmallText"};
    public static final String[] JAHIA_BIGTEXTFIELD = new String[]{"bigText"};
    public static final String[] JAHIA_DATEFIELD = new String[]{"date"};
    public static final String[] JAHIA_PAGEFIELD = new String[]{"page"};
    public static final String[] JAHIA_FILEFIELD = new String[]{"file"};
    public static final String[] JAHIA_PORTLETFIELD = new String[]{"portlet"};
    public static final String[] JAHIA_INTEGERFIELD = new String[]{"integer"};
    public static final String[] JAHIA_FLOATFIELD = new String[]{"float"};
    public static final String[] JAHIA_BOOLEANFIELD = new String[]{"boolean"};
    public static final String[] JAHIA_CATEGORYFIELD = new String[]{"category"};
    public static final String[] JAHIA_COLORFIELD = new String[]{"color"};
    public static final String EOF = "eof";
    private final StreamTokenizer st;
    private final String filename;

    public LexerLegacy(Reader r, String filename) {
        this.filename = filename;
        this.st = new StreamTokenizer(r);
        this.st.eolIsSignificant(false);
        this.st.lowerCaseMode(false);
        this.st.slashSlashComments(true);
        this.st.slashStarComments(true);
        this.st.wordChars(97, 122);
        this.st.wordChars(65, 90);
        this.st.wordChars(58, 58);
        this.st.wordChars(95, 95);
        this.st.quoteChar(39);
        this.st.quoteChar(34);
        this.st.ordinaryChar(91);
        this.st.ordinaryChar(93);
        this.st.ordinaryChar(62);
        this.st.ordinaryChar(44);
        this.st.ordinaryChar(45);
        this.st.ordinaryChar(43);
        this.st.ordinaryChar(40);
        this.st.ordinaryChar(41);
        this.st.ordinaryChar(61);
        this.st.ordinaryChar(60);
    }

    public String getNextToken() throws ParseException {
        try {
            int tokenType = this.st.nextToken();
            if (tokenType == -1) {
                return EOF;
            }
            if (tokenType == -3 || tokenType == 39 || tokenType == 34) {
                return this.st.sval;
            }
            if (tokenType == -2) {
                return String.valueOf(this.st.nval);
            }
            return new String(new char[]{(char)tokenType});
        }
        catch (IOException e) {
            this.fail("IOException while attempting to read input stream", e);
            return null;
        }
    }

    public void fail(String message) throws ParseException {
        throw new ParseException(message, this.st.lineno(), -1, this.filename);
    }

    public void fail(String message, Throwable e) throws ParseException {
        throw new ParseException(message, e, this.st.lineno(), -1, this.filename);
    }

    public void fail(Throwable e) throws ParseException {
        throw new ParseException(e, this.st.lineno(), -1, this.filename);
    }
}

