/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.nodetypes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.commons.nodetype.constraint.ValueConstraint;
import org.apache.jackrabbit.spi.commons.value.QValueValue;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.nodetypes.ExtendedItemDefinition;
import org.jahia.services.content.nodetypes.ExtendedNodeDefinition;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.Name;
import org.jahia.services.content.nodetypes.NodeTypeIteratorImpl;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.utils.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedNodeType
implements NodeType {
    private static final transient Logger logger = LoggerFactory.getLogger(ExtendedNodeType.class);
    public static final Name NT_BASE_NAME = new Name("base", "nt", "http://www.jcp.org/jcr/nt/1.0");
    private NodeTypeRegistry registry;
    private String systemId;
    private List<ExtendedItemDefinition> items = new ArrayList<ExtendedItemDefinition>();
    private List<String> groupedItems;
    private Map<String, ExtendedNodeDefinition> nodes = new ConcurrentHashMap<String, ExtendedNodeDefinition>();
    private Map<String, ExtendedPropertyDefinition> properties = new ConcurrentHashMap<String, ExtendedPropertyDefinition>();
    private Map<String, ExtendedNodeDefinition> unstructuredNodes = new ConcurrentHashMap<String, ExtendedNodeDefinition>();
    private Map<Integer, ExtendedPropertyDefinition> unstructuredProperties = new ConcurrentHashMap<Integer, ExtendedPropertyDefinition>();
    private Map<String, ExtendedNodeDefinition> allNodes;
    private volatile Map<String, ExtendedPropertyDefinition> allProperties;
    private Map<String, ExtendedNodeDefinition> allUnstructuredNodes;
    private Map<Integer, ExtendedPropertyDefinition> allUnstructuredProperties;
    private Name name;
    private String alias;
    private boolean isAbstract;
    private boolean isMixin;
    private boolean hasOrderableChildNodes;
    private String primaryItemName;
    private String[] declaredSupertypeNames = new String[0];
    private ExtendedNodeType[] declaredSupertypes = new ExtendedNodeType[0];
    private List<ExtendedNodeType> declaredSubtypes = new ArrayList<ExtendedNodeType>();
    private boolean queryable = true;
    private String itemsType;
    private List<String> mixinExtendNames = new ArrayList<String>();
    private List<ExtendedNodeType> mixinExtend = new ArrayList<ExtendedNodeType>();
    private Map<Locale, String> labels = new ConcurrentHashMap<Locale, String>(1);
    private Map<Locale, String> descriptions = new ConcurrentHashMap<Locale, String>(1);
    private boolean systemType;
    private JahiaTemplatesPackage templatesPackage;

    public ExtendedNodeType(NodeTypeRegistry registry, String systemId) {
        this.registry = registry;
        this.systemId = systemId;
        this.systemType = systemId.startsWith("system-");
    }

    public String getSystemId() {
        return this.systemId;
    }

    public String getName() {
        return this.name.toString();
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public Name getNameObject() {
        return this.name;
    }

    public void setName(Name name) {
        this.name = name;
        this.alias = name != null ? name.toString() : null;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public void setAbstract(boolean anAbstract) {
        this.isAbstract = anAbstract;
    }

    public boolean isMixin() {
        return this.isMixin;
    }

    public void setMixin(boolean mixin) {
        this.isMixin = mixin;
    }

    public boolean hasOrderableChildNodes() {
        if (!this.hasOrderableChildNodes) {
            return this.hasOrderableChildNodes(true);
        }
        return this.hasOrderableChildNodes;
    }

    private boolean hasOrderableChildNodes(boolean checkSupertypes) {
        if (checkSupertypes) {
            ExtendedNodeType[] supertypes;
            for (ExtendedNodeType supertype : supertypes = this.getSupertypes()) {
                if (!supertype.hasOrderableChildNodes(false)) continue;
                return true;
            }
            return false;
        }
        return this.hasOrderableChildNodes;
    }

    public void setHasOrderableChildNodes(boolean hasOrderableChildNodes) {
        this.hasOrderableChildNodes = hasOrderableChildNodes;
    }

    public boolean isQueryable() {
        return this.queryable;
    }

    public void setQueryable(boolean queryable) {
        this.queryable = queryable;
    }

    public String getPrimaryItemName() {
        return this.primaryItemName;
    }

    public void setPrimaryItemName(String primaryItemName) {
        this.primaryItemName = primaryItemName;
    }

    public ExtendedNodeType[] getSupertypes() {
        Set<ExtendedNodeType> l = this.getSupertypeSet();
        return l.toArray(new ExtendedNodeType[l.size()]);
    }

    public Set<ExtendedNodeType> getSupertypeSet() {
        LinkedHashSet<ExtendedNodeType> l = new LinkedHashSet<ExtendedNodeType>();
        boolean primaryFound = false;
        ExtendedNodeType[] d = this.getDeclaredSupertypes();
        for (int i = 0; i < d.length; ++i) {
            ExtendedNodeType s = d[i];
            if (s != null && !s.getNameObject().equals(this.getNameObject())) {
                l.add(s);
                l.addAll(s.getSupertypeSet());
                if (!s.isMixin()) {
                    primaryFound = true;
                }
            }
            if (s == null || !s.getNameObject().equals(this.getNameObject())) continue;
            logger.error("Loop detected in definition " + this.getName());
        }
        if (!(primaryFound || "nt:base".equals(this.getName()) || this.isMixin)) {
            try {
                l.add(this.registry.getNodeType("nt:base"));
            }
            catch (NoSuchNodeTypeException e) {
                logger.error("No such supertype for " + this.getName(), (Throwable)e);
            }
        }
        return l;
    }

    public ExtendedNodeType[] getPrimarySupertypes() {
        ArrayList<ExtendedNodeType> l = new ArrayList<ExtendedNodeType>();
        boolean primaryFound = false;
        ExtendedNodeType[] d = this.getDeclaredSupertypes();
        for (int i = 0; i < d.length; ++i) {
            ExtendedNodeType s = d[i];
            if (s == null || s.isMixin()) continue;
            l.add(s);
            l.addAll(Arrays.asList(s.getPrimarySupertypes()));
            primaryFound = true;
        }
        if (!(primaryFound || "nt:base".equals(this.name.toString()) || this.isMixin)) {
            try {
                l.add(this.registry.getNodeType("nt:base"));
            }
            catch (NoSuchNodeTypeException e) {
                logger.error("No such supertype for " + this.getName(), (Throwable)e);
            }
        }
        return l.toArray(new ExtendedNodeType[l.size()]);
    }

    public ExtendedNodeType[] getDeclaredSupertypes() {
        return this.declaredSupertypes;
    }

    public void setDeclaredSupertypes(String[] declaredSupertypes) {
        this.declaredSupertypeNames = declaredSupertypes;
    }

    public void validate() throws NoSuchNodeTypeException {
        this.declaredSupertypes = new ExtendedNodeType[this.declaredSupertypeNames.length];
        int mixIndex = 0;
        for (int i = 0; i < this.declaredSupertypeNames.length; ++i) {
            ExtendedNodeType nodeType = this.registry.getNodeType(this.declaredSupertypeNames[i]);
            if (!nodeType.isMixin && i > 0) {
                System.arraycopy(this.declaredSupertypes, mixIndex, this.declaredSupertypes, mixIndex + 1, i - mixIndex);
                this.declaredSupertypes[mixIndex] = nodeType;
                ++mixIndex;
            } else {
                this.declaredSupertypes[i] = nodeType;
            }
            nodeType.addSubType(this);
        }
        ArrayList<ExtendedNodeType> newMixinExtend = new ArrayList<ExtendedNodeType>();
        for (String s : this.mixinExtendNames) {
            ExtendedNodeType type = this.registry.getNodeType(s);
            this.registry.addMixinExtension(this, type);
            newMixinExtend.add(type);
        }
        this.mixinExtend = newMixinExtend;
        for (ExtendedItemDefinition itemDefinition : this.items) {
            if (itemDefinition.getItemType() == null) continue;
            this.registry.addTypedItem(itemDefinition);
        }
    }

    void removeSubType(ExtendedNodeType subType) {
        this.declaredSubtypes.remove(subType);
        this.declaredSubtypes.add(subType);
    }

    void addSubType(ExtendedNodeType subType) {
        this.declaredSubtypes.remove(subType);
        this.declaredSubtypes.add(subType);
    }

    public NodeTypeIterator getDeclaredSubtypes() {
        return new NodeTypeIteratorImpl((Iterator)this.declaredSubtypes.iterator(), (long)this.declaredSubtypes.size());
    }

    public String[] getDeclaredSupertypeNames() {
        return this.declaredSupertypeNames;
    }

    public NodeTypeIterator getSubtypes() {
        ArrayList<ExtendedNodeType> l = new ArrayList<ExtendedNodeType>();
        for (ExtendedNodeType s : this.declaredSubtypes) {
            l.add(s);
            NodeTypeIterator subtypes = s.getSubtypes();
            while (subtypes.hasNext()) {
                l.add((ExtendedNodeType)subtypes.next());
            }
        }
        return new NodeTypeIteratorImpl(l.iterator(), (long)l.size());
    }

    public List<ExtendedNodeType> getSubtypesAsList() {
        ArrayList<ExtendedNodeType> l = new ArrayList<ExtendedNodeType>();
        for (ExtendedNodeType s : this.declaredSubtypes) {
            l.add(s);
            NodeTypeIterator subtypes = s.getSubtypes();
            while (subtypes.hasNext()) {
                l.add((ExtendedNodeType)subtypes.next());
            }
        }
        return l;
    }

    public ExtendedNodeType[] getMixinSubtypes() {
        ArrayList<ExtendedNodeType> l = new ArrayList<ExtendedNodeType>();
        for (ExtendedNodeType s : this.declaredSubtypes) {
            if (!s.isMixin()) continue;
            l.add(s);
            l.addAll(Arrays.asList(s.getMixinSubtypes()));
        }
        return l.toArray(new ExtendedNodeType[l.size()]);
    }

    public boolean isNodeType(String typeName) {
        if (this.getName().equals(typeName) || "nt:base".equals(typeName)) {
            return true;
        }
        ExtendedNodeType[] d = this.getDeclaredSupertypes();
        for (int i = 0; i < d.length; ++i) {
            ExtendedNodeType s = d[i];
            if (s == null || !s.isNodeType(typeName)) continue;
            return true;
        }
        return false;
    }

    public List<ExtendedItemDefinition> getItems() {
        ArrayList<ExtendedItemDefinition> l = new ArrayList<ExtendedItemDefinition>();
        l.addAll(this.getDeclaredItems());
        ExtendedNodeType[] supertypes = this.getSupertypes();
        for (int i = 0; i < supertypes.length; ++i) {
            l.addAll(supertypes[i].getDeclaredItems());
        }
        return l;
    }

    public List<ExtendedItemDefinition> getDeclaredItems() {
        return this.getDeclaredItems(false);
    }

    public List<ExtendedItemDefinition> getDeclaredItems(boolean includeOverride) {
        List<ExtendedItemDefinition> res;
        this.getPropertyDefinitionsAsMap();
        this.getChildNodeDefinitionsAsMap();
        if (includeOverride) {
            res = this.items;
        } else {
            res = new ArrayList<ExtendedItemDefinition>();
            for (ExtendedItemDefinition item : this.items) {
                if (item.isOverride()) continue;
                res.add(item);
            }
        }
        return Collections.unmodifiableList(res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ExtendedPropertyDefinition> getPropertyDefinitionsAsMap() {
        if (this.allProperties == null) {
            ExtendedNodeType extendedNodeType = this;
            synchronized (extendedNodeType) {
                if (this.allProperties == null) {
                    LinkedHashMap<String, ExtendedPropertyDefinition> props = new LinkedHashMap<String, ExtendedPropertyDefinition>();
                    props.putAll(this.properties);
                    ExtendedNodeType[] supertypes = this.getSupertypes();
                    for (int i = supertypes.length - 1; i >= 0; --i) {
                        ExtendedNodeType nodeType = supertypes[i];
                        HashMap<String, ExtendedPropertyDefinition> c = new HashMap<String, ExtendedPropertyDefinition>(nodeType.getDeclaredPropertyDefinitionsAsMap());
                        HashMap<String, ExtendedPropertyDefinition> over = new HashMap<String, ExtendedPropertyDefinition>(this.properties);
                        over.keySet().retainAll(c.keySet());
                        for (ExtendedPropertyDefinition s : over.values()) {
                            s.setOverride(true);
                        }
                        c.keySet().removeAll(over.keySet());
                        props.putAll(c);
                    }
                    this.allProperties = Collections.unmodifiableMap(props);
                }
            }
        }
        return this.allProperties;
    }

    public Map<Integer, ExtendedPropertyDefinition> getUnstructuredPropertyDefinitions() {
        if (this.allUnstructuredProperties == null) {
            this.allUnstructuredProperties = new LinkedHashMap<Integer, ExtendedPropertyDefinition>();
            this.allUnstructuredProperties.putAll(this.unstructuredProperties);
            ExtendedNodeType[] supertypes = this.getSupertypes();
            for (int i = supertypes.length - 1; i >= 0; --i) {
                ExtendedNodeType nodeType = supertypes[i];
                HashMap<Integer, ExtendedPropertyDefinition> c = new HashMap<Integer, ExtendedPropertyDefinition>(nodeType.getDeclaredUnstructuredPropertyDefinitions());
                HashMap<Integer, ExtendedPropertyDefinition> over = new HashMap<Integer, ExtendedPropertyDefinition>(this.unstructuredProperties);
                over.keySet().retainAll(c.keySet());
                for (ExtendedPropertyDefinition s : over.values()) {
                    s.setOverride(true);
                }
                c.keySet().removeAll(over.keySet());
                this.allUnstructuredProperties.putAll(c);
            }
        }
        return Collections.unmodifiableMap(this.allUnstructuredProperties);
    }

    public ExtendedPropertyDefinition[] getPropertyDefinitions() {
        ArrayList<ExtendedPropertyDefinition> list = new ArrayList<ExtendedPropertyDefinition>();
        HashSet<String> keys = new HashSet<String>();
        List<ExtendedItemDefinition> i = this.getItems();
        Collections.reverse(i);
        for (ExtendedItemDefinition item : i) {
            if (item.isNode() || !item.isUnstructured() && keys.contains(item.getName())) continue;
            list.add((ExtendedPropertyDefinition)item);
            keys.add(item.getName());
        }
        Collections.reverse(list);
        return list.toArray(new ExtendedPropertyDefinition[list.size()]);
    }

    public Map<String, ExtendedPropertyDefinition> getDeclaredPropertyDefinitionsAsMap() {
        this.getPropertyDefinitionsAsMap();
        return this.properties;
    }

    public Map<Integer, ExtendedPropertyDefinition> getDeclaredUnstructuredPropertyDefinitions() {
        this.getUnstructuredPropertyDefinitions();
        return this.unstructuredProperties;
    }

    public ExtendedPropertyDefinition[] getDeclaredPropertyDefinitions() {
        ArrayList<ExtendedPropertyDefinition> list = new ArrayList<ExtendedPropertyDefinition>();
        List<ExtendedItemDefinition> i = this.getDeclaredItems();
        for (ExtendedItemDefinition item : i) {
            if (item.isNode()) continue;
            list.add((ExtendedPropertyDefinition)item);
        }
        return list.toArray(new ExtendedPropertyDefinition[list.size()]);
    }

    public Map<String, ExtendedNodeDefinition> getChildNodeDefinitionsAsMap() {
        if (this.allNodes == null) {
            LinkedHashMap<String, ExtendedNodeDefinition> allNodesMap = new LinkedHashMap<String, ExtendedNodeDefinition>();
            ExtendedNodeType[] supertypes = this.getSupertypes();
            for (int i = supertypes.length - 1; i >= 0; --i) {
                ExtendedNodeType nodeType = supertypes[i];
                HashMap<String, ExtendedNodeDefinition> c = new HashMap<String, ExtendedNodeDefinition>(nodeType.getDeclaredChildNodeDefinitionsAsMap());
                HashMap<String, ExtendedNodeDefinition> over = new HashMap<String, ExtendedNodeDefinition>(this.nodes);
                over.keySet().retainAll(c.keySet());
                for (ExtendedNodeDefinition s : over.values()) {
                    s.setOverride(true);
                }
                c.keySet().removeAll(over.keySet());
                allNodesMap.putAll(c);
            }
            allNodesMap.putAll(this.nodes);
            this.allNodes = Collections.unmodifiableMap(allNodesMap);
        }
        return this.allNodes;
    }

    public Map<String, ExtendedNodeDefinition> getUnstructuredChildNodeDefinitions() {
        if (this.allUnstructuredNodes == null) {
            LinkedHashMap<String, ExtendedNodeDefinition> allUnstructuredNodesMap = new LinkedHashMap<String, ExtendedNodeDefinition>();
            allUnstructuredNodesMap.putAll(this.unstructuredNodes);
            ExtendedNodeType[] supertypes = this.getSupertypes();
            for (int i = supertypes.length - 1; i >= 0; --i) {
                ExtendedNodeType nodeType = supertypes[i];
                HashMap<String, ExtendedNodeDefinition> c = new HashMap<String, ExtendedNodeDefinition>(nodeType.getDeclaredUnstructuredChildNodeDefinitions());
                HashMap<String, ExtendedNodeDefinition> over = new HashMap<String, ExtendedNodeDefinition>(this.unstructuredNodes);
                over.keySet().retainAll(c.keySet());
                for (ExtendedNodeDefinition s : over.values()) {
                    s.setOverride(true);
                }
                c.keySet().removeAll(over.keySet());
                allUnstructuredNodesMap.putAll(c);
            }
            this.allUnstructuredNodes = Collections.unmodifiableMap(allUnstructuredNodesMap);
        }
        return this.allUnstructuredNodes;
    }

    public ExtendedNodeDefinition[] getChildNodeDefinitions() {
        ArrayList<ExtendedNodeDefinition> list = new ArrayList<ExtendedNodeDefinition>();
        HashSet<String> keys = new HashSet<String>();
        List<ExtendedItemDefinition> i = this.getItems();
        Collections.reverse(i);
        for (ExtendedItemDefinition item : i) {
            if (!item.isNode() || !item.isUnstructured() && keys.contains(item.getName())) continue;
            list.add((ExtendedNodeDefinition)item);
            keys.add(item.getName());
        }
        Collections.reverse(list);
        return list.toArray(new ExtendedNodeDefinition[list.size()]);
    }

    public Map<String, ExtendedNodeDefinition> getDeclaredChildNodeDefinitionsAsMap() {
        this.getChildNodeDefinitionsAsMap();
        return this.nodes;
    }

    public Map<String, ExtendedNodeDefinition> getDeclaredUnstructuredChildNodeDefinitions() {
        this.getUnstructuredChildNodeDefinitions();
        return this.unstructuredNodes;
    }

    public ExtendedNodeDefinition[] getDeclaredChildNodeDefinitions() {
        ArrayList<ExtendedNodeDefinition> list = new ArrayList<ExtendedNodeDefinition>();
        List<ExtendedItemDefinition> i = this.getDeclaredItems();
        for (ExtendedItemDefinition item : i) {
            if (!item.isNode()) continue;
            list.add((ExtendedNodeDefinition)item);
        }
        return list.toArray(new ExtendedNodeDefinition[list.size()]);
    }

    public List<String> getGroupedItems() {
        return this.groupedItems;
    }

    public void setGroupedItems(List<String> groupedItems) {
        this.groupedItems = groupedItems;
    }

    public boolean canSetProperty(String propertyName, Value value) {
        if (value == null) {
            return this.canRemoveItem(propertyName);
        }
        try {
            ExtendedPropertyDefinition def;
            ExtendedPropertyDefinition extendedPropertyDefinition = def = this.getPropertyDefinitionsAsMap().containsKey(propertyName) ? this.getPropertyDefinitionsAsMap().get(propertyName) : this.getMatchingPropDef(this.getUnstructuredPropertyDefinitions().values(), value.getType(), false);
            if (def == null) {
                def = this.getMatchingPropDef(this.getUnstructuredPropertyDefinitions().values(), 0, false);
            }
            if (def != null) {
                if (def.isMultiple() || def.isProtected()) {
                    return false;
                }
                InternalValue internalValue = null;
                if (value.getType() != 2 && (value.getType() != 8 && value.getType() != 7 || value instanceof QValueValue)) {
                    internalValue = InternalValue.create((Value)value, null, null);
                }
                if (internalValue != null) {
                    ExtendedNodeType.checkSetPropertyValueConstraints(def, new InternalValue[]{internalValue});
                }
                return true;
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return false;
    }

    public boolean canSetProperty(String propertyName, Value[] values) {
        if (values == null) {
            return this.canRemoveItem(propertyName);
        }
        try {
            ExtendedPropertyDefinition def;
            int type = 0;
            for (Value value : values) {
                if (value == null) continue;
                if (type == 0) {
                    type = value.getType();
                    continue;
                }
                if (type == value.getType()) continue;
                return false;
            }
            ExtendedPropertyDefinition extendedPropertyDefinition = def = this.getPropertyDefinitionsAsMap().containsKey(propertyName) ? this.getPropertyDefinitionsAsMap().get(propertyName) : this.getMatchingPropDef(this.getUnstructuredPropertyDefinitions().values(), type, true);
            if (def == null) {
                def = this.getMatchingPropDef(this.getUnstructuredPropertyDefinitions().values(), 0, true);
            }
            if (def != null) {
                if (!def.isMultiple() || def.isProtected()) {
                    return false;
                }
                ArrayList<InternalValue> list = new ArrayList<InternalValue>();
                for (Value value : values) {
                    if (value == null) continue;
                    InternalValue internalValue = null;
                    if (value.getType() != 2 && (value.getType() != 8 && value.getType() != 7 || value instanceof QValueValue)) {
                        internalValue = InternalValue.create((Value)value, null, null);
                    }
                    list.add(internalValue);
                }
                if (!list.isEmpty()) {
                    InternalValue[] internalValues = list.toArray(new InternalValue[list.size()]);
                    ExtendedNodeType.checkSetPropertyValueConstraints(def, internalValues);
                }
                return true;
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return false;
    }

    public boolean canAddChildNode(String childNodeName) {
        return this.getChildNodeDefinitionsAsMap().containsKey(childNodeName) && this.getChildNodeDefinitionsAsMap().get(childNodeName).getDefaultPrimaryType() != null;
    }

    public boolean canAddChildNode(String childNodeName, String nodeTypeName) {
        try {
            ExtendedNodeType nt = NodeTypeRegistry.getInstance().getNodeType(nodeTypeName);
            if (!nt.isAbstract() && !nt.isMixin()) {
                if (this.getChildNodeDefinitionsAsMap().containsKey(childNodeName) && this.canAddChildNode(nt, this.getChildNodeDefinitionsAsMap().get(childNodeName))) {
                    return true;
                }
                Collection<ExtendedNodeDefinition> unstruct = this.getUnstructuredChildNodeDefinitions().values();
                for (ExtendedNodeDefinition definition : unstruct) {
                    if (!this.canAddChildNode(nt, definition)) continue;
                    return true;
                }
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return false;
    }

    private boolean canAddChildNode(ExtendedNodeType nt, ExtendedNodeDefinition nodeDef) {
        String[] epd;
        for (String s : epd = nodeDef.getRequiredPrimaryTypeNames()) {
            if (nt.isNodeType(s)) continue;
            return false;
        }
        return true;
    }

    public boolean canRemoveItem(String s) {
        try {
            this.checkRemoveItemConstraints(s);
            return true;
        }
        catch (RepositoryException repositoryException) {
            return false;
        }
    }

    public boolean canRemoveNode(String nodeName) {
        try {
            this.checkRemoveNodeConstraints(nodeName);
            return true;
        }
        catch (RepositoryException repositoryException) {
            return true;
        }
    }

    public boolean canRemoveProperty(String propertyName) {
        try {
            this.checkRemovePropertyConstraints(propertyName);
            return true;
        }
        catch (RepositoryException repositoryException) {
            return false;
        }
    }

    void setPropertyDefinition(String name, ExtendedPropertyDefinition p) {
        if (name.equals("*")) {
            if (p.isMultiple()) {
                this.unstructuredProperties.put(256 + p.getRequiredType(), p);
            } else {
                this.unstructuredProperties.put(p.getRequiredType(), p);
            }
            this.allUnstructuredProperties = null;
        } else {
            this.properties.put(name, p);
            this.allProperties = null;
        }
        this.items.add(p);
    }

    void removePropertyDefinition(ExtendedPropertyDefinition p) {
        String pdName = p.getName();
        if (p.isUnstructured()) {
            if (p.isMultiple()) {
                this.unstructuredProperties.remove(256 + p.getRequiredType());
            } else {
                this.unstructuredProperties.remove(p.getRequiredType());
            }
            this.allUnstructuredProperties = null;
        } else {
            this.properties.remove(pdName);
            this.allProperties = null;
        }
        this.items.remove(p);
    }

    public ExtendedPropertyDefinition getPropertyDefinition(String name) {
        return this.properties.get(name);
    }

    void setNodeDefinition(String name, ExtendedNodeDefinition p) {
        if (p.isUnstructured()) {
            StringBuilder s = new StringBuilder();
            if (p.getRequiredPrimaryTypeNames() == null) {
                logger.error("Required primary type names is null for extended node definition " + p);
            }
            for (String s1 : p.getRequiredPrimaryTypeNames()) {
                s.append(s1).append(" ");
            }
            this.unstructuredNodes.put(s.toString().trim(), p);
            this.allUnstructuredNodes = null;
        } else {
            this.nodes.put(name, p);
            this.allNodes = null;
        }
        this.items.add(p);
    }

    void removeNodeDefinition(ExtendedNodeDefinition p) {
        String ndName = p.getName();
        if (p.isUnstructured()) {
            this.unstructuredNodes.remove(StringUtils.join((Object[])p.getRequiredPrimaryTypeNames(), (String)" "));
            this.allUnstructuredNodes = null;
        } else {
            this.nodes.remove(ndName);
            this.allNodes = null;
        }
        this.items.remove(p);
    }

    public ExtendedNodeDefinition getNodeDefinition(String name) {
        return this.nodes.get(name);
    }

    public String getItemsType() {
        return this.itemsType;
    }

    public void setItemsType(String itemsType) {
        this.itemsType = itemsType;
    }

    public void sortItems(Comparator<ExtendedItemDefinition> c) {
        Collections.sort(this.items, c);
    }

    public void addMixinExtend(String mixinExtension) {
        this.mixinExtendNames.add(mixinExtension);
    }

    public void setMixinExtendNames(List<String> mixinExtendNames) {
        this.mixinExtendNames = mixinExtendNames;
    }

    public List<String> getMixinExtendNames() {
        return this.mixinExtendNames;
    }

    public List<ExtendedNodeType> getMixinExtends() {
        return this.mixinExtend;
    }

    public JahiaTemplatesPackage getTemplatePackage() {
        if (!this.systemType && this.templatesPackage == null) {
            try {
                this.templatesPackage = ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageById(this.getSystemId());
            }
            catch (Exception e) {
                logger.warn("Unable to get the template package for the node with system id '" + this.getSystemId() + "'", (Throwable)e);
            }
        }
        return this.templatesPackage;
    }

    protected String lookupLabel(String key, Locale locale, String defaultValue) {
        JahiaTemplatesPackage pkg = this.getTemplatePackage();
        return pkg != null ? Messages.get(pkg, key, locale, defaultValue) : Messages.getTypes(key, locale, defaultValue);
    }

    public String getLabel(Locale locale) {
        String label = this.labels.get(locale);
        if (label == null) {
            String key = JCRContentUtils.replaceColon(this.getName());
            label = this.lookupLabel(key, locale, StringUtils.substringAfter((String)this.getName(), (String)":"));
            this.labels.put(locale, label);
        }
        return label;
    }

    public String getDescription(Locale locale) {
        String description = this.descriptions.get(locale);
        if (description == null) {
            String key = JCRContentUtils.replaceColon(this.getName()) + "_description";
            description = this.lookupLabel(key, locale, "");
            this.descriptions.put(locale, description);
        }
        return description;
    }

    public NodeTypeDefinition getNodeTypeDefinition() {
        return new Definition();
    }

    public String getLocalName() {
        return this.name.getLocalName();
    }

    public String getPrefix() {
        return this.name.getPrefix();
    }

    private void checkRemoveItemConstraints(String s) throws ConstraintViolationException {
        ExtendedItemDefinition def = this.getPropertyDefinitionsAsMap().get(s);
        if (def == null) {
            def = this.getChildNodeDefinitionsAsMap().get(s);
        }
        if (def != null) {
            if (def.isMandatory()) {
                throw new ConstraintViolationException("can't remove mandatory item");
            }
            if (def.isProtected()) {
                throw new ConstraintViolationException("can't remove protected item");
            }
        }
    }

    private void checkRemoveNodeConstraints(String name) throws ConstraintViolationException {
        ExtendedNodeDefinition def = this.getChildNodeDefinitionsAsMap().get(name);
        if (def != null) {
            if (def.isMandatory()) {
                throw new ConstraintViolationException("can't remove mandatory node");
            }
            if (def.isProtected()) {
                throw new ConstraintViolationException("can't remove protected node");
            }
        }
    }

    private void checkRemovePropertyConstraints(String propertyName) throws ConstraintViolationException {
        ExtendedPropertyDefinition def = this.getPropertyDefinitionsAsMap().get(propertyName);
        if (def != null) {
            if (def.isMandatory()) {
                throw new ConstraintViolationException("can't remove mandatory property");
            }
            if (def.isProtected()) {
                throw new ConstraintViolationException("can't remove protected property");
            }
        }
    }

    private ExtendedPropertyDefinition getMatchingPropDef(Collection<ExtendedPropertyDefinition> defs, int type, boolean multiValued) {
        ExtendedPropertyDefinition match = null;
        for (ExtendedPropertyDefinition pd : defs) {
            int reqType = pd.getRequiredType();
            if (reqType != 0 && type != 0 && reqType != type || multiValued != pd.isMultiple()) continue;
            if (pd.getRequiredType() != 0) {
                return pd;
            }
            if (match != null) continue;
            match = pd;
        }
        return match;
    }

    private static void checkSetPropertyValueConstraints(ExtendedPropertyDefinition pd, InternalValue[] values) throws ConstraintViolationException, RepositoryException {
        if (!pd.isMultiple() && values != null && values.length > 1) {
            throw new ConstraintViolationException("the property is not multi-valued");
        }
        ValueConstraint[] constraints = pd.getValueConstraintObjects();
        if (constraints == null || constraints.length == 0) {
            return;
        }
        if (values != null && values.length > 0) {
            for (InternalValue value : values) {
                boolean satisfied = false;
                ConstraintViolationException cve = null;
                for (ValueConstraint constraint : constraints) {
                    try {
                        constraint.check((QValue)value);
                        satisfied = true;
                        break;
                    }
                    catch (ConstraintViolationException e) {
                        cve = e;
                    }
                }
                if (satisfied) continue;
                throw cve;
            }
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ExtendedNodeType other = (ExtendedNodeType)obj;
        return this.getName() != null ? this.getName().equals(other.getName()) : other.getName() == null;
    }

    public int hashCode() {
        return this.getName() != null ? this.getName().hashCode() : 0;
    }

    public void clearLabels() {
        this.labels.clear();
        this.descriptions.clear();
        if (this.allProperties != null) {
            for (ExtendedPropertyDefinition propertyDefinition : this.allProperties.values()) {
                propertyDefinition.clearLabels();
            }
        }
        if (this.properties != null) {
            for (ExtendedPropertyDefinition propertyDefinition : this.properties.values()) {
                propertyDefinition.clearLabels();
            }
        }
        if (this.items != null) {
            for (ExtendedItemDefinition item : this.items) {
                item.clearLabels();
            }
        }
    }

    public String toString() {
        return this.getName();
    }

    class Definition
    implements NodeTypeDefinition {
        Definition() {
        }

        public String getName() {
            return ExtendedNodeType.this.name.toString();
        }

        public String[] getDeclaredSupertypeNames() {
            ExtendedPropertyDefinition[] defs;
            String[] d = ExtendedNodeType.this.declaredSupertypeNames;
            for (ExtendedPropertyDefinition def : defs = ExtendedNodeType.this.getDeclaredPropertyDefinitions()) {
                if (!def.isInternationalized()) continue;
                String[] newRes = new String[d.length + 1];
                System.arraycopy(d, 0, newRes, 0, d.length);
                newRes[d.length] = "jmix:i18n";
                return newRes;
            }
            return d;
        }

        public boolean isAbstract() {
            return ExtendedNodeType.this.isAbstract;
        }

        public boolean isMixin() {
            return ExtendedNodeType.this.isMixin;
        }

        public boolean hasOrderableChildNodes() {
            return ExtendedNodeType.this.hasOrderableChildNodes;
        }

        public boolean isQueryable() {
            return true;
        }

        public String getPrimaryItemName() {
            return ExtendedNodeType.this.primaryItemName;
        }

        public PropertyDefinition[] getDeclaredPropertyDefinitions() {
            ExtendedPropertyDefinition[] defs = ExtendedNodeType.this.getDeclaredPropertyDefinitions();
            ArrayList<1> r = new ArrayList<1>();
            for (final ExtendedPropertyDefinition def : defs) {
                if (def.isInternationalized() || def.isOverride()) continue;
                r.add(new PropertyDefinition(){

                    public int getRequiredType() {
                        return def.getRequiredType() != 9 ? def.getRequiredType() : 10;
                    }

                    public String[] getValueConstraints() {
                        return def.getValueConstraints();
                    }

                    public Value[] getDefaultValues() {
                        return def.getDefaultValues();
                    }

                    public boolean isMultiple() {
                        return def.isMultiple();
                    }

                    public String[] getAvailableQueryOperators() {
                        return def.getAvailableQueryOperators();
                    }

                    public boolean isFullTextSearchable() {
                        return def.isFullTextSearchable();
                    }

                    public boolean isQueryOrderable() {
                        return def.isQueryOrderable();
                    }

                    public NodeType getDeclaringNodeType() {
                        return def.getDeclaringNodeType();
                    }

                    public String getName() {
                        return def.getName();
                    }

                    public boolean isAutoCreated() {
                        return def.isAutoCreated();
                    }

                    public boolean isMandatory() {
                        return false;
                    }

                    public int getOnParentVersion() {
                        return def.getOnParentVersion();
                    }

                    public boolean isProtected() {
                        return false;
                    }
                });
            }
            return r.toArray(new PropertyDefinition[r.size()]);
        }

        public NodeDefinition[] getDeclaredChildNodeDefinitions() {
            ExtendedNodeDefinition[] defs = ExtendedNodeType.this.getDeclaredChildNodeDefinitions();
            ArrayList<2> r = new ArrayList<2>();
            for (final ExtendedNodeDefinition def : defs) {
                if (def.isOverride()) continue;
                r.add(new NodeDefinition(){

                    public NodeType[] getRequiredPrimaryTypes() {
                        return def.getRequiredPrimaryTypes();
                    }

                    public String[] getRequiredPrimaryTypeNames() {
                        return def.getRequiredPrimaryTypeNames();
                    }

                    public NodeType getDefaultPrimaryType() {
                        return def.getDefaultPrimaryType();
                    }

                    public String getDefaultPrimaryTypeName() {
                        return def.getDefaultPrimaryTypeName();
                    }

                    public boolean allowsSameNameSiblings() {
                        return def.allowsSameNameSiblings();
                    }

                    public NodeType getDeclaringNodeType() {
                        return def.getDeclaringNodeType();
                    }

                    public String getName() {
                        return def.getName();
                    }

                    public boolean isAutoCreated() {
                        return false;
                    }

                    public boolean isMandatory() {
                        return false;
                    }

                    public int getOnParentVersion() {
                        return def.getOnParentVersion();
                    }

                    public boolean isProtected() {
                        return false;
                    }
                });
            }
            return r.toArray(new NodeDefinition[r.size()]);
        }
    }
}

