/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.nodetypes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.nodetypes.ExtendedNodeDefinition;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.utils.Patterns;

public class ConstraintsHelper {
    public static String getConstraints(JCRNodeWrapper node) throws RepositoryException {
        return ConstraintsHelper.getConstraints(node, null);
    }

    public static String getConstraints(JCRNodeWrapper node, String targetChildName) throws RepositoryException {
        ArrayList<ExtendedNodeType> list = new ArrayList<ExtendedNodeType>(Arrays.asList(node.getMixinNodeTypes()));
        list.add(node.getPrimaryNodeType());
        return ConstraintsHelper.getConstraints(list, targetChildName);
    }

    public static String getConstraints(List<ExtendedNodeType> nodeType, String targetChildName) {
        StringBuilder constraints = new StringBuilder();
        HashSet<String> nodeTypeNames = new HashSet<String>();
        if (targetChildName == null) {
            for (ExtendedNodeType type : nodeType) {
                Set<String> cons = type.getUnstructuredChildNodeDefinitions().keySet();
                for (String string : cons) {
                    if (string.equals("jnt:translation") || string.equals("jnt:referenceInField") || nodeTypeNames.contains(string)) continue;
                    if (constraints.length() > 0) {
                        constraints.append(' ');
                    }
                    constraints.append(string);
                    nodeTypeNames.add(string);
                }
            }
        }
        if (targetChildName != null) {
            for (ExtendedNodeType type : nodeType) {
                Map<String, ExtendedNodeDefinition> nodeDefinitions = type.getChildNodeDefinitionsAsMap();
                for (Map.Entry entry : nodeDefinitions.entrySet()) {
                    String[] typeNames;
                    String childName = (String)entry.getKey();
                    boolean useCurrentChild = true;
                    if (targetChildName != null && !targetChildName.equals("*") && !childName.equals(targetChildName)) {
                        useCurrentChild = false;
                    }
                    if (!useCurrentChild) continue;
                    for (String typeName : typeNames = ((ExtendedNodeDefinition)entry.getValue()).getRequiredPrimaryTypeNames()) {
                        if (typeName.equals("jnt:conditionalVisibility") || typeName.equals("jnt:vanityUrls") || typeName.equals("jnt:acl") || nodeTypeNames.contains(typeName)) continue;
                        if (constraints.length() > 0) {
                            constraints.append(' ');
                        }
                        constraints.append(typeName);
                        nodeTypeNames.add(typeName);
                    }
                }
            }
        }
        return constraints.toString();
    }

    public static String getReferenceTypes(String constraints, String nodeTypes) throws NoSuchNodeTypeException {
        StringBuilder buffer = new StringBuilder();
        List<ExtendedNodeType> refs = NodeTypeRegistry.getInstance().getNodeType("jmix:nodeReference").getSubtypesAsList();
        ArrayList<ExtendedNodeType> nodeTypesList = new ArrayList<ExtendedNodeType>();
        ArrayList<ExtendedNodeType> referencesNodeTypesList = new ArrayList<ExtendedNodeType>();
        if (StringUtils.isEmpty((String)nodeTypes)) {
            nodeTypesList.add(NodeTypeRegistry.getInstance().getNodeType("nt:base"));
        } else {
            for (String s : Patterns.SPACE.split(nodeTypes)) {
                ExtendedNodeType nt = NodeTypeRegistry.getInstance().getNodeType(s);
                if (nt.isNodeType("jmix:nodeReference")) {
                    referencesNodeTypesList.add(nt);
                    continue;
                }
                nodeTypesList.add(nt);
            }
        }
        String[] constraintsArray = Patterns.SPACE.split(constraints);
        block1: for (ExtendedNodeType ref : refs) {
            if (ref.getPropertyDefinitionsAsMap().get("j:node") == null) continue;
            for (String s : constraintsArray) {
                if (s.equals("nt:base") && constraintsArray.length > 1 || !ref.isNodeType(s)) continue;
                String[] refConstraints = ref.getPropertyDefinitionsAsMap().get("j:node").getValueConstraints();
                if (refConstraints.length == 0) {
                    refConstraints = new String[]{"jmix:droppableContent"};
                }
                ArrayList<String> finalConstraints = new ArrayList<String>();
                for (String refConstraint : refConstraints) {
                    for (ExtendedNodeType nt : nodeTypesList) {
                        if (nt.isNodeType(refConstraint)) {
                            finalConstraints.add(nt.getName());
                            continue;
                        }
                        if (!NodeTypeRegistry.getInstance().getNodeType(refConstraint).isNodeType(nt.getName())) continue;
                        finalConstraints.add(refConstraint);
                    }
                }
                refConstraints = finalConstraints.toArray(new String[finalConstraints.size()]);
                if (refConstraints.length <= 0) continue block1;
                buffer.append(ref.getName());
                buffer.append("[");
                if (refConstraints.length > 0) {
                    for (int i = 0; i < refConstraints.length; ++i) {
                        buffer.append(refConstraints[i]);
                        if (i + 1 >= refConstraints.length) continue;
                        buffer.append(",");
                    }
                }
                buffer.append("] ");
                continue block1;
            }
        }
        for (ExtendedNodeType ref : referencesNodeTypesList) {
            if (ref.getPropertyDefinitionsAsMap().get("j:node") == null) continue;
            String[] refConstraints = ref.getPropertyDefinitionsAsMap().get("j:node").getValueConstraints();
            buffer.append(ref.getName());
            buffer.append("[");
            if (refConstraints.length > 0) {
                for (int i = 0; i < refConstraints.length; ++i) {
                    buffer.append(refConstraints[i]);
                    if (i + 1 >= refConstraints.length) continue;
                    buffer.append(",");
                }
            }
            buffer.append("] ");
        }
        return buffer.toString().trim();
    }
}

