/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.impl.jackrabbit;

import java.io.File;
import java.io.IOException;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.servlet.ServletContext;
import org.apache.jackrabbit.api.JackrabbitRepository;
import org.apache.jackrabbit.commons.AbstractRepository;
import org.apache.jackrabbit.core.JahiaRepositoryImpl;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.jahia.services.content.impl.jackrabbit.JahiaRepositoryConfig;
import org.jahia.services.content.impl.jackrabbit.RepositoryMigrator;
import org.jahia.settings.SettingsBean;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;
import org.springframework.web.context.ServletContextAware;

public class SpringJackrabbitRepository
extends AbstractRepository
implements JackrabbitRepository,
ServletContextAware,
ApplicationContextAware {
    private JackrabbitRepository repository;
    private Resource configFile;
    private Resource homeDir;
    private String servletContextAttributeName;
    private ServletContext servletContext;
    private boolean useDataStore;
    private ApplicationContext applicationContext;
    private String dataStoreGarbageCollectorBeanId;
    private SettingsBean settings;
    private boolean performMigrationToDataStoreIfNeeded = true;

    public Resource getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(Resource configFile) {
        this.configFile = configFile;
    }

    public Resource getHomeDir() {
        return this.homeDir;
    }

    public void setHomeDir(Resource homeDir) {
        this.homeDir = homeDir;
    }

    public String getServletContextAttributeName() {
        return this.servletContextAttributeName;
    }

    public void setServletContextAttributeName(String servletContextAttributeName) {
        this.servletContextAttributeName = servletContextAttributeName;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    protected JackrabbitRepository createRepository() throws RepositoryException, IOException {
        RepositoryConfig config = RepositoryConfig.create((String)this.configFile.getFile().toString(), (String)this.homeDir.getFile().toString());
        JahiaRepositoryConfig jahiaConfig = new JahiaRepositoryConfig(config);
        this.useDataStore = jahiaConfig.getDataStore() != null;
        try {
            return JahiaRepositoryImpl.create(jahiaConfig);
        }
        catch (RepositoryException e) {
            if (e.getMessage().startsWith("internal error: failed to read custom node type definitions stored in ")) {
                throw new RepositoryException(e.getMessage() + "\nPlease refer to the following Jahia Knowledge Base entry for more details on the issue and how to fix it : https://jira.jahia.org/browse/JKB-29", e.getCause());
            }
            throw e;
        }
    }

    public void start() throws RepositoryException, IOException {
        if (this.homeDir == null) {
            this.homeDir = this.settings.getRepositoryHomeResource();
        }
        String targetRepositoryConfig = System.getProperty("jahia.jackrabbit.targetRepositoryConfig");
        if (this.settings.isProcessingServer() && (this.performMigrationToDataStoreIfNeeded || targetRepositoryConfig != null)) {
            new RepositoryMigrator(this.configFile.getFile(), this.homeDir.getFile(), targetRepositoryConfig != null ? new File(targetRepositoryConfig) : null, this.performMigrationToDataStoreIfNeeded).migrate();
        }
        this.repository = this.createRepository();
        if (this.servletContextAttributeName != null && this.servletContext != null) {
            this.servletContext.setAttribute(this.servletContextAttributeName, (Object)this);
        }
        if (this.settings.isProcessingServer() && this.useDataStore && this.dataStoreGarbageCollectorBeanId != null && this.dataStoreGarbageCollectorBeanId.length() > 0) {
            this.applicationContext.getBean(this.dataStoreGarbageCollectorBeanId);
        }
    }

    public void stop() {
        this.shutdown();
    }

    public Session login(Credentials credentials, String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return this.repository.login(credentials, workspaceName);
    }

    public String getDescriptor(String key) {
        return this.repository.getDescriptor(key);
    }

    public String[] getDescriptorKeys() {
        return this.repository.getDescriptorKeys();
    }

    public boolean isSingleValueDescriptor(String key) {
        return this.repository.isSingleValueDescriptor(key);
    }

    public Value getDescriptorValue(String key) {
        return this.repository.getDescriptorValue(key);
    }

    public Value[] getDescriptorValues(String key) {
        return this.repository.getDescriptorValues(key);
    }

    public JackrabbitRepository getRepository() {
        return this.repository;
    }

    public void shutdown() {
        this.repository.shutdown();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setDataStoreGarbageCollectorBeanId(String dataStoreGarbageCollectorBeanId) {
        this.dataStoreGarbageCollectorBeanId = dataStoreGarbageCollectorBeanId;
    }

    public void setSettings(SettingsBean settings) {
        this.settings = settings;
    }

    public void setPerformMigrationToDataStoreIfNeeded(boolean performMigrationToDataStoreIfNeeded) {
        this.performMigrationToDataStoreIfNeeded = performMigrationToDataStoreIfNeeded;
    }
}

