/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.impl.jackrabbit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.jcr.version.VersionManager;
import org.apache.jackrabbit.api.JackrabbitWorkspace;
import org.apache.jackrabbit.commons.iterator.PropertyIteratorAdapter;
import org.apache.jackrabbit.core.query.QueryManagerImpl;
import org.apache.jackrabbit.util.ISO9075;
import org.jahia.exceptions.JahiaInitializationException;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRStoreProvider;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JackrabbitStoreProvider
extends JCRStoreProvider {
    private static Logger logger = LoggerFactory.getLogger(JackrabbitStoreProvider.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws JahiaInitializationException {
        boolean liveWorkspaceCreated = false;
        JCRSessionWrapper session = null;
        JCRSessionWrapper livesession = null;
        try {
            try {
                session = this.getSystemSession("live");
                session.getProviderSession(this);
            }
            catch (NoSuchWorkspaceException e) {
                if (session != null && session.isLive()) {
                    session.logout();
                }
                session = this.getSystemSession();
                JackrabbitWorkspace jrWs = (JackrabbitWorkspace)session.getProviderSession(this).getWorkspace();
                jrWs.createWorkspace("live");
                liveWorkspaceCreated = true;
            }
            finally {
                if (session != null) {
                    session.logout();
                }
            }
            super.start();
            if (liveWorkspaceCreated) {
                session = this.getSystemSession();
                Session providerSession = session.getProviderSession(this);
                Node n = providerSession.getNode("/");
                this.recurseCheckin(n, providerSession.getWorkspace().getVersionManager());
                NodeIterator ni = n.getNodes();
                livesession = this.getSystemSession("live");
                Session liveProviderSession = livesession.getProviderSession(this);
                Node liveRootNode = liveProviderSession.getRootNode();
                if (!liveRootNode.isNodeType("mix:referenceable")) {
                    liveRootNode.addMixin("mix:referenceable");
                    livesession.save();
                }
                while (ni.hasNext()) {
                    Node node = (Node)ni.next();
                    if (node.getName().equals("jcr:system") || node.isNodeType("jmix:nolive") || liveProviderSession.nodeExists(node.getPath())) continue;
                    liveProviderSession.getWorkspace().clone("default", node.getPath(), node.getPath(), false);
                }
            }
        }
        catch (RepositoryException e) {
            logger.error("Error starting store provider", (Throwable)e);
        }
        finally {
            if (session != null && session.isLive()) {
                session.logout();
            }
            if (livesession != null && livesession.isLive()) {
                livesession.logout();
            }
        }
    }

    private void recurseCheckin(Node node, VersionManager versionManager) throws RepositoryException {
        if (node.isNodeType("mix:versionable")) {
            versionManager.checkpoint(node.getPath());
        }
        NodeIterator ni = node.getNodes();
        while (ni.hasNext()) {
            Node sub = ni.nextNode();
            this.recurseCheckin(sub, versionManager);
        }
    }

    @Override
    public void stop() {
        super.stop();
    }

    @Override
    protected void registerCustomNodeTypes(String systemId, Workspace ws) throws IOException, RepositoryException {
        NodeTypeRegistry.JahiaNodeTypeIterator nti = NodeTypeRegistry.getInstance().getNodeTypes(systemId);
        long timer = System.currentTimeMillis();
        NodeTypeManager jntm = ws.getNodeTypeManager();
        NamespaceRegistry namespaceRegistry = ws.getNamespaceRegistry();
        ArrayList<NodeTypeDefinition> nts = new ArrayList<NodeTypeDefinition>();
        while (nti.hasNext()) {
            ExtendedPropertyDefinition[] propertyDefinitions;
            ExtendedNodeType nodeType = (ExtendedNodeType)nti.next();
            String uri = nodeType.getNameObject().getUri();
            if ("http://www.jcp.org/jcr/nt/1.0".equals(uri) || "http://www.jcp.org/jcr/mix/1.0".equals(uri) || "internal".equals(uri)) continue;
            try {
                namespaceRegistry.getURI(nodeType.getNameObject().getPrefix());
            }
            catch (NamespaceException e) {
                namespaceRegistry.registerNamespace(nodeType.getNameObject().getPrefix(), uri);
            }
            for (ExtendedPropertyDefinition propertyDefinition : propertyDefinitions = nodeType.getDeclaredPropertyDefinitions()) {
                if ("*".equals(propertyDefinition.getLocalName()) || propertyDefinition.getPrefix() == null || "http://www.jcp.org/jcr/nt/1.0".equals(uri = propertyDefinition.getNameObject().getUri()) || "http://www.jcp.org/jcr/mix/1.0".equals(uri) || "internal".equals(uri)) continue;
                try {
                    namespaceRegistry.getURI(propertyDefinition.getPrefix());
                }
                catch (NamespaceException e) {
                    namespaceRegistry.registerNamespace(propertyDefinition.getNameObject().getPrefix(), uri);
                }
            }
            nts.add(nodeType.getNodeTypeDefinition());
        }
        jntm.registerNodeTypes(nts.toArray(new NodeTypeDefinition[nts.size()]), true);
        logger.info("Custom node types registered for {} in {} ms", (Object)systemId, (Object)(System.currentTimeMillis() - timer));
    }

    @Override
    protected void unregisterCustomNodeTypes(String systemId, Workspace ws) throws IOException, RepositoryException {
        org.apache.jackrabbit.core.nodetype.NodeTypeRegistry.disableCheckForReferencesInContentException = true;
        NodeTypeRegistry.JahiaNodeTypeIterator nti = NodeTypeRegistry.getInstance().getNodeTypes(systemId);
        ArrayList<String> names = new ArrayList<String>();
        long timer = System.currentTimeMillis();
        NodeTypeManager jntm = ws.getNodeTypeManager();
        while (nti.hasNext()) {
            names.add(nti.nextNodeType().getName());
        }
        try {
            jntm.unregisterNodeTypes(names.toArray(new String[names.size()]));
            logger.info("Custom node types unregistered for {} in {} ms", (Object)systemId, (Object)(System.currentTimeMillis() - timer));
        }
        catch (ItemNotFoundException e) {
            logger.info("Couldn't unregister custom node types {}. They probably have already been unregistered.", names);
            logger.debug("Couldn't unregister custom node types " + names + ". They probably have already been unregistered.", (Throwable)e);
        }
    }

    @Override
    protected boolean canRegisterCustomNodeTypes() {
        return true;
    }

    @Override
    public PropertyIterator getWeakReferences(JCRNodeWrapper node, String propertyName, Session session) throws RepositoryException {
        if (propertyName == null) {
            ArrayList<Node> referringNodes = ((QueryManagerImpl)session.getWorkspace().getQueryManager()).getWeaklyReferringNodes((Node)node);
            if (node.getSession().getLocale() != null) {
                String currentLanguage = node.getSession().getLocale().toString();
                ArrayList<Node> filteredNodes = new ArrayList<Node>();
                for (Node referringNode : referringNodes) {
                    if (referringNode.isNodeType("jnt:translation") && !currentLanguage.equals(referringNode.getProperty("jcr:language").getString())) continue;
                    filteredNodes.add(referringNode);
                }
                referringNodes = filteredNodes;
            }
            Value ref = session.getValueFactory().createValue((Node)node, true);
            ArrayList<Property> props = new ArrayList<Property>();
            for (Node n : referringNodes) {
                PropertyIterator it = n.getProperties();
                while (it.hasNext()) {
                    Collection<Value> refs;
                    Property p = it.nextProperty();
                    if (p.getType() != 10 || !(refs = p.isMultiple() ? Arrays.asList(p.getValues()) : Collections.singleton(p.getValue())).contains(ref)) continue;
                    props.add(p);
                }
            }
            return new PropertyIteratorAdapter(props);
        }
        StringBuilder stmt = new StringBuilder();
        stmt.append("//*[@").append(ISO9075.encode((String)propertyName));
        stmt.append(" = '").append(node.getIdentifier()).append("'");
        if (node.getSession().getLocale() != null) {
            stmt.append(" and (@jcr:language = '").append(node.getSession().getLocale().toString()).append("' or not(@jcr:language))");
        }
        stmt.append("]");
        Query q = session.getWorkspace().getQueryManager().createQuery(stmt.toString(), "xpath");
        QueryResult result = q.execute();
        ArrayList<Property> l = new ArrayList<Property>();
        HashSet<Node> uniqueResults = new HashSet<Node>();
        NodeIterator nit = result.getNodes();
        while (nit.hasNext()) {
            Node n = nit.nextNode();
            if (!uniqueResults.add(n) || !n.hasProperty(propertyName)) continue;
            l.add(n.getProperty(propertyName));
        }
        if (l.isEmpty()) {
            return PropertyIteratorAdapter.EMPTY;
        }
        return new PropertyIteratorAdapter(l);
    }

    @Override
    public boolean canCacheNode(Node node) {
        return true;
    }
}

