/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content;

import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRStoreProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeIteratorWrapper
implements JCRNodeIteratorWrapper {
    private static final Logger logger = LoggerFactory.getLogger(NodeIteratorWrapper.class);
    private NodeIterator ni;
    private JCRNodeWrapper nextNode = null;
    private JCRSessionWrapper session;
    private JCRStoreProvider provider;

    public NodeIteratorWrapper(NodeIterator ni, JCRSessionWrapper session, JCRStoreProvider provider) {
        this.ni = ni;
        this.session = session;
        this.provider = provider;
        this.prefetchNext();
    }

    private void prefetchNext() {
        block8: while (true) {
            try {
                while (true) {
                    Node n = null;
                    while (this.ni.hasNext() && n == null) {
                        n = this.ni.nextNode();
                        if (this.session.getVersionDate() == null && this.session.getVersionLabel() == null) continue;
                        try {
                            n = this.session.getNode(n.getPath());
                        }
                        catch (PathNotFoundException e) {
                            n = null;
                        }
                    }
                    if (n == null) break;
                    if (this.session.getLocale() != null && n.isNodeType("jnt:translation")) {
                        try {
                            n = n.getParent();
                        }
                        catch (ItemNotFoundException e) {
                            // empty catch block
                        }
                    }
                    try {
                        this.nextNode = this.provider.getNodeWrapper(n, this.session);
                        break block8;
                    }
                    catch (PathNotFoundException pathNotFoundException) {
                        continue;
                    }
                    break;
                }
                this.nextNode = null;
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
                continue;
            }
            break;
        }
    }

    public void skip(long skipNum) {
        int i = 0;
        while ((long)i < skipNum) {
            this.prefetchNext();
            ++i;
        }
        if (this.nextNode == null) {
            throw new NoSuchElementException();
        }
    }

    public long getSize() {
        return this.ni.getSize();
    }

    public long getPosition() {
        return this.ni.getPosition() - (long)(this.nextNode != null ? 1 : 0);
    }

    public Node nextNode() {
        return (Node)this.next();
    }

    public boolean hasNext() {
        return this.nextNode != null;
    }

    public Object next() {
        return this.wrappedNext();
    }

    private JCRNodeWrapper wrappedNext() {
        JCRNodeWrapper res = this.nextNode;
        if (res == null) {
            throw new NoSuchElementException();
        }
        this.prefetchNext();
        return res;
    }

    public void remove() {
        this.ni.remove();
    }

    @Override
    public Iterator<JCRNodeWrapper> iterator() {
        return new Iterator<JCRNodeWrapper>(){

            @Override
            public boolean hasNext() {
                return NodeIteratorWrapper.this.hasNext();
            }

            @Override
            public JCRNodeWrapper next() {
                return NodeIteratorWrapper.this.wrappedNext();
            }

            @Override
            public void remove() {
                NodeIteratorWrapper.this.remove();
            }
        };
    }
}

