/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.apache.jackrabbit.api.observation.JackrabbitEvent;
import org.jahia.services.content.JCRObservationManager;

public abstract class DefaultEventListener
implements EventListener {
    protected Set<String> propertiesToIgnore = new HashSet<String>();
    protected String workspace;
    protected boolean availableDuringPublish = false;
    protected Set<Integer> operationTypes;

    protected DefaultEventListener() {
        this.propertiesToIgnore.add("jcr:primaryType");
        this.propertiesToIgnore.add("jcr:uuid");
        this.propertiesToIgnore.add("jcr:created");
        this.propertiesToIgnore.add("jcr:createdBy");
        this.propertiesToIgnore.add("jcr:lastModified");
        this.propertiesToIgnore.add("jcr:lastModifiedBy");
        this.propertiesToIgnore.add("j:lastPublished");
        this.propertiesToIgnore.add("j:lastPublishedBy");
        this.propertiesToIgnore.add("j:published");
        this.propertiesToIgnore.add("jcr:lockOwner");
        this.propertiesToIgnore.add("jcr:lockIsDeep");
        this.propertiesToIgnore.add("j:locktoken");
        this.propertiesToIgnore.add("j:lockTypes");
        this.propertiesToIgnore.add("jcr:isCheckedOut");
        this.propertiesToIgnore.add("jcr:versionHistory");
        this.propertiesToIgnore.add("jcr:predecessors");
        this.propertiesToIgnore.add("jcr:successors");
        this.propertiesToIgnore.add("jcr:baseVersion");
        this.propertiesToIgnore.add("jcr:frozenUuid");
        this.propertiesToIgnore.add("j:fullpath");
        this.propertiesToIgnore.add("j:nodename");
        this.propertiesToIgnore.add("j:processId");
        this.propertiesToIgnore.add("jcr:mergeFailed");
        this.propertiesToIgnore.add("j:revisionNumber");
        this.propertiesToIgnore.add("j:checkinDate");
        this.propertiesToIgnore.add("lastLoginDate");
        this.propertiesToIgnore.add("j:originWS");
    }

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    protected boolean isExternal(Event event) {
        if (event instanceof JackrabbitEvent) {
            return ((JackrabbitEvent)event).isExternal();
        }
        if (event instanceof JCRObservationManager.EventWrapper) {
            return ((JCRObservationManager.EventWrapper)event).isExternal();
        }
        return false;
    }

    protected boolean isSupportedOperationType(int operationType) {
        return this.operationTypes == null || this.operationTypes.contains(operationType);
    }

    public abstract int getEventTypes();

    public String getPath() {
        return null;
    }

    public boolean isDeep() {
        return true;
    }

    public String[] getNodeTypes() {
        return null;
    }

    public String[] getUuids() {
        return null;
    }

    public boolean isAvailableDuringPublish() {
        return this.availableDuringPublish;
    }

    public void setAvailableDuringPublish(boolean availableDuringPublish) {
        this.availableDuringPublish = availableDuringPublish;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public void setOperationTypes(Set<Integer> operationTypes) {
        this.operationTypes = operationTypes;
    }

    public Set<Integer> getOperationTypes() {
        return this.operationTypes;
    }

    public List<Event> getMoveFilteredEvents(EventIterator eventIterator) throws RepositoryException {
        ArrayList<Event> eventList = new ArrayList<Event>();
        Event previousPreviousEvent = null;
        Event previousEvent = null;
        while (eventIterator.hasNext()) {
            Event event = eventIterator.nextEvent();
            String identifier = null;
            identifier = event.getIdentifier();
            String previousIdentifier = null;
            if (previousEvent != null) {
                previousIdentifier = previousEvent.getIdentifier();
            }
            String previousPreviousIdentifier = null;
            if (previousPreviousEvent != null) {
                previousPreviousIdentifier = previousPreviousEvent.getIdentifier();
            }
            if (32 == event.getType() && previousEvent != null && previousPreviousEvent != null && 2 == previousPreviousEvent.getType() && 1 == previousEvent.getType() && identifier != null && identifier.equals(previousIdentifier) && identifier.equals(previousPreviousIdentifier)) {
                eventList.remove(eventList.size());
            }
            eventList.add(event);
            previousPreviousEvent = previousEvent;
            previousEvent = event;
        }
        return eventList;
    }
}

