/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.jcr.ItemNotFoundException;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRPublicationService;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRValueWrapper;
import org.jahia.services.content.JCRVersionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConflictResolver {
    private static List<String> ignore = Arrays.asList("jcr:uuid", "jcr:primaryType", "jcr:created", "jcr:createdBy", "jcr:baseVersion", "jcr:isCheckedOut", "jcr:versionHistory", "jcr:predecessors", "jcr:activity", "j:checkinDate", "j:locktoken", "j:lockTypes", "jcr:lockOwner", "jcr:lockIsDeep", "j:deletedChildren", "j:processId");
    private static Logger logger = LoggerFactory.getLogger(ConflictResolver.class);
    private JCRNodeWrapper sourceNode;
    private JCRNodeWrapper targetNode;
    private Set<JCRNodeWrapper> toCheckpoint;
    private List<Diff> differences;
    private List<Diff> unresolvedDifferences;

    public ConflictResolver(JCRNodeWrapper sourceNode, JCRNodeWrapper targetNode) throws RepositoryException {
        this.sourceNode = sourceNode;
        this.targetNode = targetNode;
    }

    public void setToCheckpoint(Set<JCRNodeWrapper> toCheckpoint) {
        this.toCheckpoint = toCheckpoint;
    }

    public List<Diff> getUnresolvedDifferences() {
        return this.unresolvedDifferences;
    }

    public void applyDifferences() throws RepositoryException {
        this.computeDifferences();
        this.unresolvedDifferences = new ArrayList<Diff>();
        for (Diff diff : this.differences) {
            if (diff.apply()) continue;
            this.unresolvedDifferences.add(diff);
        }
        this.targetNode.getSession().save();
    }

    private void computeDifferences() throws RepositoryException {
        this.differences = this.compare(this.sourceNode, this.targetNode, "");
    }

    private List<Diff> compare(JCRNodeWrapper sourceNode, JCRNodeWrapper targetNode, String basePath) throws RepositoryException {
        boolean inludeSubNodes;
        ArrayList<Diff> diffs = new ArrayList<Diff>();
        boolean bl = inludeSubNodes = !targetNode.isNodeType("jmix:remotelyPublished");
        if (inludeSubNodes) {
            ListOrderedMap targetUuids = this.getChildEntries(targetNode, targetNode.getSession());
            ListOrderedMap sourceUuids = this.getChildEntries(sourceNode, sourceNode.getSession());
            if (!targetUuids.values().equals(sourceUuids.values())) {
                for (String key : sourceUuids.keySet()) {
                    if (!targetUuids.containsKey((Object)key) || targetUuids.get((Object)key).equals(sourceUuids.get((Object)key))) continue;
                    diffs.add(new ChildRenamedDiff(key, this.addPath(basePath, (String)targetUuids.get((Object)key)), this.addPath(basePath, (String)sourceUuids.get((Object)key))));
                }
            }
            if (!targetUuids.keyList().equals(sourceUuids.keyList())) {
                ArrayList added = new ArrayList(sourceUuids.keySet());
                added.removeAll(targetUuids.keySet());
                ArrayList removed = new ArrayList(targetUuids.keySet());
                removed.removeAll(sourceUuids.keySet());
                if (targetNode.getPrimaryNodeType().hasOrderableChildNodes()) {
                    Map<String, String> newOrdering = this.getOrdering(sourceUuids, Collections.emptyList());
                    ArrayList oldUuidsList = new ArrayList(targetUuids.keySet());
                    oldUuidsList.removeAll(removed);
                    ArrayList newUuidsList = new ArrayList(sourceUuids.keySet());
                    newUuidsList.removeAll(added);
                    if (!oldUuidsList.equals(newUuidsList)) {
                        for (int i = 1; i < oldUuidsList.size(); ++i) {
                            int n;
                            String x = (String)oldUuidsList.get(i);
                            for (n = i; n > 0 && sourceUuids.indexOf(oldUuidsList.get(n - 1)) > sourceUuids.indexOf((Object)x); --n) {
                                oldUuidsList.set(n, oldUuidsList.get(n - 1));
                            }
                            if (n == i) continue;
                            String orderBeforeUuid = n + 1 == oldUuidsList.size() ? null : (String)oldUuidsList.get(n + 1);
                            diffs.add(new ChildNodeReorderedDiff(x, orderBeforeUuid, this.addPath(basePath, (String)sourceUuids.get((Object)x)), (String)sourceUuids.get((Object)orderBeforeUuid), newOrdering));
                            logger.debug("reorder " + sourceUuids.get((Object)x) + " before " + sourceUuids.get((Object)orderBeforeUuid));
                            oldUuidsList.set(n, x);
                        }
                    }
                }
                for (String s : removed) {
                    try {
                        this.sourceNode.getSession().getNodeByUUID(s);
                    }
                    catch (ItemNotFoundException e) {
                        diffs.add(new ChildRemovedDiff(s, this.addPath(basePath, (String)targetUuids.get((Object)s)), s));
                    }
                }
                for (String uuid : added) {
                    diffs.add(new ChildAddedDiff(uuid, this.addPath(basePath, (String)sourceUuids.get((Object)uuid)), uuid.equals(sourceUuids.lastKey()) ? null : (String)sourceUuids.get(sourceUuids.get(sourceUuids.indexOf((Object)uuid) + 1))));
                }
            }
        }
        PropertyIterator pi1 = targetNode.getProperties();
        while (pi1.hasNext()) {
            JCRPropertyWrapper prop1 = (JCRPropertyWrapper)pi1.next();
            String propName = prop1.getName();
            if (ignore.contains(propName)) continue;
            if (!sourceNode.hasProperty(propName)) {
                if (prop1.isMultiple()) {
                    JCRValueWrapper[] values;
                    for (JCRValueWrapper value : values = prop1.getRealValues()) {
                        diffs.add(new PropertyRemovedDiff(this.addPath(basePath, propName), value));
                    }
                    continue;
                }
                diffs.add(new PropertyChangedDiff(this.addPath(basePath, propName), null));
                continue;
            }
            JCRPropertyWrapper prop2 = sourceNode.getProperty(propName);
            if (prop1.isMultiple() != prop2.isMultiple()) {
                throw new RepositoryException();
            }
            if (prop1.isMultiple()) {
                List<JCRValueWrapper> vs1 = Arrays.asList(prop1.getRealValues());
                List<JCRValueWrapper> vs2 = Arrays.asList(prop2.getRealValues());
                HashMap<String, JCRValueWrapper> added = new HashMap<String, JCRValueWrapper>();
                for (JCRValueWrapper value : vs2) {
                    added.put(value.getString(), value);
                }
                for (JCRValueWrapper value : vs1) {
                    added.remove(value.getString());
                }
                for (JCRValueWrapper value : added.values()) {
                    diffs.add(new PropertyAddedDiff(this.addPath(basePath, propName), value));
                }
                HashMap<String, Value> removed = new HashMap<String, Value>();
                for (Value value : vs1) {
                    removed.put(value.getString(), value);
                }
                for (Value value : vs2) {
                    removed.remove(value.getString());
                }
                for (Value value : removed.values()) {
                    diffs.add(new PropertyRemovedDiff(this.addPath(basePath, propName), value));
                }
                continue;
            }
            if (this.equalsValue(prop1.getRealValue(), prop2.getRealValue())) continue;
            diffs.add(new PropertyChangedDiff(this.addPath(basePath, propName), prop2.getRealValue()));
        }
        PropertyIterator pi2 = sourceNode.getProperties();
        while (pi2.hasNext()) {
            JCRPropertyWrapper prop2 = (JCRPropertyWrapper)pi2.next();
            String propName = prop2.getName();
            if (ignore.contains(propName) || targetNode.hasProperty(propName)) continue;
            if (prop2.isMultiple()) {
                JCRValueWrapper[] values;
                for (JCRValueWrapper value : values = prop2.getRealValues()) {
                    diffs.add(new PropertyAddedDiff(this.addPath(basePath, prop2.getName()), value));
                }
                continue;
            }
            diffs.add(new PropertyChangedDiff(this.addPath(basePath, prop2.getName()), prop2.getRealValue()));
        }
        for (Diff diff : new ArrayList(diffs)) {
            if (!(diff instanceof PropertyAddedDiff) || !((PropertyAddedDiff)diff).propertyPath.endsWith("jcr:mixinTypes")) continue;
            diffs.remove(diff);
            diffs.add(0, diff);
        }
        for (Diff diff : new ArrayList(diffs)) {
            if (!(diff instanceof PropertyRemovedDiff) || !((PropertyRemovedDiff)diff).propertyPath.endsWith("jcr:mixinTypes")) continue;
            diffs.remove(diff);
            diffs.add(0, diff);
        }
        if (inludeSubNodes) {
            JCRNodeIteratorWrapper ni = targetNode.getNodes();
            while (ni.hasNext()) {
                JCRNodeWrapper sub = (JCRNodeWrapper)ni.next();
                if (!sourceNode.hasNode(sub.getName()) || sub.isVersioned() || sourceNode.getNode(sub.getName()).isVersioned() || !JCRPublicationService.supportsPublication(sub.getSession(), sub)) continue;
                diffs.addAll(this.compare(sourceNode.getNode(sub.getName()), sub, this.addPath(basePath, sub.getName())));
            }
        }
        return diffs;
    }

    private Map<String, String> getOrdering(ListOrderedMap uuids1, List<String> removed) {
        LinkedHashMap<String, String> previousMap = new LinkedHashMap<String, String>();
        ListIterator it = uuids1.keyList().listIterator(uuids1.size());
        String previous = "";
        while (it.hasPrevious()) {
            String uuid = (String)it.previous();
            if (removed.contains(uuid)) continue;
            previousMap.put(uuid, previous);
            previous = uuid;
        }
        return previousMap;
    }

    private ListOrderedMap getChildEntries(JCRNodeWrapper node, JCRSessionWrapper session) throws RepositoryException {
        ListOrderedMap childEntries = new ListOrderedMap();
        for (JCRNodeWrapper child : node.getNodes()) {
            try {
                if (child.isNodeType("jmix:nolive") || !JCRPublicationService.supportsPublication(session, child) || session.getWorkspace().getName().equals("live") && child.hasProperty("j:originWS") && child.getProperty("j:originWS").getString().equals("live")) continue;
                session.getNodeByUUID(child.getIdentifier());
                childEntries.put((Object)child.getIdentifier(), (Object)child.getName());
            }
            catch (ItemNotFoundException e) {}
        }
        return childEntries;
    }

    public boolean equalsValue(Value o1, Value o2) {
        try {
            if (o1.getType() != o2.getType()) {
                return false;
            }
            if (o1.getType() == 2) {
                return o1.equals(o2);
            }
            return o1.getString().equals(o2.getString());
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private String addPath(String basePath, String name) {
        return basePath.equals("") ? name : basePath + "/" + name;
    }

    private JCRNodeWrapper getParentTarget(JCRNodeWrapper target, String path) throws RepositoryException {
        if (path.contains("/")) {
            return target.getNode(StringUtils.substringBeforeLast((String)path, (String)"/"));
        }
        return target;
    }

    private String getTargetName(String path) {
        if (path.contains("/")) {
            return StringUtils.substringAfterLast((String)path, (String)"/");
        }
        return path;
    }

    class PropertyChangedDiff
    implements Diff {
        private String propertyPath;
        private Value newValue;

        PropertyChangedDiff(String propertyPath, Value newValue) {
            this.propertyPath = propertyPath;
            this.newValue = newValue;
        }

        @Override
        public boolean apply() throws RepositoryException {
            JCRNodeWrapper targetNode = ConflictResolver.this.getParentTarget(ConflictResolver.this.targetNode, this.propertyPath);
            String propertyName = ConflictResolver.this.getTargetName(this.propertyPath);
            if (!targetNode.isCheckedOut()) {
                targetNode.checkout();
            }
            if (this.newValue == null) {
                if (targetNode.hasProperty(propertyName)) {
                    targetNode.getProperty(propertyName).remove();
                }
            } else {
                targetNode.getRealNode().setProperty(propertyName, this.newValue);
            }
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PropertyChangedDiff that = (PropertyChangedDiff)o;
            if (this.newValue != null ? !this.newValue.equals(that.newValue) : that.newValue != null) {
                return false;
            }
            return !(this.propertyPath != null ? !this.propertyPath.equals(that.propertyPath) : that.propertyPath != null);
        }

        public int hashCode() {
            int result = this.propertyPath != null ? this.propertyPath.hashCode() : 0;
            result = 31 * result + (this.newValue != null ? this.newValue.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "PropertyChangedDiff{propertyPath='" + this.propertyPath + '\'' + ", newValue=" + this.newValue + '}';
        }
    }

    class PropertyRemovedDiff
    implements Diff {
        private String propertyPath;
        private Value oldValue;

        PropertyRemovedDiff(String propertyPath, Value oldValue) {
            this.propertyPath = propertyPath;
            this.oldValue = oldValue;
        }

        @Override
        public boolean apply() throws RepositoryException {
            try {
                JCRNodeWrapper targetNode = ConflictResolver.this.getParentTarget(ConflictResolver.this.targetNode, this.propertyPath);
                String propertyName = ConflictResolver.this.getTargetName(this.propertyPath);
                if (!targetNode.isCheckedOut()) {
                    targetNode.checkout();
                }
                if (propertyName.equals("jcr:mixinTypes")) {
                    targetNode.removeMixin(this.oldValue.getString());
                } else {
                    List<JCRValueWrapper> oldValues = Arrays.asList(targetNode.getProperty(propertyName).getRealValues());
                    ArrayList<Value> newValues = new ArrayList<Value>();
                    for (Value value : oldValues) {
                        if (ConflictResolver.this.equalsValue(value, this.oldValue)) continue;
                        newValues.add(value);
                    }
                    if (newValues.isEmpty()) {
                        targetNode.getProperty(propertyName).remove();
                    } else {
                        targetNode.setProperty(propertyName, newValues.toArray(new Value[newValues.size()]));
                    }
                }
            }
            catch (PathNotFoundException e) {
                logger.debug("Property has already been removed", (Throwable)e);
            }
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PropertyRemovedDiff that = (PropertyRemovedDiff)o;
            return ConflictResolver.this.equalsValue(this.oldValue, that.oldValue);
        }

        public int hashCode() {
            int result = this.propertyPath != null ? this.propertyPath.hashCode() : 0;
            result = 31 * result + (this.oldValue != null ? this.oldValue.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "PropertyRemovedDiff{propertyPath='" + this.propertyPath + '\'' + ", oldValue=" + this.oldValue + '}';
        }
    }

    class PropertyAddedDiff
    implements Diff {
        private String propertyPath;
        private Value newValue;

        PropertyAddedDiff(String propertyPath, Value newValue) {
            this.propertyPath = propertyPath;
            this.newValue = newValue;
        }

        @Override
        public boolean apply() throws RepositoryException {
            JCRNodeWrapper targetNode = ConflictResolver.this.getParentTarget(ConflictResolver.this.targetNode, this.propertyPath);
            String propertyName = ConflictResolver.this.getTargetName(this.propertyPath);
            if (!targetNode.isCheckedOut()) {
                targetNode.checkout();
            }
            if (propertyName.equals("jcr:mixinTypes")) {
                targetNode.addMixin(this.newValue.getString());
            } else if (targetNode.hasProperty(propertyName)) {
                ArrayList<JCRValueWrapper> values = new ArrayList<JCRValueWrapper>(Arrays.asList(targetNode.getProperty(propertyName).getRealValues()));
                values.add((JCRValueWrapper)this.newValue);
                targetNode.setProperty(propertyName, values.toArray(new Value[values.size()]));
            } else {
                targetNode.setProperty(propertyName, new Value[]{this.newValue});
            }
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PropertyAddedDiff that = (PropertyAddedDiff)o;
            return ConflictResolver.this.equalsValue(this.newValue, that.newValue);
        }

        public int hashCode() {
            int result = this.propertyPath != null ? this.propertyPath.hashCode() : 0;
            result = 31 * result + (this.newValue != null ? this.newValue.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "PropertyAddedDiff{propertyPath='" + this.propertyPath + '\'' + ", newValue=" + this.newValue + '}';
        }
    }

    class ChildNodeReorderedDiff
    implements Diff {
        private String name;
        private String orderBeforeName;
        private String uuid;
        private String orderBeforeUuid;
        private Map<String, String> ordering;

        ChildNodeReorderedDiff(String uuid, String orderBeforeUuid, String name, String orderBeforeName, Map<String, String> ordering) {
            this.name = name;
            this.orderBeforeName = orderBeforeName;
            this.uuid = uuid;
            this.orderBeforeUuid = orderBeforeUuid;
            this.ordering = ordering;
        }

        @Override
        public boolean apply() throws RepositoryException {
            if (ConflictResolver.this.targetNode.hasNode(this.name)) {
                JCRNodeWrapper realTargetNode = ConflictResolver.this.targetNode;
                String realName = this.name;
                if (this.name.contains("/")) {
                    realTargetNode = ConflictResolver.this.targetNode.getNode(StringUtils.substringBeforeLast((String)this.name, (String)"/"));
                    realName = StringUtils.substringAfterLast((String)this.name, (String)"/");
                }
                if (realTargetNode.getPrimaryNodeType().hasOrderableChildNodes()) {
                    while (this.orderBeforeName != null && !realTargetNode.hasNode(this.orderBeforeName)) {
                        this.orderBeforeUuid = this.ordering.get(this.orderBeforeUuid);
                        try {
                            if (this.orderBeforeUuid.equals("")) {
                                this.orderBeforeName = null;
                                continue;
                            }
                            this.orderBeforeName = realTargetNode.getSession().getNodeByUUID(this.orderBeforeUuid).getName();
                        }
                        catch (ItemNotFoundException itemNotFoundException) {}
                    }
                    realTargetNode.orderBefore(realName, this.orderBeforeName);
                }
            }
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChildNodeReorderedDiff that = (ChildNodeReorderedDiff)o;
            if (this.orderBeforeUuid != null ? !this.orderBeforeUuid.equals(that.orderBeforeUuid) : that.orderBeforeUuid != null) {
                return false;
            }
            return !(this.uuid != null ? !this.uuid.equals(that.uuid) : that.uuid != null);
        }

        public int hashCode() {
            int result = this.uuid != null ? this.uuid.hashCode() : 0;
            result = 31 * result + (this.orderBeforeUuid != null ? this.orderBeforeUuid.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "ChildNodeReorderedDiff{name='" + this.name + '\'' + ", orderBeforeName='" + this.orderBeforeName + '\'' + ", uuid='" + this.uuid + '\'' + ", orderBeforeUuid='" + this.orderBeforeUuid + '\'' + ", ordering=" + this.ordering + '}';
        }
    }

    class ChildRemovedDiff
    implements Diff {
        private String uuid;
        private String oldName;
        private String identifier;

        ChildRemovedDiff(String uuid, String oldName, String identifier) {
            this.uuid = uuid;
            this.oldName = oldName;
            this.identifier = identifier;
        }

        @Override
        public boolean apply() throws RepositoryException {
            JCRNodeWrapper node;
            if (ConflictResolver.this.targetNode.hasNode(this.oldName) && (node = ConflictResolver.this.targetNode.getNode(this.oldName)).getIdentifier().equals(this.identifier)) {
                JCRPublicationService.getInstance().addRemovedLabel(node, node.getSession().getWorkspace().getName() + "_removed_at_" + JCRVersionService.DATE_FORMAT.print(System.currentTimeMillis()));
                node.remove();
            }
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChildRemovedDiff that = (ChildRemovedDiff)o;
            if (!this.oldName.equals(that.oldName)) {
                return false;
            }
            return this.uuid.equals(that.uuid);
        }

        public int hashCode() {
            int result = this.uuid.hashCode();
            result = 31 * result + this.oldName.hashCode();
            return result;
        }

        public String toString() {
            return "ChildRemovedDiff{uuid='" + this.uuid + '\'' + ", oldName='" + this.oldName + '\'' + '}';
        }
    }

    class ChildAddedDiff
    implements Diff {
        private String uuid;
        private String newName;
        private String nextSibling;

        ChildAddedDiff(String uuid, String newName, String nextSibling) {
            this.uuid = uuid;
            this.newName = newName;
            this.nextSibling = nextSibling;
        }

        @Override
        public boolean apply() throws RepositoryException {
            if (ConflictResolver.this.sourceNode.getNode(this.newName).isVersioned() || ConflictResolver.this.targetNode.hasNode(this.newName)) {
                if (ConflictResolver.this.targetNode.hasNode(this.newName) && (this.nextSibling == null || ConflictResolver.this.targetNode.hasNode(this.nextSibling)) && ConflictResolver.this.targetNode.getPrimaryNodeType().hasOrderableChildNodes()) {
                    if (!(this.newName.contains("/") || this.nextSibling != null && this.nextSibling.contains("/"))) {
                        ConflictResolver.this.targetNode.orderBefore(this.newName, this.nextSibling);
                    }
                    ConflictResolver.this.targetNode.getSession().save();
                }
                return true;
            }
            JCRNodeWrapper targetNode = ConflictResolver.this.getParentTarget(ConflictResolver.this.targetNode, this.newName);
            JCRNodeWrapper sourceNode = ConflictResolver.this.getParentTarget(ConflictResolver.this.sourceNode, this.newName);
            String newNameParsed = ConflictResolver.this.getTargetName(this.newName);
            targetNode.getSession().save();
            JCRPublicationService.getInstance().doClone(sourceNode.getNode(newNameParsed), sourceNode.getSession(), targetNode.getSession(), ConflictResolver.this.toCheckpoint);
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChildAddedDiff that = (ChildAddedDiff)o;
            if (this.newName != null ? !this.newName.equals(that.newName) : that.newName != null) {
                return false;
            }
            if (this.nextSibling != null ? !this.nextSibling.equals(that.nextSibling) : that.nextSibling != null) {
                return false;
            }
            return !(this.uuid != null ? !this.uuid.equals(that.uuid) : that.uuid != null);
        }

        public int hashCode() {
            int result = this.uuid != null ? this.uuid.hashCode() : 0;
            result = 31 * result + (this.newName != null ? this.newName.hashCode() : 0);
            result = 31 * result + (this.nextSibling != null ? this.nextSibling.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "ChildAddedDiff{uuid='" + this.uuid + '\'' + ", newName='" + this.newName + '\'' + ", nextSibling='" + this.nextSibling + '\'' + '}';
        }
    }

    class ChildRenamedDiff
    implements Diff {
        private String uuid;
        private String oldName;
        private String newName;

        ChildRenamedDiff(String uuid, String oldName, String newName) {
            this.uuid = uuid;
            this.oldName = oldName;
            this.newName = newName;
        }

        @Override
        public boolean apply() throws RepositoryException {
            return !ConflictResolver.this.targetNode.hasNode(this.oldName) || ConflictResolver.this.targetNode.getNode(this.oldName).isVersioned() || ConflictResolver.this.targetNode.getNode(this.oldName).rename(this.newName);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChildRenamedDiff that = (ChildRenamedDiff)o;
            if (!this.newName.equals(that.newName)) {
                return false;
            }
            if (!this.oldName.equals(that.oldName)) {
                return false;
            }
            return this.uuid.equals(that.uuid);
        }

        public int hashCode() {
            int result = this.uuid.hashCode();
            result = 31 * result + this.oldName.hashCode();
            result = 31 * result + this.newName.hashCode();
            return result;
        }

        public String toString() {
            return "ChildRenamedDiff{uuid='" + this.uuid + '\'' + ", oldName='" + this.oldName + '\'' + ", newName='" + this.newName + '\'' + '}';
        }
    }

    static interface Diff {
        public boolean apply() throws RepositoryException;
    }
}

