/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.cache.ehcache;

import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.util.Map;
import javax.management.MBeanServer;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.PinningConfiguration;
import net.sf.ehcache.constructs.blocking.CacheEntryFactory;
import net.sf.ehcache.constructs.blocking.SelfPopulatingCache;
import net.sf.ehcache.management.ManagementService;
import org.apache.tika.io.IOUtils;
import org.jahia.exceptions.JahiaInitializationException;
import org.jahia.services.cache.CacheImplementation;
import org.jahia.services.cache.CacheProvider;
import org.jahia.services.cache.CacheService;
import org.jahia.services.cache.ehcache.EhCacheImpl;
import org.jahia.settings.SettingsBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class EhCacheProvider
implements CacheProvider {
    private static final Logger logger = LoggerFactory.getLogger(EhCacheProvider.class);
    private CacheManager cacheManager = null;
    private int groupsSizeLimit = 100;
    private Resource configurationResource;
    private boolean statisticsEnabled;
    private boolean jmxActivated = true;
    private boolean initialized = false;

    @Override
    public void init(SettingsBean settingsBean, CacheService cacheService) throws JahiaInitializationException {
        if (this.initialized) {
            return;
        }
        InputStream is = null;
        try {
            is = this.configurationResource.getInputStream();
            this.cacheManager = CacheManager.newInstance((InputStream)is);
        }
        catch (IOException e) {
            throw new JahiaInitializationException(e.getMessage(), e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        if (this.jmxActivated) {
            ManagementService.registerMBeans((CacheManager)this.cacheManager, (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (boolean)true, (boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
        this.initialized = true;
    }

    @Override
    public void shutdown() {
        if (this.initialized) {
            logger.info("Shutting down cache provider, serializing to disk if active. Please wait...");
            long startTime = System.currentTimeMillis();
            this.cacheManager.shutdown();
            logger.info("Cache provider shutdown completed in {} ms", (Object)(System.currentTimeMillis() - startTime));
            this.initialized = false;
        }
    }

    @Override
    public CacheImplementation<?, ?> newCacheImplementation(String name) {
        return new EhCacheImpl(name, this.cacheManager, this);
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public int getGroupsSizeLimit() {
        return this.groupsSizeLimit;
    }

    public void setGroupsSizeLimit(int groupsSizeLimit) {
        this.groupsSizeLimit = groupsSizeLimit;
    }

    public void setConfigurationResource(Resource configurationResource) {
        this.configurationResource = configurationResource;
    }

    public void setJmxActivated(boolean jmxActivated) {
        this.jmxActivated = jmxActivated;
    }

    public void setStatisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
    }

    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    public synchronized SelfPopulatingCache registerSelfPopulatingCache(String cacheName, CacheEntryFactory factory) {
        if (this.cacheManager.getEhcache(cacheName) == null) {
            Configuration configuration = this.cacheManager.getConfiguration();
            Map cacheConfigurations = configuration.getCacheConfigurations();
            CacheConfiguration cacheConfiguration = (CacheConfiguration)cacheConfigurations.get("org.jahia.selfPopulatingReplicatedCache");
            PinningConfiguration pinningConfiguration = new PinningConfiguration();
            pinningConfiguration.setStore("INCACHE");
            cacheConfiguration.addPinning(pinningConfiguration);
            Cache cache = new Cache(cacheConfiguration);
            cache.setName(cacheName);
            cache = this.cacheManager.addCacheIfAbsent((Ehcache)cache);
            SelfPopulatingCache selfPopulatingCache = new SelfPopulatingCache((Ehcache)cache, factory);
            this.cacheManager.replaceCacheWithDecoratedCache((Ehcache)cache, (Ehcache)selfPopulatingCache);
            return selfPopulatingCache;
        }
        return (SelfPopulatingCache)this.cacheManager.getEhcache(cacheName);
    }
}

