/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.cache;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;

public abstract class ClassLoaderAwareCacheEntry
implements Serializable {
    private static final long serialVersionUID = -4281419239864698107L;
    private Object value;

    protected ClassLoaderAwareCacheEntry(Object value) {
        this.value = value;
    }

    protected abstract void beforeReadObject(ObjectInputStream var1) throws IOException, ClassNotFoundException;

    protected abstract void beforeWriteObject(ObjectOutputStream var1) throws IOException;

    protected abstract ClassLoader getClassLoaderToUse();

    public Object getValue() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.beforeReadObject(in);
        ClassLoader cl = this.getClassLoaderToUse();
        Thread currentThread = null;
        ClassLoader tccl = null;
        if (cl != null) {
            currentThread = Thread.currentThread();
            tccl = currentThread.getContextClassLoader();
            currentThread.setContextClassLoader(cl);
        }
        try {
            in.defaultReadObject();
        }
        finally {
            if (cl != null) {
                currentThread.setContextClassLoader(tccl);
            }
        }
    }

    private void readObjectNoData() throws ObjectStreamException {
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.beforeWriteObject(out);
        out.defaultWriteObject();
    }
}

