/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.hibernate;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.cfg.ImprovedNamingStrategy;
import org.hibernate.cfg.NamingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaNamingStrategy
extends ImprovedNamingStrategy
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(JahiaNamingStrategy.class);
    public static final NamingStrategy INSTANCE = new JahiaNamingStrategy();
    private static final int MAX_LENGTH = 30;
    private static final long serialVersionUID = 2436201913019906777L;
    private static String[] sqlReservedWords = new String[0];
    private static final String VOWELS = "aeiou";

    private static String ensureLength(String name) {
        if (name.length() <= 30) {
            return name;
        }
        Object[] tokens = StringUtils.split((String)name, (char)'_');
        JahiaNamingStrategy.shorten(name, (String[])tokens);
        return StringUtils.join((Object[])tokens, (char)'_');
    }

    private static int getIndexOfLongest(String[] tokens) {
        int maxLength = 0;
        int index = -1;
        for (int i = 0; i < tokens.length; ++i) {
            String string = tokens[i];
            if (maxLength >= string.length()) continue;
            maxLength = string.length();
            index = i;
        }
        return index;
    }

    public static boolean isSqlReservedWord(String name) {
        String lowerCaseName = name.toLowerCase();
        for (String reservedWord : sqlReservedWords) {
            if (!reservedWord.equals(lowerCaseName)) continue;
            return true;
        }
        return false;
    }

    public static String prefixSqlReservedWords(String name) {
        if (JahiaNamingStrategy.isSqlReservedWord(name)) {
            return "r_" + name;
        }
        return name;
    }

    public static String processColumnName(String columnName) {
        return JahiaNamingStrategy.processNameCase(JahiaNamingStrategy.prefixSqlReservedWords(columnName));
    }

    public static String processNameCase(String name) {
        return name.toLowerCase();
    }

    public static String processTableName(String tableName) {
        return JahiaNamingStrategy.processNameCase("jbpm_" + tableName);
    }

    private static void shorten(String someName, String[] tokens) {
        int tokenIndex;
        String oldToken;
        for (int currentLength = someName.length(); currentLength > 30; currentLength -= oldToken.length() - tokens[tokenIndex].length()) {
            tokenIndex = JahiaNamingStrategy.getIndexOfLongest(tokens);
            oldToken = tokens[tokenIndex];
            tokens[tokenIndex] = JahiaNamingStrategy.substringAfterLastVowel(oldToken);
        }
    }

    private static String substringAfterLastVowel(String token) {
        boolean vowelFound = false;
        for (int i = token.length() - 1; i >= 0; --i) {
            boolean isVowel;
            char c = token.charAt(i);
            boolean bl = isVowel = VOWELS.indexOf(c) != -1;
            if (isVowel) {
                vowelFound = true;
                continue;
            }
            if (!vowelFound) continue;
            return token.substring(0, i + 1);
        }
        return "";
    }

    public String classToTableName(String className) {
        String tableName = super.classToTableName(className);
        return JahiaNamingStrategy.processTableName(tableName);
    }

    public String columnName(String columnName) {
        return JahiaNamingStrategy.ensureLength(JahiaNamingStrategy.processColumnName(super.columnName(columnName)));
    }

    public String propertyToColumnName(String propertyName) {
        String columnName = super.propertyToColumnName(propertyName);
        return JahiaNamingStrategy.ensureLength(JahiaNamingStrategy.processColumnName(columnName));
    }

    public String tableName(String tableName) {
        return JahiaNamingStrategy.ensureLength(JahiaNamingStrategy.processTableName(super.tableName(tableName)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        InputStream sqlReservedWordsStream = JahiaNamingStrategy.class.getClassLoader().getResourceAsStream("org/jahia/hibernate/sqlReservedWords.txt");
        if (sqlReservedWordsStream != null) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(sqlReservedWordsStream));
            String newLine = null;
            ArrayList<String> reservedWordList = new ArrayList<String>();
            try {
                while ((newLine = bufferedReader.readLine()) != null) {
                    reservedWordList.add(newLine.trim().toLowerCase());
                }
                sqlReservedWords = reservedWordList.toArray(new String[reservedWordList.size()]);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            finally {
                IOUtils.closeQuietly((Reader)bufferedReader);
            }
        }
    }
}

