/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.data.webapps;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jahia.data.webapps.Security_Role;
import org.jahia.data.webapps.Servlet_Element;
import org.jahia.exceptions.JahiaException;
import org.jahia.utils.xml.XMLParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Web_App_Xml {
    private static final int SERVLET_TYPE = 1;
    private static final int JSP_TYPE = 2;
    private String m_DisplayName;
    private String m_desc;
    private List<Servlet_Element> m_Servlets = new ArrayList<Servlet_Element>();
    private Map<String, String> m_ServletMappings = new HashMap<String, String>();
    private List<Security_Role> m_Roles = new ArrayList<Security_Role>();
    private List<String> m_WelcomeFiles = new ArrayList<String>();
    private Document m_XMLDocument;

    private Web_App_Xml(Document xmlDocument) {
        this.m_XMLDocument = xmlDocument;
    }

    public static Web_App_Xml parse(InputStream stream) throws JahiaException {
        Web_App_Xml xml = null;
        try {
            DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
            Document xmlDocument = dfactory.newDocumentBuilder().parse(stream);
            xmlDocument.normalize();
            xml = new Web_App_Xml(xmlDocument);
            xml.extractDocumentData();
        }
        catch (Exception t) {
            throw new JahiaException("JahiaXmlDocument", "Exception while parsing web.xml stream", 2, 12, t);
        }
        return xml;
    }

    private void extractDocumentData() throws JahiaException {
        Node descriptionNode;
        if (this.m_XMLDocument == null) {
            throw new JahiaException("Web_App_Xml", "Parsed web.xml document is null", 2, 11);
        }
        if (!this.m_XMLDocument.hasChildNodes()) {
            throw new JahiaException("Web_App_Xml", "Main document node has no children", 2, 11);
        }
        Element webAppNode = this.m_XMLDocument.getDocumentElement();
        if (!webAppNode.getNodeName().equalsIgnoreCase("web-app")) {
            throw new JahiaException("Invalid XML format", "web-app tag is not present as starting tag in file", 2, 11);
        }
        Node displayNameNode = XMLParser.nextChildOfTag(webAppNode, "display-name");
        if (displayNameNode != null) {
            this.m_DisplayName = displayNameNode.getFirstChild().getNodeValue().trim();
        }
        if ((descriptionNode = XMLParser.nextChildOfTag(webAppNode, "description")) != null) {
            this.m_desc = descriptionNode.getFirstChild().getNodeValue().trim();
        }
        this.m_Servlets = this.getServlets(webAppNode);
        this.m_ServletMappings = this.getServletMappings(webAppNode);
        this.m_Roles = this.getRoles(webAppNode);
        this.m_WelcomeFiles = this.getWelcomeFiles(webAppNode);
    }

    public String getDisplayName() {
        return this.m_DisplayName;
    }

    protected void setDisplayName(String name) {
        this.m_DisplayName = name;
    }

    public List<Servlet_Element> getServlets() {
        return this.m_Servlets;
    }

    public Map<String, String> getServletMappings() {
        return this.m_ServletMappings;
    }

    public List<String> getWelcomeFiles() {
        return this.m_WelcomeFiles;
    }

    public List<Security_Role> getRoles() {
        return this.m_Roles;
    }

    public String getdesc() {
        return this.m_desc;
    }

    protected void setdesc(String descr) {
        this.m_desc = descr;
    }

    private List<Security_Role> getRoles(Node parentNode) throws JahiaException {
        List<Node> nodesList = XMLParser.getChildNodes(parentNode, "security-role");
        ArrayList<Security_Role> roles = new ArrayList<Security_Role>();
        int size = nodesList.size();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                String name = "";
                String descr = "";
                Node nodeItem = nodesList.get(i);
                Node childNode = XMLParser.nextChildOfTag(nodeItem, "role-name");
                if (childNode != null) {
                    name = childNode.getFirstChild().getNodeValue().trim();
                }
                if ((childNode = XMLParser.nextChildOfTag(nodeItem, "desc")) != null) {
                    descr = childNode.getFirstChild().getNodeValue().trim();
                }
                if (name.length() <= 0) continue;
                Security_Role role = new Security_Role(name, descr);
                roles.add(role);
            }
        }
        return roles;
    }

    private List<Servlet_Element> getServlets(Node parentNode) throws JahiaException {
        ArrayList<Servlet_Element> servlets = new ArrayList<Servlet_Element>();
        List<Node> nodesList = XMLParser.getChildNodes(parentNode, "servlet");
        int size = nodesList.size();
        if (size > 0) {
            Node nodeItem = null;
            String displayName = "";
            String servletName = "";
            String descr = "";
            String servletsrc = "";
            int servletType = 1;
            Node childNode = null;
            for (int i = 0; i < size; ++i) {
                nodeItem = nodesList.get(i);
                childNode = XMLParser.nextChildOfTag(nodeItem, "servlet-name");
                if (childNode != null) {
                    servletName = childNode.getFirstChild().getNodeValue().trim();
                }
                displayName = (childNode = XMLParser.nextChildOfTag(nodeItem, "display-name")) != null ? childNode.getFirstChild().getNodeValue().trim() : servletName;
                childNode = XMLParser.nextChildOfTag(nodeItem, "desc");
                if (childNode != null) {
                    descr = childNode.getFirstChild().getNodeValue().trim();
                }
                if (XMLParser.nextChildOfTag(nodeItem, "servlet-class") != null) {
                    servletsrc = XMLParser.nextChildOfTag(nodeItem, "servlet-class").getFirstChild().getNodeValue().trim();
                    servletType = 1;
                } else {
                    servletsrc = XMLParser.nextChildOfTag(nodeItem, "jsp-file").getFirstChild().getNodeValue().trim();
                    servletType = 2;
                }
                if (displayName == null || displayName.length() <= 0 || servletName == null || servletName.length() <= 0 || servletsrc == null || servletsrc.length() <= 0) continue;
                Servlet_Element servlet = new Servlet_Element(servletName, displayName, descr, servletsrc, servletType, i + 1);
                servlets.add(servlet);
            }
        }
        return servlets;
    }

    private List<String> getWelcomeFiles(Node parentNode) throws JahiaException {
        ArrayList<String> results = new ArrayList<String>();
        Node welcomeFileListNode = XMLParser.nextChildOfTag(parentNode, "welcome-file-list");
        if (welcomeFileListNode == null) {
            return results;
        }
        List<Node> nodesList = XMLParser.getChildNodes(welcomeFileListNode, "welcome-file");
        int size = nodesList.size();
        if (size > 0) {
            Node nodeItem = null;
            String filename = "";
            for (int i = 0; i < size; ++i) {
                nodeItem = nodesList.get(i);
                filename = nodeItem.getFirstChild().getNodeValue().trim();
                if (filename == null || filename.length() <= 0) continue;
                results.add(filename);
            }
        }
        return results;
    }

    private Map<String, String> getServletMappings(Node parentNode) throws JahiaException {
        HashMap<String, String> hash = new HashMap<String, String>();
        List<Node> nodesList = XMLParser.getChildNodes(parentNode, "servlet-mapping");
        int size = nodesList.size();
        if (size > 0) {
            Node nodeItem = null;
            String servletName = "";
            String urlPattern = "";
            Node childNode = null;
            for (int i = 0; i < size; ++i) {
                servletName = "";
                urlPattern = "";
                nodeItem = nodesList.get(i);
                childNode = XMLParser.nextChildOfTag(nodeItem, "servlet-name");
                if (childNode != null) {
                    servletName = childNode.getFirstChild().getNodeValue().trim();
                }
                if ((childNode = XMLParser.nextChildOfTag(nodeItem, "url-pattern")) != null) {
                    urlPattern = childNode.getFirstChild().getNodeValue().trim();
                }
                if (servletName == null || servletName.length() <= 0 || urlPattern == null || urlPattern.length() <= 0) continue;
                hash.put(urlPattern, servletName);
            }
        }
        return hash;
    }
}

