/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.data.viewhelper.principal;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.jcr.RepositoryException;
import javax.servlet.ServletRequest;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.decorator.JCRGroupNode;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.usermanager.GuestGroup;
import org.jahia.services.usermanager.JahiaGroup;
import org.jahia.services.usermanager.JahiaGroupManagerService;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.services.usermanager.UsersGroup;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrincipalViewHelper
implements Serializable {
    private static final long serialVersionUID = -3791113369394869324L;
    public static final String PRINCIPAL = "Principal";
    public static final String PERMISSIONS = "Permissions";
    public static final String PROVIDER = "Provider";
    public static final String SITEKEY = "SiteKey";
    public static final String SITETITLE = "SiteTitle";
    public static final String NAME = "Name";
    public static final String PROPERTIES = "Properties";
    public static final String INHERITANCE = "Inheritance";
    private static final transient Logger logger = LoggerFactory.getLogger(PrincipalViewHelper.class);
    private static final transient Comparator<JCRNodeWrapper> PRINCIPAL_COMPARATOR = new PrincipalComparator();
    private static Set<String> selectBoxFieldsHeading = new HashSet<String>();
    private List<Integer> selectBoxFieldsSize = new ArrayList<Integer>();
    private List<Method> selectBoxFieldsMethod = new ArrayList<Method>();

    public PrincipalViewHelper(String[] textFormat) {
        for (int i = 0; i < textFormat.length; ++i) {
            StringTokenizer st = new StringTokenizer(textFormat[i], ",");
            String fieldToDisplay = (String)st.nextElement();
            if (!selectBoxFieldsHeading.contains(fieldToDisplay)) continue;
            if (st.hasMoreElements()) {
                this.selectBoxFieldsSize.add(Integer.valueOf(((String)st.nextElement()).trim()));
            } else {
                this.selectBoxFieldsSize.add(new Integer(-1));
            }
            try {
                this.selectBoxFieldsMethod.add(PrincipalViewHelper.class.getMethod("get" + fieldToDisplay, JCRNodeWrapper.class, Integer.class));
                continue;
            }
            catch (NoSuchMethodException nsme) {
                logger.error("Internal class error ! Please check Jahia code", (Throwable)nsme);
            }
        }
    }

    public String getPrincipalTextOption(JCRNodeWrapper p) {
        StringBuilder authUserText = new StringBuilder();
        for (int i = 0; i < this.selectBoxFieldsMethod.size(); ++i) {
            Method m = this.selectBoxFieldsMethod.get(i);
            Integer size = this.selectBoxFieldsSize.get(i);
            Object[] args = new Object[]{p, size};
            try {
                authUserText.append(StringEscapeUtils.escapeXml((String)((String)m.invoke((Object)this, args))));
                if (i < this.selectBoxFieldsMethod.size() - 1) {
                    authUserText.append("|");
                }
            }
            catch (InvocationTargetException ite) {
                logger.error("Internal class error !", (Throwable)ite);
            }
            catch (IllegalAccessException iae) {
                logger.error("Internal class error !", (Throwable)iae);
            }
            if (i + 1 >= selectBoxFieldsHeading.size()) continue;
            authUserText.append(" ");
        }
        return StringUtils.replace((String)authUserText.toString(), (String)" ", (String)"&nbsp;");
    }

    public String getPrincipalValueOption(Object p) {
        StringBuilder buff = new StringBuilder();
        if (p == null) {
            return "null";
        }
        if (p instanceof JCRUserNode) {
            return buff.append("u").append(((JCRUserNode)p).getUserKey()).toString();
        }
        if (p instanceof JCRGroupNode) {
            return buff.append("g").append(((JCRGroupNode)p).getGroupKey()).toString();
        }
        if (p instanceof Principal) {
            if (p instanceof JahiaUser) {
                return buff.append("u").append(((JahiaUser)p).getUserKey()).toString();
            }
            return buff.append("g").append(((JahiaGroup)p).getGroupKey()).toString();
        }
        return "";
    }

    public static String getFullName(Object p) {
        String firstName = null;
        String lastName = null;
        if (p instanceof JCRGroupNode) {
            firstName = PrincipalViewHelper.getDisplayName(p);
        } else if (p instanceof JCRUserNode) {
            JCRUserNode jahiaUser = (JCRUserNode)p;
            try {
                firstName = jahiaUser.hasProperty("j:firstName") ? jahiaUser.getProperty("j:firstName").getString() : "";
                lastName = jahiaUser.hasProperty("j:lastName") ? jahiaUser.getProperty("j:lastName").getString() : "";
            }
            catch (RepositoryException e) {}
        } else if (p instanceof Principal) {
            if (p instanceof JahiaUser) {
                firstName = ((JahiaUser)p).getProperty("j:firstName");
                lastName = ((JahiaUser)p).getProperty("j:lastname");
            } else {
                firstName = ((Principal)p).getName();
            }
        } else {
            throw new IllegalArgumentException("getFullName only support Principal, JCRGroupNode, JCRUserNode, " + p.getClass().getName() + " is not supported ");
        }
        String fullName = (StringUtils.isEmpty((String)firstName) ? "" : firstName) + (StringUtils.isEmpty(lastName) ? "" : (StringUtils.isEmpty((String)firstName) ? "" : " ") + lastName);
        return StringUtils.isEmpty((String)fullName) ? PrincipalViewHelper.getDisplayName(p) : fullName;
    }

    public static String getDisplayName(Object p) {
        return PrincipalViewHelper.getDisplayName(p, null);
    }

    public static String getDisplayName(Object p, Locale locale) {
        if (p instanceof JCRUserNode) {
            JCRUserNode jahiaUser = (JCRUserNode)p;
            String userName = jahiaUser.getName();
            userName = PrincipalViewHelper.getUserDisplayName(userName, locale);
            return userName;
        }
        if (p instanceof JCRGroupNode) {
            JCRGroupNode jahiaGroup = (JCRGroupNode)p;
            String groupName = jahiaGroup.getName();
            groupName = PrincipalViewHelper.getGroupDisplayName(groupName, locale);
            return groupName;
        }
        if (p instanceof JahiaUser) {
            JahiaUser jahiaUser = (JahiaUser)p;
            String userName = jahiaUser.getName();
            userName = PrincipalViewHelper.getUserDisplayName(userName, locale);
            return userName;
        }
        if (p instanceof JahiaGroup) {
            JahiaGroup jahiaGroup = (JahiaGroup)p;
            String groupName = jahiaGroup.getName();
            groupName = PrincipalViewHelper.getGroupDisplayName(groupName, locale);
            return groupName;
        }
        if (p instanceof Principal) {
            return ((Principal)p).getName();
        }
        throw new IllegalArgumentException("getFullName only support Principal, JCRGroupNode, JCRUserNode, " + p.getClass().getName() + " is not supported ");
    }

    public static String getGroupDisplayName(String groupName) {
        return PrincipalViewHelper.getGroupDisplayName(groupName, null);
    }

    public static String getGroupDisplayName(String groupName, Locale locale) {
        if ("guest".equals(groupName)) {
            groupName = Messages.get(ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackage(SettingsBean.getInstance().getGuestGroupResourceModuleName()), SettingsBean.getInstance().getGuestGroupResourceKey(), locale != null ? locale : PrincipalViewHelper.getLocale(), groupName);
        }
        return groupName;
    }

    public static String getUserDisplayName(String userName) {
        return PrincipalViewHelper.getUserDisplayName(userName, null);
    }

    public static String getUserDisplayName(String userName, Locale locale) {
        if ("guest".equals(userName)) {
            userName = Messages.get(ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackage(SettingsBean.getInstance().getGuestUserResourceModuleName()), SettingsBean.getInstance().getGuestUserResourceKey(), locale != null ? locale : PrincipalViewHelper.getLocale(), userName);
        }
        return userName;
    }

    public static String getName(JCRNodeWrapper p, Integer size) {
        String displayName = PrincipalViewHelper.getDisplayName(p);
        return PrincipalViewHelper.adjustStringSize(displayName, size);
    }

    public static String getProvider(JCRNodeWrapper p, Integer size) {
        if (p instanceof JCRUserNode) {
            return PrincipalViewHelper.adjustStringSize(((JCRUserNode)p).getProviderName(), size);
        }
        if (p instanceof JCRGroupNode) {
            return PrincipalViewHelper.adjustStringSize(((JCRGroupNode)p).getProviderName(), size);
        }
        return null;
    }

    public static String getSiteKey(JCRNodeWrapper p, Integer size) throws RepositoryException {
        String siteKey = null;
        if (p instanceof JCRGroupNode) {
            siteKey = p.getResolveSite().getSiteKey();
        }
        if (siteKey == null) {
            return PrincipalViewHelper.adjustStringSize("server", size);
        }
        return PrincipalViewHelper.adjustStringSize(siteKey, size);
    }

    public static String getSiteTitle(JCRNodeWrapper p, Integer size) throws RepositoryException {
        String siteKey = null;
        if (p instanceof JCRGroupNode) {
            siteKey = p.getResolveSite().getTitle();
        }
        if (siteKey == null) {
            return PrincipalViewHelper.adjustStringSize("server", size);
        }
        return PrincipalViewHelper.adjustStringSize(siteKey, size);
    }

    public static String getPrincipal(JCRNodeWrapper p, Integer size) {
        if (p instanceof JCRUserNode) {
            return "u";
        }
        return "g";
    }

    public static char getPrincipalType(Principal p) {
        if (p instanceof JahiaUser) {
            return 'u';
        }
        return 'g';
    }

    public static String getProperties(JCRNodeWrapper p, Integer size) {
        StringBuilder properties = new StringBuilder();
        if (p instanceof JCRUserNode) {
            JCRUserNode user = (JCRUserNode)p;
            if (user.getName().equals("guest")) {
                properties.append(PrincipalViewHelper.getI18n("org.jahia.engines.users.guest.label", "guest"));
                return PrincipalViewHelper.adjustStringSize(properties.toString(), size);
            }
            String firstname = null;
            try {
                firstname = user.getProperty("j:firstName").getString();
            }
            catch (RepositoryException e) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            String lastname = null;
            try {
                lastname = user.getProperty("j:lastName").getString();
            }
            catch (RepositoryException e) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            if (lastname != null && !"".equals(lastname.trim())) {
                properties.append(lastname);
                if (size == -1 || lastname.length() < size) {
                    properties.append(" ");
                }
            }
            if (firstname != null && !"".equals(firstname.trim())) {
                properties.append(firstname);
            }
            if ("".equals(properties.toString())) {
                String email = null;
                try {
                    email = user.getProperty("j:email").getString();
                    properties.append(email);
                }
                catch (RepositoryException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            return PrincipalViewHelper.adjustStringSize(properties.toString(), size);
        }
        if (p instanceof UsersGroup) {
            properties.append(PrincipalViewHelper.getI18n("org.jahia.engines.groups.users.label", "users"));
            return PrincipalViewHelper.adjustStringSize(properties.toString(), size);
        }
        if (p instanceof GuestGroup) {
            properties.append(PrincipalViewHelper.getI18n("org.jahia.engines.groups.guest.label", "guest"));
            return PrincipalViewHelper.adjustStringSize(properties.toString(), size);
        }
        JCRGroupNode group = (JCRGroupNode)p;
        List<JCRNodeWrapper> grpMembers = group.getProviderName().equals("default") ? group.getMembers() : null;
        StringBuilder members = new StringBuilder().append("(");
        if (grpMembers != null) {
            for (JCRNodeWrapper member : grpMembers) {
                if (members.length() > 1) {
                    members.append(", ");
                }
                members.append(PrincipalViewHelper.getDisplayName(member));
                if (size == -1 || members.length() <= size) continue;
                break;
            }
        } else {
            members.append("...");
        }
        members.append(")");
        return PrincipalViewHelper.adjustStringSize(members.toString(), size);
    }

    public static Set<JCRUserNode> getSearchResult(ServletRequest request) {
        String searchString = request.getParameter("searchString");
        String searchIn = request.getParameter("searchIn");
        String[] searchInProps = request.getParameterValues("properties");
        String storedOn = request.getParameter("storedOn");
        String[] providers = request.getParameterValues("providers");
        return PrincipalViewHelper.getSearchResult(searchIn, null, searchString, searchInProps, storedOn, providers);
    }

    public static Set<JCRUserNode> getSearchResult(String searchIn, String searchString, String[] searchInProps, String storedOn, String[] providers) {
        return PrincipalViewHelper.getSearchResult(searchIn, null, searchString, searchInProps, storedOn, providers);
    }

    public static Set<JCRUserNode> getSearchResult(String searchIn, String siteKey, String searchString, String[] searchInProps, String storedOn, String[] providers) {
        return PrincipalViewHelper.getSearchResult(searchIn, siteKey, searchString, searchInProps, storedOn, providers, true);
    }

    public static Set<JCRUserNode> getSearchResult(String searchIn, String siteKey, String searchString, String[] searchInProps, String storedOn, String[] providers, boolean includeGlobalUsers) {
        JahiaUserManagerService jahiaUserManagerService = ServicesRegistry.getInstance().getJahiaUserManagerService();
        Properties searchParameters = new Properties();
        long countLimit = SettingsBean.getInstance().getJahiaJCRUserCountLimit();
        if (countLimit > 0L) {
            logger.info("Just first {} users are returned from Jahia JCR repository...", (Object)countLimit);
            searchParameters.setProperty("countLimit", String.valueOf(countLimit));
        }
        if (searchIn == null) {
            logger.debug("No formular transmited. Finding all Jahia DB users.");
            searchParameters.setProperty("*", "*");
            return PrincipalViewHelper.getSearchResult(siteKey, null, jahiaUserManagerService, searchParameters, includeGlobalUsers);
        }
        if ("".equals(searchString)) {
            searchString = "*";
        }
        if ("allProps".equals(searchIn) || searchInProps == null) {
            searchParameters.setProperty("*", searchString);
        } else {
            for (String searchInProp : searchInProps) {
                searchParameters.setProperty(searchInProp, searchString);
            }
        }
        if ("everywhere".equals(storedOn) || providers == null) {
            return PrincipalViewHelper.getSearchResult(siteKey, null, jahiaUserManagerService, searchParameters, includeGlobalUsers);
        }
        if ("providers".equals(storedOn)) {
            return PrincipalViewHelper.getSearchResult(siteKey, providers, jahiaUserManagerService, searchParameters, includeGlobalUsers);
        }
        return new TreeSet<JCRNodeWrapper>(PRINCIPAL_COMPARATOR);
    }

    private static Set<JCRUserNode> getSearchResult(String siteKey, String[] providers, JahiaUserManagerService jahiaUserManagerService, Properties searchParameters, boolean includeGlobalUsers) {
        TreeSet<JCRNodeWrapper> searchResults = new TreeSet<JCRNodeWrapper>(PRINCIPAL_COMPARATOR);
        try {
            JCRSessionWrapper systemSession = JCRSessionFactory.getInstance().getCurrentSystemSession(null, null, null);
            if (siteKey != null && includeGlobalUsers) {
                searchResults.addAll(jahiaUserManagerService.searchUsers(searchParameters, null, providers, systemSession));
            }
            searchResults.addAll(jahiaUserManagerService.searchUsers(searchParameters, siteKey, providers, !includeGlobalUsers, systemSession));
        }
        catch (RepositoryException e) {
            logger.error("Error while searching for users", (Throwable)e);
        }
        return searchResults;
    }

    public static Set<JCRGroupNode> getGroupSearchResult(ServletRequest request, String siteKey) {
        String searchString = request.getParameter("searchString");
        String searchIn = request.getParameter("searchIn");
        String[] searchInProps = request.getParameterValues("properties");
        String storedOn = request.getParameter("storedOn");
        String[] providers = request.getParameterValues("providers");
        return PrincipalViewHelper.getGroupSearchResult(searchIn, siteKey, searchString, searchInProps, storedOn, providers);
    }

    public static Set<JCRGroupNode> getGroupSearchResult(String searchIn, String siteKey, String searchString, String[] searchInProps, String storedOn, String[] providers) {
        return PrincipalViewHelper.getGroupSearchResult(searchIn, siteKey, searchString, searchInProps, storedOn, providers, true);
    }

    public static Set<JCRGroupNode> getGroupSearchResult(String searchIn, String siteKey, String searchString, String[] searchInProps, String storedOn, String[] providers, boolean includeGlobalUsers) {
        JahiaGroupManagerService jahiaGroupManagerService = ServicesRegistry.getInstance().getJahiaGroupManagerService();
        Properties searchParameters = new Properties();
        if (searchIn == null) {
            logger.debug("No formular transmited. Finding all Jahia DB users.");
            searchParameters.setProperty("*", "*");
            return PrincipalViewHelper.getGroupSearchResult(siteKey, null, jahiaGroupManagerService, searchParameters, includeGlobalUsers);
        }
        if ("".equals(searchString)) {
            searchString = "*";
        }
        if ("allProps".equals(searchIn) || searchInProps == null) {
            searchParameters.setProperty("*", searchString);
        } else {
            for (int i = 0; i < searchInProps.length; ++i) {
                searchParameters.setProperty(searchInProps[i], searchString);
            }
        }
        if ("everywhere".equals(storedOn) || providers == null) {
            return PrincipalViewHelper.getGroupSearchResult(siteKey, null, jahiaGroupManagerService, searchParameters, includeGlobalUsers);
        }
        if ("providers".equals(storedOn)) {
            return PrincipalViewHelper.getGroupSearchResult(siteKey, providers, jahiaGroupManagerService, searchParameters, includeGlobalUsers);
        }
        return new TreeSet<JCRNodeWrapper>(PRINCIPAL_COMPARATOR);
    }

    private static Set<JCRGroupNode> getGroupSearchResult(String siteKey, String[] providers, JahiaGroupManagerService jahiaGroupManagerService, Properties searchParameters, boolean includeGlobalUsers) {
        TreeSet<JCRNodeWrapper> searchResults = new TreeSet<JCRNodeWrapper>(PRINCIPAL_COMPARATOR);
        try {
            JCRSessionWrapper systemSession = JCRSessionFactory.getInstance().getCurrentSystemSession(null, null, null);
            if (siteKey != null && includeGlobalUsers) {
                searchResults.addAll(jahiaGroupManagerService.searchGroups(null, searchParameters, providers, systemSession));
            }
            searchResults.addAll(jahiaGroupManagerService.searchGroups(siteKey, searchParameters, providers, !includeGlobalUsers, systemSession));
        }
        catch (RepositoryException e) {
            logger.error("Error while searching for users", (Throwable)e);
        }
        return searchResults;
    }

    public static Set<JCRUserNode> removeJahiaAdministrators(Set<JCRUserNode> users) {
        TreeSet<JCRNodeWrapper> usersWithoutJahiaAdmin = new TreeSet<JCRNodeWrapper>(PRINCIPAL_COMPARATOR);
        usersWithoutJahiaAdmin.addAll(users);
        try {
            JCRGroupNode jahiaAdminGroup = ServicesRegistry.getInstance().getJahiaGroupManagerService().getAdministratorGroup(null);
            List<JCRNodeWrapper> members = jahiaAdminGroup.getMembers();
            for (JCRNodeWrapper member : members) {
                if (!(member instanceof JCRUserNode)) continue;
                usersWithoutJahiaAdmin.remove(member);
            }
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return usersWithoutJahiaAdmin;
    }

    private static String getI18n(String key, String defaultValue) {
        Locale locale = PrincipalViewHelper.getLocale();
        return Messages.getInternal(key, locale, defaultValue);
    }

    private static Locale getLocale() {
        Locale locale = JCRSessionFactory.getInstance().getCurrentLocale();
        if (locale == null) {
            locale = SettingsBean.getInstance().getDefaultLocale();
        }
        if (locale == null) {
            locale = Locale.ENGLISH;
        }
        return locale;
    }

    private static String adjustStringSize(String str, int size) {
        if (size == -1 || str == null) {
            return str;
        }
        if (str.length() > size) {
            return str.substring(0, size - 2) + "..";
        }
        StringBuilder emtpyStr = new StringBuilder();
        for (int i = 0; i < size - str.length(); ++i) {
            emtpyStr.append(" ");
        }
        return str + emtpyStr;
    }

    static {
        selectBoxFieldsHeading.add(PRINCIPAL);
        selectBoxFieldsHeading.add(PERMISSIONS);
        selectBoxFieldsHeading.add(PROVIDER);
        selectBoxFieldsHeading.add(SITEKEY);
        selectBoxFieldsHeading.add(SITETITLE);
        selectBoxFieldsHeading.add(NAME);
        selectBoxFieldsHeading.add(PROPERTIES);
        selectBoxFieldsHeading.add(INHERITANCE);
    }

    private static class PrincipalComparator
    implements Comparator<JCRNodeWrapper>,
    Serializable {
        private static final long serialVersionUID = 7942666955260548143L;

        private PrincipalComparator() {
        }

        @Override
        public int compare(JCRNodeWrapper o1, JCRNodeWrapper o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null || o1.getName() == null) {
                return 1;
            }
            if (o2 == null || o2.getName() == null) {
                return -1;
            }
            int result = o1.getName().toLowerCase().compareTo(o2.getName().toLowerCase());
            if (result == 0) {
                return o1.getName().compareTo(o2.getName());
            }
            return result;
        }
    }
}

