/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.data.templates;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jahia.commons.Version;

public class ModulesPackage {
    private Map<String, PackagedModule> modules = new LinkedHashMap<String, PackagedModule>();
    private String name;
    private String description;
    private Version version;

    public static ModulesPackage create(JarFile jarFile) throws IOException {
        return new ModulesPackage(jarFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModulesPackage(JarFile jarFile) throws IOException {
        Attributes manifestAttributes = jarFile.getManifest().getMainAttributes();
        this.version = new Version(manifestAttributes.getValue("Jahia-Package-Version"));
        this.name = manifestAttributes.getValue("Jahia-Package-Name");
        this.description = manifestAttributes.getValue("Jahia-Package-Description");
        Enumeration<JarEntry> jars = jarFile.entries();
        while (jars.hasMoreElements()) {
            JarEntry jar = jars.nextElement();
            ZipFile moduleJarFile = null;
            FileOutputStream output = null;
            if (!StringUtils.endsWith((String)jar.getName(), (String)".jar")) continue;
            try {
                InputStream input = jarFile.getInputStream(jar);
                File moduleFile = File.createTempFile(jar.getName(), "");
                output = new FileOutputStream(moduleFile);
                int read = 0;
                byte[] bytes = new byte[1024];
                while ((read = input.read(bytes)) != -1) {
                    ((OutputStream)output).write(bytes, 0, read);
                }
                moduleJarFile = new JarFile(moduleFile);
                Attributes moduleManifestAttributes = ((JarFile)moduleJarFile).getManifest().getMainAttributes();
                String bundleName = moduleManifestAttributes.getValue("Bundle-SymbolicName");
                String jahiaGroupId = moduleManifestAttributes.getValue("Jahia-GroupId");
                if (bundleName == null || jahiaGroupId == null) {
                    throw new IOException("Jar file " + jar.getName() + " in package does not seems to be a Jahia bundle.");
                }
                this.modules.put(bundleName, new PackagedModule(moduleManifestAttributes, moduleFile));
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(output);
                if (moduleJarFile != null) {
                    moduleJarFile.close();
                }
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)output);
            if (moduleJarFile == null) continue;
            moduleJarFile.close();
        }
    }

    public String getName() {
        return this.name;
    }

    public Map<String, PackagedModule> getModules() {
        return this.modules;
    }

    public String getDescription() {
        return this.description;
    }

    public Version getVersion() {
        return this.version;
    }

    public class PackagedModule {
        private final Attributes manifestAttributes;
        private final File moduleFile;

        public PackagedModule(Attributes manifestAttributes, File moduleFile) {
            this.manifestAttributes = manifestAttributes;
            this.moduleFile = moduleFile;
        }

        public Attributes getManifestAttributes() {
            return this.manifestAttributes;
        }

        public File getModuleFile() {
            return this.moduleFile;
        }
    }
}

