/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.data.applications;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletMode;
import org.apache.pluto.container.om.portlet.Description;
import org.apache.pluto.container.om.portlet.DisplayName;
import org.apache.pluto.container.om.portlet.InitParam;
import org.apache.pluto.container.om.portlet.PortletDefinition;
import org.apache.pluto.container.om.portlet.Supports;
import org.jahia.data.applications.EntryPointDefinition;
import org.jahia.registries.ServicesRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletEntryPointDefinition
implements Serializable,
EntryPointDefinition {
    private static final long serialVersionUID = 687873504629004699L;
    private static Logger logger = LoggerFactory.getLogger(PortletEntryPointDefinition.class);
    private String applicationID;
    private String context;
    private PortletDefinition portletDefinition;
    private List<PortletMode> portletModes = null;

    public PortletEntryPointDefinition(String applicationID, String context, PortletDefinition portletDefinition) {
        this.applicationID = applicationID;
        this.context = context;
        this.portletDefinition = portletDefinition;
    }

    @Override
    public String getContext() {
        return this.context;
    }

    @Override
    public String getName() {
        return this.portletDefinition.getPortletName();
    }

    @Override
    public String getDisplayName(Locale locale) {
        DisplayName displayName = this.portletDefinition.getDisplayName(locale);
        if (displayName == null || displayName.getDisplayName() == null || displayName.getDisplayName().length() == 0) {
            return this.getName();
        }
        return displayName.getDisplayName();
    }

    @Override
    public String getDescription(Locale locale) {
        Description description = this.portletDefinition.getDescription(locale);
        if (description != null) {
            return description.getDescription();
        }
        return null;
    }

    @Override
    public String getApplicationID() {
        return this.applicationID;
    }

    @Override
    public List<PortletMode> getPortletModes() {
        if (this.portletModes == null) {
            List supportsList = this.portletDefinition.getSupports();
            List definitionPortletModes = null;
            for (Supports currentSupport : supportsList) {
                if (!"text/html".equals(currentSupport.getMimeType())) continue;
                definitionPortletModes = currentSupport.getPortletModes();
            }
            if (definitionPortletModes == null) {
                logger.error("Couldn't find portlet mode definition for portlet" + this.portletDefinition.getPortletName() + " returning empty list !");
                return new ArrayList<PortletMode>();
            }
            ArrayList<String> lowercaseDefinitionPortletModes = new ArrayList<String>();
            for (String curPortletMode : definitionPortletModes) {
                lowercaseDefinitionPortletModes.add(curPortletMode.toLowerCase());
            }
            List<PortletMode> portalPortletModes = ServicesRegistry.getInstance().getApplicationsManagerService().getSupportedPortletModes();
            ArrayList<PortletMode> resultPortletModes = new ArrayList<PortletMode>();
            for (PortletMode curPortletMode : portalPortletModes) {
                if (!lowercaseDefinitionPortletModes.contains(curPortletMode.toString().toLowerCase())) continue;
                resultPortletModes.add(curPortletMode);
            }
            this.portletModes = resultPortletModes;
            return resultPortletModes;
        }
        return this.portletModes;
    }

    public List getWindowStates() {
        return ServicesRegistry.getInstance().getApplicationsManagerService().getSupportedWindowStates();
    }

    public PortletDefinition getPortletDefinition() {
        return this.portletDefinition;
    }

    public String getInitParameter(String param) {
        if (this.portletDefinition.getInitParams() != null) {
            for (InitParam initParam : this.portletDefinition.getInitParams()) {
                if (!param.equals(initParam.getParamName())) continue;
                return initParam.getParamValue();
            }
        }
        return null;
    }

    public String getCacheScope() {
        return this.portletDefinition.getCacheScope();
    }

    public int getExpirationCache() {
        return this.portletDefinition.getExpirationCache();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PortletEntryPointDefinition that = (PortletEntryPointDefinition)o;
        return this.applicationID.equals(that.applicationID);
    }

    public int hashCode() {
        return this.applicationID.hashCode();
    }
}

