/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin.filters;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.jahia.bin.filters.AbstractServletFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeFilter
implements Filter {
    private static Logger logger = LoggerFactory.getLogger(CompositeFilter.class);
    private List<AbstractServletFilter> filters = new ArrayList<AbstractServletFilter>();
    private FilterConfig filterConfig;

    public void destroy() {
        int i = this.filters.size();
        while (i-- > 0) {
            AbstractServletFilter filter = this.filters.get(i);
            filter.destroy();
        }
    }

    public boolean containsFilter(AbstractServletFilter filter) {
        return this.filters.contains(filter);
    }

    public void registerFilter(AbstractServletFilter filter) throws ServletException {
        if (this.filterConfig != null) {
            filter.init(this.filterConfig);
        }
        logger.info("Registering servlet filter {}", (Object)filter);
        this.filters.add(filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterFilter(AbstractServletFilter filter) {
        logger.info("Unregistering servlet filter {}", (Object)filter);
        try {
            filter.destroy();
        }
        finally {
            this.filters.remove(filter);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        for (AbstractServletFilter filter : this.filters) {
            filter.init(filterConfig);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.filters.isEmpty()) {
            chain.doFilter(request, response);
        } else {
            new VirtualFilterChain(chain, this.filters).doFilter(request, response);
        }
    }

    private static boolean isFilterMatchPath(AbstractServletFilter filter, HttpServletRequest request) {
        String[] testPaths;
        if (filter.isMatchAllUrls()) {
            return true;
        }
        int length = request.getContextPath().length();
        String requestPath = length > 0 ? request.getRequestURI().substring(length) : request.getRequestURI();
        for (String testPath : testPaths = filter.getUrlPatterns()) {
            if (!CompositeFilter.matchFiltersURL(testPath, requestPath)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchFiltersURL(String testPath, String requestPath) {
        if (testPath == null) {
            return false;
        }
        if (testPath.equals(requestPath)) {
            return true;
        }
        if (testPath.equals("/*")) {
            return true;
        }
        if (testPath.endsWith("/*")) {
            if (testPath.regionMatches(0, requestPath, 0, testPath.length() - 2)) {
                if (requestPath.length() == testPath.length() - 2) {
                    return true;
                }
                if ('/' == requestPath.charAt(testPath.length() - 2)) {
                    return true;
                }
            }
            return false;
        }
        if (testPath.startsWith("*.")) {
            int slash = requestPath.lastIndexOf(47);
            int period = requestPath.lastIndexOf(46);
            if (slash >= 0 && period > slash && period != requestPath.length() - 1 && requestPath.length() - period == testPath.length() - 1) {
                return testPath.regionMatches(2, requestPath, period + 1, testPath.length() - 2);
            }
        }
        return false;
    }

    private static class VirtualFilterChain
    implements FilterChain {
        private final FilterChain originalChain;
        private final List<? extends AbstractServletFilter> additionalFilters;
        private int currentPosition = 0;

        private VirtualFilterChain(FilterChain chain, List<? extends AbstractServletFilter> additionalFilters) {
            this.originalChain = chain;
            this.additionalFilters = additionalFilters;
        }

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            AbstractServletFilter nextFilter = this.getNext(request);
            if (nextFilter == null) {
                this.originalChain.doFilter(request, response);
            } else {
                nextFilter.doFilter(request, response, this);
            }
        }

        private AbstractServletFilter getNext(ServletRequest request) {
            if (this.currentPosition < this.additionalFilters.size()) {
                AbstractServletFilter next = this.additionalFilters.get(this.currentPosition);
                ++this.currentPosition;
                if (request instanceof HttpServletRequest && CompositeFilter.isFilterMatchPath(next, (HttpServletRequest)request)) {
                    return next;
                }
                return this.getNext(request);
            }
            return null;
        }
    }
}

