/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import javax.jcr.AccessDeniedException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.taglibs.standard.tag.common.core.Util;
import org.jahia.bin.errors.DefaultErrorHandler;
import org.jahia.bin.errors.ErrorHandler;
import org.jahia.exceptions.JahiaException;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRStoreService;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.preferences.user.UserPreferencesHelper;
import org.jahia.services.sites.JahiaSite;
import org.jahia.services.sites.JahiaSitesService;
import org.jahia.services.uicomponents.bean.editmode.EditConfiguration;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.LanguageCodeConverters;
import org.jahia.utils.Url;
import org.jahia.utils.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WelcomeServlet
extends HttpServlet {
    private static final long serialVersionUID = -2055161334153523152L;
    private static final transient Logger logger = LoggerFactory.getLogger(WelcomeServlet.class);
    private static final String DEFAULT_LOCALE = Locale.ENGLISH.toString();
    private static final String DASHBOARD_HOME = ".projects.html";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            if (request.getRequestURI().endsWith("/start")) {
                this.userRedirect(request, response, this.getServletContext());
            } else {
                this.defaultRedirect(request, response, this.getServletContext());
            }
        }
        catch (Exception e) {
            List<ErrorHandler> handlers = ServicesRegistry.getInstance().getJahiaTemplateManagerService().getErrorHandler();
            for (ErrorHandler handler : handlers) {
                if (!handler.handle(e, request, response)) continue;
                return;
            }
            DefaultErrorHandler.getInstance().handle(e, request, response);
        }
    }

    protected void userRedirect(HttpServletRequest request, HttpServletResponse response, ServletContext context) throws Exception {
        JCRUserNode userNode;
        JahiaUser user = (JahiaUser)request.getSession().getAttribute("org.jahia.usermanager.jahiauser");
        JCRUserNode jCRUserNode = userNode = user != null ? JahiaUserManagerService.getInstance().lookupUserByPath(user.getLocalPath()) : null;
        if (JahiaUserManagerService.isGuest(user) || !userNode.isMemberOfGroup(null, "privileged")) {
            throw new AccessDeniedException();
        }
        JCRSiteNode site = this.resolveSite(request, "live", JCRContentUtils.getSystemSitePath());
        String language = this.resolveLanguage(request, site, userNode, true);
        this.redirect(request.getContextPath() + "/cms/dashboard/default/" + language + user.getLocalPath() + DASHBOARD_HOME, response);
    }

    protected void redirect(String url, HttpServletResponse response) throws IOException {
        String targetUrl = response.encodeRedirectURL(url);
        String jsessionIdParameterName = SettingsBean.getInstance().getJsessionIdParameterName();
        if (targetUrl.contains(";" + jsessionIdParameterName)) {
            targetUrl = targetUrl.contains("?") ? StringUtils.substringBefore((String)targetUrl, (String)(";" + jsessionIdParameterName + "=")) + "?" + StringUtils.substringAfter((String)targetUrl, (String)"?") : StringUtils.substringBefore((String)targetUrl, (String)(";" + jsessionIdParameterName + "="));
        }
        WebUtils.setNoCacheHeaders(response);
        response.sendRedirect(targetUrl);
    }

    protected void defaultRedirect(HttpServletRequest request, HttpServletResponse response, ServletContext context) throws Exception {
        JCRSiteNode site;
        String siteKey;
        request.getSession(true);
        JahiaSitesService siteService = JahiaSitesService.getInstance();
        JahiaSite defaultSite = null;
        String defaultSitePath = null;
        String string = siteKey = !Url.isLocalhost(request.getServerName()) ? siteService.getSitenameByServerName(request.getServerName()) : null;
        if (siteKey != null) {
            site = (JCRSiteNode)siteService.getSiteByKey(siteKey);
        } else {
            defaultSite = siteService.getDefaultSite();
            defaultSitePath = defaultSite != null ? defaultSite.getJCRLocalPath() : null;
            site = (JCRSiteNode)defaultSite;
        }
        String redirect = null;
        String pathInfo = request.getPathInfo();
        String defaultLocation = null;
        String mapping = null;
        if (pathInfo != null && (pathInfo.endsWith("mode") || pathInfo.endsWith("mode/"))) {
            String mode;
            String string2 = mode = pathInfo.endsWith("/") ? StringUtils.substringBetween((String)pathInfo, (String)"/", (String)"/") : StringUtils.substringAfter((String)pathInfo, (String)"/");
            if (SpringContextSingleton.getInstance().getContext().containsBean(mode)) {
                EditConfiguration editConfiguration = (EditConfiguration)SpringContextSingleton.getInstance().getContext().getBean(mode);
                defaultLocation = editConfiguration.getDefaultLocation();
                mapping = editConfiguration.getDefaultUrlMapping();
            }
        }
        if (site == null && (defaultLocation == null || defaultLocation.contains("$defaultSiteHome"))) {
            this.userRedirect(request, response, context);
        } else {
            JahiaUser user;
            if (defaultSite == null) {
                defaultSite = siteService.getDefaultSite();
                defaultSitePath = defaultSite != null ? defaultSite.getJCRLocalPath() : null;
            }
            JCRUserNode userNode = (user = (JahiaUser)request.getSession().getAttribute("org.jahia.usermanager.jahiauser")) != null ? JahiaUserManagerService.getInstance().lookupUserByPath(user.getLocalPath()) : null;
            String language = this.resolveLanguage(request, site, userNode, false);
            if (defaultLocation != null) {
                if (site != null && defaultLocation.contains("$defaultSiteHome")) {
                    JCRNodeWrapper home = site.getHome();
                    if (home == null) {
                        home = this.resolveSite(request, "default", defaultSitePath).getHome();
                    }
                    defaultLocation = defaultLocation.replace("$defaultSiteHome", home.getPath());
                }
                redirect = request.getContextPath() + mapping + "/" + language + defaultLocation;
            } else {
                JCRNodeWrapper home = site.getHome();
                if (home != null) {
                    redirect = request.getContextPath() + "/cms/render/" + "live" + "/" + language + home.getPath() + ".html";
                } else if (!SettingsBean.getInstance().isDistantPublicationServerMode()) {
                    JCRSiteNode defSite;
                    block21: {
                        defSite = null;
                        try {
                            defSite = (JCRSiteNode)JCRStoreService.getInstance().getSessionFactory().getCurrentUserSession().getNode(site.getPath());
                        }
                        catch (PathNotFoundException e) {
                            JCRSiteNode defaultSiteNode;
                            if (Url.isLocalhost(request.getServerName()) || defaultSite == null || site.getSiteKey().equals(defaultSite.getSiteKey()) || SettingsBean.getInstance().isUrlRewriteUseAbsoluteUrls() && !site.getServerName().equals(defaultSite.getServerName()) && !Url.isLocalhost(defaultSite.getServerName()) || (defaultSiteNode = (JCRSiteNode)JCRStoreService.getInstance().getSessionFactory().getCurrentUserSession("live").getNode(defaultSitePath)).getHome() == null) break block21;
                            redirect = request.getContextPath() + "/cms/render/" + "live" + "/" + language + defaultSiteNode.getHome().getPath() + ".html";
                        }
                    }
                    if (redirect == null && defSite != null && defSite.getHome() != null) {
                        if (defSite.getHome().hasPermission("editModeAccess")) {
                            redirect = request.getContextPath() + "/cms/edit/" + "default" + "/" + language + defSite.getHome().getPath() + ".html";
                        } else if (defSite.getHome().hasPermission("contributeModeAccess")) {
                            redirect = request.getContextPath() + "/cms/contribute/" + "default" + "/" + language + defSite.getHome().getPath() + ".html";
                        }
                    }
                }
            }
            if (redirect == null) {
                this.redirect(request.getContextPath() + "/start", response);
                return;
            }
            this.redirect(redirect, response);
        }
    }

    protected JCRSiteNode resolveSite(HttpServletRequest request, String workspace, String fallbackSitePath) throws JahiaException, RepositoryException {
        JahiaSitesService siteService = JahiaSitesService.getInstance();
        JahiaSite resolvedSite = !Url.isLocalhost(request.getServerName()) ? siteService.getSiteByServerName(request.getServerName()) : null;
        String sitePath = resolvedSite == null ? fallbackSitePath : resolvedSite.getJCRLocalPath();
        return sitePath != null ? (JCRSiteNode)JCRStoreService.getInstance().getSessionFactory().getCurrentUserSession(workspace).getNode(sitePath) : null;
    }

    protected String resolveLanguage(HttpServletRequest request, JCRSiteNode site, JCRUserNode user, boolean userRedirect) throws JahiaException {
        Locale preferredLocale;
        List<Locale> siteLanguages = null;
        if (!userRedirect && site != null && !"systemsite".equals(site.getSiteKey())) {
            try {
                siteLanguages = site.getActiveLiveLanguagesAsLocales();
            }
            catch (Exception t) {
                logger.debug("Exception while getting language settings as locales", (Throwable)t);
                siteLanguages = Collections.emptyList();
            }
        }
        if ((preferredLocale = UserPreferencesHelper.getPreferredLocale(user)) != null && this.isLocaleSupported(site, siteLanguages, preferredLocale)) {
            return preferredLocale.toString();
        }
        Enumeration requestLocales = Util.getRequestLocales((HttpServletRequest)request);
        while (requestLocales.hasMoreElements()) {
            Locale langOnlyLocale;
            Locale curLocale = (Locale)requestLocales.nextElement();
            if (curLocale == null) continue;
            if (this.isLocaleSupported(site, siteLanguages, curLocale)) {
                return curLocale.toString();
            }
            if (StringUtils.isEmpty((String)curLocale.getCountry()) || !this.isLocaleSupported(site, siteLanguages, langOnlyLocale = LanguageCodeConverters.languageCodeToLocale(curLocale.getLanguage()))) continue;
            return langOnlyLocale.toString();
        }
        String lang = site.getDefaultLanguage();
        if (lang != null) {
            return lang;
        }
        return StringUtils.defaultIfEmpty((String)SettingsBean.getInstance().getDefaultLanguageCode(), (String)DEFAULT_LOCALE);
    }

    private boolean isLocaleSupported(JCRSiteNode site, List<Locale> siteLanguages, Locale locale) {
        return siteLanguages == null || siteLanguages.contains(locale) && this.ensureHomePageExists(site, locale);
    }

    private boolean ensureHomePageExists(final JCRSiteNode site, final Locale curLocale) {
        try {
            return JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(null, "live", curLocale, new JCRCallback<Boolean>(){

                @Override
                public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    try {
                        JCRSiteNode nodeByIdentifier = (JCRSiteNode)session.getNodeByIdentifier(site.getIdentifier());
                        return nodeByIdentifier.getHome() != null;
                    }
                    catch (RepositoryException e) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("This site does not have a published home in language " + curLocale, (Throwable)e);
                        }
                        return Boolean.FALSE;
                    }
                }
            });
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

