/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin;

import java.io.IOException;
import java.io.Writer;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jahia.bin.errors.DefaultErrorHandler;
import org.jahia.bin.listeners.JahiaContextLoaderListener;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.render.RenderException;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.utils.RequestLoadAverage;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

public class ServerStats
implements Controller {
    private static Logger logger = LoggerFactory.getLogger(ServerStats.class);
    private RequestLoadAverage requestLoadAverage;

    public void setRequestLoadAverage(RequestLoadAverage requestLoadAverage) {
        this.requestLoadAverage = requestLoadAverage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        long startTime = System.currentTimeMillis();
        String sessionId = null;
        try {
            if (logger.isInfoEnabled()) {
                sessionId = request.getSession().getId();
            }
            if (request.getMethod().equals("GET") || request.getMethod().equals("POST")) {
                this.handle(request, response);
            } else if (request.getMethod().equals("OPTIONS")) {
                response.setHeader("Allow", "GET, OPTIONS, POST");
            } else {
                response.sendError(405);
            }
        }
        catch (Exception e) {
            DefaultErrorHandler.getInstance().handle(e, request, response);
        }
        finally {
            if (logger.isInfoEnabled()) {
                StringBuilder sb = new StringBuilder(100);
                sb.append("Rendered [").append(request.getRequestURI());
                JahiaUser user = JCRTemplate.getInstance().getSessionFactory().getCurrentUser();
                if (user != null) {
                    sb.append("] user=[").append(user.getUsername());
                }
                sb.append("] ip=[").append(request.getRemoteAddr()).append("] sessionID=[").append(sessionId).append("] in [").append(System.currentTimeMillis() - startTime).append("ms]");
                logger.info(sb.toString());
            }
        }
        return null;
    }

    protected void handle(HttpServletRequest request, HttpServletResponse response) throws RenderException, IOException, RepositoryException, JSONException {
        response.setContentType("application/json; charset=UTF-8");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("currentRequestCount", JahiaContextLoaderListener.getRequestCount());
        jsonObject.put("currentSessionCount", JahiaContextLoaderListener.getSessionCount());
        jsonObject.put("oneMinuteRequestLoadAverage", this.requestLoadAverage.getOneMinuteLoad());
        jsonObject.put("fiveMinuteRequestLoadAverage", this.requestLoadAverage.getFiveMinuteLoad());
        jsonObject.put("fifteenMinuteRequestLoadAverage", this.requestLoadAverage.getFifteenMinuteLoad());
        jsonObject.write((Writer)response.getWriter());
    }
}

