/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.htmlparser.jericho.Attribute;
import net.htmlparser.jericho.Attributes;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.EndTag;
import net.htmlparser.jericho.OutputDocument;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tika.io.IOUtils;
import org.jahia.api.Constants;
import org.jahia.bin.Action;
import org.jahia.bin.ActionResult;
import org.jahia.bin.DefaultDeleteAction;
import org.jahia.bin.LicensedAction;
import org.jahia.bin.SystemAction;
import org.jahia.bin.TokenChecker;
import org.jahia.bin.errors.DefaultErrorHandler;
import org.jahia.bin.errors.ErrorHandler;
import org.jahia.exceptions.JahiaBadRequestException;
import org.jahia.exceptions.JahiaForbiddenAccessException;
import org.jahia.exceptions.JahiaUnauthorizedException;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.logging.MetricsLoggingService;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.RenderException;
import org.jahia.services.render.RenderService;
import org.jahia.services.render.Resource;
import org.jahia.services.render.URLResolver;
import org.jahia.services.render.URLResolverFactory;
import org.jahia.services.seo.urlrewrite.SessionidRemovalResponseWrapper;
import org.jahia.services.templates.JahiaTemplateManagerService;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.settings.SettingsBean;
import org.jahia.tools.files.FileUpload;
import org.jahia.utils.Url;
import org.jahia.utils.i18n.Messages;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.ServletConfigAware;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

public class Render
extends HttpServlet
implements Controller,
ServletConfigAware {
    private static final long serialVersionUID = 5377039107890340659L;
    public static final String METHOD_DELETE = "DELETE";
    public static final String METHOD_HEAD = "HEAD";
    public static final String METHOD_GET = "GET";
    public static final String METHOD_OPTIONS = "OPTIONS";
    public static final String METHOD_POST = "POST";
    public static final String METHOD_PUT = "PUT";
    public static final String METHOD_TRACE = "TRACE";
    protected static final String HEADER_IFMODSINCE = "If-Modified-Since";
    protected static final String HEADER_LASTMOD = "Last-Modified";
    public static final String NODE_TYPE = "jcrNodeType";
    public static final String NODE_NAME = "jcrNodeName";
    public static final String NODE_NAME_PROPERTY = "jcrNodeNameProperty";
    public static final String NEW_NODE_OUTPUT_FORMAT = "jcrNewNodeOutputFormat";
    public static final String REDIRECT_TO = "jcrRedirectTo";
    public static final String REDIRECT_HTTP_RESPONSE_CODE = "jcrRedirectResponseCode";
    public static final String METHOD_TO_CALL = "jcrMethodToCall";
    public static final String AUTO_CHECKIN = "jcrAutoCheckin";
    public static final String CAPTCHA = "jcrCaptcha";
    public static final String TARGETDIRECTORY = "jcrTargetDirectory";
    public static final String TARGETNAME = "jcrTargetName";
    public static final String NORMALIZE_NODE_NAME = "jcrNormalizeNodeName";
    public static final String VERSION = "jcrVersion";
    public static final String SUBMIT = "jcrSubmit";
    public static final String AUTO_ASSIGN_ROLE = "jcrAutoAssignRole";
    public static final String ALIAS_USER = "alias";
    public static final String PARENT_TYPE = "jcrParentType";
    public static final String RETURN_CONTENTTYPE = "jcrReturnContentType";
    public static final String RETURN_CONTENTTYPE_OVERRIDE = "jcrReturnContentTypeOverride";
    public static final String RESOURCE_ID = "jcrResourceID";
    public static final String REMOVE_MIXIN = "jcrRemoveMixin";
    public static final String COOKIE_VALUE = "jcrCookieValue";
    public static final String COOKIE_NAME = "jcrCookieName";
    public static final String COOKIE_PATH = "jcrCookiePath";
    public static final String CONTRIBUTE_POST = "jcrContributePost";
    public static final String MARK_FOR_DELETION = "jcrMarkForDeletion";
    public static final String MARK_FOR_DELETION_MESSAGE = "jcrDeletionMessage";
    public static final String PREVIEW_DATE = "prevdate";
    public static final String DISABLE_XSS_FILTERING = "disableXSSFiltering";
    public static final List<String> EVENT_ATTRIBUTE_NAMES = Arrays.asList("onblur", "onchange", "onclick", "ondblclick", "onfocus", "onkeydown", "onkeypress", "onkeyup", "onload", "onmousedown", "onmousemove", "onmouseover", "onmouseout", "onmouseup", "onselect", "onsubmit", "onabort", "oncanplay", "oncanplaythrough", "oncontextmenu", "ondrag", "ondragend", "ondragenter", "ondragleave", "ondragstart", "ondrop", "ondurationchange", "onemptied", "onended", "onerror", "onformchange", "onforminput", "oninput", "oninvalid", "onloadeddata", "onloadedmetadata", "onloadstart", "onmousewheel", "onpause", "onplay", "onplaying", "onprogress", "onratechange", "onreadystatechange", "onscroll", "onseeked", "onseeking", "onshow", "onstalled", "onsuspend", "ontimeupdate", "onvolumechange", "onwaiting");
    public static final Pattern TAG_MISSING_END_BIGGERTHAN_PATTERN = Pattern.compile("<([^<>]*)(?=<|$)");
    public static final Pattern TAG_MISSING_START_LESSERTHAN_PATTERN = Pattern.compile("(^|(?<=>))([^<>]*)>");
    public static final String ALLOWS_MULTIPLE_SUBMITS = "allowsMultipleSubmits";
    private static final List<String> REDIRECT_CODE_MOVED_PERMANENTLY = new ArrayList<String>(Arrays.asList(String.valueOf(301)));
    private static final List<String> LIST_WITH_EMPTY_STRING = new ArrayList<String>(Arrays.asList(""));
    public static final String PLUTO_PREFIX = "__";
    public static final String PLUTO_ACTION = "ac";
    public static final String PLUTO_RESOURCE = "rs";
    protected static final Set<String> RESERVED_PARAMETERS = new HashSet<String>();
    private static Logger logger;
    private transient String workspace;
    private transient MetricsLoggingService loggingService;
    private transient JahiaTemplateManagerService templateService;
    private transient Action defaultPostAction;
    private transient Action defaultPutAction;
    private final transient Action defaultDeleteAction = new DefaultDeleteAction();
    private transient Action webflowAction;
    private transient Map<String, String> defaultContentType = new HashMap<String, String>();
    private transient SettingsBean settingsBean;
    private transient RenderService renderService;
    private transient JCRSessionFactory jcrSessionFactory;
    private transient URLResolverFactory urlResolverFactory;
    private transient Integer sessionExpiryTime = null;
    private Integer cookieExpirationInDays = 1;
    private Set<String> allowedMethods = new HashSet<String>();
    private transient ServletConfig servletConfig;

    protected long getLastModified(Resource resource, RenderContext renderContext) throws RepositoryException, IOException {
        return -1L;
    }

    protected void maybeSetLastModified(HttpServletResponse resp, long lastModified) {
        if (resp.containsHeader(HEADER_LASTMOD)) {
            return;
        }
        if (lastModified >= 0L) {
            resp.setDateHeader(HEADER_LASTMOD, lastModified);
        }
    }

    protected RenderContext createRenderContext(HttpServletRequest req, HttpServletResponse resp, JahiaUser user) {
        RenderContext context = new RenderContext(req, resp, user);
        int index = req.getPathInfo().indexOf("/", 1);
        if (index == -1 || index == req.getPathInfo().length() - 1) {
            throw new JahiaBadRequestException("Invalid path");
        }
        context.setServletPath(req.getServletPath() + req.getPathInfo().substring(0, index));
        return context;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp, RenderContext renderContext, Resource resource, long startTime) throws RepositoryException, RenderException, IOException {
        this.loggingService.startProfiler("MAIN");
        resp.setCharacterEncoding(this.getSettingsBean().getCharacterEncoding());
        String out = this.renderService.render(resource, renderContext).trim();
        if (renderContext.getRedirect() != null && !resp.isCommitted()) {
            resp.sendRedirect(renderContext.getRedirect());
        } else if (!renderContext.isPortletActionRequest()) {
            resp.setContentType(renderContext.getContentType() != null ? renderContext.getContentType() : this.getDefaultContentType(resource.getTemplateType()));
            resp.getWriter().print(out);
        }
        String sessionID = "";
        HttpSession httpSession = req.getSession(false);
        if (httpSession != null) {
            sessionID = httpSession.getId();
        }
        this.loggingService.stopProfiler("MAIN");
        if (this.loggingService.isEnabled()) {
            this.loggingService.logContentEvent(renderContext.getUser().getName(), req.getRemoteAddr(), sessionID, resource.getNode().getIdentifier(), resource.getNode().getPath(), resource.getNode().getPrimaryNodeType().getName(), "pageViewed", req.getHeader("User-Agent"), req.getHeader("Referer"), Long.toString(System.currentTimeMillis() - startTime));
        }
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp, RenderContext renderContext, URLResolver urlResolver) throws Exception {
        this.doAction(req, resp, urlResolver, renderContext, null, this.defaultPutAction, this.toParameterMapOfListOfString(req));
    }

    public void addCookie(HttpServletRequest req, HttpServletResponse resp) {
        if (req.getParameter(COOKIE_NAME) != null && req.getParameter(COOKIE_VALUE) != null) {
            Cookie cookie = new Cookie(req.getParameter(COOKIE_NAME), req.getParameter(COOKIE_VALUE));
            cookie.setMaxAge(86400 * this.cookieExpirationInDays);
            if (req.getParameter(COOKIE_PATH) != null) {
                cookie.setPath(req.getParameter(COOKIE_PATH));
            } else {
                cookie.setPath("/");
            }
            resp.addCookie(cookie);
        }
    }

    public static JSONObject serializeNodeToJSON(JCRNodeWrapper node) throws RepositoryException, IOException, JSONException {
        PropertyIterator stringMap = node.getProperties();
        HashMap<String, String> map = new HashMap<String, String>();
        while (stringMap.hasNext()) {
            JCRPropertyWrapper propertyWrapper = (JCRPropertyWrapper)stringMap.next();
            int type = propertyWrapper.getType();
            String name = JCRContentUtils.replaceColon(propertyWrapper.getName());
            if (Constants.forbiddenPropertiesToSerialize.contains(propertyWrapper.getDefinition().getName())) continue;
            if (type == 10 || type == 9) {
                if (propertyWrapper.isMultiple()) continue;
                map.put(name, ((JCRNodeWrapper)propertyWrapper.getNode()).getUrl());
                continue;
            }
            if (propertyWrapper.isMultiple()) continue;
            map.put(name, propertyWrapper.getValue().getString());
        }
        JSONObject nodeJSON = new JSONObject(map);
        return nodeJSON;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp, RenderContext renderContext, URLResolver urlResolver) throws Exception {
        Action action;
        if (req.getParameter("portletInfo") != null) {
            Resource resource = urlResolver.getResource();
            renderContext.setMainResource(resource);
            JCRSiteNode site = resource.getNode().getResolveSite();
            renderContext.setSite(site);
            this.doGet(req, resp, renderContext, resource, System.currentTimeMillis());
            return;
        }
        Map<String, List<String>> parameters = new HashMap<String, List<String>>();
        if (this.checkForUploadedFiles(req, resp, urlResolver.getWorkspace(), urlResolver.getLocale(), parameters, urlResolver) && parameters.isEmpty()) {
            return;
        }
        if (parameters.isEmpty()) {
            parameters = this.toParameterMapOfListOfString(req);
        }
        Resource resource = null;
        if (urlResolver.getPath().endsWith(".do") || this.isWebflowRequest(req)) {
            resource = urlResolver.getResource();
            renderContext.setMainResource(resource);
            try {
                JCRSiteNode site = resource.getNode().getResolveSite();
                renderContext.setSite(site);
            }
            catch (RepositoryException e) {
                logger.warn("Cannot get site for action context", (Throwable)e);
            }
            action = this.isWebflowRequest(req) ? this.webflowAction : this.templateService.getActions().get(resource.getResolvedTemplate());
        } else {
            final String path = urlResolver.getPath();
            String resourcePath = JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(null, urlResolver.getWorkspace(), urlResolver.getLocale(), new JCRCallback<String>(){

                @Override
                public String doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    String resourcePath = path.endsWith("*") ? StringUtils.substringBeforeLast((String)path, (String)"/") : path;
                    while (true) {
                        try {
                            session.getNode(resourcePath);
                        }
                        catch (PathNotFoundException e) {
                            if ((resourcePath = StringUtils.substringBeforeLast((String)resourcePath, (String)"/")).contains("/")) continue;
                        }
                        break;
                    }
                    return resourcePath;
                }
            });
            resource = urlResolver.getResource(resourcePath + ".html");
            renderContext.setMainResource(resource);
            try {
                JCRSiteNode site = resource.getNode().getResolveSite();
                renderContext.setSite(site);
            }
            catch (RepositoryException e) {
                // empty catch block
            }
            action = this.defaultPostAction;
        }
        if (action == null) {
            if (urlResolver.getPath().endsWith(".do")) {
                logger.error("Couldn't resolve action named [" + resource.getResolvedTemplate() + "]");
            }
            resp.sendError(501);
        } else {
            this.doAction(req, resp, urlResolver, renderContext, resource, action, parameters);
        }
    }

    private Map<String, List<String>> toParameterMapOfListOfString(HttpServletRequest req) {
        Map toks;
        String token;
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        Map parameterMap = req.getParameterMap();
        boolean doXSSFilter = true;
        String string = token = parameterMap.get("form-token") != null ? ((String[])parameterMap.get("form-token"))[0] : null;
        if (token != null && (toks = (Map)req.getSession().getAttribute("form-tokens")) != null && toks.containsKey(token)) {
            doXSSFilter = !((Map)toks.get(token)).containsKey(DISABLE_XSS_FILTERING) || ((List)((Map)toks.get(token)).get(DISABLE_XSS_FILTERING)).contains("false");
        }
        for (Object key : parameterMap.keySet()) {
            ArrayList<String> stringList;
            if (key == null) continue;
            String[] parameterValues = (String[])parameterMap.get(key);
            if (doXSSFilter && !RESERVED_PARAMETERS.contains(key)) {
                stringList = new ArrayList();
                for (String s : parameterValues) {
                    stringList.add(this.xssFilter(s));
                }
            } else {
                stringList = new ArrayList<String>(Arrays.asList(parameterValues));
            }
            parameters.put((String)key, stringList);
        }
        return parameters;
    }

    private String xssFilter(String stringValue) {
        if (!stringValue.contains("<") && !stringValue.contains(">")) {
            return stringValue;
        }
        stringValue = TAG_MISSING_END_BIGGERTHAN_PATTERN.matcher(stringValue).replaceAll("&lt;$1");
        stringValue = TAG_MISSING_START_LESSERTHAN_PATTERN.matcher(stringValue).replaceAll("$1&gt;");
        Source source = new Source((CharSequence)stringValue);
        OutputDocument outputDocument = new OutputDocument(source);
        List elements = source.getAllElements();
        for (Element element : elements) {
            Attributes attributes;
            if ("script".equals(element.getName())) {
                EndTag endTag;
                StartTag startTag = element.getStartTag();
                outputDocument.remove((Segment)startTag);
                if (!startTag.isSyntacticalEmptyElementTag() && (endTag = element.getEndTag()) != null) {
                    outputDocument.remove((Segment)endTag);
                }
            }
            if ((attributes = element.getAttributes()) == null) continue;
            for (Attribute attribute : attributes) {
                if (!EVENT_ATTRIBUTE_NAMES.contains(attribute.getName())) continue;
                outputDocument.remove((Segment)attribute);
            }
        }
        return outputDocument.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkForUploadedFiles(HttpServletRequest req, HttpServletResponse resp, String workspace, Locale locale, Map<String, List<String>> parameters, URLResolver urlResolver) throws RepositoryException, IOException {
        block23: {
            block24: {
                if (!this.isMultipartRequest(req)) break block23;
                if (this.isPortletRequest(req)) break block24;
                String savePath = this.getSettingsBean().getTmpContentDiskPath();
                File tmp = new File(savePath);
                if (!tmp.exists()) {
                    tmp.mkdirs();
                }
                try {
                    FileUpload fileUpload;
                    block25: {
                        LinkedList<String> urls;
                        ArrayList<String> files;
                        LinkedList<String> uuids;
                        boolean isAjaxRequest;
                        boolean isContributePost;
                        boolean isAction;
                        boolean isTargetDirectoryDefined;
                        block26: {
                            String path;
                            String target;
                            fileUpload = new FileUpload(req, savePath, Integer.MAX_VALUE);
                            req.setAttribute("fileUpload", (Object)fileUpload);
                            if (fileUpload.getFileItems() == null || fileUpload.getFileItems().size() <= 0) break block25;
                            isTargetDirectoryDefined = fileUpload.getParameterNames().contains(TARGETDIRECTORY);
                            isAction = urlResolver.getPath().endsWith(".do");
                            isContributePost = fileUpload.getParameterNames().contains(CONTRIBUTE_POST);
                            String requestWith = req.getHeader("x-requested-with");
                            isAjaxRequest = req.getHeader("accept") != null && req.getHeader("accept").contains("application/json") && requestWith != null && requestWith.equals("XMLHttpRequest") || fileUpload.getParameterMap().isEmpty();
                            uuids = new LinkedList<String>();
                            files = new ArrayList<String>();
                            urls = new LinkedList<String>();
                            if (isAction || !isContributePost && !isTargetDirectoryDefined && !isAjaxRequest) break block26;
                            JCRSessionWrapper session = this.jcrSessionFactory.getCurrentUserSession(workspace, locale);
                            if (isTargetDirectoryDefined) {
                                target = fileUpload.getParameterValues(TARGETDIRECTORY)[0];
                            } else if (isContributePost) {
                                path = urlResolver.getPath();
                                path = path.endsWith("*") ? StringUtils.substringBeforeLast((String)path, (String)"/") : path;
                                JCRNodeWrapper sessionNode = session.getNode(path);
                                JCRSiteNode siteNode = sessionNode.getResolveSite();
                                if (siteNode != null) {
                                    String s = sessionNode.getResolveSite().getPath() + "/files/contributed/";
                                    String name = JCRContentUtils.replaceColon(sessionNode.getPrimaryNodeTypeName()) + "_" + sessionNode.getName();
                                    target = s + name;
                                    try {
                                        session.getNode(target);
                                    }
                                    catch (RepositoryException e) {
                                        JCRNodeWrapper node = session.getNode(s);
                                        session.checkout(node);
                                        node.addNode(name, "jnt:folder");
                                        session.save();
                                    }
                                } else {
                                    target = sessionNode.getPath() + "/files";
                                    if (!sessionNode.hasNode("files")) {
                                        session.checkout(sessionNode);
                                        sessionNode.addNode("files", "jnt:folder");
                                        session.save();
                                    }
                                }
                            } else {
                                path = urlResolver.getPath();
                                target = path.endsWith("*") ? StringUtils.substringBeforeLast((String)path, (String)"/") : path;
                            }
                            JCRNodeWrapper targetDirectory = session.getNode(target);
                            boolean isVersionActivated = fileUpload.getParameterNames().contains(VERSION) ? fileUpload.getParameterValues(VERSION)[0].equals("true") : false;
                            Map<String, DiskFileItem> stringDiskFileItemMap = fileUpload.getFileItems();
                            for (Map.Entry<String, DiskFileItem> itemEntry : stringDiskFileItemMap.entrySet()) {
                                JCRNodeWrapper fileNode;
                                String name = itemEntry.getValue().getName();
                                if (fileUpload.getParameterNames().contains(TARGETNAME)) {
                                    name = fileUpload.getParameterValues(TARGETNAME)[0];
                                }
                                JCRNodeWrapper jCRNodeWrapper = fileNode = targetDirectory.hasNode(name = JCRContentUtils.escapeLocalNodeName(FilenameUtils.getName((String)name))) ? targetDirectory.getNode(name) : null;
                                if (fileNode != null && isVersionActivated) {
                                    session.checkout(fileNode);
                                }
                                session.checkout(targetDirectory);
                                InputStream is = null;
                                JCRNodeWrapper wrapper = null;
                                try {
                                    is = itemEntry.getValue().getInputStream();
                                    wrapper = targetDirectory.uploadFile(name, is, JCRContentUtils.getMimeType(name, itemEntry.getValue().getContentType()));
                                }
                                catch (Throwable throwable) {
                                    IOUtils.closeQuietly(is);
                                    throw throwable;
                                }
                                IOUtils.closeQuietly((InputStream)is);
                                uuids.add(wrapper.getIdentifier());
                                urls.add(wrapper.getAbsoluteUrl((ServletRequest)req));
                                files.add(itemEntry.getValue().getName());
                                if (!isVersionActivated) continue;
                                if (!wrapper.isVersioned()) {
                                    wrapper.versionFile();
                                }
                                session.save();
                                wrapper = session.getNodeByIdentifier(wrapper.getIdentifier());
                                wrapper.checkpoint();
                            }
                            fileUpload.disposeItems();
                            fileUpload.markFilesAsConsumed();
                            session.save();
                        }
                        if (isAction || !isAjaxRequest && !isContributePost) {
                            parameters.putAll(fileUpload.getParameterMap());
                            if (isTargetDirectoryDefined) {
                                parameters.put(NODE_NAME, files);
                            }
                            return true;
                        }
                        try {
                            resp.setStatus(201);
                            LinkedHashMap<String, LinkedList<String>> map = new LinkedHashMap<String, LinkedList<String>>();
                            map.put("uuids", uuids);
                            map.put("urls", urls);
                            JSONObject nodeJSON = new JSONObject(map);
                            nodeJSON.write((Writer)resp.getWriter());
                            return true;
                        }
                        catch (JSONException e) {
                            logger.error(e.getMessage(), (Throwable)e);
                        }
                    }
                    if (fileUpload.getParameterMap() != null && !fileUpload.getParameterMap().isEmpty()) {
                        parameters.putAll(fileUpload.getParameterMap());
                    }
                    break block23;
                }
                catch (IOException e) {
                    logger.error("Cannot parse multipart data !", (Throwable)e);
                }
                break block23;
            }
            logger.debug("Mulipart request is not processed. It's the task of the portlet");
        }
        return false;
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp, RenderContext renderContext, URLResolver urlResolver) throws Exception {
        this.doAction(req, resp, urlResolver, renderContext, null, this.defaultDeleteAction, this.toParameterMapOfListOfString(req));
    }

    public boolean isMultipartRequest(HttpServletRequest req) {
        String contentType = req.getHeader("Content-Type");
        return contentType != null && contentType.indexOf("multipart/form-data") >= 0;
    }

    public boolean isPortletRequest(HttpServletRequest req) {
        String pathInfo = req.getPathInfo();
        if (pathInfo != null && pathInfo.contains(PLUTO_PREFIX)) {
            StringTokenizer st = new StringTokenizer(pathInfo, "/", false);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.startsWith("__rs")) {
                    return true;
                }
                if (!token.startsWith("__ac")) continue;
                return true;
            }
        }
        return false;
    }

    public static void performRedirect(String url, String path, HttpServletRequest req, HttpServletResponse resp, Map<String, List<String>> parameters, boolean bypassCache) throws IOException {
        String stayOnPage;
        String renderedURL = null;
        List<String> stringList = parameters.get(NEW_NODE_OUTPUT_FORMAT);
        String outputFormat = !CollectionUtils.isEmpty(stringList) && stringList.get(0) != null ? stringList.get(0) : "html";
        stringList = parameters.get(REDIRECT_HTTP_RESPONSE_CODE);
        int responseCode = !CollectionUtils.isEmpty(stringList) && !StringUtils.isBlank((String)stringList.get(0)) ? Integer.parseInt(stringList.get(0)) : 303;
        stringList = parameters.get(REDIRECT_TO);
        String string = stayOnPage = !CollectionUtils.isEmpty(stringList) && !StringUtils.isBlank((String)stringList.get(0)) ? StringUtils.substringBeforeLast((String)stringList.get(0), (String)";") : "";
        if (!StringUtils.isEmpty((String)stayOnPage)) {
            renderedURL = stayOnPage + (!StringUtils.isEmpty((String)outputFormat) ? "." + outputFormat : "");
        } else if (!StringUtils.isEmpty((String)url)) {
            String requestedURL = req.getRequestURI();
            String decodedURL = URLDecoder.decode(requestedURL, "UTF-8");
            int index = decodedURL.indexOf(path);
            renderedURL = decodedURL.substring(0, index) + url + (!StringUtils.isEmpty((String)outputFormat) ? "." + outputFormat : "");
        }
        if (bypassCache) {
            String formuuid;
            stringList = parameters.get(RESOURCE_ID);
            String string2 = formuuid = !CollectionUtils.isEmpty(stringList) && !StringUtils.isBlank((String)stringList.get(0)) ? stringList.get(0) : null;
            if (formuuid != null) {
                renderedURL = renderedURL + "?ec=" + formuuid;
            }
        }
        if (!StringUtils.isEmpty(renderedURL)) {
            String s;
            String redirect = resp.encodeRedirectURL(renderedURL);
            if (SettingsBean.getInstance().isDisableJsessionIdParameter() && redirect.contains(s = ";" + SettingsBean.getInstance().getJsessionIdParameterName())) {
                redirect = SessionidRemovalResponseWrapper.removeJsessionId(redirect);
            }
            if (StringUtils.isEmpty((String)stayOnPage)) {
                resp.setHeader("Location", redirect);
            } else if (responseCode == 303) {
                resp.setHeader("Location", redirect);
            }
            if (responseCode == 302) {
                resp.sendRedirect(redirect);
            } else {
                resp.setStatus(responseCode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ModelAndView handleRequest(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        if (this.isDisabled()) {
            resp.sendError(404);
            return null;
        }
        String method = req.getMethod();
        if (req.getParameter(METHOD_TO_CALL) != null) {
            method = req.getParameter(METHOD_TO_CALL).toUpperCase();
        }
        if (!this.isMethodAllowed(method)) {
            resp.sendError(405);
            return null;
        }
        long startTime = System.currentTimeMillis();
        String sessionId = null;
        try {
            JahiaUserManagerService userManagerService;
            JCRUserNode userNode;
            HttpSession session = req.getSession();
            if (logger.isInfoEnabled()) {
                sessionId = session.getId();
            }
            URLResolver urlResolver = this.urlResolverFactory.createURLResolver(req.getPathInfo(), req.getServerName(), this.workspace, req);
            req.setAttribute("urlResolver", (Object)urlResolver);
            session.setAttribute("workspace", (Object)urlResolver.getWorkspace());
            if (this.sessionExpiryTime != null && session.getMaxInactiveInterval() != this.sessionExpiryTime * 60) {
                session.setMaxInactiveInterval(this.sessionExpiryTime * 60);
            }
            RenderContext renderContext = this.createRenderContext(req, resp, this.jcrSessionFactory.getCurrentUser());
            renderContext.setWorkspace(urlResolver.getWorkspace());
            urlResolver.setRenderContext(renderContext);
            req.getSession().setAttribute("org.jahia.services.multilang.currentlocale", (Object)urlResolver.getLocale());
            this.jcrSessionFactory.setCurrentLocale(urlResolver.getLocale());
            if (renderContext.isPreviewMode() && req.getParameter(ALIAS_USER) != null && !JahiaUserManagerService.isGuest(this.jcrSessionFactory.getCurrentUser()) && (userNode = (userManagerService = ServicesRegistry.getInstance().getJahiaUserManagerService()).lookupUser(req.getParameter(ALIAS_USER), urlResolver.getSiteKey())) != null) {
                this.jcrSessionFactory.setCurrentAliasedUser(userNode.getJahiaUser());
            }
            try {
                if (!this.hasAccess(urlResolver.getNode())) {
                    if (!JahiaUserManagerService.isGuest(this.jcrSessionFactory.getCurrentUser())) throw new JahiaForbiddenAccessException();
                    throw new JahiaUnauthorizedException();
                }
            }
            catch (PathNotFoundException e) {
                // empty catch block
            }
            renderContext.setSiteInfo(urlResolver.getSiteInfo());
            if (renderContext.isPreviewMode() && req.getParameter(PREVIEW_DATE) != null && !JahiaUserManagerService.isGuest(this.jcrSessionFactory.getCurrentUser())) {
                Calendar previewDate = Calendar.getInstance();
                previewDate.setTime(new Date(new Long(req.getParameter(PREVIEW_DATE))));
                this.jcrSessionFactory.setCurrentPreviewDate(previewDate);
            }
            if (method.equals(METHOD_GET)) {
                Resource resource = urlResolver.getResource();
                if (!StringUtils.isEmpty((String)urlResolver.getRedirectUrl()) && (StringUtils.isEmpty((String)resource.getTemplate()) || StringUtils.equals((String)resource.getTemplate(), (String)"default"))) {
                    HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
                    parameters.put(NEW_NODE_OUTPUT_FORMAT, LIST_WITH_EMPTY_STRING);
                    parameters.put(REDIRECT_HTTP_RESPONSE_CODE, REDIRECT_CODE_MOVED_PERMANENTLY);
                    Render.performRedirect(urlResolver.getRedirectUrl(), StringUtils.isEmpty((String)urlResolver.getVanityUrl()) ? "/" + urlResolver.getLocale().toString() + urlResolver.getPath() : urlResolver.getVanityUrl(), req, resp, parameters, false);
                    return null;
                }
                renderContext.setMainResource(resource);
                if (renderContext.getSite() == null) {
                    JCRSiteNode site = resource.getNode().getResolveSite();
                    if (!Url.isLocalhost(req.getServerName()) && !renderContext.isEditMode()) {
                        JCRSessionWrapper session1 = resource.getNode().getSession();
                        if (!(urlResolver.getSiteKey() == null || site != null && site.getSiteKey().equals(urlResolver.getSiteKey()))) {
                            site = (JCRSiteNode)session1.getNode("/sites/" + urlResolver.getSiteKey());
                        } else if (renderContext.isLiveMode() && urlResolver.getSiteKeyByServerName() != null && (site == null || !site.getSiteKey().equals(urlResolver.getSiteKeyByServerName()))) {
                            site = (JCRSiteNode)session1.getNode("/sites/" + urlResolver.getSiteKeyByServerName());
                        }
                    }
                    String jsite = null;
                    HttpServletRequest request = renderContext.getRequest();
                    if (request != null) {
                        jsite = request.getParameter("jsite");
                    }
                    if (jsite == null && renderContext.getMainResource() != null) {
                        jsite = (String)((Object)renderContext.getMainResource().getModuleParams().get("jsite"));
                    }
                    if (jsite != null) {
                        try {
                            site = (JCRSiteNode)resource.getNode().getSession().getNodeByIdentifier(jsite);
                        }
                        catch (ItemNotFoundException e) {
                            if (!JahiaUserManagerService.isGuest(this.jcrSessionFactory.getCurrentUser())) throw new JahiaForbiddenAccessException();
                            throw new JahiaUnauthorizedException();
                        }
                    }
                    if (resource.getNode().getPath().startsWith("/sites/")) {
                        if (site == null) throw new PathNotFoundException("This language does not exist on this site");
                        if (!site.getPath().startsWith("/modules/") && !site.isAllowsUnlistedLanguages()) {
                            if (renderContext.isLiveMode()) {
                                if (!site.getActiveLiveLanguagesAsLocales().contains(urlResolver.getLocale())) throw new PathNotFoundException("This language does not exist on this site");
                            } else if (!site.getLanguagesAsLocales().contains(urlResolver.getLocale())) {
                                throw new PathNotFoundException("This language does not exist on this site");
                            }
                        }
                    }
                    renderContext.setSite(site);
                }
                if (urlResolver.getPath().endsWith(".do")) {
                    Action action = this.templateService.getActions().get(resource.getResolvedTemplate());
                    Map<String, List<String>> parameters = this.toParameterMapOfListOfString(req);
                    if (action != null) {
                        this.doAction(req, resp, urlResolver, renderContext, resource, action, parameters);
                        return null;
                    }
                    logger.error("Action {} does not exist", (Object)resource.getResolvedTemplate());
                    throw new PathNotFoundException("Action does not exist");
                }
                long lastModified = this.getLastModified(resource, renderContext);
                if (lastModified == -1L) {
                    this.doGet(req, resp, renderContext, resource, startTime);
                    return null;
                }
                long ifModifiedSince = req.getDateHeader(HEADER_IFMODSINCE);
                if (ifModifiedSince < lastModified / 1000L * 1000L) {
                    this.maybeSetLastModified(resp, lastModified);
                    this.doGet(req, resp, renderContext, resource, startTime);
                    return null;
                }
                resp.setStatus(304);
                return null;
            }
            if (method.equals(METHOD_HEAD)) {
                this.doHead(req, resp);
                return null;
            }
            if (method.equals(METHOD_POST)) {
                this.doPost(req, resp, renderContext, urlResolver);
                return null;
            }
            if (method.equals(METHOD_PUT)) {
                this.doPut(req, resp, renderContext, urlResolver);
                return null;
            }
            if (method.equals(METHOD_DELETE)) {
                this.doDelete(req, resp, renderContext, urlResolver);
                return null;
            }
            if (method.equals(METHOD_OPTIONS)) {
                this.doOptions(req, resp);
                return null;
            }
            if (method.equals(METHOD_TRACE)) {
                this.doTrace(req, resp);
                return null;
            }
            resp.sendError(405);
            return null;
        }
        catch (Exception e) {
            ErrorHandler handler;
            List<ErrorHandler> handlers = this.templateService.getErrorHandler();
            Iterator<ErrorHandler> i$ = handlers.iterator();
            do {
                if (i$.hasNext()) continue;
                DefaultErrorHandler.getInstance().handle(e, req, resp);
                return null;
            } while (!(handler = i$.next()).handle(e, req, resp));
            ModelAndView modelAndView = null;
            return modelAndView;
        }
        finally {
            if (logger.isInfoEnabled()) {
                StringBuilder sb = new StringBuilder(100);
                sb.append("Rendered [").append(req.getRequestURI());
                if (this.jcrSessionFactory.getCurrentUser() != null) {
                    sb.append("] user=[").append(this.jcrSessionFactory.getCurrentUser().getUsername());
                }
                sb.append("] ip=[").append(req.getRemoteAddr()).append("] sessionID=[").append(sessionId).append("] in [").append(System.currentTimeMillis() - startTime).append("ms]");
                logger.info(sb.toString());
            }
        }
    }

    private boolean isWebflowRequest(HttpServletRequest req) {
        boolean webflowRequest = false;
        if (req.getMethod().equals(METHOD_POST)) {
            Enumeration parameterNames = req.getParameterNames();
            while (parameterNames.hasMoreElements()) {
                String s = (String)parameterNames.nextElement();
                if (!s.startsWith("webflowexecution")) continue;
                webflowRequest = true;
                break;
            }
        }
        return webflowRequest;
    }

    protected boolean isDisabled() {
        return false;
    }

    private void doAction(HttpServletRequest req, HttpServletResponse resp, URLResolver urlResolver, RenderContext renderContext, Resource resource, Action action, Map<String, List<String>> parameters) throws Exception {
        ActionResult result;
        LicensedAction licensedAction;
        String requestWith = req.getHeader("x-requested-with");
        boolean isAjaxRequest = req.getHeader("accept") != null && req.getHeader("accept").contains("application/json") && requestWith != null && requestWith.equals("XMLHttpRequest");
        final Action originalAction = action;
        int tokenResult = 0;
        if (!this.isWebflowRequest(req)) {
            tokenResult = TokenChecker.checkToken(req, resp, parameters);
        }
        switch (tokenResult) {
            case 0: {
                break;
            }
            case 2: {
                throw new AccessDeniedException("Invalid token.");
            }
            case 4: {
                HashMap<String, String[]> formDatas = new HashMap<String, String[]>();
                Set<Map.Entry<String, List<String>>> set = parameters.entrySet();
                for (Map.Entry<String, List<String>> params : set) {
                    formDatas.put(params.getKey(), params.getValue().toArray(new String[params.getValue().size()]));
                }
                String errorMessage = Messages.getInternal("failure.captcha", urlResolver.getLocale(), "Your captcha is invalid");
                if (!isAjaxRequest) {
                    req.getSession().setAttribute("formDatas", formDatas);
                    req.getSession().setAttribute("formError", (Object)errorMessage);
                    Render.performRedirect(renderContext.getMainResource().getNode().getPath(), urlResolver.getPath(), req, resp, parameters, true);
                } else {
                    resp.setContentType("application/json; charset=UTF-8");
                    HashMap<String, String> res = new HashMap<String, String>();
                    res.put("status", errorMessage);
                    new JSONObject(res).write((Writer)resp.getWriter());
                }
                return;
            }
            case 3: {
                throw new AccessDeniedException();
            }
            case 1: {
                action = new SystemAction(){

                    @Override
                    public ActionResult doExecuteAsSystem(HttpServletRequest req, RenderContext renderContext, JCRSessionWrapper systemSession, Resource resource, Map<String, List<String>> parameters, URLResolver urlResolver) throws Exception {
                        return originalAction.doExecute(req, renderContext, resource, systemSession, parameters, urlResolver);
                    }
                };
            }
        }
        if (!(action instanceof SystemAction)) {
            if (action.getRequiredWorkspace() != null && !action.getRequiredWorkspace().equals(urlResolver.getWorkspace())) {
                throw new PathNotFoundException("Action is not supported for this workspace");
            }
            if (action.isRequireAuthenticatedUser() && !renderContext.isLoggedIn()) {
                throw new AccessDeniedException("Action '" + action.getName() + "' requires an authenticated user");
            }
            if (!action.isPermitted(urlResolver.getNode())) {
                throw new AccessDeniedException("Action '" + action.getName() + "' requires '" + action.getRequiredPermission() + "' permission.");
            }
        } else if (originalAction instanceof LicensedAction && !(licensedAction = (LicensedAction)originalAction).isAllowedByLicense()) {
            logger.error("Action '{}' requires a licene feature '{}' which is not allowed by the current license terms", (Object)originalAction.getName(), (Object)licensedAction.getLicenseFeature());
            throw new AccessDeniedException("Action '" + action.getName() + "' requires a licene feature '" + licensedAction.getLicenseFeature() + "' which is not allowed by the current license terms");
        }
        JCRSessionWrapper session = null;
        session = resource != null ? resource.getNode().getSession() : JCRSessionFactory.getInstance().getCurrentUserSession(urlResolver.getWorkspace(), urlResolver.getLocale());
        try {
            result = action.doExecute(req, renderContext, resource, session, parameters, urlResolver);
        }
        catch (Exception e) {
            logger.error("An error occurs when executing action {}", (Object)action.getName(), (Object)e);
            throw e;
        }
        if (result != null) {
            boolean returnJSON;
            boolean bl = returnJSON = "json".equals(parameters.get(RETURN_CONTENTTYPE) != null ? parameters.get(RETURN_CONTENTTYPE).get(0) : "") || req.getHeader("accept") != null && req.getHeader("accept").contains("application/json");
            if (result.getResultCode() < 300 || returnJSON) {
                resp.setStatus(result.getResultCode());
                this.addCookie(req, resp);
                if (result.getJson() != null && returnJSON) {
                    try {
                        String contentType;
                        String string = contentType = parameters.get(RETURN_CONTENTTYPE_OVERRIDE) != null ? StringUtils.defaultIfEmpty((String)parameters.get(RETURN_CONTENTTYPE_OVERRIDE).get(0), null) : null;
                        if (contentType == null) {
                            contentType = "application/json; charset=UTF-8";
                        } else if (!contentType.toLowerCase().contains("charset")) {
                            contentType = contentType + "; charset=UTF-8";
                        }
                        resp.setContentType(contentType);
                        result.getJson().write((Writer)resp.getWriter());
                    }
                    catch (JSONException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                } else if (!result.isAbsoluteUrl()) {
                    Render.performRedirect(result.getUrl(), urlResolver.getPath(), req, resp, parameters, false);
                } else {
                    resp.sendRedirect(resp.encodeRedirectURL(result.getUrl()));
                }
            } else {
                resp.sendError(result.getResultCode());
            }
        }
    }

    protected boolean isMethodAllowed(String method) {
        return this.allowedMethods.isEmpty() || this.allowedMethods.contains(method);
    }

    protected boolean hasAccess(JCRNodeWrapper node) {
        return true;
    }

    public void setServletConfig(ServletConfig servletConfig) {
        this.servletConfig = servletConfig;
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public String getServletName() {
        return this.getServletConfig().getServletName();
    }

    public static String getRenderServletPath() {
        return "/cms/render";
    }

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    public void setLoggingService(MetricsLoggingService loggingService) {
        this.loggingService = loggingService;
    }

    public void setTemplateService(JahiaTemplateManagerService templateService) {
        this.templateService = templateService;
    }

    public void setSessionExpiryTime(int sessionExpiryTime) {
        this.sessionExpiryTime = sessionExpiryTime;
    }

    public void setDefaultPostAction(Action defaultPostActionResult) {
        this.defaultPostAction = defaultPostActionResult;
    }

    public void setDefaultPutAction(Action defaultPutActionResult) {
        this.defaultPutAction = defaultPutActionResult;
    }

    public void setWebflowAction(Action webflowAction) {
        this.webflowAction = webflowAction;
    }

    public static Set<String> getReservedParameters() {
        return RESERVED_PARAMETERS;
    }

    public void setSettingsBean(SettingsBean settingsBean) {
        this.settingsBean = settingsBean;
    }

    public void setRenderService(RenderService renderService) {
        this.renderService = renderService;
    }

    public void setJcrSessionFactory(JCRSessionFactory jcrSessionFactory) {
        this.jcrSessionFactory = jcrSessionFactory;
    }

    public void setCookieExpirationInDays(Integer cookieExpirationInDays) {
        this.cookieExpirationInDays = cookieExpirationInDays;
    }

    public void setUrlResolverFactory(URLResolverFactory urlResolverFactory) {
        this.urlResolverFactory = urlResolverFactory;
    }

    public void setAllowedMethods(Set<String> allowedMethods) {
        this.allowedMethods = new HashSet<String>(allowedMethods.size());
        for (String method : allowedMethods) {
            this.allowedMethods.add(method.toUpperCase());
        }
    }

    public String getDefaultContentType(String templateType) {
        if (templateType != null && this.defaultContentType.get(templateType) != null) {
            return this.defaultContentType.get(templateType);
        }
        return "text/html; charset=UTF-8";
    }

    public void setDefaultContentType(Map<String, String> defaultContentType) {
        this.defaultContentType = defaultContentType;
    }

    public SettingsBean getSettingsBean() {
        return this.settingsBean;
    }

    static {
        RESERVED_PARAMETERS.add(NODE_TYPE);
        RESERVED_PARAMETERS.add(NODE_NAME);
        RESERVED_PARAMETERS.add(NODE_NAME_PROPERTY);
        RESERVED_PARAMETERS.add(NEW_NODE_OUTPUT_FORMAT);
        RESERVED_PARAMETERS.add(REDIRECT_TO);
        RESERVED_PARAMETERS.add(METHOD_TO_CALL);
        RESERVED_PARAMETERS.add(AUTO_CHECKIN);
        RESERVED_PARAMETERS.add(CAPTCHA);
        RESERVED_PARAMETERS.add(TARGETDIRECTORY);
        RESERVED_PARAMETERS.add(TARGETNAME);
        RESERVED_PARAMETERS.add("jcr:mixinTypes");
        RESERVED_PARAMETERS.add(NORMALIZE_NODE_NAME);
        RESERVED_PARAMETERS.add(VERSION);
        RESERVED_PARAMETERS.add(SUBMIT);
        RESERVED_PARAMETERS.add(AUTO_ASSIGN_ROLE);
        RESERVED_PARAMETERS.add(PARENT_TYPE);
        RESERVED_PARAMETERS.add(RETURN_CONTENTTYPE);
        RESERVED_PARAMETERS.add(RETURN_CONTENTTYPE_OVERRIDE);
        RESERVED_PARAMETERS.add(COOKIE_NAME);
        RESERVED_PARAMETERS.add(COOKIE_VALUE);
        RESERVED_PARAMETERS.add(COOKIE_PATH);
        RESERVED_PARAMETERS.add(CONTRIBUTE_POST);
        RESERVED_PARAMETERS.add(MARK_FOR_DELETION);
        RESERVED_PARAMETERS.add(DISABLE_XSS_FILTERING);
        RESERVED_PARAMETERS.add(ALLOWS_MULTIPLE_SUBMITS);
        logger = LoggerFactory.getLogger(Render.class);
    }
}

