/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.utils;

import java.net.MalformedURLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.jahia.exceptions.JahiaRuntimeException;
import org.jahia.services.templates.JahiaTemplateManagerService;
import org.springframework.context.ApplicationListener;
import org.springframework.web.context.ServletContextAware;

public class GWTResourceConfig
implements ApplicationListener<JahiaTemplateManagerService.TemplatePackageRedeployedEvent>,
ServletContextAware {
    private List<String> cssStyles = Collections.emptyList();
    private List<String> cssStylesForFrame = Collections.emptyList();
    private boolean detectCustomCKEditorConfig = true;
    private List<String> javaScripts = Collections.emptyList();
    private Map<String, Map<String, Boolean>> lookupCache = new HashMap<String, Map<String, Boolean>>();
    private ServletContext servletContext;

    public boolean exists(String templateSetFolder, String resource) {
        Boolean value;
        boolean found = false;
        Map<String, Boolean> templateSetLookups = this.lookupCache.get(templateSetFolder);
        if (templateSetLookups == null) {
            templateSetLookups = new HashMap<String, Boolean>();
            this.lookupCache.put(templateSetFolder, templateSetLookups);
        }
        if ((value = templateSetLookups.get(resource)) == null) {
            try {
                found = this.servletContext.getResource("/modules/" + templateSetFolder + resource) != null;
                templateSetLookups.put(resource, found);
            }
            catch (MalformedURLException e) {
                throw new JahiaRuntimeException(e);
            }
        } else {
            found = value;
        }
        return found;
    }

    public List<String> getCssStyles() {
        return this.cssStyles;
    }

    public List<String> getCssStylesForFrame() {
        return this.cssStylesForFrame;
    }

    public List<String> getJavaScripts() {
        return this.javaScripts;
    }

    public boolean isDetectCustomCKEditorConfig() {
        return this.detectCustomCKEditorConfig;
    }

    public void onApplicationEvent(JahiaTemplateManagerService.TemplatePackageRedeployedEvent event) {
        this.lookupCache.clear();
    }

    public void setCssStyles(List<String> cssStyles) {
        this.cssStyles = cssStyles;
    }

    public void setCssStylesForFrame(List<String> cssStylesForFrame) {
        this.cssStylesForFrame = cssStylesForFrame;
    }

    public void setDetectCustomCKEditorConfig(boolean detectCKEditorResources) {
        this.detectCustomCKEditorConfig = detectCKEditorResources;
    }

    public void setJavaScripts(List<String> javaScripts) {
        this.javaScripts = javaScripts;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }
}

