/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFactory;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeProperty;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodePropertyValue;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.workflow.GWTJahiaWorkflow;
import org.jahia.ajax.gwt.client.data.workflow.GWTJahiaWorkflowComment;
import org.jahia.ajax.gwt.client.data.workflow.GWTJahiaWorkflowDefinition;
import org.jahia.ajax.gwt.client.data.workflow.GWTJahiaWorkflowInfo;
import org.jahia.ajax.gwt.client.data.workflow.GWTJahiaWorkflowOutcome;
import org.jahia.ajax.gwt.client.data.workflow.GWTJahiaWorkflowTask;
import org.jahia.ajax.gwt.client.data.workflow.GWTJahiaWorkflowType;
import org.jahia.ajax.gwt.client.data.workflow.history.GWTJahiaWorkflowHistoryItem;
import org.jahia.ajax.gwt.client.data.workflow.history.GWTJahiaWorkflowHistoryProcess;
import org.jahia.ajax.gwt.client.data.workflow.history.GWTJahiaWorkflowHistoryTask;
import org.jahia.ajax.gwt.client.service.GWTJahiaServiceException;
import org.jahia.ajax.gwt.client.widget.poller.TaskEvent;
import org.jahia.ajax.gwt.client.widget.workflow.CustomWorkflow;
import org.jahia.ajax.gwt.commons.server.ChannelHolder;
import org.jahia.ajax.gwt.commons.server.JGroupsChannel;
import org.jahia.ajax.gwt.helper.NavigationHelper;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.atmosphere.AtmosphereServlet;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPublicationService;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.decorator.JCRGroupNode;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.preferences.user.UserPreferencesHelper;
import org.jahia.services.usermanager.JahiaGroup;
import org.jahia.services.usermanager.JahiaGroupManagerService;
import org.jahia.services.usermanager.JahiaPrincipal;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.services.workflow.HistoryWorkflow;
import org.jahia.services.workflow.HistoryWorkflowTask;
import org.jahia.services.workflow.Workflow;
import org.jahia.services.workflow.WorkflowAction;
import org.jahia.services.workflow.WorkflowComment;
import org.jahia.services.workflow.WorkflowDefinition;
import org.jahia.services.workflow.WorkflowListener;
import org.jahia.services.workflow.WorkflowParticipation;
import org.jahia.services.workflow.WorkflowRule;
import org.jahia.services.workflow.WorkflowService;
import org.jahia.services.workflow.WorkflowTask;
import org.jahia.services.workflow.WorkflowVariable;
import org.jahia.utils.LanguageCodeConverters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowHelper {
    private static final transient Logger logger = LoggerFactory.getLogger(WorkflowHelper.class);
    private WorkflowService service;
    private JahiaUserManagerService userManagerService;
    private JahiaGroupManagerService groupManagerService;

    public void start() {
        this.service.addWorkflowListener(new PollingWorkflowListener());
    }

    public GWTJahiaWorkflowInfo getWorkflowInfo(String path, boolean includeActiveWorfklows, JCRSessionWrapper session, Locale locale, Locale uiLocale) throws GWTJahiaServiceException {
        try {
            GWTJahiaWorkflowInfo info = new GWTJahiaWorkflowInfo();
            HashMap<GWTJahiaWorkflowType, GWTJahiaWorkflowDefinition> gwtWorkflowDefinitions = new HashMap<GWTJahiaWorkflowType, GWTJahiaWorkflowDefinition>();
            info.setPossibleWorkflows(gwtWorkflowDefinitions);
            JCRNodeWrapper node = session.getNode(path);
            Map<String, WorkflowDefinition> wfs = this.service.getPossibleWorkflows(node, true, locale);
            for (Map.Entry<String, WorkflowDefinition> entry : wfs.entrySet()) {
                gwtWorkflowDefinitions.put(this.getGWTJahiaWorkflowType(entry.getKey()), this.getGWTJahiaWorkflowDefinition(entry.getValue()));
            }
            HashMap<GWTJahiaWorkflowType, GWTJahiaWorkflow> gwtWorkflows = new HashMap<GWTJahiaWorkflowType, GWTJahiaWorkflow>();
            info.setActiveWorkflows(gwtWorkflows);
            if (includeActiveWorfklows) {
                List<Workflow> actives = this.service.getActiveWorkflows(node, locale, uiLocale);
                for (Workflow workflow : actives) {
                    GWTJahiaWorkflow gwtWf = this.getGWTJahiaWorkflow(workflow);
                    gwtWorkflows.put(this.getGWTJahiaWorkflowType(this.service.getWorkflowType(workflow.getWorkflowDefinition())), gwtWf);
                    block4: for (WorkflowAction workflowAction : workflow.getAvailableActions()) {
                        WorkflowTask workflowTask;
                        List<WorkflowParticipation> participations;
                        if (!(workflowAction instanceof WorkflowTask) || (participations = (workflowTask = (WorkflowTask)workflowAction).getParticipations()) == null) continue;
                        for (WorkflowParticipation participation : participations) {
                            JahiaPrincipal principal = participation.getJahiaPrincipal();
                            if (principal instanceof JahiaGroup) {
                                JCRGroupNode groupNode = this.groupManagerService.lookupGroupByPath(principal.getLocalPath());
                                JCRUserNode userNode = this.userManagerService.lookupUserByPath(session.getUser().getLocalPath());
                                if (groupNode != null && userNode != null && groupNode.isMember(userNode)) {
                                    gwtWf.getAvailableTasks().add(this.getGWTJahiaWorkflowTask(workflowTask));
                                    continue block4;
                                }
                            }
                            if (!(principal instanceof JahiaUser) || !principal.getLocalPath().equals(session.getUser().getLocalPath())) continue;
                            gwtWf.getAvailableTasks().add(this.getGWTJahiaWorkflowTask(workflowTask));
                            continue block4;
                        }
                    }
                }
            }
            return info;
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new GWTJahiaServiceException("Cannot get workflow info for " + path + ". Cause: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public GWTJahiaWorkflow getGWTJahiaWorkflow(Workflow wf) {
        GWTJahiaWorkflow gwtWf = new GWTJahiaWorkflow();
        gwtWf.setId(wf.getId());
        gwtWf.setProvider(wf.getProvider());
        gwtWf.setDefinition(this.getGWTJahiaWorkflowDefinition(wf.getWorkflowDefinition()));
        gwtWf.setAvailableTasks(new ArrayList());
        Map<String, Object> map = wf.getVariables();
        gwtWf.setStartTime(wf.getStartTime());
        gwtWf.setVariables(this.getPropertiesMap(map));
        if (map.get("customWorkflowInfo") != null) {
            gwtWf.setCustomWorkflowInfo((CustomWorkflow)map.get("customWorkflowInfo"));
        }
        gwtWf.setLocale(map.get("locale").toString());
        gwtWf.setWorkspace(map.get("workspace").toString());
        if (wf.getDuedate() != null) {
            gwtWf.setDuedate(wf.getDuedate());
        }
        return gwtWf;
    }

    public GWTJahiaWorkflowTask getGWTJahiaWorkflowTask(WorkflowTask workflowTask) {
        GWTJahiaWorkflowTask task = new GWTJahiaWorkflowTask();
        ArrayList<GWTJahiaWorkflowOutcome> gwtOutcomes = new ArrayList<GWTJahiaWorkflowOutcome>();
        task.setProvider(workflowTask.getProvider());
        task.setOutcomes(gwtOutcomes);
        task.setName(workflowTask.getName());
        task.setDisplayName(workflowTask.getDisplayName());
        task.setId(workflowTask.getId());
        task.setFormResourceName(workflowTask.getFormResourceName());
        task.setCreateTime(workflowTask.getCreateTime());
        task.setProcessId(workflowTask.getProcessId());
        Set<String> outcomes = workflowTask.getOutcomes();
        List<String> display = workflowTask.getDisplayOutcomes();
        List<String> icons = workflowTask.getOutcomeIcons();
        int i = 0;
        for (String outcome : outcomes) {
            GWTJahiaWorkflowOutcome gwtOutcome = new GWTJahiaWorkflowOutcome();
            gwtOutcome.setName(outcome);
            gwtOutcome.setLabel(display.get(i));
            gwtOutcome.setIcon(icons.get(i));
            ++i;
            gwtOutcomes.add(gwtOutcome);
        }
        task.setVariables(this.getPropertiesMap(workflowTask.getVariables()));
        return task;
    }

    private GWTJahiaWorkflowHistoryProcess getGWTJahiaHistoryProcess(HistoryWorkflow wf) {
        return new GWTJahiaWorkflowHistoryProcess(wf.getName(), wf.getDisplayName(), wf.getProcessId(), wf.getProvider(), wf.getWorkflowDefinition().getKey(), wf.isCompleted(), wf.getStartTime(), wf.getEndTime(), wf.getDuration(), this.getUsername(wf.getUser()), wf.getNodeId());
    }

    public GWTJahiaWorkflowDefinition getGWTJahiaWorkflowDefinition(String key, Locale uiLocale) {
        return this.getGWTJahiaWorkflowDefinition(this.service.getWorkflowDefinition(StringUtils.substringBefore((String)key, (String)":"), StringUtils.substringAfter((String)key, (String)":"), uiLocale));
    }

    public GWTJahiaWorkflowDefinition getGWTJahiaWorkflowDefinition(WorkflowDefinition workflow) {
        GWTJahiaWorkflowDefinition w = new GWTJahiaWorkflowDefinition();
        w.setProvider(workflow.getProvider());
        w.setName(workflow.getName());
        w.setId(workflow.getKey());
        w.setFormResourceName(workflow.getFormResourceName());
        w.setDisplayName(workflow.getDisplayName());
        return w;
    }

    public void startWorkflow(String path, GWTJahiaWorkflowDefinition def, JCRSessionWrapper session, List<GWTJahiaNodeProperty> properties, List<String> comments) throws GWTJahiaServiceException {
        try {
            JCRNodeWrapper node = session.getNode(path);
            Map<String, Object> map = this.getVariablesMap(properties);
            this.service.startProcessAsJob(Arrays.asList(node.getIdentifier()), session, def.getId(), def.getProvider(), map, comments);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new GWTJahiaServiceException("Cannot start workflow " + path + ". Cause: " + e.getLocalizedMessage());
        }
    }

    public void startWorkflow(List<String> uuids, GWTJahiaWorkflowDefinition def, JCRSessionWrapper session, List<GWTJahiaNodeProperty> properties, List<String> comments, Map<String, Object> args) throws GWTJahiaServiceException {
        try {
            Map<String, Object> map = this.getVariablesMap(properties);
            map.putAll(args);
            this.service.startProcessAsJob(uuids, session, def.getId(), def.getProvider(), map, comments);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new GWTJahiaServiceException("Cannot start workflows " + uuids + ". Cause: " + e.getLocalizedMessage());
        }
    }

    public void abortWorkflow(String processId, String provider) {
        try {
            Workflow w = this.service.getWorkflow(provider, processId, null);
            if (w != null && w.getWorkflowDefinition().getWorkflowType().equals("publish")) {
                List info = (List)w.getVariables().get("nodeIds");
                String workspace = (String)w.getVariables().get("workspace");
                JCRPublicationService.getInstance().unlockForPublication(info, workspace, "publication-process-" + processId);
            }
        }
        catch (Exception e) {
            logger.error("Cannot clear workflow locks", (Throwable)e);
        }
        this.service.abortProcess(processId, provider);
    }

    public void assignAndCompleteTask(GWTJahiaWorkflowTask task, GWTJahiaWorkflowOutcome outcome, JCRSessionWrapper session, List<GWTJahiaNodeProperty> properties) throws GWTJahiaServiceException {
        try {
            Map<String, Object> map = this.getVariablesMap(properties);
            this.service.assignAndCompleteTask(task.getId(), task.getProvider(), outcome.getName(), map, session.getUser());
        }
        catch (Exception e) {
            logger.error("Exception in task", (Throwable)e);
            throw new GWTJahiaServiceException("Cannot assign and complete task " + task.getName() + ". Cause: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private Map<String, GWTJahiaNodeProperty> getPropertiesMap(Map<String, Object> variables) {
        HashMap<String, GWTJahiaNodeProperty> properties = new HashMap<String, GWTJahiaNodeProperty>(variables.size());
        for (Map.Entry<String, Object> entry : variables.entrySet()) {
            GWTJahiaNodeProperty property = new GWTJahiaNodeProperty();
            property.setName(entry.getKey());
            Object variable = entry.getValue();
            if (variable instanceof List) {
                List list = (List)variable;
                ArrayList<GWTJahiaNodePropertyValue> values = new ArrayList<GWTJahiaNodePropertyValue>();
                for (Object o : list) {
                    if (!(o instanceof WorkflowVariable)) continue;
                    values.add(new GWTJahiaNodePropertyValue(((WorkflowVariable)o).getValue(), ((WorkflowVariable)o).getType()));
                }
                if (values.isEmpty()) continue;
                property.setValues(values);
                properties.put(entry.getKey(), property);
                continue;
            }
            if (!(variable instanceof WorkflowVariable)) continue;
            property.setValue(new GWTJahiaNodePropertyValue(((WorkflowVariable)variable).getValue(), ((WorkflowVariable)variable).getType()));
            properties.put(entry.getKey(), property);
        }
        return properties;
    }

    private Map<String, Object> getVariablesMap(List<GWTJahiaNodeProperty> properties) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (GWTJahiaNodeProperty property : properties) {
            GWTJahiaNodePropertyValue value;
            String s;
            List propertyValues = property.getValues();
            if (property.isMultiple()) {
                ArrayList<WorkflowVariable> values = new ArrayList<WorkflowVariable>();
                for (GWTJahiaNodePropertyValue value2 : propertyValues) {
                    String s2 = value2.getString();
                    if (!StringUtils.isNotBlank((String)s2)) continue;
                    values.add(new WorkflowVariable(s2, value2.getType()));
                }
                map.put(property.getName(), values);
                continue;
            }
            if (propertyValues.isEmpty() || !StringUtils.isNotBlank((String)(s = (value = (GWTJahiaNodePropertyValue)propertyValues.get(0)).getString()))) continue;
            map.put(property.getName(), new WorkflowVariable(s, value.getType()));
        }
        return map;
    }

    public void addCommentToWorkflow(GWTJahiaWorkflow workflow, JahiaUser user, String comment, Locale locale) {
        this.service.addComment(workflow.getId(), workflow.getProvider(), comment, user.getUserKey());
    }

    public List<GWTJahiaWorkflowComment> getWorkflowComments(GWTJahiaWorkflow workflow, Locale locale) {
        Workflow wf = this.service.getWorkflow(workflow.getProvider(), workflow.getId(), locale);
        ArrayList<GWTJahiaWorkflowComment> gwtComments = new ArrayList<GWTJahiaWorkflowComment>();
        if (wf == null) {
            return gwtComments;
        }
        List<WorkflowComment> comments = wf.getComments();
        if (comments == null) {
            return gwtComments;
        }
        for (WorkflowComment comment : comments) {
            GWTJahiaWorkflowComment workflowComment = new GWTJahiaWorkflowComment();
            workflowComment.setComment(comment.getComment());
            workflowComment.setTime(comment.getTime());
            JCRUserNode userNode = this.userManagerService.lookupUserByPath(comment.getUser());
            if (userNode != null) {
                workflowComment.setUser(userNode.getName());
            } else {
                workflowComment.setUser(comment.getUser());
            }
            gwtComments.add(workflowComment);
        }
        return gwtComments;
    }

    public List<GWTJahiaWorkflowHistoryItem> getWorkflowHistoryProcesses(String nodeId, JCRSessionWrapper session, Locale uiLocale) throws GWTJahiaServiceException {
        ArrayList<GWTJahiaWorkflowHistoryItem> history = new ArrayList<GWTJahiaWorkflowHistoryItem>();
        try {
            List<HistoryWorkflow> workflows = this.service.getHistoryWorkflows(session.getNodeByIdentifier(nodeId), uiLocale);
            for (HistoryWorkflow wf : workflows) {
                history.add((GWTJahiaWorkflowHistoryItem)this.getGWTJahiaHistoryProcess(wf));
            }
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new GWTJahiaServiceException("Cannot get workflow history. Cause: " + e.getLocalizedMessage(), (Throwable)e);
        }
        return history;
    }

    private String getUsername(String userPath) {
        return StringUtils.substringAfterLast((String)userPath, (String)"/");
    }

    public List<GWTJahiaWorkflowHistoryItem> getWorkflowHistoryTasks(String provider, String processId, Locale uiLocale) throws GWTJahiaServiceException {
        ArrayList<GWTJahiaWorkflowHistoryItem> history = new ArrayList<GWTJahiaWorkflowHistoryItem>();
        List<HistoryWorkflowTask> tasks = this.service.getHistoryWorkflowTasks(processId, provider, uiLocale);
        for (HistoryWorkflowTask wfTask : tasks) {
            history.add((GWTJahiaWorkflowHistoryItem)new GWTJahiaWorkflowHistoryTask(wfTask.getActionId(), wfTask.getName(), wfTask.getDisplayName() + (wfTask.getDisplayOutcome() != null ? " : " + wfTask.getDisplayOutcome() : ""), wfTask.getProcessId(), wfTask.getProvider(), wfTask.isCompleted(), wfTask.getStartTime(), wfTask.getEndTime(), wfTask.getDuration(), wfTask.getOutcome(), this.getUsername(wfTask.getUser())));
        }
        return history;
    }

    public List<GWTJahiaWorkflowHistoryItem> getWorkflowHistoryForUser(JahiaUser user, Locale locale, Locale uiLocale) throws GWTJahiaServiceException {
        ArrayList<GWTJahiaWorkflowHistoryItem> gwtWorkflows = new ArrayList<GWTJahiaWorkflowHistoryItem>();
        HashMap<String, GWTJahiaWorkflowHistoryProcess> gwtWorkflowsMap = new HashMap<String, GWTJahiaWorkflowHistoryProcess>();
        List<WorkflowTask> tasks = this.service.getTasksForUser(user, uiLocale);
        for (WorkflowTask task : tasks) {
            GWTJahiaWorkflowHistoryProcess gwtWfHistory = (GWTJahiaWorkflowHistoryProcess)gwtWorkflowsMap.get(task.getProcessId());
            HistoryWorkflow historyWorkflow = this.service.getHistoryWorkflow(task.getProcessId(), task.getProvider(), uiLocale);
            if (historyWorkflow == null) continue;
            if (gwtWfHistory == null) {
                List<String> nodeIds;
                gwtWfHistory = this.getGWTJahiaHistoryProcess(historyWorkflow);
                gwtWfHistory.setAvailableTasks(new ArrayList());
                gwtWorkflowsMap.put(task.getProcessId(), gwtWfHistory);
                Workflow wf = this.service.getWorkflow(gwtWfHistory.getProvider(), gwtWfHistory.getProcessId(), uiLocale);
                if (wf != null) {
                    gwtWfHistory.setRunningWorkflow(this.getGWTJahiaWorkflow(wf));
                    nodeIds = (List<String>)wf.getVariables().get("nodeIds");
                    if (nodeIds == null) {
                        nodeIds = Collections.singletonList((String)wf.getVariables().get("nodeId"));
                    }
                } else {
                    nodeIds = Collections.singletonList(gwtWfHistory.getNodeId());
                }
                for (String nodeId : nodeIds) {
                    try {
                        Locale wflocale = locale;
                        if (wf != null && wf.getVariables().get("locale") != null) {
                            wflocale = (Locale)wf.getVariables().get("locale");
                        }
                        JCRNodeWrapper nodeWrapper = JCRSessionFactory.getInstance().getCurrentUserSession(null, wflocale).getNodeByIdentifier(nodeId);
                        gwtWfHistory.set("nodeWrapper", (Object)((NavigationHelper)SpringContextSingleton.getInstance().getContext().getBeansOfType(NavigationHelper.class).values().iterator().next()).getGWTJahiaNode(nodeWrapper));
                        gwtWorkflows.add((GWTJahiaWorkflowHistoryItem)gwtWfHistory);
                        break;
                    }
                    catch (ItemNotFoundException e) {
                    }
                    catch (RepositoryException e) {
                        logger.warn(e.getMessage(), (Throwable)e);
                    }
                }
            }
            gwtWfHistory.getAvailableTasks().add(this.getGWTJahiaWorkflowTask(task));
        }
        List<Workflow> workflows = this.service.getWorkflowsForUser(user, uiLocale);
        for (Workflow wf : workflows) {
            GWTJahiaWorkflowHistoryProcess gwtWfHistory = (GWTJahiaWorkflowHistoryProcess)gwtWorkflowsMap.get(wf.getId());
            if (gwtWfHistory != null) continue;
            gwtWfHistory = this.getGWTJahiaHistoryProcess(this.service.getHistoryWorkflow(wf.getId(), wf.getProvider(), uiLocale));
            try {
                JCRNodeWrapper nodeWrapper = JCRSessionFactory.getInstance().getCurrentUserSession("default", locale).getNodeByIdentifier(gwtWfHistory.getNodeId());
                gwtWfHistory.set("nodeWrapper", (Object)((NavigationHelper)SpringContextSingleton.getInstance().getContext().getBeansOfType(NavigationHelper.class).values().iterator().next()).getGWTJahiaNode(nodeWrapper));
            }
            catch (RepositoryException e) {
                logger.warn(e.getMessage(), (Throwable)e);
                continue;
            }
            gwtWorkflowsMap.put(wf.getId(), gwtWfHistory);
            gwtWorkflows.add((GWTJahiaWorkflowHistoryItem)gwtWfHistory);
            gwtWfHistory.setRunningWorkflow(this.getGWTJahiaWorkflow(wf));
            gwtWfHistory.setAvailableTasks(new ArrayList());
        }
        return gwtWorkflows;
    }

    public Map<GWTJahiaWorkflowType, List<GWTJahiaWorkflowDefinition>> getWorkflowRules(String path, JCRSessionWrapper session, Locale uiLocale) throws GWTJahiaServiceException {
        try {
            HashMap<String, String> rev = new HashMap<String, String>();
            HashMap<GWTJahiaWorkflowType, List<GWTJahiaWorkflowDefinition>> result = new HashMap<GWTJahiaWorkflowType, List<GWTJahiaWorkflowDefinition>>();
            HashMap keyToMap = new HashMap();
            Set<String> workflowTypes = this.service.getTypesOfWorkflow();
            for (String workflowType : workflowTypes) {
                ArrayList<GWTJahiaWorkflowDefinition> definitions = new ArrayList<GWTJahiaWorkflowDefinition>();
                List<WorkflowDefinition> workflowDefinitions = this.service.getWorkflowDefinitionsForType(workflowType, uiLocale);
                for (WorkflowDefinition definition : workflowDefinitions) {
                    GWTJahiaWorkflowDefinition workflowDefinition = this.getGWTJahiaWorkflowDefinition(definition);
                    definitions.add(workflowDefinition);
                    rev.put(definition.getKey(), workflowType);
                }
                GWTJahiaWorkflowType t = this.getGWTJahiaWorkflowType(workflowType);
                result.put(t, definitions);
                keyToMap.put(workflowType, definitions);
            }
            JCRNodeWrapper node = session.getNode(path);
            Collection<WorkflowRule> map = this.service.getWorkflowRules(node);
            for (WorkflowRule rule : map) {
                try {
                    WorkflowDefinition definition = this.service.getWorkflowDefinition(rule.getProviderKey(), rule.getWorkflowDefinitionKey(), uiLocale);
                    if (definition != null) {
                        GWTJahiaWorkflowDefinition workflowDefinition = this.getGWTJahiaWorkflowDefinition(definition);
                        workflowDefinition.set("active", (Object)Boolean.TRUE);
                        workflowDefinition.set("definitionPath", (Object)rule.getDefinitionPath());
                        workflowDefinition.set("workflowRootPath", (Object)rule.getWorkflowRootPath());
                        ((List)keyToMap.get(rev.get(definition.getKey()))).remove(workflowDefinition);
                        ((List)keyToMap.get(rev.get(definition.getKey()))).add(workflowDefinition);
                        continue;
                    }
                    logger.warn("Couldn't find definition for workflow " + rule.getWorkflowDefinitionKey());
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            return result;
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new GWTJahiaServiceException("Cannot get workflow rules for " + path + ". Cause: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private GWTJahiaWorkflowType getGWTJahiaWorkflowType(String workflowType) {
        GWTJahiaWorkflowType t = new GWTJahiaWorkflowType();
        t.setDisplayName(workflowType);
        t.setName(workflowType);
        return t;
    }

    public List<GWTJahiaWorkflowDefinition> getWorkflows(Locale locale) throws GWTJahiaServiceException {
        try {
            Set<String> workflowTypes = this.service.getTypesOfWorkflow();
            ArrayList<GWTJahiaWorkflowDefinition> definitions = new ArrayList<GWTJahiaWorkflowDefinition>();
            for (String workflowType : workflowTypes) {
                List<WorkflowDefinition> workflowDefinitions = this.service.getWorkflowDefinitionsForType(workflowType, locale);
                for (WorkflowDefinition definition : workflowDefinitions) {
                    definitions.add(this.getGWTJahiaWorkflowDefinition(definition));
                }
            }
            return definitions;
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new GWTJahiaServiceException("Cannot get workflows for " + locale + ". Cause: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void updateWorkflowRules(GWTJahiaNode gwtNode, Set<GWTJahiaWorkflowDefinition> actives, JCRSessionWrapper session) throws GWTJahiaServiceException {
        try {
            JCRNodeWrapper node = session.getNode(gwtNode.getPath());
            if (!node.isCheckedOut()) {
                session.checkout(node);
            }
            if (!actives.isEmpty()) {
                if (!node.isNodeType("jmix:workflowRulesable")) {
                    node.addMixin("jmix:workflowRulesable");
                }
                session.save();
            }
            if (node.hasNode("j:workflowRules")) {
                JCRNodeWrapper wfRulesNode = node.getNode("j:workflowRules");
                if (!wfRulesNode.isCheckedOut()) {
                    session.checkout(wfRulesNode);
                }
                HashSet<String> activeKeys = new HashSet<String>();
                for (GWTJahiaWorkflowDefinition definition : actives) {
                    JCRNodeWrapper wfRuleNode;
                    String defKey = definition.getProvider() + "_" + definition.getId();
                    activeKeys.add(defKey);
                    if (!wfRulesNode.hasNode(defKey)) {
                        wfRuleNode = wfRulesNode.addNode(defKey, "jnt:workflowRule");
                        wfRuleNode.setProperty("j:workflow", definition.getProvider() + ":" + definition.getId());
                        continue;
                    }
                    wfRuleNode = wfRulesNode.getNode(defKey);
                }
                if (actives == null || actives.isEmpty()) {
                    wfRulesNode.remove();
                    if (node.isNodeType("jmix:workflowRulesable")) {
                        node.removeMixin("jmix:workflowRulesable");
                    }
                } else {
                    JCRNodeIteratorWrapper ni = wfRulesNode.getNodes();
                    while (ni.hasNext()) {
                        JCRNodeWrapper rule = (JCRNodeWrapper)ni.next();
                        if (activeKeys.contains(rule.getName())) continue;
                        rule.remove();
                    }
                }
            }
            session.save();
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new GWTJahiaServiceException("Cannot update workflow rules. Cause: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public int getNumberOfTasksForUser(JahiaUser user) throws GWTJahiaServiceException {
        return this.getNumberOfTasksForUser(user, null);
    }

    private int getNumberOfTasksForUser(JahiaUser user, String excludedTaskId) throws GWTJahiaServiceException {
        int total = 0;
        List<WorkflowTask> tasks = this.service.getTasksForUser(user, null);
        block3: for (WorkflowTask task : tasks) {
            Workflow workflow;
            if (excludedTaskId != null && excludedTaskId.equals(task.getId()) || (workflow = this.service.getWorkflow(task.getProvider(), task.getProcessId(), null)) == null) continue;
            List<String> uuids = (List<String>)workflow.getVariables().get("nodeIds");
            if (uuids == null) {
                uuids = Collections.singletonList((String)workflow.getVariables().get("nodeId"));
            }
            for (String uuid : uuids) {
                try {
                    JCRSessionFactory.getInstance().getCurrentUserSession(null, null).getNodeByIdentifier(uuid);
                    ++total;
                    continue block3;
                }
                catch (ItemNotFoundException e) {
                }
                catch (RepositoryException e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                }
            }
        }
        return total;
    }

    public void setService(WorkflowService service) {
        this.service = service;
    }

    public void setUserManagerService(JahiaUserManagerService userManagerService) {
        this.userManagerService = userManagerService;
    }

    public void setGroupManagerService(JahiaGroupManagerService groupManagerService) {
        this.groupManagerService = groupManagerService;
    }

    class PollingWorkflowListener
    extends WorkflowListener {
        PollingWorkflowListener() {
        }

        @Override
        public void workflowEnded(HistoryWorkflow workflow) {
            JCRUserNode user = WorkflowHelper.this.userManagerService.lookupUserByPath(workflow.getUser());
            BroadcasterFactory broadcasterFactory = AtmosphereServlet.getBroadcasterFactory();
            Broadcaster broadcaster = broadcasterFactory.lookup((Object)("org.jahia.broadcaster" + user.getName()));
            if (broadcaster != null) {
                TaskEvent taskEvent = new TaskEvent();
                Locale preferredLocale = UserPreferencesHelper.getPreferredLocale(user);
                if (preferredLocale == null) {
                    preferredLocale = LanguageCodeConverters.languageCodeToLocale(ServicesRegistry.getInstance().getJahiaSitesService().getDefaultSite().getDefaultLanguage());
                }
                workflow = WorkflowHelper.this.service.getHistoryWorkflow(workflow.getProcessId(), workflow.getProvider(), preferredLocale);
                taskEvent.setEndedWorkflow(StringUtils.defaultString((String)workflow.getDisplayName(), (String)workflow.getName()));
                broadcaster.broadcast((Object)taskEvent);
            }
        }

        @Override
        public void taskEnded(WorkflowTask task) {
            this.update(task, false);
        }

        @Override
        public void newTaskCreated(WorkflowTask task) {
            this.update(task, true);
        }

        private void update(WorkflowTask task, boolean newTask) {
            BroadcasterFactory broadcasterFactory = AtmosphereServlet.getBroadcasterFactory();
            if (broadcasterFactory != null) {
                HashSet<JCRUserNode> users = new HashSet<JCRUserNode>();
                for (WorkflowParticipation workflowParticipation : task.getParticipations()) {
                    JCRGroupNode g;
                    JahiaPrincipal p = workflowParticipation.getJahiaPrincipal();
                    if (p instanceof JahiaUser) {
                        JCRUserNode u = WorkflowHelper.this.userManagerService.lookupUserByPath(p.getLocalPath());
                        if (u == null) continue;
                        users.add(u);
                        continue;
                    }
                    if (!(p instanceof JahiaGroup) || (g = WorkflowHelper.this.groupManagerService.lookupGroupByPath(p.getLocalPath())) == null) continue;
                    users.addAll(g.getRecursiveUserMembers());
                }
                for (JCRUserNode user : users) {
                    if (user == null) continue;
                    TaskEvent taskEvent = new TaskEvent();
                    try {
                        JahiaUser jahiaUser = user.getJahiaUser();
                        if (newTask) {
                            Locale preferredLocale = UserPreferencesHelper.getPreferredLocale(user);
                            if (preferredLocale == null) {
                                preferredLocale = LanguageCodeConverters.languageCodeToLocale(ServicesRegistry.getInstance().getJahiaSitesService().getDefaultSite().getDefaultLanguage());
                            }
                            task = WorkflowHelper.this.service.getWorkflowTask(task.getId(), task.getProvider(), preferredLocale);
                            taskEvent.setNewTask(StringUtils.defaultString((String)task.getDisplayName(), (String)task.getName()));
                        }
                        taskEvent.setNumberOfTasks(Integer.valueOf(WorkflowHelper.this.getNumberOfTasksForUser(jahiaUser, newTask ? null : task.getId())));
                        if (!newTask) {
                            taskEvent.setEndedTask(task.getId());
                        }
                    }
                    catch (GWTJahiaServiceException e) {
                        logger.debug(e.getMessage(), (Throwable)e);
                    }
                    Broadcaster broadcaster = broadcasterFactory.lookup((Object)("org.jahia.broadcaster" + user.getName()));
                    if (broadcaster != null) {
                        broadcaster.broadcast((Object)taskEvent);
                        continue;
                    }
                    try {
                        ChannelHolder bean = (ChannelHolder)SpringContextSingleton.getBean("org.jahia.ajax.gwt.commons.server.ChannelHolderImpl");
                        JGroupsChannel jc = bean.getChannel();
                        if (jc == null) continue;
                        jc.send("org.jahia.broadcaster" + user.getName(), taskEvent);
                    }
                    catch (Exception e) {
                        logger.debug(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }
}

