/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.helper;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.jcr.RepositoryException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang.StringUtils;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeProperty;
import org.jahia.ajax.gwt.client.data.publication.GWTJahiaPublicationInfo;
import org.jahia.ajax.gwt.client.service.GWTJahiaServiceException;
import org.jahia.ajax.gwt.client.widget.publication.PublicationWorkflow;
import org.jahia.ajax.gwt.helper.WorkflowHelper;
import org.jahia.bin.Render;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPublicationService;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.PublicationInfo;
import org.jahia.services.content.PublicationInfoNode;
import org.jahia.services.content.PublicationJob;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.notification.HttpClientService;
import org.jahia.services.scheduler.BackgroundJob;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.workflow.WorkflowDefinition;
import org.jahia.services.workflow.WorkflowRule;
import org.jahia.services.workflow.WorkflowService;
import org.jahia.utils.i18n.Messages;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublicationHelper {
    private static Logger logger = LoggerFactory.getLogger(PublicationHelper.class);
    private JCRPublicationService publicationService;
    private WorkflowHelper workflowHelper;
    private WorkflowService workflowService;
    private HttpClientService httpClientService;

    public void setPublicationService(JCRPublicationService publicationService) {
        this.publicationService = publicationService;
    }

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    public WorkflowHelper getWorkflowHelper() {
        return this.workflowHelper;
    }

    public void setWorkflowHelper(WorkflowHelper workflowHelper) {
        this.workflowHelper = workflowHelper;
    }

    public Map<String, GWTJahiaPublicationInfo> getAggregatedPublicationInfosByLanguage(JCRNodeWrapper node, Set<String> languages, JCRSessionWrapper currentUserSession, boolean includesReferences, boolean includesSubnodes) throws GWTJahiaServiceException {
        try {
            HashMap<String, GWTJahiaPublicationInfo> infos = new HashMap<String, GWTJahiaPublicationInfo>(languages.size());
            for (String language : languages) {
                String langNodeName;
                JCRSessionWrapper unlocalizedSession;
                JCRNodeWrapper nodeByIdentifier;
                PublicationInfo pubInfo = this.publicationService.getPublicationInfo(node.getIdentifier(), Collections.singleton(language), includesReferences, includesSubnodes, false, currentUserSession.getWorkspace().getName(), "live").get(0);
                if (!includesSubnodes && (nodeByIdentifier = (unlocalizedSession = JCRSessionFactory.getInstance().getCurrentUserSession()).getNodeByIdentifier(node.getIdentifier())).hasNode(langNodeName = "j:translation_" + language)) {
                    JCRNodeWrapper next = nodeByIdentifier.getNode(langNodeName);
                    PublicationInfo translationInfo = this.publicationService.getPublicationInfo(next.getIdentifier(), Collections.singleton(language), includesReferences, false, false, currentUserSession.getWorkspace().getName(), "live").get(0);
                    pubInfo.getRoot().addChild(translationInfo.getRoot());
                }
                GWTJahiaPublicationInfo gwtInfo = new GWTJahiaPublicationInfo(pubInfo.getRoot().getUuid(), pubInfo.getRoot().getStatus());
                String translationNodeName = pubInfo.getRoot().getChildren().size() > 0 ? "/j:translation_" + language : null;
                for (PublicationInfoNode sub : pubInfo.getRoot().getChildren()) {
                    if (!sub.getPath().contains(translationNodeName)) continue;
                    if (sub.getStatus() > gwtInfo.getStatus()) {
                        gwtInfo.setStatus(Integer.valueOf(sub.getStatus()));
                    }
                    if (gwtInfo.getStatus() == 5 && sub.getStatus() != 5) {
                        gwtInfo.setStatus(Integer.valueOf(sub.getStatus()));
                    }
                    if (sub.isLocked()) {
                        gwtInfo.setLocked(Boolean.valueOf(true));
                    }
                    if (!sub.isWorkInProgress()) continue;
                    gwtInfo.setWorkInProgress(Boolean.valueOf(true));
                }
                gwtInfo.setIsAllowedToPublishWithoutWorkflow(Boolean.valueOf(node.hasPermission("publish")));
                gwtInfo.setIsNonRootMarkedForDeletion(Boolean.valueOf(gwtInfo.getStatus() == 12 && !node.isNodeType("jmix:markedForDeletionRoot")));
                if (gwtInfo.getStatus() == 1) {
                    boolean overrideStatus;
                    Set<Integer> status = pubInfo.getTreeStatus(language);
                    boolean bl = overrideStatus = !status.isEmpty() && Collections.max(status) > 1;
                    if (!overrideStatus) {
                        for (PublicationInfo refInfo : pubInfo.getAllReferences()) {
                            status = refInfo.getTreeStatus(language);
                            if (status.isEmpty() || Collections.max(status) <= 1) continue;
                            overrideStatus = true;
                            break;
                        }
                    }
                    if (overrideStatus) {
                        gwtInfo.setStatus(Integer.valueOf(3));
                    }
                }
                infos.put(language, gwtInfo);
            }
            return infos;
        }
        catch (RepositoryException e) {
            logger.error("repository exception", (Throwable)e);
            throw new GWTJahiaServiceException("Cannot get publication status for node " + node.getPath() + ". Cause: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public Map<String, List<GWTJahiaPublicationInfo>> getFullPublicationInfosByLanguage(List<String> uuids, Set<String> languages, JCRSessionWrapper currentUserSession, boolean allSubTree) throws GWTJahiaServiceException {
        List<GWTJahiaPublicationInfo> all = this.getFullPublicationInfos(uuids, languages, currentUserSession, allSubTree, false);
        HashMap<String, List<GWTJahiaPublicationInfo>> res = new HashMap<String, List<GWTJahiaPublicationInfo>>();
        for (GWTJahiaPublicationInfo info : all) {
            if (!res.containsKey(info.getLanguage())) {
                res.put(info.getLanguage(), new ArrayList());
            }
            ((List)res.get(info.getLanguage())).add(info);
        }
        return res;
    }

    public List<GWTJahiaPublicationInfo> getFullPublicationInfos(List<String> uuids, Set<String> languages, JCRSessionWrapper currentUserSession, boolean allSubTree, boolean checkForUnpublication) throws GWTJahiaServiceException {
        try {
            if (!checkForUnpublication) {
                LinkedHashMap<String, GWTJahiaPublicationInfo> res = new LinkedHashMap<String, GWTJahiaPublicationInfo>();
                for (String language : languages) {
                    List<PublicationInfo> infos = this.publicationService.getPublicationInfos(uuids, Collections.singleton(language), true, true, allSubTree, currentUserSession.getWorkspace().getName(), "live");
                    for (PublicationInfo info : infos) {
                        info.clearInternalAndPublishedReferences(uuids);
                    }
                    List<GWTJahiaPublicationInfo> infoList = this.convert(infos, currentUserSession, language, "publish");
                    String lastGroup = null;
                    String lastTitle = null;
                    Locale l = new Locale(language);
                    for (GWTJahiaPublicationInfo info : infoList) {
                        if (!info.isPublishable() && info.getStatus() != 6 || info.getWorkflowDefinition() == null && !info.isAllowedToPublishWithoutWorkflow().booleanValue()) continue;
                        res.put(language + "/" + info.getUuid(), info);
                        if (lastGroup == null || !info.getWorkflowGroup().equals(lastGroup)) {
                            lastGroup = info.getWorkflowGroup();
                            lastTitle = info.getTitle() + " ( " + l.getDisplayName(l) + " )";
                        }
                        info.setWorkflowTitle(lastTitle);
                    }
                }
                return new ArrayList<GWTJahiaPublicationInfo>(res.values());
            }
            List<PublicationInfo> infos = this.publicationService.getPublicationInfos(uuids, null, false, true, allSubTree, currentUserSession.getWorkspace().getName(), "live");
            LinkedHashMap<String, GWTJahiaPublicationInfo> res = new LinkedHashMap<String, GWTJahiaPublicationInfo>();
            for (String language : languages) {
                List<GWTJahiaPublicationInfo> infoList = this.convert(infos, currentUserSession, language, "unpublish");
                String lastGroup = null;
                String lastTitle = null;
                Locale l = new Locale(language);
                for (GWTJahiaPublicationInfo info : infoList) {
                    if (info.getStatus() != 1 || info.getWorkflowDefinition() == null && !info.isAllowedToPublishWithoutWorkflow().booleanValue()) continue;
                    res.put(language + "/" + info.getUuid(), info);
                    if (lastGroup == null || !info.getWorkflowGroup().equals(lastGroup)) {
                        lastGroup = info.getWorkflowGroup();
                        lastTitle = info.getTitle() + " ( " + l.getDisplayName(l) + " )";
                    }
                    info.setWorkflowTitle(lastTitle);
                }
            }
            for (PublicationInfo info : infos) {
                Set<String> publishedLanguages = info.getAllPublishedLanguages();
                if (languages.containsAll(publishedLanguages)) continue;
                this.keepOnlyTranslation(res);
            }
            return new ArrayList<GWTJahiaPublicationInfo>(res.values());
        }
        catch (RepositoryException e) {
            logger.error("repository exception", (Throwable)e);
            throw new GWTJahiaServiceException("Cannot get publication status for nodes " + uuids + ". Cause: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void keepOnlyTranslation(LinkedHashMap<String, GWTJahiaPublicationInfo> all) throws RepositoryException {
        HashSet<String> keys = new HashSet<String>(all.keySet());
        for (String key : keys) {
            GWTJahiaPublicationInfo gwtinfo = all.get(key);
            if (gwtinfo.getI18nUuid() == null) {
                all.remove(key);
                continue;
            }
            gwtinfo.remove("uuid");
        }
    }

    private List<GWTJahiaPublicationInfo> convert(List<PublicationInfo> pubInfos, JCRSessionWrapper currentUserSession, String language, String workflowAction) throws RepositoryException {
        ArrayList<GWTJahiaPublicationInfo> gwtInfos = new ArrayList<GWTJahiaPublicationInfo>();
        ArrayList<String> mainPaths = new ArrayList<String>();
        for (PublicationInfo pubInfo : pubInfos) {
            Collection<GWTJahiaPublicationInfo> infoCollection = this.convert(pubInfo, pubInfo.getRoot(), mainPaths, currentUserSession, language, workflowAction).values();
            gwtInfos.addAll(infoCollection);
        }
        return gwtInfos;
    }

    private Map<String, GWTJahiaPublicationInfo> convert(PublicationInfo pubInfo, PublicationInfoNode root, List<String> mainPaths, JCRSessionWrapper currentUserSession, String language, String workflowAction) {
        LinkedHashMap<String, GWTJahiaPublicationInfo> gwtInfos = new LinkedHashMap<String, GWTJahiaPublicationInfo>();
        return this.convert(pubInfo, root, mainPaths, currentUserSession, language, gwtInfos, workflowAction);
    }

    private Map<String, GWTJahiaPublicationInfo> convert(PublicationInfo pubInfo, PublicationInfoNode root, List<String> mainPaths, JCRSessionWrapper currentUserSession, String language, Map<String, GWTJahiaPublicationInfo> gwtInfos, String workflowAction) {
        PublicationInfoNode node = pubInfo.getRoot();
        ArrayList<PublicationInfo> references = new ArrayList<PublicationInfo>();
        this.convert(gwtInfos, root, mainPaths, null, node, references, currentUserSession, language, workflowAction);
        LinkedHashMap<String, GWTJahiaPublicationInfo> res = new LinkedHashMap<String, GWTJahiaPublicationInfo>();
        res.putAll(gwtInfos);
        for (PublicationInfo pi : references) {
            if (gwtInfos.containsKey(pi.getRoot().getUuid())) continue;
            res.putAll(this.convert(pi, pi.getRoot(), mainPaths, currentUserSession, language, gwtInfos, workflowAction));
        }
        return res;
    }

    private GWTJahiaPublicationInfo convert(Map<String, GWTJahiaPublicationInfo> all, PublicationInfoNode root, List<String> mainPaths, WorkflowRule lastRule, PublicationInfoNode node, List<PublicationInfo> references, JCRSessionWrapper currentUserSession, String language, String workflowAction) {
        GWTJahiaPublicationInfo gwtInfo = new GWTJahiaPublicationInfo(node.getUuid(), node.getStatus());
        try {
            JCRNodeWrapper jcrNode;
            if (node.getStatus() == 11) {
                JCRSessionWrapper liveSession = JCRTemplate.getInstance().getSessionFactory().getCurrentUserSession("live", currentUserSession.getLocale(), currentUserSession.getFallbackLocale());
                jcrNode = liveSession.getNodeByUUID(node.getUuid());
            } else {
                WorkflowRule rule;
                jcrNode = currentUserSession.getNodeByUUID(node.getUuid());
                if ((lastRule == null || jcrNode.hasNode("j:workflowRules")) && (rule = this.workflowService.getWorkflowRuleForAction(jcrNode, false, workflowAction)) != null && !rule.equals(lastRule)) {
                    lastRule = this.workflowService.getWorkflowRuleForAction(jcrNode, true, workflowAction) != null ? rule : null;
                }
            }
            if (jcrNode.hasProperty("jcr:title")) {
                gwtInfo.setTitle(jcrNode.getProperty("jcr:title").getString());
            } else {
                gwtInfo.setTitle(jcrNode.getName());
            }
            gwtInfo.setPath(jcrNode.getPath());
            gwtInfo.setNodetype(jcrNode.getPrimaryNodeType().getLabel(currentUserSession.getLocale()));
            gwtInfo.setIsAllowedToPublishWithoutWorkflow(Boolean.valueOf(jcrNode.hasPermission("publish")));
            gwtInfo.setIsNonRootMarkedForDeletion(Boolean.valueOf(jcrNode.isNodeType("jmix:markedForDeletion") && !jcrNode.isNodeType("jmix:markedForDeletionRoot")));
        }
        catch (RepositoryException e1) {
            logger.warn("Issue when reading workflow and delete status of node " + node.getPath(), (Throwable)e1);
            gwtInfo.setTitle(node.getPath());
        }
        gwtInfo.setWorkInProgress(Boolean.valueOf(node.isWorkInProgress()));
        String mainPath = root.getPath();
        gwtInfo.setMainPath(mainPath);
        gwtInfo.setMainUUID(root.getUuid());
        gwtInfo.setLanguage(language);
        if (!mainPaths.contains(mainPath)) {
            mainPaths.add(mainPath);
        }
        gwtInfo.setMainPathIndex(Integer.valueOf(mainPaths.indexOf(mainPath)));
        HashMap<String, GWTJahiaPublicationInfo> gwtInfos = new HashMap<String, GWTJahiaPublicationInfo>();
        gwtInfos.put(node.getPath(), gwtInfo);
        ArrayList<String> refUuids = new ArrayList<String>();
        all.put(node.getUuid(), gwtInfo);
        if (lastRule != null) {
            gwtInfo.setWorkflowGroup(language + lastRule.getDefinitionPath());
            gwtInfo.setWorkflowDefinition(lastRule.getProviderKey() + ":" + lastRule.getWorkflowDefinitionKey());
        } else {
            gwtInfo.setWorkflowGroup(language + " no-workflow");
        }
        String translationNodeName = node.getChildren().size() > 0 ? "/j:translation_" + language : null;
        for (PublicationInfoNode sub : node.getChildren()) {
            GWTJahiaPublicationInfo lastPub;
            String key;
            if (sub.getPath().contains(translationNodeName)) {
                key = StringUtils.substringBeforeLast((String)sub.getPath(), (String)"/j:translation");
                lastPub = (GWTJahiaPublicationInfo)gwtInfos.get(key);
                if (lastPub != null) {
                    if (sub.getStatus() > lastPub.getStatus()) {
                        lastPub.setStatus(Integer.valueOf(sub.getStatus()));
                    }
                    if (lastPub.getStatus() == 5 && sub.getStatus() != 5) {
                        lastPub.setStatus(Integer.valueOf(sub.getStatus()));
                    }
                    if (sub.isLocked()) {
                        gwtInfo.setLocked(Boolean.valueOf(true));
                    }
                    if (sub.isWorkInProgress()) {
                        gwtInfo.setWorkInProgress(Boolean.valueOf(true));
                    }
                    lastPub.setI18NUuid(sub.getUuid());
                }
                for (PublicationInfo pi : sub.getReferences()) {
                    if (refUuids.contains(pi.getRoot().getUuid()) || all.containsKey(pi.getRoot().getUuid())) continue;
                    refUuids.add(pi.getRoot().getUuid());
                    all.putAll(this.convert(pi, pi.getRoot(), mainPaths, currentUserSession, language, all, workflowAction));
                }
                continue;
            }
            if (!sub.getPath().contains("/j:translation") || node.getStatus() != 12 && node.getStatus() != 11) continue;
            key = StringUtils.substringBeforeLast((String)sub.getPath(), (String)"/j:translation");
            lastPub = (GWTJahiaPublicationInfo)gwtInfos.get(key);
            if (lastPub.getDeletedI18nUuid() != null) {
                lastPub.setDeletedI18nUuid(lastPub.getDeletedI18nUuid() + " " + sub.getUuid());
                continue;
            }
            lastPub.setDeletedI18nUuid(sub.getUuid());
        }
        references.addAll(node.getReferences());
        for (PublicationInfo pi : node.getReferences()) {
            if (refUuids.contains(pi.getRoot().getUuid())) continue;
            refUuids.add(pi.getRoot().getUuid());
            if (mainPaths.contains(pi.getRoot().getPath()) || all.containsKey(pi.getRoot().getUuid())) continue;
            all.putAll(this.convert(pi, pi.getRoot(), mainPaths, currentUserSession, language, all, workflowAction));
        }
        all.remove(node.getUuid());
        all.put(node.getUuid(), gwtInfo);
        for (PublicationInfoNode sub : node.getChildren()) {
            if (sub.getPath().indexOf("/j:translation") != -1) continue;
            this.convert(all, root, mainPaths, lastRule, sub, references, currentUserSession, language, workflowAction);
        }
        return gwtInfo;
    }

    public Map<PublicationWorkflow, WorkflowDefinition> createPublicationWorkflows(List<GWTJahiaPublicationInfo> all) {
        TreeMap infosListByWorflowGroup = new TreeMap();
        HashMap<String, String> workflowGroupToKey = new HashMap<String, String>();
        ArrayList<String> keys = new ArrayList<String>();
        for (GWTJahiaPublicationInfo info : all) {
            String workflowGroup = info.getWorkflowGroup();
            if (!infosListByWorflowGroup.containsKey(workflowGroup)) {
                infosListByWorflowGroup.put(workflowGroup, new ArrayList());
            }
            ((List)infosListByWorflowGroup.get(workflowGroup)).add(info);
            if (info.getWorkflowDefinition() == null) continue;
            workflowGroupToKey.put(info.getWorkflowGroup(), info.getWorkflowDefinition());
            if (keys.contains(info.getWorkflowDefinition())) continue;
            keys.add(info.getWorkflowDefinition());
        }
        LinkedHashMap<PublicationWorkflow, WorkflowDefinition> result = new LinkedHashMap<PublicationWorkflow, WorkflowDefinition>();
        HashMap<String, WorkflowDefinition> workflows = new HashMap<String, WorkflowDefinition>();
        for (String string : keys) {
            WorkflowDefinition w = this.workflowService.getWorkflowDefinition(StringUtils.substringBefore((String)string, (String)":"), StringUtils.substringAfter((String)string, (String)":"), null);
            workflows.put(string, w);
        }
        for (Map.Entry entry : infosListByWorflowGroup.entrySet()) {
            result.put(new PublicationWorkflow((List)entry.getValue()), (WorkflowDefinition)workflows.get(workflowGroupToKey.get(entry.getKey())));
        }
        return result;
    }

    public void publish(List<String> uuids, JCRSessionWrapper session, JCRSiteNode site, List<GWTJahiaNodeProperty> properties, List<String> comments) throws GWTJahiaServiceException {
        try {
            String workspaceName = session.getWorkspace().getName();
            JobDetail jobDetail = BackgroundJob.createJahiaJob("Publication", PublicationJob.class);
            JobDataMap jobDataMap = jobDetail.getJobDataMap();
            jobDataMap.put("sitekey", site.getName());
            jobDataMap.put((Object)"publicationProperties", properties);
            jobDataMap.put((Object)"publicationComments", comments);
            jobDataMap.put((Object)"publicationInfos", uuids);
            jobDataMap.put("source", workspaceName);
            jobDataMap.put("destination", "live");
            jobDataMap.put("checkPermissions", true);
            ServicesRegistry.getInstance().getSchedulerService().scheduleJobNow(jobDetail);
        }
        catch (SchedulerException e) {
            logger.error("repository exception", (Throwable)e);
            throw new GWTJahiaServiceException("Cannot get publish nodes " + uuids + ". Cause: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void publish(List<String> uuids) throws GWTJahiaServiceException {
        try {
            this.publicationService.publish(uuids, "default", "live", null);
        }
        catch (RepositoryException e) {
            logger.error("repository exception", (Throwable)e);
            throw new GWTJahiaServiceException("Cannot get publish nodes " + uuids + ". Cause: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void unpublish(List<String> uuids, Set<String> languages, JahiaUser user) throws GWTJahiaServiceException {
        try {
            this.publicationService.unpublish(uuids);
        }
        catch (RepositoryException e) {
            logger.error("repository exception", (Throwable)e);
            throw new GWTJahiaServiceException("Cannot get unpublish nodes " + uuids + ". Cause: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void validateConnection(Map<String, String> props, JCRSessionWrapper jcrSession, Locale uiLocale) throws GWTJahiaServiceException {
        PostMethod post = null;
        URL url = null;
        try {
            String languageCode = jcrSession.getNodeByIdentifier(props.get("node")).getResolveSite().getDefaultLanguage();
            String theUrl = props.get("remoteUrl") + Render.getRenderServletPath() + "/live/" + languageCode + props.get("remotePath") + ".preparereplay.do";
            url = new URL(theUrl);
            post = new PostMethod(theUrl);
            post.addParameter("testOnly", "true");
            post.addRequestHeader("accept", "application/json");
            HttpState state = new HttpState();
            state.setCredentials(new AuthScope(url.getHost(), url.getPort()), (Credentials)new UsernamePasswordCredentials(props.get("remoteUser"), props.get("remotePassword")));
            if (this.httpClientService.getHttpClient().executeMethod(null, (HttpMethod)post, state) != 200) {
                logger.warn("Connection to URL: {} failed with status {}", (Object)url, (Object)post.getStatusLine());
                throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.connection.failed.with.the.status", uiLocale, post.getStatusLine()));
            }
        }
        catch (RepositoryException e) {
            logger.error("Unable to get source node with identifier: " + props.get("node") + ". Cause: " + e.getMessage(), (Throwable)e);
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.connection.failed.with.the.an.error", uiLocale, e.getMessage()));
        }
        catch (HttpException e) {
            logger.error("Unable to get the content of the URL: " + url + ". Cause: " + e.getMessage(), (Throwable)e);
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.connection.failed.with.the.an.error", uiLocale, e.getMessage()));
        }
        catch (IOException e) {
            logger.error("Unable to get the content of the URL: " + url + ". Cause: " + e.getMessage(), (Throwable)e);
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.connection.failed.with.the.an.error", uiLocale, e.getMessage()));
        }
        finally {
            if (post != null) {
                post.releaseConnection();
            }
        }
    }

    public void setHttpClientService(HttpClientService httpClientService) {
        this.httpClientService = httpClientService;
    }
}

