/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.helper;

import com.extjs.gxt.ui.client.data.ModelData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.query.Query;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.queryParser.ParseException;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNodeUsage;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNodeVersion;
import org.jahia.ajax.gwt.client.service.GWTJahiaServiceException;
import org.jahia.ajax.gwt.helper.NodeHelper;
import org.jahia.bin.Jahia;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.registries.ServicesRegistry;
import org.jahia.security.license.LicenseCheckerService;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.decorator.JCRQueryNode;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.query.QueryWrapper;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.utils.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class NavigationHelper {
    private static Logger logger = LoggerFactory.getLogger(NavigationHelper.class);
    public static final String SAVED_OPEN_PATHS = "org.jahia.contentmanager.savedopenpaths.";
    public static final String SELECTED_PATH = "org.jahia.contentmanager.selectedpath.";
    private Set<String> ignoreInUsages = Collections.emptySet();
    private NodeHelper nodeHelper;

    public void setIgnoreInUsages(Set<String> ignoreInUsages) {
        this.ignoreInUsages = ignoreInUsages;
    }

    public void setNodeHelper(NodeHelper nodeHelper) {
        this.nodeHelper = nodeHelper;
    }

    public List<GWTJahiaNode> ls(String gwtParentPath, List<String> nodeTypes, List<String> mimeTypes, List<String> nameFilters, List<String> fields, JCRSessionWrapper currentUserSession, Locale uiLocale) throws GWTJahiaServiceException {
        return this.ls(gwtParentPath, nodeTypes, mimeTypes, nameFilters, fields, false, false, null, null, currentUserSession, false, uiLocale);
    }

    public List<GWTJahiaNode> ls(String parentPath, List<String> nodeTypes, List<String> mimeTypes, List<String> nameFilters, List<String> fields, boolean checkSubChild, boolean displayHiddenTypes, List<String> hiddenTypes, String hiddenRegex, JCRSessionWrapper currentUserSession, boolean showOnlyNodesWithTemplates, Locale uiLocale) throws GWTJahiaServiceException {
        JCRNodeWrapper node = null;
        try {
            node = currentUserSession.getNode(parentPath != null ? parentPath : "/");
        }
        catch (RepositoryException e) {
            logger.error(e.toString(), (Throwable)e);
        }
        if (node == null) {
            throw new GWTJahiaServiceException(Messages.getInternal("label.gwt.error.parent.node.is.null", uiLocale));
        }
        ArrayList<GWTJahiaNode> gwtNodeChildren = new ArrayList<GWTJahiaNode>();
        try {
            this.getMatchingChildNodes(nodeTypes, mimeTypes, nameFilters, fields, node, gwtNodeChildren, checkSubChild, displayHiddenTypes, hiddenTypes, hiddenRegex, showOnlyNodesWithTemplates, uiLocale);
            return gwtNodeChildren;
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.cannot.ls", uiLocale, parentPath, e.getLocalizedMessage()));
        }
    }

    private void getMatchingChildNodes(List<String> nodeTypes, List<String> mimeTypes, List<String> nameFilters, List<String> fields, JCRNodeWrapper node, List<GWTJahiaNode> gwtNodeChildren, boolean checkSubChild, boolean displayHiddenTypes, List<String> hiddenTypes, String hiddenRegex, boolean showOnlyNodesWithTemplates, Locale uiLocale) throws RepositoryException, GWTJahiaServiceException {
        if (node instanceof JCRQueryNode) {
            QueryWrapper q = node.getSession().getWorkspace().getQueryManager().getQuery(node.getRealNode());
            List<GWTJahiaNode> gwtJahiaNodes = this.executeQuery(q, nodeTypes, mimeTypes, nameFilters, fields, null, showOnlyNodesWithTemplates);
            gwtNodeChildren.addAll(gwtJahiaNodes);
            return;
        }
        JCRNodeIteratorWrapper nodesIterator = node.getNodes();
        if (nodesIterator == null) {
            throw new GWTJahiaServiceException(Messages.getInternal("label.gwt.error.children.list.is.null", uiLocale));
        }
        boolean licenseCheck = this.haveToCheckLicense(fields);
        Boolean hasOrderableChildren = null;
        int i = 1;
        while (nodesIterator.hasNext()) {
            try {
                JCRNodeWrapper childNode = (JCRNodeWrapper)nodesIterator.nextNode();
                if (logger.isDebugEnabled()) {
                    logger.debug("processing {}", (Object)childNode.getPath());
                }
                if (showOnlyNodesWithTemplates) {
                    RenderContext context = new RenderContext(null, null, node.getSession().getUser());
                    context.setMainResource(new Resource(childNode, "html", null, "page"));
                    context.setServletPath("/cms/render/live");
                    if (!JCRContentUtils.isADisplayableNode(childNode, context)) continue;
                }
                boolean hiddenNode = false;
                if (!displayHiddenTypes) {
                    if (hiddenRegex != null && childNode.getName().matches(hiddenRegex)) {
                        hiddenNode = true;
                    }
                    if (!hiddenNode && hiddenTypes != null && hiddenTypes.size() > 0) {
                        hiddenNode = NavigationHelper.matchesNodeType(childNode, hiddenTypes);
                    }
                    if (!hiddenNode && childNode.getNodeTypes().contains("jmix:hiddenNode")) {
                        hiddenNode = true;
                    }
                }
                if (!hiddenNode) {
                    boolean nameFilter;
                    boolean matchNodeType = NavigationHelper.matchesNodeType(childNode, nodeTypes);
                    if (logger.isDebugEnabled()) {
                        logger.debug("----------");
                        if (nodeTypes != null) {
                            for (String s : nodeTypes) {
                                logger.debug("Node " + childNode.getPath() + " match with " + s + "? " + childNode.isNodeType(s) + "[" + matchNodeType + "]");
                            }
                        }
                        logger.debug("----------");
                    }
                    if (!matchNodeType || !(nameFilter = NavigationHelper.matchesFilters(childNode.getName(), nameFilters))) continue;
                    boolean mimeTypeFilter = NavigationHelper.matchesMimeTypeFilters(childNode, mimeTypes);
                    boolean hasNodes = false;
                    if (!mimeTypeFilter) {
                        try {
                            hasNodes = childNode.hasNodes();
                        }
                        catch (RepositoryException e) {
                            logger.error(e.getMessage(), (Throwable)e);
                        }
                    }
                    if (!mimeTypeFilter && !hasNodes || licenseCheck && !this.isAllowedByLicense(childNode)) continue;
                    GWTJahiaNode gwtChildNode = this.getGWTJahiaNode(childNode, fields);
                    gwtChildNode.setMatchFilters(matchNodeType && mimeTypeFilter);
                    if (hasOrderableChildren == null) {
                        hasOrderableChildren = node.getPrimaryNodeType().hasOrderableChildNodes();
                    }
                    if (hasOrderableChildren.booleanValue()) {
                        gwtChildNode.set("index", (Object)i++);
                    }
                    if (!childNode.getProvider().isSlowConnection()) {
                        JCRNodeIteratorWrapper ni = childNode.getNodes();
                        gwtChildNode.setHasChildren(false);
                        while (ni.hasNext()) {
                            Node n = ni.nextNode();
                            if (!NavigationHelper.matchesNodeType(n, nodeTypes) || !NavigationHelper.matchesFilters(n.getName(), nameFilters)) continue;
                            gwtChildNode.setHasChildren(true);
                            break;
                        }
                    } else {
                        gwtChildNode.setHasChildren(true);
                    }
                    gwtNodeChildren.add(gwtChildNode);
                    continue;
                }
                if (!checkSubChild || !childNode.hasNodes()) continue;
                this.getMatchingChildNodes(nodeTypes, mimeTypes, nameFilters, fields, childNode, gwtNodeChildren, checkSubChild, displayHiddenTypes, hiddenTypes, hiddenRegex, showOnlyNodesWithTemplates, uiLocale);
            }
            catch (InvalidItemStateException e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected static boolean matchesFilters(String nodeName, List<String> filters) {
        if (CollectionUtils.isEmpty(filters)) {
            return true;
        }
        boolean matches = false;
        for (String wildcard : filters) {
            if (!FilenameUtils.wildcardMatch((String)nodeName, (String)wildcard, (IOCase)IOCase.INSENSITIVE)) continue;
            matches = true;
            break;
        }
        return matches;
    }

    protected static boolean matchesMimeTypeFilters(JCRNodeWrapper node, List<String> filters) {
        if (CollectionUtils.isEmpty(filters)) {
            return true;
        }
        if (!node.isFile()) {
            return true;
        }
        return NavigationHelper.matchesFilters(node.getFileContent().getContentType(), filters);
    }

    protected static boolean matchesNodeType(Node node, List<String> nodeTypes) {
        if (CollectionUtils.isEmpty(nodeTypes)) {
            return true;
        }
        for (String nodeType : nodeTypes) {
            try {
                if (!node.isNodeType(nodeType)) continue;
                return true;
            }
            catch (RepositoryException e) {
                logger.error("can't get nodetype", (Throwable)e);
            }
        }
        return false;
    }

    public List<GWTJahiaNode> retrieveRoot(List<String> paths, List<String> nodeTypes, List<String> mimeTypes, List<String> filters, List<String> fields, List<String> selectedNodes, List<String> openPaths, JCRSiteNode site, JCRSessionWrapper currentUserSession, Locale uiLocale) throws GWTJahiaServiceException {
        return this.retrieveRoot(paths, nodeTypes, mimeTypes, filters, fields, selectedNodes, openPaths, site, currentUserSession, uiLocale, false, false, null, null);
    }

    public List<GWTJahiaNode> retrieveRoot(List<String> paths, List<String> nodeTypes, List<String> mimeTypes, List<String> filters, List<String> fields, List<String> selectedNodes, List<String> openPaths, JCRSiteNode site, JCRSessionWrapper currentUserSession, Locale uiLocale, boolean checkSubChild, boolean displayHiddenTypes, List<String> hiddenTypes, String hiddenRegex) throws GWTJahiaServiceException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("open paths for getRoot : " + openPaths);
            }
            List<GWTJahiaNode> userNodes = this.retrieveRoot(paths, nodeTypes, mimeTypes, filters, fields, site, uiLocale, currentUserSession, checkSubChild, displayHiddenTypes, hiddenTypes, hiddenRegex);
            ArrayList<GWTJahiaNode> allNodes = new ArrayList<GWTJahiaNode>(userNodes);
            if (selectedNodes != null) {
                if (openPaths == null) {
                    openPaths = selectedNodes;
                } else {
                    openPaths = new ArrayList<String>(openPaths);
                    openPaths.addAll(selectedNodes);
                }
            }
            if (openPaths != null) {
                for (String openPath : new HashSet<String>(openPaths)) {
                    try {
                        for (int i = 0; i < allNodes.size(); ++i) {
                            GWTJahiaNode node = (GWTJahiaNode)allNodes.get(i);
                            if (!node.isExpandOnLoad()) {
                                boolean matchPath;
                                if (openPath.endsWith("*")) {
                                    String p = StringUtils.substringBeforeLast((String)openPath, (String)"*");
                                    matchPath = node.getPath().startsWith(p) || p.startsWith(node.getPath());
                                } else {
                                    matchPath = openPath.startsWith(node.getPath());
                                }
                                if (matchPath) {
                                    node.setExpandOnLoad(true);
                                    List<GWTJahiaNode> list = this.ls(node.getPath(), nodeTypes, mimeTypes, filters, fields, checkSubChild, displayHiddenTypes, hiddenTypes, hiddenRegex, currentUserSession, false, uiLocale);
                                    for (int j = 0; j < list.size(); ++j) {
                                        node.insert((ModelData)list.get(j), j);
                                        allNodes.add(list.get(j));
                                    }
                                }
                            }
                            if (selectedNodes == null || !selectedNodes.contains(node.getPath())) continue;
                            node.setSelectedOnLoad(true);
                        }
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
            for (GWTJahiaNode userNode : userNodes) {
                userNode.set("isRootNode", (Object)Boolean.TRUE);
            }
            return userNodes;
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.cannot.retrieve.root.nodes", uiLocale, paths, e.getLocalizedMessage()));
        }
    }

    public List<GWTJahiaNode> retrieveRoot(List<String> paths, List<String> nodeTypes, List<String> mimeTypes, List<String> filters, List<String> fields, final JCRSiteNode site, Locale uiLocale, JCRSessionWrapper currentUserSession, boolean checkSubChild, boolean displayHiddenTypes, List<String> hiddenTypes, String hiddenRegex) throws RepositoryException, GWTJahiaServiceException {
        final ArrayList<GWTJahiaNode> userNodes = new ArrayList<GWTJahiaNode>();
        final boolean checkLicense = this.haveToCheckLicense(fields);
        for (String path : paths) {
            String displayName = null;
            if (site != null) {
                if (path.contains("$site/") || path.endsWith("$site")) {
                    String sitePath = site.getPath();
                    if (StringUtils.startsWith((String)sitePath, (String)"/modules/")) {
                        String moduleName = sitePath.indexOf(47, "/modules/".length()) != -1 ? StringUtils.substringBetween((String)sitePath, (String)"/modules/", (String)"/") : StringUtils.substringAfter((String)sitePath, (String)"/modules/");
                        JahiaTemplatesPackage module = ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageById(moduleName);
                        if (module == null) {
                            return userNodes;
                        }
                        path = StringUtils.replace((String)path, (String)"$site", (String)(sitePath + "/" + module.getVersion().toString()));
                    } else {
                        path = StringUtils.replace((String)path, (String)"$site", (String)sitePath);
                    }
                }
                if (path.contains("$siteKey/")) {
                    path = path.replace("$siteKey", site.getSiteKey());
                }
            }
            if (path.contains("$moduleversion")) {
                String moduleName = StringUtils.split((String)path, (char)'/')[1];
                if (ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageById(moduleName) != null) {
                    path = path.replace("$moduleversion", ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageById(moduleName).getVersion().toString());
                } else {
                    logger.warn("read version - Unable to get bundle " + moduleName + " from registry");
                    continue;
                }
            }
            if (path.contains("$systemsite")) {
                String systemSiteKey = JCRContentUtils.getSystemSitePath();
                path = path.replace("$systemsite", systemSiteKey);
            }
            if (site != null && path.contains("$sites")) {
                JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<Object>(){

                    @Override
                    public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                        JCRNodeWrapper parent = site.getParent();
                        JCRNodeIteratorWrapper nodes = parent.getNodes();
                        while (nodes.hasNext()) {
                            JCRNodeWrapper nodeWrapper = (JCRNodeWrapper)nodes.next();
                            if (checkLicense && !NavigationHelper.this.isAllowedByLicense(nodeWrapper)) continue;
                            userNodes.add(NavigationHelper.this.getGWTJahiaNode(nodeWrapper));
                        }
                        return null;
                    }
                });
            }
            if (path.contains("$user")) {
                JCRNodeWrapper userFolder = JCRContentUtils.getInstance().getDefaultUserFolder(currentUserSession, StringUtils.substringAfter((String)path, (String)"$user"));
                path = userFolder.getPath();
                displayName = Messages.getInternal("label.personalFolder", uiLocale, "label.personalFolder");
            }
            if (!path.startsWith("/")) continue;
            try {
                if (path.endsWith("/*")) {
                    this.getMatchingChildNodes(nodeTypes, mimeTypes, filters, fields, currentUserSession.getNode(StringUtils.substringBeforeLast((String)path, (String)"/*")), userNodes, checkSubChild, displayHiddenTypes, hiddenTypes, hiddenRegex, false, uiLocale);
                    continue;
                }
                GWTJahiaNode root = this.getNode(path, fields, currentUserSession, uiLocale);
                if (root == null) continue;
                if (displayName != null) {
                    root.setDisplayName(JCRContentUtils.unescapeLocalNodeName(displayName));
                }
                userNodes.add(root);
            }
            catch (PathNotFoundException e) {}
        }
        return userNodes;
    }

    public GWTJahiaNode getNode(String path, List<String> fields, JCRSessionWrapper currentUserSession, Locale uiLocale) throws GWTJahiaServiceException {
        try {
            return this.getGWTJahiaNode(currentUserSession.getNode(path), fields, uiLocale);
        }
        catch (RepositoryException e) {
            throw new GWTJahiaServiceException(path + Messages.getInternal("label.gwt.error.could.not.be.accessed", uiLocale) + (Object)((Object)e));
        }
    }

    public GWTJahiaNode getParentNode(String path, JCRSessionWrapper currentUserSession) throws GWTJahiaServiceException {
        try {
            return this.getGWTJahiaNode(currentUserSession.getNode(path).getParent());
        }
        catch (RepositoryException e) {
            logger.error(e.toString(), (Throwable)e);
            throw new GWTJahiaServiceException(path + " could not be accessed :\n" + e.toString());
        }
    }

    public String getAbsolutePath(String path, JCRSessionWrapper currentUserSession, HttpServletRequest request, Locale uiLocale) throws GWTJahiaServiceException {
        JCRNodeWrapper node;
        try {
            node = currentUserSession.getNode(path);
        }
        catch (RepositoryException e) {
            logger.error(e.toString(), (Throwable)e);
            throw new GWTJahiaServiceException(path + Messages.getInternal("label.gwt.error.could.not.be.accessed", uiLocale) + e.toString());
        }
        return node.getAbsoluteWebdavUrl(request);
    }

    public List<GWTJahiaNodeUsage> getUsages(List<String> paths, JCRSessionWrapper currentUserSession, Locale uiLocale) throws GWTJahiaServiceException {
        ArrayList<GWTJahiaNodeUsage> result = new ArrayList<GWTJahiaNodeUsage>();
        for (String path : paths) {
            JCRNodeWrapper node;
            try {
                node = currentUserSession.getNode(path);
            }
            catch (RepositoryException e) {
                logger.error(e.toString(), (Throwable)e);
                throw new GWTJahiaServiceException(path + Messages.getInternal("label.gwt.error.could.not.be.accessed", uiLocale) + e.toString());
            }
            try {
                if (node.isNodeType("mix:shareable")) {
                    JCRNodeIteratorWrapper usages = node.getSharedSet();
                    while (usages.hasNext()) {
                        JCRNodeWrapper usage = (JCRNodeWrapper)usages.next();
                        if (usage.getPath().equals(node.getPath()) || usage.getPath().startsWith("/jcr:system")) continue;
                        this.addUsage(result, usage, "shared");
                    }
                }
            }
            catch (RepositoryException e) {
                logger.error(e.toString(), (Throwable)e);
            }
            try {
                this.fillUsages(result, node.getWeakReferences());
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    private void fillUsages(List<GWTJahiaNodeUsage> result, PropertyIterator r) throws RepositoryException {
        while (r.hasNext()) {
            String nt;
            JCRNodeWrapper refNode;
            JCRPropertyWrapper reference = (JCRPropertyWrapper)r.next();
            if (reference.getPath().startsWith("/referencesKeeper") || (refNode = reference.getParent()).getPath().startsWith("/jcr:system") || !this.ignoreInUsages.isEmpty() && (this.ignoreInUsages.contains((nt = refNode.getPrimaryNodeTypeName() + ".") + "*") || this.ignoreInUsages.contains(nt + reference.getName()))) continue;
            this.addUsage(result, refNode, "reference");
        }
    }

    private void addUsage(List<GWTJahiaNodeUsage> result, JCRNodeWrapper refNode, String type) throws RepositoryException {
        JCRNodeWrapper parent = refNode.isNodeType("jnt:page") ? refNode : this.lookUpParentPageNode(refNode);
        String language = null;
        if (refNode.isNodeType("jnt:translation")) {
            language = refNode.getProperty("jcr:language").getString();
            refNode = refNode.getParent();
        }
        GWTJahiaNodeUsage usage = new GWTJahiaNodeUsage(refNode.getIdentifier(), refNode.getPath());
        usage.setNodeName(refNode.getName());
        usage.setPagePath(parent != null ? parent.getPath() : refNode.getPath());
        usage.setNodeTitle(refNode.hasProperty("jcr:title") ? refNode.getPropertyAsString("jcr:title") : "");
        if (parent != null) {
            usage.setPageTitle(parent.getPropertyAsString("jcr:title"));
        } else {
            String title = refNode.getPropertyAsString("jcr:title");
            if (title == null) {
                title = refNode.getName();
            }
            title = title + " (" + refNode.getPrimaryNodeType().getName() + ")";
            usage.setPageTitle(title);
        }
        usage.setLanguage(language);
        usage.setType(type);
        result.add(usage);
    }

    public List<GWTJahiaNode> getNodesByCategory(String path, JCRSessionWrapper currentUserSession) throws GWTJahiaServiceException {
        JCRNodeWrapper node;
        try {
            node = currentUserSession.getNode(path);
        }
        catch (RepositoryException e) {
            logger.error(e.toString(), (Throwable)e);
            throw new GWTJahiaServiceException(path + " could not be accessed :\n" + e.toString());
        }
        ArrayList<GWTJahiaNode> result = new ArrayList<GWTJahiaNode>();
        try {
            PropertyIterator references = node.getWeakReferences();
            HashSet<String> alreadyIncludedIdentifiers = new HashSet<String>();
            while (references.hasNext()) {
                JCRPropertyWrapper reference = (JCRPropertyWrapper)references.next();
                JCRNodeWrapper currentNode = reference.getParent();
                if (currentNode.isNodeType("jnt:category")) continue;
                if (currentNode.isNodeType("jnt:translation")) {
                    currentNode = currentNode.getParent();
                }
                if (alreadyIncludedIdentifiers.contains(currentNode.getIdentifier())) continue;
                result.add(this.getGWTJahiaNode(currentNode, Arrays.asList("icon", "publicationInfo", "name")));
                alreadyIncludedIdentifiers.add(currentNode.getIdentifier());
            }
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private JCRNodeWrapper lookUpParentPageNode(JCRNodeWrapper usage) throws RepositoryException {
        return this.lookUpParentNode(usage, "jnt:page");
    }

    private JCRNodeWrapper lookUpParentNode(JCRNodeWrapper usage, String nodeType) throws RepositoryException {
        if (nodeType == null) {
            return null;
        }
        boolean pageParentFound = false;
        JCRNodeWrapper parentNode = usage.getParent();
        while (!pageParentFound) {
            if (parentNode.isNodeType(nodeType)) {
                return parentNode;
            }
            if (parentNode.getPath().lastIndexOf("/") == 0) {
                return null;
            }
            parentNode = parentNode.getParent();
        }
        return null;
    }

    public List<GWTJahiaNode> executeQuery(Query q, List<String> nodeTypesToApply, List<String> mimeTypesToMatch, List<String> filtersToApply, List<String> sites) throws RepositoryException {
        return this.executeQuery(q, nodeTypesToApply, mimeTypesToMatch, filtersToApply, GWTJahiaNode.DEFAULT_FIELDS, sites, false);
    }

    public List<GWTJahiaNode> executeQuery(Query q, List<String> nodeTypesToApply, List<String> mimeTypesToMatch, List<String> filtersToApply, List<String> fields, List<String> sites, boolean showOnlyNodesWithTemplates) throws RepositoryException {
        boolean licenseCheck = this.haveToCheckLicense(fields);
        ArrayList<GWTJahiaNode> result = new ArrayList<GWTJahiaNode>();
        HashSet<String> addedIds = new HashSet<String>();
        NodeIterator ni = null;
        try {
            ni = q.execute().getNodes();
        }
        catch (RepositoryException e) {
            if (e.getMessage() != null && e.getMessage().contains(ParseException.class.getName())) {
                logger.warn(e.getMessage());
                if (logger.isDebugEnabled()) {
                    logger.debug(e.getMessage(), (Throwable)e);
                }
            }
            throw e;
        }
        while (ni != null && ni.hasNext()) {
            try {
                boolean siteCheck;
                boolean matchFilter;
                JCRNodeWrapper n = (JCRNodeWrapper)ni.nextNode();
                if (n.isNodeType("jnt:translation") || "jcr:content".equals(n.getName())) {
                    n = n.getParent();
                }
                if (n.isNodeType("nt:frozenNode") || !CollectionUtils.isEmpty(nodeTypesToApply) && !NavigationHelper.matchesNodeType(n, nodeTypesToApply)) continue;
                boolean hasNodes = false;
                try {
                    hasNodes = n.getProvider().isSlowConnection() || n.hasNodes();
                }
                catch (RepositoryException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                boolean bl = matchFilter = NavigationHelper.matchesFilters(n.getName(), filtersToApply) && NavigationHelper.matchesMimeTypeFilters(n, mimeTypesToMatch);
                if (showOnlyNodesWithTemplates && !JCRContentUtils.isADisplayableNode(n, new RenderContext(null, null, n.getSession().getUser())) || !(siteCheck = sites == null || sites.contains(n.getResolveSite().getSiteKey())) || !matchFilter && !hasNodes || !addedIds.add(n.getIdentifier()) || licenseCheck && !this.isAllowedByLicense(n)) continue;
                GWTJahiaNode node = this.getGWTJahiaNode(n, fields);
                node.setMatchFilters(matchFilter);
                result.add(node);
            }
            catch (Exception e) {
                logger.warn("Error resolving search hit", (Throwable)e);
            }
        }
        return result;
    }

    public GWTJahiaNode getGWTJahiaNode(JCRNodeWrapper node) {
        return this.nodeHelper.getGWTJahiaNode(node);
    }

    public GWTJahiaNode getGWTJahiaNode(JCRNodeWrapper node, List<String> fields) {
        return this.nodeHelper.getGWTJahiaNode(node, fields, null);
    }

    public GWTJahiaNode getGWTJahiaNode(JCRNodeWrapper node, List<String> fields, Locale uiLocale) {
        return this.nodeHelper.getGWTJahiaNode(node, fields, uiLocale);
    }

    public List<GWTJahiaNodeVersion> getVersions(JCRNodeWrapper node) throws RepositoryException {
        return this.getVersions(node, false);
    }

    public List<GWTJahiaNodeVersion> getVersions(JCRNodeWrapper node, boolean publishedOnly) throws RepositoryException {
        return this.nodeHelper.getVersions(node, publishedOnly);
    }

    public String getNodeURL(String servlet, JCRNodeWrapper node, Date versionDate, String versionLabel, String workspace, Locale locale) throws RepositoryException {
        return NodeHelper.getNodeURL(servlet, node, versionDate, versionLabel, workspace, locale);
    }

    private boolean isAllowedByLicense(JCRNodeWrapper node) {
        boolean allowed = true;
        try {
            if (node.isNodeType("jmix:requireLicense")) {
                try {
                    String feature = node.getProperty("j:requiredLicenseFeature").getString();
                    allowed = StringUtils.isEmpty((String)feature) || LicenseCheckerService.Stub.isAllowed(feature);
                }
                catch (PathNotFoundException e) {}
            }
        }
        catch (RepositoryException e) {
            logger.error("Error checking required license feature on node " + node, (Throwable)e);
        }
        return allowed;
    }

    private boolean haveToCheckLicense(List<String> fields) {
        return fields != null && Jahia.isEnterpriseEdition() && fields.contains("j:requiredLicenseFeature");
    }
}

