/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.helper;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyIterator;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jahia.ajax.gwt.client.data.GWTJahiaContentHistoryEntry;
import org.jahia.ajax.gwt.client.data.acl.GWTJahiaNodeACE;
import org.jahia.ajax.gwt.client.data.acl.GWTJahiaNodeACL;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeProperty;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodePropertyValue;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.service.GWTJahiaServiceException;
import org.jahia.ajax.gwt.content.server.GWTFileManagerUploadServlet;
import org.jahia.ajax.gwt.helper.NavigationHelper;
import org.jahia.ajax.gwt.helper.PropertiesHelper;
import org.jahia.ajax.gwt.helper.VersioningHelper;
import org.jahia.api.Constants;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.data.viewhelper.principal.PrincipalViewHelper;
import org.jahia.exceptions.JahiaException;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeLockType;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.JCRValueWrapper;
import org.jahia.services.content.decorator.JCRGroupNode;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.history.ContentHistoryService;
import org.jahia.services.history.HistoryEntry;
import org.jahia.services.importexport.ImportExportBaseService;
import org.jahia.services.importexport.ImportJob;
import org.jahia.services.importexport.ReferencesHelper;
import org.jahia.services.importexport.validation.MissingModulesValidationResult;
import org.jahia.services.importexport.validation.MissingNodetypesValidationResult;
import org.jahia.services.importexport.validation.MissingTemplatesValidationResult;
import org.jahia.services.importexport.validation.ValidationResult;
import org.jahia.services.importexport.validation.ValidationResults;
import org.jahia.services.query.QueryWrapper;
import org.jahia.services.scheduler.BackgroundJob;
import org.jahia.services.sites.JahiaSitesService;
import org.jahia.services.templates.JahiaTemplateManagerService;
import org.jahia.services.templates.SourceControlManagement;
import org.jahia.services.usermanager.JahiaGroupManagerService;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.i18n.Messages;
import org.osgi.framework.BundleException;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentManagerHelper {
    private static final List<String> COPIED_NODE_FIELDS = Arrays.asList("icon", "tags", "childrenInfo", "j:view", "j:width", "j:height", "publicationInfo", "permissions");
    private static final List<String> NEW_NODE_FIELDS = Arrays.asList("icon", "tags", "childrenInfo", "j:view", "j:width", "j:height", "locksInfo", "subnodesConstraintsInfo");
    private static Logger logger = LoggerFactory.getLogger(ContentManagerHelper.class);
    private JahiaSitesService sitesService;
    private ContentHistoryService contentHistoryService;
    private JahiaTemplateManagerService templateManagerService;
    private NavigationHelper navigation;
    private PropertiesHelper properties;
    private VersioningHelper versioning;

    public void setNavigation(NavigationHelper navigation) {
        this.navigation = navigation;
    }

    public void setProperties(PropertiesHelper properties) {
        this.properties = properties;
    }

    public void setSitesService(JahiaSitesService sitesService) {
        this.sitesService = sitesService;
    }

    public void setVersioning(VersioningHelper versioning) {
        this.versioning = versioning;
    }

    public void setContentHistoryService(ContentHistoryService contentHistoryService) {
        this.contentHistoryService = contentHistoryService;
    }

    public void setTemplateManagerService(JahiaTemplateManagerService templateManagerService) {
        this.templateManagerService = templateManagerService;
    }

    public JCRNodeWrapper addNode(JCRNodeWrapper parentNode, String name, String nodeType, List<String> mixin, List<GWTJahiaNodeProperty> props, Locale uiLocale) throws GWTJahiaServiceException {
        JCRNodeWrapper childNode;
        if (!parentNode.hasPermission("{http://www.jcp.org/jcr/1.0}addChildNodes")) {
            throw new GWTJahiaServiceException(parentNode.getPath() + " - ACCESS DENIED");
        }
        try {
            parentNode.getSession().checkout(parentNode);
            childNode = parentNode.addNode(name, nodeType);
            if (mixin != null) {
                for (String m : mixin) {
                    childNode.addMixin(m);
                }
            }
            this.properties.setProperties(childNode, props);
        }
        catch (Exception e) {
            logger.error("Exception", (Throwable)e);
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.cannot.get.node", uiLocale, e.getLocalizedMessage()));
        }
        if (childNode == null) {
            throw new GWTJahiaServiceException(Messages.getInternal("label.gwt.error.node.creation.failed", uiLocale));
        }
        return childNode;
    }

    public GWTJahiaNode createNode(String parentPath, String name, String nodeType, List<String> mixin, List<GWTJahiaNodeProperty> props, JCRSessionWrapper currentUserSession, Locale uiLocale, Map<String, String> parentNodesType, boolean forceCreation) throws GWTJahiaServiceException {
        try {
            String nodeName;
            JCRNodeWrapper parentNode = this.ensureParent(parentPath, currentUserSession, uiLocale, parentNodesType);
            if (name == null) {
                nodeName = this.findAvailableName(parentNode, nodeType.substring(nodeType.lastIndexOf(58) + 1));
            } else {
                nodeName = JCRContentUtils.escapeLocalNodeName(name);
                if (!forceCreation && this.checkExistence(parentPath + "/" + nodeName, currentUserSession, uiLocale)) {
                    throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.node.already.exists.with.name", uiLocale, nodeName));
                }
                nodeName = this.findAvailableName(parentNode, nodeName);
            }
            JCRNodeWrapper childNode = this.addNode(parentNode, nodeName, nodeType, mixin, props, uiLocale);
            return this.navigation.getGWTJahiaNode(currentUserSession.getNode(childNode.getPath()), NEW_NODE_FIELDS);
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new GWTJahiaServiceException(parentPath + Messages.getInternal("label.gwt.error.could.not.be.accessed", uiLocale) + e.toString());
        }
    }

    private JCRNodeWrapper ensureParent(String parentPath, JCRSessionWrapper currentUserSession, Locale uiLocale, Map<String, String> parentNodesType) throws RepositoryException, GWTJahiaServiceException, PathNotFoundException, NoSuchNodeTypeException, LockException, VersionException, ConstraintViolationException {
        JCRNodeWrapper parentNode;
        try {
            parentNode = currentUserSession.getNode(parentPath);
        }
        catch (PathNotFoundException e) {
            if (parentNodesType != null) {
                String[] pathElements = StringUtils.split((String)parentPath, (char)'/');
                JCRNodeWrapper current = currentUserSession.getRootNode();
                for (String pathElement : pathElements) {
                    try {
                        current = current.getNode(pathElement);
                    }
                    catch (PathNotFoundException pnfe) {
                        String currentPath = current.getPath() + "/" + pathElement;
                        if (!parentNodesType.containsKey(currentPath)) {
                            throw new GWTJahiaServiceException(currentPath + Messages.getInternal("label.gwt.error.could.not.be.accessed", uiLocale));
                        }
                        current = current.addNode(pathElement, parentNodesType.get(currentPath));
                    }
                }
                parentNode = current;
            }
            throw e;
        }
        return parentNode;
    }

    public String generateNameFromTitle(List<GWTJahiaNodeProperty> props) {
        String nodeName = null;
        for (GWTJahiaNodeProperty property : props) {
            if (property != null) {
                List propertyValues = property.getValues();
                if (!property.getName().equals("jcr:title") || propertyValues == null || propertyValues.size() <= 0 || ((GWTJahiaNodePropertyValue)propertyValues.get(0)).getString() == null) continue;
                nodeName = JCRContentUtils.generateNodeName(((GWTJahiaNodePropertyValue)propertyValues.get(0)).getString());
                continue;
            }
            logger.error("found a null property");
        }
        return nodeName;
    }

    public GWTJahiaNode createFolder(String parentPath, String name, JCRSessionWrapper currentUserSession, Locale uiLocale) throws GWTJahiaServiceException {
        GWTJahiaNode newNode = null;
        try {
            JCRSessionWrapper jcrSessionWrapper = currentUserSession;
            JCRNodeWrapper parentNode = jcrSessionWrapper.getNode(parentPath);
            newNode = this.createNode(parentPath, name, parentNode.isNodeType("jnt:folder") ? "jnt:folder" : "jnt:contentList", null, null, currentUserSession, uiLocale, null, true);
            currentUserSession.save();
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new GWTJahiaServiceException(parentPath + Messages.getInternal("label.gwt.error.could.not.be.accessed", uiLocale) + e.toString());
        }
        return newNode;
    }

    public String findAvailableName(JCRNodeWrapper dest, String name) {
        return JCRContentUtils.findAvailableNodeName(dest, name);
    }

    public boolean checkExistence(String path, JCRSessionWrapper currentUserSession, Locale uiLocale) throws GWTJahiaServiceException {
        try {
            return currentUserSession.nodeExists(JCRContentUtils.escapeNodePath(path));
        }
        catch (RepositoryException e) {
            logger.error(e.toString(), (Throwable)e);
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error", uiLocale, e.toString()));
        }
    }

    public void move(String sourcePath, String targetPath, JCRSessionWrapper currentUserSession) throws RepositoryException {
        currentUserSession.move(sourcePath, targetPath);
        currentUserSession.save();
    }

    public void moveAtEnd(String sourcePath, String targetPath, JCRSessionWrapper currentUserSession) throws RepositoryException, GWTJahiaServiceException {
        JCRNodeWrapper srcNode = currentUserSession.getNode(sourcePath);
        JCRNodeWrapper targetNode = currentUserSession.getNode(targetPath);
        currentUserSession.checkout(targetNode);
        if (srcNode.getParent().getPath().equals(targetNode.getPath())) {
            if (targetNode.getPrimaryNodeType().hasOrderableChildNodes()) {
                targetNode.orderBefore(srcNode.getName(), null);
            }
        } else {
            currentUserSession.checkout(srcNode);
            currentUserSession.checkout(srcNode.getParent());
            String newname = this.findAvailableName(targetNode, srcNode.getName());
            currentUserSession.move(sourcePath, targetNode.getPath() + "/" + newname);
            if (targetNode.getPrimaryNodeType().hasOrderableChildNodes()) {
                targetNode.orderBefore(newname, null);
            }
        }
        currentUserSession.save();
    }

    public void moveOnTopOf(String sourcePath, String targetPath, JCRSessionWrapper currentUserSession) throws RepositoryException, GWTJahiaServiceException {
        JCRNodeWrapper srcNode = currentUserSession.getNode(sourcePath);
        JCRNodeWrapper targetNode = currentUserSession.getNode(targetPath);
        JCRNodeWrapper targetParent = targetNode.getParent();
        currentUserSession.checkout(targetParent);
        if (srcNode.getParent().getPath().equals(targetParent.getPath())) {
            if (targetParent.getPrimaryNodeType().hasOrderableChildNodes()) {
                targetParent.orderBefore(srcNode.getName(), targetNode.getName());
            }
        } else {
            currentUserSession.checkout(srcNode);
            currentUserSession.checkout(srcNode.getParent());
            String newname = this.findAvailableName(targetParent, srcNode.getName());
            currentUserSession.move(sourcePath, targetParent.getPath() + "/" + newname);
            if (targetParent.getPrimaryNodeType().hasOrderableChildNodes()) {
                targetParent.orderBefore(newname, targetNode.getName());
            }
        }
        currentUserSession.save();
    }

    public void checkWriteable(List<String> paths, JahiaUser user, JCRSessionWrapper currentUserSession, Locale uiLocale) throws GWTJahiaServiceException {
        try {
            ArrayList<String> missedPaths = new ArrayList<String>();
            for (String aNode : paths) {
                JCRNodeWrapper node;
                try {
                    node = currentUserSession.getNode(aNode);
                }
                catch (RepositoryException e) {
                    logger.error(e.toString(), (Throwable)e);
                    missedPaths.add(aNode + Messages.getInternal("label.gwt.error.could.not.be.accessed", uiLocale) + e.toString());
                    continue;
                }
                if (!node.hasPermission("{http://www.jcp.org/jcr/1.0}addChildNodes")) {
                    missedPaths.add(Messages.getInternalWithArguments("label.gwt.error.has.no.write.access.to", uiLocale, user.getUsername(), node.getName()));
                    continue;
                }
                if (!node.isLocked() || node.getLockOwner().equals(user.getUsername())) continue;
                missedPaths.add(node.getName() + Messages.getInternal("label.gwt.error.locked.by", uiLocale) + user.getUsername());
            }
            if (missedPaths.size() > 0) {
                StringBuilder errors = new StringBuilder(Messages.getInternal("label.gwt.error.following.files.could.not.be.cut", uiLocale));
                for (String err : missedPaths) {
                    errors.append("\n").append(err);
                }
                throw new GWTJahiaServiceException(errors.toString());
            }
        }
        catch (RepositoryException e) {
            throw new GWTJahiaServiceException((Throwable)e);
        }
    }

    public List<GWTJahiaNode> copy(List<String> pathsToCopy, String destinationPath, String newName, boolean moveOnTop, boolean cut, boolean reference, boolean allLanguages, JCRSessionWrapper currentUserSession) throws GWTJahiaServiceException {
        return this.copy(pathsToCopy, destinationPath, newName, moveOnTop, cut, reference, null, allLanguages, currentUserSession, currentUserSession.getLocale());
    }

    public List<GWTJahiaNode> copy(final List<String> pathsToCopy, final String destinationPath, final String newName, final boolean moveOnTop, final boolean cut, final boolean reference, final List<String> childNodeTypesToSkip, boolean allLanguages, JCRSessionWrapper currentUserSession, Locale uiLocale) throws GWTJahiaServiceException {
        final ArrayList<String> missedPaths = new ArrayList<String>();
        ArrayList<GWTJahiaNode> res = new ArrayList<GWTJahiaNode>();
        Iterator<String> iterator = pathsToCopy.iterator();
        while (iterator.hasNext()) {
            String toCopy = iterator.next();
            if (!destinationPath.equals(toCopy) && !destinationPath.startsWith(toCopy + "/")) continue;
            missedPaths.add(Messages.getInternalWithArguments("failure.paste.cannot.paste", uiLocale, "Content {0} cannot be pasted into {1}", toCopy, destinationPath));
            iterator.remove();
        }
        if (!missedPaths.isEmpty() && pathsToCopy.isEmpty()) {
            throw new GWTJahiaServiceException(StringUtils.join(missedPaths, (String)"\n"));
        }
        try {
            JCRCallback<List<String>> callback = new JCRCallback<List<String>>(){

                @Override
                public List<String> doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    ArrayList<String> res = new ArrayList<String>();
                    JCRNodeWrapper targetNode = session.getNode(destinationPath);
                    JCRNodeWrapper targetParent = moveOnTop ? targetNode.getParent() : targetNode;
                    for (String aNode : pathsToCopy) {
                        JCRNodeWrapper node = session.getNode(aNode);
                        String name = newName != null ? newName : node.getName();
                        try {
                            name = ContentManagerHelper.this.findAvailableName(targetParent, name);
                            if (targetParent.hasPermission("jcr:addChildNodes") && !targetParent.isLocked()) {
                                JCRNodeWrapper copy = ContentManagerHelper.this.doPaste(targetParent, node, name, cut, reference, childNodeTypesToSkip);
                                if (moveOnTop && targetParent.getPrimaryNodeType().hasOrderableChildNodes()) {
                                    targetParent.orderBefore(name, targetNode.getName());
                                }
                                session.save();
                                res.add(copy.getIdentifier());
                                continue;
                            }
                            missedPaths.add("File " + name + " could not be referenced in " + targetParent.getPath());
                        }
                        catch (RepositoryException e) {
                            logger.error("Exception", (Throwable)e);
                            missedPaths.add("File " + name + " could not be referenced in " + targetParent.getPath());
                        }
                        catch (JahiaException e) {
                            logger.error("Exception", (Throwable)e);
                            missedPaths.add("File " + name + " could not be referenced in " + targetParent.getPath());
                        }
                    }
                    return res;
                }
            };
            List<String> uuids = allLanguages ? JCRTemplate.getInstance().doExecute(currentUserSession.getUser(), currentUserSession.getWorkspace().getName(), null, callback) : (List<String>)callback.doInJCR(currentUserSession);
            if (missedPaths.size() > 0) {
                StringBuilder errors = new StringBuilder("The following files could not have their reference pasted:");
                for (String err : missedPaths) {
                    errors.append("\n").append(err);
                }
                throw new GWTJahiaServiceException(errors.toString());
            }
            for (String uuid : uuids) {
                res.add(this.navigation.getGWTJahiaNode(currentUserSession.getNodeByUUID(uuid), COPIED_NODE_FIELDS));
            }
        }
        catch (RepositoryException e) {
            throw new GWTJahiaServiceException((Throwable)e);
        }
        return res;
    }

    private JCRNodeWrapper doPaste(JCRNodeWrapper targetNode, JCRNodeWrapper node, String name, boolean cut, boolean reference, List<String> childNodeTypesToSkip) throws RepositoryException, JahiaException {
        block10: {
            JCRSiteNode targetSite;
            block11: {
                block12: {
                    block13: {
                        block9: {
                            targetNode.checkout();
                            if (!cut) break block9;
                            node.getSession().checkout(node);
                            node.getParent().getSession().checkout(node.getParent());
                            targetNode.getSession().move(node.getPath(), targetNode.getPath() + "/" + name);
                            break block10;
                        }
                        if (!reference) break block11;
                        targetNode.getSession().checkout(targetNode);
                        if (!targetNode.getPrimaryNodeTypeName().equals("jnt:members")) break block12;
                        if (!node.getPrimaryNodeTypeName().equals("jnt:user")) break block13;
                        JCRNodeWrapper member = targetNode.addNode(name, "jnt:member");
                        member.setProperty("j:member", node.getIdentifier());
                        break block10;
                    }
                    if (!node.getPrimaryNodeTypeName().equals("jnt:group")) break block10;
                    JCRNodeWrapper node1 = node.getParent().getParent();
                    String id = "systemsite";
                    if (node1 != null && node1.getPrimaryNodeType().getName().equals("jnt:virtualsite")) {
                        id = this.sitesService.getSiteByKey(node1.getName()).getSiteKey();
                    }
                    name = name + "___" + id;
                    JCRNodeWrapper member = targetNode.addNode(name, "jnt:member");
                    member.setProperty("j:member", node.getIdentifier());
                    break block10;
                }
                JCRNodeWrapper ref = targetNode.addNode(name, "jnt:contentReference");
                ref.setProperty("j:node", node.getIdentifier());
                break block10;
            }
            JCRSiteNode sourceSite = node.getResolveSite();
            if (!sourceSite.equals(targetSite = targetNode.getResolveSite())) {
                JCRSessionWrapper session = node.getSession();
                QueryWrapper q = session.getWorkspace().getQueryManager().createQuery("select * from [jnt:template] as t where isdescendantnode(t, ['" + JCRContentUtils.sqlEncode(sourceSite.getPath()) + "/templates'])", "JCR-SQL2");
                NodeIterator ni = q.execute().getNodes();
                while (ni.hasNext()) {
                    JCRNodeWrapper next = (JCRNodeWrapper)ni.next();
                    try {
                        session.getUuidMapping().put(next.getIdentifier(), session.getNode(targetSite.getPath() + StringUtils.substringAfter((String)next.getPath(), (String)sourceSite.getPath())).getIdentifier());
                    }
                    catch (RepositoryException e) {
                        logger.debug("No matching template for copy", (Throwable)e);
                    }
                }
            }
            if (childNodeTypesToSkip == null) {
                node.copy(targetNode, name, true, null, SettingsBean.getInstance().getImportMaxBatch());
            } else {
                String newName = JCRContentUtils.findAvailableNodeName(targetNode, name);
                JCRNodeWrapper newNode = targetNode.addNode(newName, node.getPrimaryNodeTypeName());
                for (ExtendedNodeType mixin : node.getMixinNodeTypes()) {
                    if (Constants.forbiddenMixinToCopy.contains(mixin.getName())) continue;
                    newNode.addMixin(mixin.getName());
                }
                HashMap<String, List<String>> references = new HashMap<String, List<String>>();
                node.copyProperties(newNode, references);
                ReferencesHelper.resolveCrossReferences(node.getSession(), references, false);
                for (JCRNodeWrapper childNode : node.getNodes()) {
                    childNode.copy(newNode, childNode.getName(), true, childNodeTypesToSkip, SettingsBean.getInstance().getImportMaxBatch());
                }
            }
        }
        return targetNode.getNode(name);
    }

    public void deletePaths(List<String> paths, boolean permanentlyDelete, String comment, JahiaUser user, JCRSessionWrapper currentUserSession, Locale uiLocale) throws GWTJahiaServiceException {
        ArrayList<String> missedPaths = new ArrayList<String>();
        for (String path : paths) {
            JCRNodeWrapper nodeToDelete = null;
            try {
                nodeToDelete = currentUserSession.getNode(path);
                if (!currentUserSession.getUserNode().isRoot() && nodeToDelete.isLocked() && !nodeToDelete.getLockOwner().equals(user.getUsername())) {
                    if (nodeToDelete.isNodeType("jmix:markedForDeletionRoot") && nodeToDelete.hasPermission("{http://www.jcp.org/jcr/1.0}removeNode")) {
                        nodeToDelete.unmarkForDeletion();
                    } else {
                        missedPaths.add(nodeToDelete.getPath() + " - locked by " + nodeToDelete.getLockOwner());
                    }
                }
                if (!nodeToDelete.hasPermission("{http://www.jcp.org/jcr/1.0}removeNode")) {
                    missedPaths.add(nodeToDelete.getPath() + " - ACCESS DENIED");
                    continue;
                }
                if (this.getRecursedLocksAndFileUsages(nodeToDelete, missedPaths, user.getUsername())) continue;
                if (!permanentlyDelete && this.supportsMarkingForDeletion(nodeToDelete)) {
                    nodeToDelete.markForDeletion(comment);
                } else {
                    nodeToDelete.getParent().getSession().checkout(nodeToDelete.getParent());
                    nodeToDelete.remove();
                }
                nodeToDelete.saveSession();
            }
            catch (PathNotFoundException e) {
                missedPaths.add(path + Messages.getInternal("label.gwt.error.could.not.be.accessed", uiLocale) + e.toString());
            }
            catch (AccessDeniedException e) {
                missedPaths.add((nodeToDelete != null ? nodeToDelete.getPath() : "") + " - ACCESS DENIED");
            }
            catch (ReferentialIntegrityException e) {
                missedPaths.add((nodeToDelete != null ? nodeToDelete.getPath() : "") + " - is in use");
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new GWTJahiaServiceException((Throwable)e);
            }
        }
        if (missedPaths.size() > 0) {
            StringBuilder errors = new StringBuilder(Messages.getInternal("label.error.nodes.not.deleted", uiLocale, "The following nodes could not be deleted:"));
            for (String err : missedPaths) {
                errors.append("\n").append(err);
            }
            throw new GWTJahiaServiceException(errors.toString());
        }
    }

    public void undeletePaths(List<String> paths, JahiaUser user, JCRSessionWrapper currentUserSession, Locale uiLocale) throws GWTJahiaServiceException {
        ArrayList<String> missedPaths = new ArrayList<String>();
        for (String path : paths) {
            JCRNodeWrapper nodeToUndelete = null;
            try {
                nodeToUndelete = currentUserSession.getNode(path);
                if (!nodeToUndelete.hasPermission("{http://www.jcp.org/jcr/1.0}removeNode")) {
                    missedPaths.add(nodeToUndelete.getPath() + " - ACCESS DENIED");
                    continue;
                }
                nodeToUndelete.unmarkForDeletion();
                nodeToUndelete.saveSession();
            }
            catch (PathNotFoundException e) {
                missedPaths.add(path + Messages.getInternal("label.gwt.error.could.not.be.accessed", uiLocale) + e.toString());
            }
            catch (AccessDeniedException e) {
                missedPaths.add((nodeToUndelete != null ? nodeToUndelete.getPath() : "") + " - ACCESS DENIED");
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new GWTJahiaServiceException((Throwable)e);
            }
        }
        if (missedPaths.size() > 0) {
            StringBuilder errors = new StringBuilder(Messages.getInternal("label.error.nodes.not.deleted", uiLocale, "The following nodes could not be undeleted:"));
            for (String err : missedPaths) {
                errors.append("\n").append(err);
            }
            throw new GWTJahiaServiceException(errors.toString());
        }
    }

    private boolean supportsMarkingForDeletion(JCRNodeWrapper nodeToDelete) throws RepositoryException {
        return nodeToDelete.canMarkForDeletion();
    }

    public GWTJahiaNode rename(String path, String newName, JCRSessionWrapper currentUserSession, Locale uiLocale) throws GWTJahiaServiceException {
        JCRNodeWrapper node;
        try {
            node = currentUserSession.getNode(path);
        }
        catch (RepositoryException e) {
            logger.error(e.toString(), (Throwable)e);
            throw new GWTJahiaServiceException(path + Messages.getInternal("label.gwt.error.could.not.be.accessed", uiLocale) + e.toString());
        }
        try {
            if (node.isLocked() && !node.getLockOwner().equals(currentUserSession.getUser().getName())) {
                throw new GWTJahiaServiceException(node.getName() + Messages.getInternal("label.gwt.error.locked.by", uiLocale) + currentUserSession.getUser().getName());
            }
            if (!node.hasPermission("{http://www.jcp.org/jcr/1.0}write")) {
                throw new GWTJahiaServiceException(node.getName() + " - ACCESS DENIED");
            }
            if (!node.rename(JCRContentUtils.escapeLocalNodeName(newName))) {
                throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.could.not.rename", uiLocale, node.getName(), newName));
            }
        }
        catch (ItemExistsException e) {
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.already.exists", uiLocale, newName));
        }
        catch (ConstraintViolationException e) {
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.could.not.rename", uiLocale, node.getName(), newName) + ". " + Messages.getInternal("label.cause", uiLocale) + ": " + e.getLocalizedMessage());
        }
        catch (RepositoryException e) {
            logger.error(e.toString(), (Throwable)e);
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.could.not.rename", uiLocale, node.getName(), newName));
        }
        try {
            node.saveSession();
            return this.navigation.getGWTJahiaNode(currentUserSession.getNode(node.getPath()), NEW_NODE_FIELDS);
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new GWTJahiaServiceException("Could not save file " + node.getName() + " into " + newName);
        }
    }

    public void importContent(String parentPath, String fileKey, JCRSessionWrapper session, Locale uiLocale) throws GWTJahiaServiceException {
        this.importContent(parentPath, fileKey, false, session, uiLocale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importContent(String parentPath, String fileKey, boolean replaceContent, JCRSessionWrapper session, Locale uiLocale) throws GWTJahiaServiceException {
        block15: {
            try {
                ValidationResults results;
                GWTFileManagerUploadServlet.Item item = GWTFileManagerUploadServlet.getItem(fileKey);
                ImportExportBaseService importExport = ServicesRegistry.getInstance().getImportExportService();
                JCRNodeWrapper parent = session.getNode(parentPath);
                JCRSiteNode resolveSite = parent.getResolveSite();
                String detectedContentType = ImportExportBaseService.detectImportContentType(item);
                InputStream itemStream = null;
                try {
                    itemStream = item.getStream();
                    results = importExport.validateImportFile(session, itemStream, detectedContentType, resolveSite != null ? resolveSite.getInstalledModules() : null);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)itemStream);
                }
                if (results.isSuccessful()) {
                    try {
                        JCRNodeWrapper privateFilesFolder = JCRContentUtils.getInstance().getUserPrivateFilesFolder(session);
                        String importFilename = "import" + Math.random() * 1000.0;
                        itemStream = item.getStream();
                        JCRNodeWrapper jcrNodeWrapper = privateFilesFolder.uploadFile(importFilename, itemStream, detectedContentType);
                        session.save();
                        JobDetail jobDetail = BackgroundJob.createJahiaJob(Messages.getInternal("import.file", uiLocale, "Import file") + " " + FilenameUtils.getName((String)item.getOriginalFileName()), ImportJob.class);
                        JobDataMap jobDataMap = jobDetail.getJobDataMap();
                        jobDataMap.put("destParentPath", parentPath);
                        jobDataMap.put("uri", jcrNodeWrapper.getPath());
                        jobDataMap.put("filename", FilenameUtils.getName((String)item.getOriginalFileName()));
                        jobDataMap.put("replaceContent", replaceContent);
                        ServicesRegistry.getInstance().getSchedulerService().scheduleJobNow(jobDetail);
                        break block15;
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)itemStream);
                    }
                }
                StringBuilder buffer = new StringBuilder();
                for (ValidationResult result : results.getResults()) {
                    if (result.isSuccessful()) continue;
                    if (result instanceof MissingModulesValidationResult) {
                        MissingModulesValidationResult missingModule = (MissingModulesValidationResult)result;
                        if (missingModule.isTargetTemplateSetPresent()) {
                            buffer.append(Messages.getInternalWithArguments("failure.import.missingTemplateSet", uiLocale, missingModule.getTargetTemplateSet()));
                        }
                        if (missingModule.getMissingModules().isEmpty()) continue;
                        buffer.append(Messages.getInternalWithArguments("failure.import.missingModules", uiLocale, missingModule.getMissingModules().size())).append(missingModule.getMissingModules());
                        continue;
                    }
                    if (result instanceof MissingNodetypesValidationResult) {
                        buffer.append(Messages.getInternalWithArguments("failure.import.missingNodetypes", uiLocale, ((MissingNodetypesValidationResult)result).getMissingNodetypes(), ((MissingNodetypesValidationResult)result).getMissingMixins()));
                        continue;
                    }
                    if (!(result instanceof MissingTemplatesValidationResult)) continue;
                    MissingTemplatesValidationResult missingTemplates = (MissingTemplatesValidationResult)result;
                    buffer.append(Messages.getInternalWithArguments("failure.import.missingTemplates", uiLocale, missingTemplates.getMissingTemplates().size())).append(missingTemplates.getMissingTemplates().keySet());
                }
                throw new GWTJahiaServiceException(buffer.toString());
            }
            catch (GWTJahiaServiceException e) {
                throw e;
            }
            catch (Exception e) {
                logger.error("Error when importing", (Throwable)e);
                throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.could.not.import", uiLocale, e.getLocalizedMessage()));
            }
        }
    }

    public GWTJahiaNodeACL getACL(String path, boolean newAcl, JCRSessionWrapper currentUserSession, Locale uiLocale) throws GWTJahiaServiceException {
        JCRNodeWrapper node;
        try {
            node = currentUserSession.getNode(path);
        }
        catch (RepositoryException e) {
            logger.error(e.toString(), (Throwable)e);
            throw new GWTJahiaServiceException(path + Messages.getInternal("label.gwt.error.could.not.be.accessed", uiLocale) + e.toString());
        }
        Map<String, List<String[]>> m = node.getAclEntries();
        GWTJahiaNodeACL acl = new GWTJahiaNodeACL();
        try {
            String role;
            String aclType;
            String pathFrom;
            Map<String, List<JCRNodeWrapper>> roles = node.getAvailableRoles();
            HashMap dependencies = new HashMap();
            HashMap availablePermissions = new HashMap();
            HashSet<String> allAvailablePermissions = new HashSet<String>();
            HashMap<String, String> labels = new HashMap<String, String>();
            HashMap<String, String> tooltips = new HashMap<String, String>();
            for (Map.Entry<String, List<JCRNodeWrapper>> entry : roles.entrySet()) {
                availablePermissions.put(entry.getKey(), new ArrayList());
                for (JCRNodeWrapper nodeWrapper : entry.getValue()) {
                    String nodeName = nodeWrapper.getName();
                    allAvailablePermissions.add(nodeName);
                    ((List)availablePermissions.get(entry.getKey())).add(nodeName);
                    String label = nodeWrapper.getDisplayableName();
                    labels.put(nodeName, StringUtils.isEmpty((String)label) ? nodeName : label);
                    if (nodeWrapper.hasProperty("jcr:description")) {
                        tooltips.put(nodeName, nodeWrapper.getProperty("jcr:description").getString());
                    }
                    ArrayList<String> d = new ArrayList<String>();
                    if (nodeWrapper.hasProperty("j:dependencies")) {
                        for (JCRValueWrapper value : nodeWrapper.getProperty("j:dependencies").getValues()) {
                            d.add(value.getNode().getName());
                        }
                    }
                    dependencies.put(nodeName, d);
                }
            }
            acl.setAvailableRoles(availablePermissions);
            acl.setRolesLabels(labels);
            acl.setRolesTooltips(tooltips);
            acl.setRoleDependencies(dependencies);
            ArrayList<GWTJahiaNodeACE> aces = new ArrayList<GWTJahiaNodeACE>();
            HashMap<String, GWTJahiaNodeACE> map = new HashMap<String, GWTJahiaNodeACE>();
            JahiaGroupManagerService groupManagerService = ServicesRegistry.getInstance().getJahiaGroupManagerService();
            for (String principal : m.keySet()) {
                GWTJahiaNodeACE ace = new GWTJahiaNodeACE();
                ace.setPrincipalType(principal.charAt(0));
                ace.setPrincipal(principal.substring(2));
                if (ace.getPrincipalType() == 'g') {
                    JCRGroupNode g = groupManagerService.lookupGroup(node.getResolveSite().getSiteKey(), ace.getPrincipal());
                    if (g == null) {
                        g = groupManagerService.lookupGroup(null, ace.getPrincipal());
                    }
                    if (g == null) continue;
                    ace.setHidden(g.isHidden());
                    ace.setPrincipalKey(g.getPath());
                    String groupName = PrincipalViewHelper.getDisplayName(g, uiLocale);
                    ace.setPrincipalDisplayName(groupName);
                } else {
                    JCRUserNode u = ServicesRegistry.getInstance().getJahiaUserManagerService().lookupUser(ace.getPrincipal(), node.getResolveSite().getName());
                    if (u == null) continue;
                    ace.setPrincipalKey(u.getPath());
                    String userName = PrincipalViewHelper.getDisplayName(u, uiLocale);
                    ace.setPrincipalDisplayName(userName);
                }
                map.put(principal, ace);
                List<String[]> st = m.get(principal);
                HashMap<String, Boolean> perms = new HashMap<String, Boolean>();
                HashMap<String, Boolean> inheritedPerms = new HashMap<String, Boolean>();
                String inheritedFrom = null;
                for (String[] strings : st) {
                    pathFrom = strings[0];
                    aclType = strings[1];
                    if (!aclType.equals("GRANT") && !aclType.equals("DENY")) continue;
                    role = strings[2];
                    if (!newAcl && path.equals(pathFrom)) {
                        perms.put(role, aclType.equals("GRANT"));
                        continue;
                    }
                    if (inheritedPerms.containsKey(role)) continue;
                    if (inheritedFrom == null || inheritedFrom.length() < pathFrom.length()) {
                        inheritedFrom = pathFrom;
                    }
                    inheritedPerms.put(role, aclType.equals("GRANT"));
                }
                if (CollectionUtils.intersection(allAvailablePermissions, inheritedPerms.keySet()).isEmpty() && CollectionUtils.intersection(allAvailablePermissions, perms.keySet()).isEmpty()) continue;
                aces.add(ace);
                ace.setInheritedFrom(inheritedFrom);
                ace.setInheritedRoles(inheritedPerms);
                ace.setRoles(perms);
                ace.setInherited(perms.isEmpty());
            }
            boolean aclInheritanceBreak = node.getAclInheritanceBreak();
            acl.setBreakAllInheritance(aclInheritanceBreak);
            if (aclInheritanceBreak) {
                m = node.getParent().getAclEntries();
                for (String principal : m.keySet()) {
                    GWTJahiaNodeACE ace = (GWTJahiaNodeACE)map.get(principal);
                    if (ace == null) {
                        ace = new GWTJahiaNodeACE();
                        map.put(principal, ace);
                        aces.add(ace);
                        ace.setPrincipalType(principal.charAt(0));
                        ace.setPrincipal(principal.substring(2));
                        if (ace.getPrincipalType() == 'g') {
                            JCRGroupNode g = groupManagerService.lookupGroup(node.getResolveSite().getSiteKey(), ace.getPrincipal());
                            if (g == null) {
                                g = groupManagerService.lookupGroup(null, ace.getPrincipal());
                            }
                            if (g != null) {
                                ace.setHidden(g.isHidden());
                                String groupName = PrincipalViewHelper.getDisplayName(g, uiLocale);
                                ace.setPrincipalKey(g.getPath());
                                ace.setPrincipalDisplayName(groupName);
                            }
                        } else {
                            JCRUserNode u = ServicesRegistry.getInstance().getJahiaUserManagerService().lookupUser(ace.getPrincipal(), node.getResolveSite().getName());
                            if (u != null) {
                                ace.setPrincipalKey(u.getPath());
                                String userName = PrincipalViewHelper.getDisplayName(u, uiLocale);
                                ace.setPrincipalDisplayName(userName);
                            }
                        }
                        ace.setRoles(new HashMap());
                    }
                    HashMap<String, Boolean> inheritedPerms = new HashMap<String, Boolean>();
                    List<String[]> st = m.get(principal);
                    String inheritedFrom = null;
                    for (String[] strings : st) {
                        pathFrom = strings[0];
                        aclType = strings[1];
                        if (!aclType.equals("GRANT") && !aclType.equals("DENY") || inheritedPerms.containsKey(role = strings[2])) continue;
                        if (inheritedFrom == null || inheritedFrom.length() < pathFrom.length()) {
                            inheritedFrom = pathFrom;
                        }
                        inheritedPerms.put(role, aclType.equals("GRANT"));
                    }
                    ace.setInheritedFrom(inheritedFrom);
                    ace.setInheritedRoles(inheritedPerms);
                }
            }
            acl.setAce(aces);
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return acl;
    }

    public void setACL(String uuid, GWTJahiaNodeACL acl, JCRSessionWrapper currentUserSession) throws GWTJahiaServiceException {
        JCRNodeWrapper node;
        try {
            node = currentUserSession.getNodeByUUID(uuid);
            if (!node.isCheckedOut()) {
                currentUserSession.checkout(node);
            }
        }
        catch (RepositoryException e) {
            logger.error(e.toString(), (Throwable)e);
            throw new GWTJahiaServiceException(uuid + " could not be accessed :\n" + e.toString());
        }
        GWTJahiaNodeACL oldAcl = this.getACL(node.getPath(), false, currentUserSession, null);
        if (oldAcl.equals((Object)acl)) {
            return;
        }
        try {
            HashMap<String, GWTJahiaNodeACE> oldPrincipals = new HashMap<String, GWTJahiaNodeACE>();
            for (GWTJahiaNodeACE ace : oldAcl.getAce()) {
                if (ace.getRoles().isEmpty()) continue;
                oldPrincipals.put(ace.getPrincipalType() + ":" + ace.getPrincipal(), ace);
            }
            for (GWTJahiaNodeACE ace : acl.getAce()) {
                String user = ace.getPrincipalType() + ":" + ace.getPrincipal();
                if (ace.getRoles().isEmpty()) continue;
                HashMap<String, String> perms = new HashMap<String, String>();
                GWTJahiaNodeACE oldAce = (GWTJahiaNodeACE)oldPrincipals.get(user);
                if (ace.equals((Object)oldAce)) continue;
                for (Map.Entry entry : ace.getRoles().entrySet()) {
                    if (((Boolean)entry.getValue()).equals(Boolean.TRUE) && (!Boolean.TRUE.equals(ace.getInheritedRoles().get(entry.getKey())) || acl.isBreakAllInheritance())) {
                        perms.put((String)entry.getKey(), "GRANT");
                        continue;
                    }
                    if (((Boolean)entry.getValue()).equals(Boolean.FALSE) && (Boolean.TRUE.equals(ace.getInheritedRoles().get(entry.getKey())) || acl.isBreakAllInheritance())) {
                        perms.put((String)entry.getKey(), "DENY");
                        continue;
                    }
                    perms.put((String)entry.getKey(), "REMOVE");
                }
                for (Map.Entry entry : ace.getInheritedRoles().entrySet()) {
                    if (((Boolean)entry.getValue()).booleanValue() || perms.containsKey(entry.getKey())) continue;
                    perms.put((String)entry.getKey(), "REMOVE");
                }
                node.changeRoles(user, perms);
            }
            node.setAclInheritanceBreak(acl.isBreakAllInheritance());
        }
        catch (RepositoryException e) {
            logger.error("Error while saving acl on node " + node.getPath(), (Throwable)e);
            throw new GWTJahiaServiceException("Could not save acl on node " + node.getPath());
        }
    }

    private boolean getRecursedLocksAndFileUsages(JCRNodeWrapper nodeToDelete, List<String> lockedNodes, String username) throws GWTJahiaServiceException {
        try {
            Set<JCRNodeLockType> lockTypes;
            JCRNodeIteratorWrapper iterator = nodeToDelete.getNodes();
            while (iterator.hasNext()) {
                JCRNodeWrapper child = (JCRNodeWrapper)iterator.next();
                this.getRecursedLocksAndFileUsages(child, lockedNodes, username);
                if (lockedNodes.size() < 10) continue;
                return true;
            }
            if (!(!nodeToDelete.isLocked() || nodeToDelete.getLockOwner().equals(username) || (lockTypes = JCRContentUtils.getLockTypes(nodeToDelete.getLockInfos())).size() == 1 && lockTypes.contains((Object)JCRNodeLockType.DELETION))) {
                lockedNodes.add(nodeToDelete.getPath() + " - locked by " + nodeToDelete.getLockOwner());
            }
        }
        catch (RepositoryException e) {
            throw new GWTJahiaServiceException("Cannot get lock information", (Throwable)e);
        }
        return !lockedNodes.isEmpty();
    }

    public void clearAllLocks(String path, boolean processChildNodes, JCRSessionWrapper currentUserSession, Locale uiLocale) throws GWTJahiaServiceException {
        try {
            if (!currentUserSession.getUserNode().isRoot()) {
                logger.error("Error when clearing all locks on node " + path);
                throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.when.clearing.all.locks.on.node", uiLocale, path, currentUserSession.getUser().getUserKey()));
            }
            JCRContentUtils.clearAllLocks(path, processChildNodes, currentUserSession.getWorkspace().getName());
        }
        catch (RepositoryException e) {
            logger.error("Repository error when clearing all locks on node " + path, (Throwable)e);
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.when.clearing.all.locks.on.node", uiLocale, path, currentUserSession.getUser().getUserKey()));
        }
    }

    public void setLock(List<String> paths, boolean toLock, JCRSessionWrapper currentUserSession) throws GWTJahiaServiceException {
        JahiaUser user = currentUserSession.getUser();
        ArrayList<String> missedPaths = new ArrayList<String>();
        ArrayList<JCRNodeWrapper> nodes = new ArrayList<JCRNodeWrapper>();
        for (String path : paths) {
            try {
                JCRNodeWrapper node = currentUserSession.getNode(path);
                this.addSub(nodes, node);
            }
            catch (RepositoryException e) {
                logger.error(e.toString(), (Throwable)e);
                missedPaths.add(path + " could not be accessed : " + e.toString());
            }
        }
        for (JCRNodeWrapper node : nodes) {
            try {
                if (!node.hasPermission("{http://www.jcp.org/jcr/1.0}lockManagement")) {
                    missedPaths.add(node.getName() + ": write access denied");
                    continue;
                }
                if (node.getLockedLocales().contains(currentUserSession.getLocale()) || node.getLockedLocales().isEmpty() && node.isLocked()) {
                    if (!toLock) {
                        try {
                            node.unlock("user");
                        }
                        catch (LockException e) {
                            logger.error(e.toString(), (Throwable)e);
                            missedPaths.add(node.getName() + ": repository exception");
                        }
                        continue;
                    }
                    String lockOwner = node.getLockOwner();
                    if (lockOwner == null || lockOwner.equals(user.getName())) continue;
                    missedPaths.add(node.getName() + ": locked by " + lockOwner);
                    continue;
                }
                if (toLock) {
                    if (node.lockAndStoreToken("user")) continue;
                    missedPaths.add(node.getName() + ": repository exception");
                    continue;
                }
                if (!node.isLocked()) continue;
                node.unlock("user");
            }
            catch (RepositoryException e) {
                logger.error(e.toString(), (Throwable)e);
                missedPaths.add(node.getName() + ": repository exception");
            }
        }
        try {
            currentUserSession.save();
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new GWTJahiaServiceException("Could not save session");
        }
        if (missedPaths.size() > 0) {
            StringBuilder errors = new StringBuilder("The following files could not be ").append(toLock ? "locked:" : "unlocked:");
            for (String missedPath : missedPaths) {
                errors.append("\n").append(missedPath);
            }
            throw new GWTJahiaServiceException(errors.toString());
        }
    }

    private void addSub(List<JCRNodeWrapper> nodes, JCRNodeWrapper node) throws RepositoryException {
        if (!nodes.contains(node)) {
            nodes.add(node);
        }
        JCRNodeIteratorWrapper ni = node.getNodes();
        while (ni.hasNext()) {
            JCRNodeWrapper subNode = (JCRNodeWrapper)ni.next();
            if (!subNode.isNodeType("jnt:content")) continue;
            this.addSub(nodes, subNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadedFile(String location, String tmpName, int operation, String newName, JCRSessionWrapper currentUserSession, Locale uiLocale) throws GWTJahiaServiceException {
        try {
            JCRNodeWrapper parent = currentUserSession.getNode(location);
            if (2 == operation) {
                JCRNodeWrapper node = parent.getNode(newName);
                if (node == null) {
                    throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.new.version.file.not.found", uiLocale, location, newName));
                }
                this.versioning.addNewVersionFile(node, tmpName);
            } else {
                if (1 == operation) {
                    newName = this.findAvailableName(parent, newName);
                }
                if (parent.hasNode(newName)) {
                    throw new GWTJahiaServiceException(Messages.getInternal("label.gwt.error.file.exists", uiLocale));
                }
                GWTFileManagerUploadServlet.Item item = GWTFileManagerUploadServlet.getItem(tmpName);
                InputStream is = null;
                try {
                    is = item.getStream();
                    parent.uploadFile(newName, is, JCRContentUtils.getMimeType(newName, item.getContentType()));
                }
                catch (FileNotFoundException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)is);
                    item.dispose();
                }
            }
            currentUserSession.save();
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void markConflictAsResolved(String moduleId, GWTJahiaNode node, JCRSessionWrapper session) throws IOException, RepositoryException, BundleException {
        JahiaTemplatesPackage templatePackage = this.templateManagerService.getTemplatePackageById(moduleId);
        SourceControlManagement sourceControl = templatePackage.getSourceControl();
        if (sourceControl != null) {
            String path = node.getPath();
            path = path.substring(path.indexOf("/sources/") + "/sources".length());
            String sourcesFolderPath = templatePackage.getSourcesFolder().getAbsolutePath();
            sourceControl.markConflictAsResolved(new File(sourcesFolderPath + path));
        }
    }

    public GWTJahiaNode sendToSourceControl(String moduleId, String scmURI, String scmType, JCRSessionWrapper session) throws IOException, RepositoryException {
        this.templateManagerService.sendToSourceControl(moduleId, scmURI, scmType, session);
        return this.navigation.getGWTJahiaNode(session.getNode("/modules/" + moduleId), GWTJahiaNode.DEFAULT_SITE_FIELDS);
    }

    public List<GWTJahiaContentHistoryEntry> getContentHistory(JCRSessionWrapper session, String nodeIdentifier, int offset, int limit) throws RepositoryException {
        JCRNodeWrapper node = session.getNodeByIdentifier(nodeIdentifier);
        List<HistoryEntry> historyEntryList = this.contentHistoryService.getNodeHistory(node, true);
        ArrayList<GWTJahiaContentHistoryEntry> result = new ArrayList<GWTJahiaContentHistoryEntry>();
        for (HistoryEntry historyEntry : historyEntryList) {
            result.add(this.convertToGWTJahiaContentHistoryEntry(historyEntry));
        }
        Collections.sort(result, new Comparator<GWTJahiaContentHistoryEntry>(){

            @Override
            public int compare(GWTJahiaContentHistoryEntry o1, GWTJahiaContentHistoryEntry o2) {
                return o2.compareTo(o1);
            }
        });
        return result;
    }

    private GWTJahiaContentHistoryEntry convertToGWTJahiaContentHistoryEntry(HistoryEntry historyEntry) {
        String languageCode = null;
        if (historyEntry.getLocale() != null) {
            languageCode = historyEntry.getLocale().toString();
        }
        return new GWTJahiaContentHistoryEntry(historyEntry.getDate() > 0L ? new Date(historyEntry.getDate()) : null, historyEntry.getAction(), historyEntry.getPropertyName(), historyEntry.getUserKey(), historyEntry.getPath(), historyEntry.getMessage(), languageCode);
    }

    public void deleteReferences(String path, JahiaUser user, JCRSessionWrapper currentUserSession, Locale uiLocale) throws GWTJahiaServiceException {
        ArrayList<String> missedPaths = new ArrayList<String>();
        try {
            JCRNodeWrapper referencedNode = currentUserSession.getNode(path);
            if (referencedNode != null) {
                if (!currentUserSession.getUserNode().isRoot() && referencedNode.isLocked() && !referencedNode.getLockOwner().equals(user.getUsername())) {
                    missedPaths.add(referencedNode.getPath() + " - locked by " + referencedNode.getLockOwner());
                }
                if (!referencedNode.hasPermission("{http://www.jcp.org/jcr/1.0}removeNode")) {
                    missedPaths.add(referencedNode.getPath() + " - ACCESS DENIED");
                } else if (!this.getRecursedLocksAndFileUsages(referencedNode, missedPaths, user.getUsername())) {
                    try {
                        String referenceToRemove = referencedNode.getIdentifier();
                        PropertyIterator r = referencedNode.getWeakReferences();
                        while (r.hasNext()) {
                            JCRPropertyWrapper reference = (JCRPropertyWrapper)r.next();
                            if (reference.getPath().startsWith("/referencesKeeper")) continue;
                            if (!reference.getDefinition().isMandatory()) {
                                if (reference.getDefinition().isMultiple()) {
                                    JCRValueWrapper[] values = reference.getValues();
                                    if (values.length > 1) {
                                        Value[] valuesCopy = new Value[values.length - 1];
                                        int i = 0;
                                        for (JCRValueWrapper value : values) {
                                            if (value.getString().equals(referenceToRemove)) continue;
                                            valuesCopy[i++] = value;
                                        }
                                        reference.setValue(valuesCopy);
                                        continue;
                                    }
                                    reference.remove();
                                    continue;
                                }
                                reference.remove();
                                continue;
                            }
                            missedPaths.add(referencedNode.getPath() + " - is use in a mandatory property of " + reference.getParent().getPath());
                        }
                        currentUserSession.save();
                    }
                    catch (AccessDeniedException e) {
                        missedPaths.add(referencedNode.getPath() + " - ACCESS DENIED");
                    }
                    catch (ReferentialIntegrityException e) {
                        missedPaths.add(referencedNode.getPath() + " - is in use");
                    }
                    catch (RepositoryException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        missedPaths.add(referencedNode.getPath() + " - UNSUPPORTED");
                    }
                }
            }
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            missedPaths.add(path + Messages.getInternal("label.gwt.error.could.not.be.accessed", uiLocale) + e.toString());
        }
        if (missedPaths.size() > 0) {
            StringBuilder errors = new StringBuilder(Messages.getInternal("label.error.nodes.not.deleted", uiLocale));
            for (String err : missedPaths) {
                errors.append("\n").append(err);
            }
            throw new GWTJahiaServiceException(errors.toString());
        }
    }

    public void saveVisibilityConditions(GWTJahiaNode node, List<GWTJahiaNode> conditions, JCRSessionWrapper session, Locale uiLocale) throws GWTJahiaServiceException {
        try {
            JCRNodeWrapper parent = session.getNode(node.getPath());
            if (!conditions.isEmpty() && !parent.hasNode("j:conditionalVisibility")) {
                parent.addNode("j:conditionalVisibility", "jnt:conditionalVisibility");
            }
            String path = node.getPath() + "/" + "j:conditionalVisibility";
            for (GWTJahiaNode condition : conditions) {
                List props = (List)condition.get("gwtproperties");
                if (condition.get("new-node") != null) {
                    GWTJahiaNode n = this.createNode(path, condition.getName(), (String)condition.getNodeTypes().get(0), new ArrayList<String>(), props, session, uiLocale, null, true);
                    condition.setUUID(n.getUUID());
                    condition.setPath(n.getPath());
                    continue;
                }
                JCRNodeWrapper jcrCondition = session.getNode(condition.getPath());
                this.properties.setProperties(jcrCondition, props);
            }
            try {
                session.save();
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.occur.when.trying.to.save.the.node", uiLocale, node.getPath() + " (saveVisibilityConditions)"));
            }
            for (GWTJahiaNode condition : conditions) {
                if (condition.get("node-removed") == null) continue;
                JCRNodeWrapper jcrCondition = session.getNode(condition.getPath());
                jcrCondition.remove();
            }
            if (parent.hasNode("j:conditionalVisibility")) {
                JCRNodeWrapper wrapper = parent.getNode("j:conditionalVisibility");
                if (node.get("node-visibility-forceMatchAllConditions") != null) {
                    wrapper.setProperty("j:forceMatchAllConditions", (Boolean)node.get("node-visibility-forceMatchAllConditions"));
                }
                if (!wrapper.hasNodes()) {
                    wrapper.markForDeletion("");
                }
            }
            session.save();
        }
        catch (RepositoryException e) {
            logger.error(e.toString(), (Throwable)e);
            throw new GWTJahiaServiceException((Throwable)e);
        }
    }
}

