/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spell;

import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.spell.Dictionary;
import org.apache.lucene.search.spell.SpellChecker;
import org.apache.lucene.search.spell.StringDistance;
import org.apache.lucene.search.spell.SuggestWord;
import org.apache.lucene.search.spell.SuggestWordQueue;
import org.apache.lucene.store.Directory;

public class JahiaExtendedSpellChecker
extends SpellChecker {
    public static final String F_LANGUAGE = "language".intern();
    public static final String F_SITE = "site".intern();
    private static final String F_WORD_INTERNED = "word".intern();
    private float minScore = 0.5f;
    private float bStart = 2.0f;
    private float bEnd = 1.0f;
    private IndexSearcher searcher;

    public JahiaExtendedSpellChecker(Directory spellIndex, StringDistance sd) throws IOException {
        super(spellIndex, sd);
    }

    public JahiaExtendedSpellChecker(Directory spellIndex) throws IOException {
        super(spellIndex);
    }

    public String[] suggestSimilar(String word, int numSug, IndexReader ir, String field, boolean morePopular, String site, String language) throws IOException {
        int goalFreq;
        float min = this.minScore;
        int lengthWord = word.length();
        int freq = ir != null && field != null ? ir.docFreq(new Term(field, word)) : 0;
        int n = goalFreq = morePopular && ir != null && field != null ? freq : 0;
        if (!morePopular && freq > 0) {
            return new String[]{word};
        }
        BooleanQuery query = new BooleanQuery();
        if (language != null) {
            JahiaExtendedSpellChecker.add(query, F_LANGUAGE, language, BooleanClause.Occur.MUST);
        }
        if (site != null) {
            JahiaExtendedSpellChecker.add(query, F_SITE, site, BooleanClause.Occur.MUST);
        }
        for (int ng = this.getMin(lengthWord); ng <= this.getMax(lengthWord); ++ng) {
            String key = "gram" + ng;
            String[] grams = JahiaExtendedSpellChecker.formGrams(word, ng);
            if (grams.length == 0) continue;
            if (this.bStart > 0.0f) {
                JahiaExtendedSpellChecker.add(query, "start" + ng, grams[0], this.bStart);
            }
            if (this.bEnd > 0.0f) {
                JahiaExtendedSpellChecker.add(query, "end" + ng, grams[grams.length - 1], this.bEnd);
            }
            for (int i = 0; i < grams.length; ++i) {
                JahiaExtendedSpellChecker.add(query, key, grams[i]);
            }
        }
        int maxHits = 10 * numSug;
        IndexSearcher usedSearcher = this.searcher;
        ScoreDoc[] hits = null;
        boolean retry = true;
        while (retry) {
            boolean useOtherSearcher = false;
            try {
                hits = usedSearcher.search((Query)query, (int)maxHits).scoreDocs;
            }
            catch (IOException e) {
                if (retry && usedSearcher != this.searcher) {
                    usedSearcher = this.searcher;
                    useOtherSearcher = true;
                }
                throw e;
            }
            if (useOtherSearcher) continue;
            retry = false;
        }
        SuggestWordQueue sugQueue = new SuggestWordQueue(numSug);
        int stop = hits == null ? 0 : Math.min(hits.length, 10 * numSug);
        SuggestWord sugWord = new SuggestWord();
        for (int i = 0; i < stop; ++i) {
            sugWord.string = usedSearcher.doc(hits[i].doc).get(language != null ? "word-" + language : "word");
            if (sugWord.string == null || word.equals(sugWord.string)) continue;
            sugWord.score = this.getStringDistance().getDistance(word, sugWord.string);
            if (sugWord.score < min) continue;
            if (ir != null && field != null) {
                sugWord.freq = ir.docFreq(new Term(field, sugWord.string));
                if (morePopular && goalFreq > sugWord.freq || sugWord.freq < 1) continue;
            }
            sugQueue.insertWithOverflow((Object)sugWord);
            if (sugQueue.size() == numSug) {
                min = ((SuggestWord)sugQueue.top()).score;
            }
            sugWord = new SuggestWord();
        }
        String[] list = new String[sugQueue.size()];
        for (int i = sugQueue.size() - 1; i >= 0; --i) {
            list[i] = ((SuggestWord)sugQueue.pop()).string;
        }
        return list;
    }

    private int getMin(int l) {
        if (l > 5) {
            return 3;
        }
        if (l == 5) {
            return 2;
        }
        return 1;
    }

    private int getMax(int l) {
        if (l > 5) {
            return 4;
        }
        if (l == 5) {
            return 3;
        }
        return 2;
    }

    public void setAccuracy(float minScore) {
        this.minScore = minScore;
        super.setAccuracy(minScore);
    }

    private static String[] formGrams(String text, int ng) {
        int len = text.length();
        String[] res = new String[len - ng + 1];
        for (int i = 0; i < len - ng + 1; ++i) {
            res[i] = text.substring(i, i + ng);
        }
        return res;
    }

    private static void add(BooleanQuery q, String name, String value, float boost) {
        TermQuery tq = new TermQuery(new Term(name, value));
        tq.setBoost(boost);
        q.add(new BooleanClause((Query)tq, BooleanClause.Occur.SHOULD));
    }

    private static void add(BooleanQuery q, String name, String value, BooleanClause.Occur occur) {
        q.add(new BooleanClause((Query)new TermQuery(new Term(name, value)), occur));
    }

    private static void add(BooleanQuery q, String name, String value) {
        q.add(new BooleanClause((Query)new TermQuery(new Term(name, value)), BooleanClause.Occur.SHOULD));
    }

    public void setSpellIndex(Directory spellIndex) throws IOException {
        this.spellIndex = spellIndex;
        if (!IndexReader.indexExists((Directory)spellIndex)) {
            IndexWriter writer = new IndexWriter(spellIndex, null, true, IndexWriter.MaxFieldLength.UNLIMITED);
            writer.close();
        }
        this.reopenSearcher();
    }

    private void reopenSearcher() throws IOException {
        IndexSearcher newSearcher;
        IndexSearcher oldSearcher = this.searcher;
        this.searcher = newSearcher = new IndexSearcher(this.spellIndex);
        if (oldSearcher != null) {
            oldSearcher.close();
        }
    }

    public void clearIndex() throws IOException {
        IndexWriter writer = new IndexWriter(this.spellIndex, null, true, IndexWriter.MaxFieldLength.UNLIMITED);
        writer.close();
        this.reopenSearcher();
    }

    public boolean exist(String word, String langCode, String site) throws IOException {
        BooleanQuery query = new BooleanQuery();
        JahiaExtendedSpellChecker.add(query, langCode != null ? "word-" + langCode : "word", word, BooleanClause.Occur.MUST);
        JahiaExtendedSpellChecker.add(query, F_SITE, site, BooleanClause.Occur.MUST);
        return this.searcher.search((Query)query, (int)1).scoreDocs.length > 0;
    }

    public void indexDictionary(Dictionary dict, int mergeFactor, int ramMB, String site, String langCode) throws IOException {
        IndexSearcher newSearcher;
        IndexWriter writer = new IndexWriter(this.spellIndex, (Analyzer)new WhitespaceAnalyzer(), IndexWriter.MaxFieldLength.UNLIMITED);
        writer.setMergeFactor(mergeFactor);
        writer.setRAMBufferSizeMB((double)ramMB);
        Iterator iter = dict.getWordsIterator();
        while (iter.hasNext()) {
            String word = (String)iter.next();
            int len = word.length();
            if (len < 3 || this.exist(word, langCode, site)) continue;
            Document doc = JahiaExtendedSpellChecker.createDocument(word, this.getMin(len), this.getMax(len), site, langCode);
            writer.addDocument(doc);
        }
        writer.optimize();
        writer.close();
        IndexSearcher oldSearcher = this.searcher;
        this.searcher = newSearcher = new IndexSearcher(this.spellIndex);
        oldSearcher.close();
    }

    private static Document createDocument(String text, int ng1, int ng2, String site, String langCode) {
        Document doc = new Document();
        doc.add((Fieldable)new Field(langCode != null ? "word-" + langCode : F_WORD_INTERNED, langCode != null, text, Field.Store.YES, Field.Index.NOT_ANALYZED, Field.TermVector.NO));
        doc.add((Fieldable)new Field(F_LANGUAGE, false, langCode, Field.Store.YES, Field.Index.NOT_ANALYZED, Field.TermVector.NO));
        doc.add((Fieldable)new Field(F_SITE, false, site, Field.Store.YES, Field.Index.NOT_ANALYZED, Field.TermVector.NO));
        JahiaExtendedSpellChecker.addGram(text, doc, ng1, ng2);
        return doc;
    }

    private static void addGram(String text, Document doc, int ng1, int ng2) {
        int len = text.length();
        for (int ng = ng1; ng <= ng2; ++ng) {
            String key = "gram" + ng;
            String end = null;
            for (int i = 0; i < len - ng + 1; ++i) {
                String gram = text.substring(i, i + ng);
                doc.add((Fieldable)new Field(key, true, gram, Field.Store.NO, Field.Index.NOT_ANALYZED, Field.TermVector.NO));
                if (i == 0) {
                    doc.add((Fieldable)new Field("start" + ng, true, gram, Field.Store.NO, Field.Index.NOT_ANALYZED, Field.TermVector.NO));
                }
                end = gram;
            }
            if (end == null) continue;
            doc.add((Fieldable)new Field("end" + ng, true, end, Field.Store.NO, Field.Index.NOT_ANALYZED, Field.TermVector.NO));
        }
    }

    public void close() throws IOException {
        if (this.searcher != null) {
            this.searcher.close();
        }
    }
}

