/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.server.io;

import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.server.io.DefaultHandler;
import org.apache.jackrabbit.server.io.ExportContext;
import org.apache.jackrabbit.server.io.IOHandler;
import org.apache.jackrabbit.server.io.IOManager;
import org.apache.jackrabbit.server.io.ImportContext;
import org.apache.jackrabbit.webdav.DavResource;

public class ExtraContentHandler
extends DefaultHandler
implements IOHandler {
    public ExtraContentHandler(IOManager ioManager) {
        super(ioManager);
    }

    public boolean canImport(ImportContext context, boolean isCollection) {
        return false;
    }

    public boolean canImport(ImportContext context, DavResource resource) {
        return false;
    }

    public boolean canExport(ExportContext context, boolean isCollection) {
        boolean success;
        if (context == null || context.isCompleted()) {
            return false;
        }
        Item exportRoot = context.getExportRoot();
        boolean bl = success = exportRoot != null && exportRoot.isNode();
        if (success && !isCollection) {
            try {
                Node th = (Node)exportRoot;
                success = th.isNodeType("nt:resource") && th.hasProperty("jcr:data");
            }
            catch (RepositoryException e) {
                success = false;
            }
        }
        return success;
    }

    protected Node getContentNode(ExportContext context, boolean isCollection) throws RepositoryException {
        return (Node)context.getExportRoot();
    }
}

