/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security;

import java.util.Iterator;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.security.auth.Subject;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.core.JahiaRepositoryImpl;
import org.apache.jackrabbit.core.config.LoginModuleConfig;
import org.apache.jackrabbit.core.config.SecurityConfig;
import org.apache.jackrabbit.core.security.AMContext;
import org.apache.jackrabbit.core.security.AccessManager;
import org.apache.jackrabbit.core.security.JackrabbitSecurityManager;
import org.apache.jackrabbit.core.security.JahiaAccessManager;
import org.apache.jackrabbit.core.security.JahiaAuthContextProvider;
import org.apache.jackrabbit.core.security.JahiaSystemSession;
import org.apache.jackrabbit.core.security.authentication.AuthContext;
import org.apache.jackrabbit.core.security.authentication.AuthContextProvider;
import org.jahia.jaas.JahiaPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaSecurityManager
implements JackrabbitSecurityManager {
    private static final Logger log = LoggerFactory.getLogger(JahiaSecurityManager.class);
    private boolean initialized;
    private JahiaRepositoryImpl repository;
    private Session securitySession;
    private AuthContextProvider authContextProvider;

    public synchronized void init(Repository repository, Session systemSession) throws RepositoryException {
        if (this.initialized) {
            throw new IllegalStateException("already initialized");
        }
        this.securitySession = systemSession;
        this.repository = (JahiaRepositoryImpl)repository;
        SecurityConfig config = this.repository.getConfig().getSecurityConfig();
        LoginModuleConfig loginModConf = config.getLoginModuleConfig();
        this.authContextProvider = new JahiaAuthContextProvider(config.getAppName(), loginModConf);
        if (this.authContextProvider.isLocal()) {
            log.info("init: use Repository Login-Configuration for " + config.getAppName());
        } else if (this.authContextProvider.isJAAS()) {
            log.info("init: use JAAS login-configuration for " + config.getAppName());
        } else {
            String msg = "Neither JAAS nor RepositoryConfig contained a valid Configuriation for " + config.getAppName();
            log.error(msg);
            throw new RepositoryException(msg);
        }
        this.initialized = true;
    }

    public String getUserID(Subject subject, String workspace) throws RepositoryException {
        Set<JahiaPrincipal> s = subject.getPrincipals(JahiaPrincipal.class);
        Iterator<JahiaPrincipal> i$ = s.iterator();
        if (i$.hasNext()) {
            JahiaPrincipal jahiaPrincipal = i$.next();
            return jahiaPrincipal.getName();
        }
        return null;
    }

    public UserManager getUserManager(Session session) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException("UserManager not supported.");
    }

    public PrincipalManager getPrincipalManager(Session session) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException("PrincipalManager not supported.");
    }

    public AccessManager getAccessManager(Session session, AMContext amContext) throws RepositoryException {
        this.checkInitialized();
        try {
            if (session instanceof JahiaSystemSession) {
                return ((JahiaSystemSession)session).createAccessManager(((JahiaSystemSession)session).getSubject());
            }
            JahiaAccessManager accessMgr = new JahiaAccessManager();
            accessMgr.init(amContext, null, null, this.repository.getContext(), this.repository.getConfig().getWorkspaceConfig(session.getWorkspace().getName()));
            return accessMgr;
        }
        catch (AccessDeniedException ade) {
            throw ade;
        }
        catch (Exception e) {
            String msg = "Failed to instantiate JahiaAccessManager";
            log.error(msg, (Throwable)e);
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    public AuthContext getAuthContext(Credentials credentials, Subject subject, String workspace) throws RepositoryException {
        this.checkInitialized();
        return this.authContextProvider.getAuthContext(credentials, subject, this.securitySession, null, " system ", " guest ");
    }

    public SecurityConfig getSecurityConfig() throws RepositoryException {
        return this.repository.getConfig().getSecurityConfig();
    }

    public void close() {
        log.info("close");
    }

    public void dispose(String s) {
        log.info("dispose");
    }

    private void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("Not initialized");
        }
    }
}

