/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene.join;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import javax.jcr.query.qom.And;
import javax.jcr.query.qom.Column;
import javax.jcr.query.qom.Comparison;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.DynamicOperand;
import javax.jcr.query.qom.EquiJoinCondition;
import javax.jcr.query.qom.FullTextSearchScore;
import javax.jcr.query.qom.Join;
import javax.jcr.query.qom.LowerCase;
import javax.jcr.query.qom.Not;
import javax.jcr.query.qom.Or;
import javax.jcr.query.qom.Ordering;
import javax.jcr.query.qom.PropertyValue;
import javax.jcr.query.qom.QueryObjectModelFactory;
import javax.jcr.query.qom.Selector;
import javax.jcr.query.qom.Source;
import javax.jcr.query.qom.UpperCase;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.commons.iterator.RowIteratorAdapter;
import org.apache.jackrabbit.commons.query.qom.OperandEvaluator;
import org.apache.jackrabbit.core.query.FacetedQueryResult;
import org.apache.jackrabbit.core.query.JahiaSimpleQueryResult;
import org.apache.jackrabbit.core.query.lucene.FacetRow;
import org.apache.jackrabbit.core.query.lucene.JahiaLuceneQueryFactoryImpl;
import org.apache.jackrabbit.core.query.lucene.LuceneQueryFactory;
import org.apache.jackrabbit.core.query.lucene.join.ConstraintSplitter;
import org.apache.jackrabbit.core.query.lucene.join.Constraints;
import org.apache.jackrabbit.core.query.lucene.join.JahiaEquiJoinMerger;
import org.apache.jackrabbit.core.query.lucene.join.JahiaOperandEvaluator;
import org.apache.jackrabbit.core.query.lucene.join.QueryEngine;
import org.apache.jackrabbit.core.query.lucene.join.RowPathComparator;
import org.apache.jackrabbit.core.query.lucene.sort.DynamicOperandFieldComparatorSource;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaQueryEngine
extends QueryEngine {
    private static final Logger log = LoggerFactory.getLogger(QueryEngine.class);
    protected final OperandEvaluator evaluator;
    public static boolean nativeSort = Boolean.valueOf(System.getProperty("useNativeSort", "false"));

    public JahiaQueryEngine(Session session, LuceneQueryFactory lqf, Map<String, Value> variables) throws RepositoryException {
        super(session, lqf, variables);
        Locale locale = null;
        if (lqf instanceof JahiaLuceneQueryFactoryImpl) {
            locale = ((JahiaLuceneQueryFactoryImpl)lqf).getLocale();
        }
        this.evaluator = new JahiaOperandEvaluator(this.valueFactory, variables, locale);
    }

    protected QueryResult execute(Column[] columns, Selector selector, Constraint constraint, Ordering[] orderings, long offset, long limit, int printIndentation) throws RepositoryException {
        Map selectorMap = this.getSelectorNames((Source)selector);
        String[] selectorNames = selectorMap.keySet().toArray(new String[selectorMap.size()]);
        Map<String, PropertyValue> columnMap = this.getColumnMap(columns, selectorMap);
        String[] columnNames = columnMap.keySet().toArray(new String[columnMap.size()]);
        Sort sort = new Sort();
        if (nativeSort) {
            sort = new Sort(this.createSortFields(orderings, this.session));
        }
        boolean externalSort = !nativeSort && orderings != null && orderings.length > 0;
        List rowsList = null;
        try {
            rowsList = this.lqf.execute(columnMap, selector, constraint, sort, externalSort, offset, limit);
        }
        catch (IOException e) {
            throw new RepositoryException("Failed to access the query index", (Throwable)e);
        }
        if (rowsList.size() > 0 && rowsList.get(0) instanceof FacetRow) {
            FacetRow facets = (FacetRow)rowsList.remove(0);
            RowIteratorAdapter rows = new RowIteratorAdapter((Collection)rowsList);
            return new FacetedQueryResult(columnNames, selectorNames, (RowIterator)rows, facets);
        }
        RowIteratorAdapter rows = new RowIteratorAdapter((Collection)rowsList);
        JahiaSimpleQueryResult result = new JahiaSimpleQueryResult(columnNames, selectorNames, (RowIterator)rows);
        if (nativeSort) {
            return result;
        }
        long timeSort = System.currentTimeMillis();
        QueryResult r = JahiaQueryEngine.sort((QueryResult)result, (Ordering[])orderings, (OperandEvaluator)this.evaluator, (long)offset, (long)limit);
        if (log.isDebugEnabled()) {
            log.debug("{}SQL2 SORT took {} ms.", (Object)JahiaQueryEngine.genString(printIndentation), (Object)(System.currentTimeMillis() - timeSort));
        }
        if (r != result) {
            return new JahiaSimpleQueryResult(columnNames, selectorNames, r.getRows(), limit > 0L ? result.getRows().getSize() : 0L);
        }
        return result;
    }

    public SortField[] createSortFields(Ordering[] orderings, Session session) throws RepositoryException {
        if (orderings == null || orderings.length == 0) {
            return new SortField[]{SortField.FIELD_SCORE};
        }
        HashMap<String, Ordering> orderByProperties = new HashMap<String, Ordering>();
        for (Ordering o : orderings) {
            String p = o.toString();
            if (orderByProperties.containsKey(p)) continue;
            orderByProperties.put(p, o);
        }
        DynamicOperandFieldComparatorSource dofcs = new DynamicOperandFieldComparatorSource(session, this.evaluator, orderByProperties);
        ArrayList<SortField> sortFields = new ArrayList<SortField>();
        for (Ordering o : orderings) {
            String p = o.toString();
            boolean isAsc = "jcr.order.ascending".equals(o.getOrder());
            if (o.getOperand() instanceof FullTextSearchScore || "jcr:score".equals(p)) {
                sortFields.add(new SortField(null, 0, isAsc));
                continue;
            }
            sortFields.add(new SortField(p, (FieldComparatorSource)dofcs, !isAsc));
        }
        return sortFields.toArray(new SortField[sortFields.size()]);
    }

    private static String genString(int len) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    protected QueryResult execute(Column[] columns, Join join, Constraint constraint, Ordering[] orderings, long offset, long limit, int printIndentation) throws RepositoryException {
        Object result;
        QueryResult queryResult = result = this.isEquiJoinWithUuid(join, constraint) ? this.executeEquiJoin(columns, join, constraint, orderings, offset, limit) : super.execute(columns, join, constraint, orderings, offset, limit, printIndentation);
        if (!(result instanceof JahiaSimpleQueryResult)) {
            result = new JahiaSimpleQueryResult(result.getColumnNames(), result.getSelectorNames(), result.getRows());
        }
        return result;
    }

    protected boolean isEquiJoinWithUuid(Join join, Constraint constraint) {
        EquiJoinCondition condition;
        boolean result = false;
        if (join.getJoinCondition() instanceof EquiJoinCondition && (condition = (EquiJoinCondition)join.getJoinCondition()).getProperty2Name().equals("jcr:uuid")) {
            result = true;
        }
        return result;
    }

    protected boolean hasLanguageConstraint(Constraint constraint) {
        boolean languageConstraint = false;
        if (constraint instanceof And) {
            And and = (And)constraint;
            languageConstraint = this.hasLanguageConstraint(and.getConstraint1());
            languageConstraint = languageConstraint || this.hasLanguageConstraint(and.getConstraint2());
        } else if (constraint instanceof Or) {
            Or or = (Or)constraint;
            languageConstraint = this.hasLanguageConstraint(or.getConstraint1());
            languageConstraint = languageConstraint || this.hasLanguageConstraint(or.getConstraint2());
        } else if (constraint instanceof Not) {
            Not not = (Not)constraint;
            languageConstraint = this.hasLanguageConstraint(not.getConstraint());
        } else if (constraint instanceof Comparison) {
            Comparison c = (Comparison)constraint;
            languageConstraint = this.hasLanguageConstraint(c.getOperand1());
        }
        return languageConstraint;
    }

    private boolean hasLanguageConstraint(DynamicOperand operand) {
        boolean languageConstraint = false;
        if (operand instanceof LowerCase) {
            LowerCase lower = (LowerCase)operand;
            return this.hasLanguageConstraint(lower.getOperand());
        }
        if (operand instanceof PropertyValue) {
            PropertyValue value = (PropertyValue)operand;
            return value.getPropertyName().equals("jcr:language");
        }
        if (operand instanceof UpperCase) {
            UpperCase upper = (UpperCase)operand;
            return this.hasLanguageConstraint(upper.getOperand());
        }
        return languageConstraint;
    }

    protected QueryResult executeEquiJoin(Column[] columns, Join join, Constraint constraint, Ordering[] orderings, long offset, long limit) throws RepositoryException {
        RowIteratorAdapter rightRows;
        JahiaEquiJoinMerger merger = new JahiaEquiJoinMerger(join, this.getColumnMap(columns, this.getSelectorNames((Source)join)), this.evaluator, this.qomFactory, (EquiJoinCondition)join.getJoinCondition());
        ConstraintSplitter splitter = new ConstraintSplitter(constraint, this.qomFactory, merger.getLeftSelectors(), merger.getRightSelectors(), join);
        Source left = join.getLeft();
        Constraint leftConstraint = splitter.getConstraintSplitInfo().getLeftConstraint();
        QueryResult leftResult = this.execute(null, left, leftConstraint, null, 0L, -1L);
        ArrayList<Row> leftRows = new ArrayList<Row>();
        for (Row row : JcrUtils.getRows((QueryResult)leftResult)) {
            leftRows.add(row);
        }
        if (this.hasLanguageConstraint(splitter.getConstraintSplitInfo().getRightConstraint())) {
            merger.setIncludeTranslationNode(true);
        }
        Source right = join.getRight();
        List<Constraint> rightConstraints = merger.getRightJoinConstraints(leftRows);
        RowPathComparator rightCo = new RowPathComparator((Collection)merger.getRightSelectors());
        if (rightConstraints.size() < 500) {
            Constraint rightConstraint = Constraints.and((QueryObjectModelFactory)this.qomFactory, (Constraint[])new Constraint[]{Constraints.or((QueryObjectModelFactory)this.qomFactory, rightConstraints), splitter.getConstraintSplitInfo().getRightConstraint()});
            rightRows = this.execute(null, right, rightConstraint, null, 0L, -1L).getRows();
        } else {
            ArrayList<Row> list = new ArrayList<Row>();
            for (int i = 0; i < rightConstraints.size(); i += 500) {
                Constraint rightConstraint = Constraints.and((QueryObjectModelFactory)this.qomFactory, (Constraint[])new Constraint[]{Constraints.or((QueryObjectModelFactory)this.qomFactory, rightConstraints.subList(i, Math.min(i + 500, rightConstraints.size()))), splitter.getConstraintSplitInfo().getRightConstraint()});
                QueryResult rigthResult = this.execute(null, right, rightConstraint, null, 0L, -1L);
                for (Row row : JcrUtils.getRows((QueryResult)rigthResult)) {
                    list.add(row);
                }
            }
            rightRows = new RowIteratorAdapter(list);
        }
        QueryResult result = merger.merge((RowIterator)new RowIteratorAdapter(leftRows), (RowIterator)rightRows, null, (Comparator)rightCo);
        return JahiaQueryEngine.sort((QueryResult)result, (Ordering[])orderings, (OperandEvaluator)this.evaluator, (long)offset, (long)limit);
    }

    public QueryResult execute(Column[] columns, Source source, Constraint constraint, Ordering[] orderings, long offset, long limit) throws RepositoryException {
        Object result = super.execute(columns, source, constraint, orderings, offset, limit);
        if (!(result instanceof JahiaSimpleQueryResult)) {
            result = new JahiaSimpleQueryResult(result.getColumnNames(), result.getSelectorNames(), result.getRows());
        }
        return result;
    }

    protected Map<String, PropertyValue> getColumnMap(String selector, NodeType type) throws RepositoryException {
        return super.getColumnMap(selector, (NodeType)NodeTypeRegistry.getInstance().getNodeType(type.getName()));
    }

    protected Map<String, PropertyValue> getColumnMap(Column[] columns, Map<String, NodeType> selectors) throws RepositoryException {
        LinkedHashMap<String, PropertyValue> map = new LinkedHashMap<String, PropertyValue>();
        if (columns != null && columns.length > 0) {
            for (int i = 0; i < columns.length; ++i) {
                String name = columns[i].getColumnName();
                if (name != null) {
                    map.put(name, this.qomFactory.propertyValue(columns[i].getSelectorName(), columns[i].getPropertyName()));
                    continue;
                }
                if (!StringUtils.isEmpty((String)columns[i].getPropertyName())) {
                    map.put(columns[i].getSelectorName() + "." + columns[i].getPropertyName(), this.qomFactory.propertyValue(columns[i].getSelectorName(), columns[i].getPropertyName()));
                    continue;
                }
                String selector = columns[i].getSelectorName();
                map.putAll(this.getColumnMap(selector, selectors.get(selector)));
            }
        } else {
            for (Map.Entry<String, NodeType> selector : selectors.entrySet()) {
                map.putAll(this.getColumnMap(selector.getKey(), selector.getValue()));
            }
        }
        return map;
    }
}

