/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene.join;

import java.util.Locale;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.query.Row;
import javax.jcr.query.qom.Operand;
import javax.jcr.query.qom.PropertyValue;
import org.apache.jackrabbit.commons.query.qom.OperandEvaluator;

public class JahiaOperandEvaluator
extends OperandEvaluator {
    private final Locale locale;

    public JahiaOperandEvaluator(ValueFactory factory, Map<String, Value> variables, Locale locale) {
        super(factory, variables, locale != null ? locale : Locale.ENGLISH);
        this.locale = locale;
    }

    public Value[] getValues(Operand operand, Row row) throws RepositoryException {
        if (operand instanceof PropertyValue) {
            return this.getPropertyValues((PropertyValue)operand, row);
        }
        return super.getValues(operand, row);
    }

    public Value[] getValues(Operand operand, Node node) throws RepositoryException {
        if (operand instanceof PropertyValue) {
            return this.getPropertyValues((PropertyValue)operand, node);
        }
        return super.getValues(operand, node);
    }

    private Value[] getPropertyValues(PropertyValue operand, Row row) throws RepositoryException {
        Property property = this.getProperty(operand, row);
        return this.getValuesFrom(property);
    }

    private Value[] getValuesFrom(Property property) throws RepositoryException {
        if (property == null) {
            return new Value[0];
        }
        if (property.isMultiple()) {
            return property.getValues();
        }
        return new Value[]{property.getValue()};
    }

    private Value[] getPropertyValues(PropertyValue operand, Node node) throws RepositoryException {
        Property property = this.getProperty(operand, node);
        return this.getValuesFrom(property);
    }

    private Property getProperty(PropertyValue operand, Row row) throws RepositoryException {
        return this.getProperty(operand, row.getNode(operand.getSelectorName()));
    }

    private Property getProperty(PropertyValue operand, Node node) throws RepositoryException {
        if (node == null) {
            return null;
        }
        try {
            return node.getProperty(operand.getPropertyName());
        }
        catch (PathNotFoundException e) {
            try {
                if (this.locale != null && node.hasNode("j:translation_" + this.locale)) {
                    return node.getNode("j:translation_" + this.locale).getProperty(operand.getPropertyName());
                }
                if (node.getName().startsWith("j:translation_")) {
                    return node.getParent().getProperty(operand.getPropertyName());
                }
            }
            catch (PathNotFoundException e1) {
                // empty catch block
            }
            return null;
        }
    }
}

