/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import javax.jcr.query.InvalidQueryException;
import org.apache.jackrabbit.core.query.PropertyTypeRegistry;
import org.apache.jackrabbit.core.query.lucene.QueryImpl;
import org.apache.jackrabbit.core.query.lucene.SearchIndex;
import org.apache.jackrabbit.core.query.lucene.constraint.Constraint;
import org.apache.jackrabbit.core.session.SessionContext;
import org.apache.jackrabbit.spi.commons.query.QueryNodeFactory;
import org.apache.lucene.analysis.Analyzer;
import org.jahia.utils.LuceneUtils;

public class JahiaQueryImpl
extends QueryImpl {
    private Constraint constraint = null;
    private String statement = null;

    public JahiaQueryImpl(SessionContext sessionContext, SearchIndex index, PropertyTypeRegistry propReg, String statement, String language, QueryNodeFactory factory) throws InvalidQueryException {
        super(sessionContext, index, propReg, statement, language, factory);
        this.statement = statement;
    }

    public Constraint getConstraint() {
        return this.constraint;
    }

    public void setConstraint(Constraint constraint) {
        this.constraint = constraint;
    }

    public boolean needsSystemTree() {
        return this.statement.contains("jcr:system");
    }

    protected Analyzer getTextAnalyzer() {
        String lang = LuceneUtils.extractLanguageOrNullFromStatement(this.statement);
        if (lang != null) {
            Analyzer analyzer = this.index.getAnalyzerRegistry().getAnalyzer((Object)lang);
            return analyzer != null ? analyzer : super.getTextAnalyzer();
        }
        return super.getTextAnalyzer();
    }
}

