/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.Row;
import org.jahia.services.content.nodetypes.ValueImpl;

public class CountRow
implements Row {
    private long count;
    private boolean approxLimitReached;

    public CountRow(long count, boolean approxLimitReached) {
        this.count = count;
        this.approxLimitReached = approxLimitReached;
    }

    public Value[] getValues() throws RepositoryException {
        Value[] valueArray;
        if (this.approxLimitReached) {
            Value[] valueArray2 = new Value[2];
            valueArray2[0] = new ValueImpl(this.count);
            valueArray = valueArray2;
            valueArray2[1] = new ValueImpl(this.approxLimitReached);
        } else {
            Value[] valueArray3 = new Value[1];
            valueArray = valueArray3;
            valueArray3[0] = new ValueImpl(this.count);
        }
        return valueArray;
    }

    public Value getValue(String columnName) throws ItemNotFoundException, RepositoryException {
        return columnName.equals("approxLimitReached") ? new ValueImpl(this.approxLimitReached) : new ValueImpl(this.count);
    }

    public Node getNode() throws RepositoryException {
        return null;
    }

    public Node getNode(String selectorName) throws RepositoryException {
        return null;
    }

    public String getPath() throws RepositoryException {
        return null;
    }

    public String getPath(String selectorName) throws RepositoryException {
        return null;
    }

    public double getScore() throws RepositoryException {
        return 0.0;
    }

    public double getScore(String selectorName) throws RepositoryException {
        return 0.0;
    }
}

