/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.cluster;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.cluster.ChangeLogRecord;
import org.apache.jackrabbit.core.cluster.ClusterException;
import org.apache.jackrabbit.core.cluster.ClusterNode;
import org.apache.jackrabbit.core.cluster.NamespaceRecord;
import org.apache.jackrabbit.core.cluster.NodeLevelLockableJournal;
import org.apache.jackrabbit.core.cluster.NodeTypeRecord;
import org.apache.jackrabbit.core.cluster.Update;
import org.apache.jackrabbit.core.cluster.UpdateEventChannel;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.journal.AbstractJournal;
import org.apache.jackrabbit.core.journal.FileRevision;
import org.apache.jackrabbit.core.journal.Journal;
import org.apache.jackrabbit.core.journal.JournalException;
import org.apache.jackrabbit.core.journal.RecordProducer;
import org.apache.jackrabbit.core.state.ItemState;
import org.jahia.services.content.JCRStoreService;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaClusterNode
extends ClusterNode {
    private static final int NONE = 0;
    private static final int STARTED = 1;
    private static final int STOPPED = 2;
    private static Logger log = LoggerFactory.getLogger(JahiaClusterNode.class);
    private RecordProducer producer;
    private final AtomicInteger status = new AtomicInteger(0);

    public synchronized void start() throws ClusterException {
        if (this.status.get() == 0) {
            super.start();
            this.status.set(1);
        }
    }

    protected void init() throws ClusterException {
        super.init();
        try {
            this.producer = this.getJournal().getProducer("JR");
        }
        catch (JournalException e) {
            throw new ClusterException("Journal initialization failed: " + (Object)((Object)this), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        String revisionFile;
        this.status.set(2);
        super.stop();
        Journal j = this.getJournal();
        if (j != null && j instanceof AbstractJournal && (revisionFile = ((AbstractJournal)j).getRevision()) != null) {
            try (FileRevision currentFileRevision = null;){
                currentFileRevision = new FileRevision(new File(revisionFile));
                long rev = this.getRevision();
                currentFileRevision.set(rev);
                log.info("Written local revision {} into revision file", (Object)rev);
            }
        }
    }

    public UpdateEventChannel createUpdateChannel(String workspace) {
        return new WorkspaceUpdateChannel(workspace);
    }

    private void unlockNodes(Update update) throws JournalException {
        if (this.getJournal() instanceof NodeLevelLockableJournal) {
            Set ids = (Set)update.getAttribute("allIds");
            ((NodeLevelLockableJournal)this.getJournal()).unlockNodes(ids);
        }
    }

    private void lockNodes(Update update) throws JournalException {
        if (this.getJournal() instanceof NodeLevelLockableJournal) {
            Set ids = (Set)update.getAttribute("allIds");
            ((NodeLevelLockableJournal)this.getJournal()).lockNodes(ids);
        }
    }

    private void storeNodeIds(Update update) {
        HashSet<NodeId> nodeIdList = new HashSet<NodeId>();
        for (ItemState state : update.getChanges().addedStates()) {
            nodeIdList.add(state.getParentId());
        }
        for (ItemState state : update.getChanges().modifiedStates()) {
            if (state.isNode()) {
                nodeIdList.add((NodeId)state.getId());
                continue;
            }
            nodeIdList.add(state.getParentId());
        }
        for (ItemState state : update.getChanges().deletedStates()) {
            if (state.isNode()) {
                nodeIdList.add((NodeId)state.getId());
                continue;
            }
            nodeIdList.add(state.getParentId());
        }
        update.setAttribute("allIds", nodeIdList);
    }

    public void process(ChangeLogRecord record) {
        if (log.isDebugEnabled()) {
            HashSet<NodeId> nodeIdList = new HashSet<NodeId>();
            for (ItemState state : record.getChanges().addedStates()) {
                nodeIdList.add(state.getParentId());
            }
            for (ItemState state : record.getChanges().modifiedStates()) {
                if (state.isNode()) {
                    nodeIdList.add((NodeId)state.getId());
                    continue;
                }
                nodeIdList.add(state.getParentId());
            }
            for (ItemState state : record.getChanges().deletedStates()) {
                if (state.isNode()) {
                    nodeIdList.add((NodeId)state.getId());
                    continue;
                }
                nodeIdList.add(state.getParentId());
            }
            log.debug("Getting change  " + record.getRevision() + " : " + nodeIdList);
        }
        super.process(record);
    }

    public void process(NamespaceRecord record) {
        NodeTypeRegistry.getInstance().getNamespaces().put(record.getNewPrefix(), record.getUri());
        super.process(record);
    }

    public void process(NodeTypeRecord record) {
        try {
            JCRStoreService.getInstance().reloadNodeTypeRegistry();
        }
        catch (RepositoryException e) {
            String msg = "Unable to register nodetypes : " + e.getMessage();
            log.error(msg);
        }
        super.process(record);
    }

    public void setRevision(long revision) {
        if (!(this.getJournal() instanceof NodeLevelLockableJournal)) {
            super.setRevision(revision);
        }
    }

    public void reallySetRevision(long revision) {
        log.debug("Set revision : " + revision);
        super.setRevision(revision);
    }

    class WorkspaceUpdateChannel
    extends ClusterNode.WorkspaceUpdateChannel
    implements UpdateEventChannel {
        private static final String ATTRIBUTE_RECORD = "record";
        private final String workspace;

        public WorkspaceUpdateChannel(String workspace) {
            super((ClusterNode)JahiaClusterNode.this, workspace);
            this.workspace = workspace;
        }

        public void updateCreated(Update update) throws ClusterException {
            if (JahiaClusterNode.this.status.get() != 1) {
                log.info("not started: update create ignored.");
                return;
            }
            super.updateCreated(update);
            try {
                JahiaClusterNode.this.storeNodeIds(update);
                JahiaClusterNode.this.lockNodes(update);
            }
            catch (JournalException e) {
                String msg = "Unable to create log entry: " + e.getMessage();
                throw new ClusterException(msg, (Throwable)e);
            }
            catch (Exception e) {
                String msg = "Unexpected error while creating log entry: " + e.getMessage();
                throw new ClusterException(msg, (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateCommitted(Update update, String path) {
            if (JahiaClusterNode.this.status.get() != 1) {
                log.info("not started: update commit ignored.");
                return;
            }
            try {
                super.updateCommitted(update, path);
            }
            finally {
                try {
                    JahiaClusterNode.this.unlockNodes(update);
                }
                catch (JournalException e) {
                    log.error("Unable to commit log entry.", (Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateCancelled(Update update) {
            if (JahiaClusterNode.this.status.get() != 1) {
                log.info("not started: update cancel ignored.");
                return;
            }
            try {
                super.updateCancelled(update);
            }
            finally {
                try {
                    JahiaClusterNode.this.unlockNodes(update);
                }
                catch (JournalException e) {
                    log.error("Unable to cancel log entry.", (Throwable)e);
                }
            }
        }
    }
}

