/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.observation.EventIterator;
import org.apache.jackrabbit.core.RepositoryContext;
import org.apache.jackrabbit.core.SearchManager;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.observation.EventImpl;
import org.apache.jackrabbit.core.persistence.PersistenceManager;
import org.apache.jackrabbit.core.query.QueryHandlerFactory;
import org.apache.jackrabbit.core.query.lucene.FieldSelectors;
import org.apache.jackrabbit.core.query.lucene.JahiaIndexingConfigurationImpl;
import org.apache.jackrabbit.core.query.lucene.JahiaNodeIndexer;
import org.apache.jackrabbit.core.query.lucene.SearchIndex;
import org.apache.jackrabbit.core.query.lucene.Util;
import org.apache.jackrabbit.core.query.lucene.hits.AbstractHitCollector;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.SharedItemStateManager;
import org.apache.jackrabbit.spi.Name;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaSearchManager
extends SearchManager {
    private static final String TRANSLATION_LOCALNODENAME_PREFIX = "translation_";
    private static final Logger log = LoggerFactory.getLogger(JahiaSearchManager.class);
    private final SharedItemStateManager itemMgr;

    public JahiaSearchManager(String workspace, RepositoryContext repositoryContext, QueryHandlerFactory qhf, SharedItemStateManager itemMgr, PersistenceManager pm, NodeId rootNodeId, SearchManager parentMgr, NodeId excludedNodeId) throws RepositoryException {
        super(workspace, repositoryContext, qhf, itemMgr, pm, rootNodeId, parentMgr, excludedNodeId);
        this.itemMgr = itemMgr;
    }

    public void onEvent(EventIterator events) {
        log.debug("onEvent: indexing started");
        long time = System.currentTimeMillis();
        HashSet<NodeId> removedNodes = new HashSet<NodeId>();
        final HashMap<NodeId, EventImpl> addedNodes = new HashMap<NodeId, EventImpl>();
        ArrayList<EventImpl> propEvents = new ArrayList<EventImpl>();
        while (events.hasNext()) {
            EventImpl e = (EventImpl)events.nextEvent();
            if (this.isExcluded(e)) continue;
            long type = e.getType();
            if (type == 1L) {
                addedNodes.put(e.getChildId(), e);
                if (!e.isShareableChildNode()) continue;
                removedNodes.add(e.getChildId());
                continue;
            }
            if (type == 2L) {
                removedNodes.add(e.getChildId());
                if (!e.isShareableChildNode() || !this.itemMgr.hasItemState((ItemId)e.getChildId())) continue;
                addedNodes.put(e.getChildId(), e);
                continue;
            }
            propEvents.add(e);
        }
        HashSet<NodeId> nodeEventRemovedNodes = new HashSet<NodeId>(removedNodes);
        for (EventImpl e : propEvents) {
            NodeId nodeId = e.getParentId();
            if (e.getType() == 4) {
                if (addedNodes.put(nodeId, e) != null) continue;
                removedNodes.add(nodeId);
                continue;
            }
            if (e.getType() == 16) {
                addedNodes.put(nodeId, e);
                removedNodes.add(nodeId);
                continue;
            }
            addedNodes.put(nodeId, e);
            removedNodes.add(nodeId);
        }
        try {
            boolean addedNodesPresent;
            this.addJahiaDependencies(removedNodes, addedNodes, propEvents, nodeEventRemovedNodes);
            boolean bl = addedNodesPresent = addedNodes.size() > 0;
            if (addedNodesPresent || removedNodes.size() > 0) {
                Iterator<NodeState> addedStates = addedNodesPresent ? new Iterator<NodeState>(){
                    private final Iterator<NodeId> iter;
                    {
                        this.iter = addedNodes.keySet().iterator();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public NodeState next() {
                        NodeState item = null;
                        NodeId id = this.iter.next();
                        try {
                            item = (NodeState)JahiaSearchManager.this.itemMgr.getItemState((ItemId)id);
                        }
                        catch (ItemStateException ise) {
                            EventImpl e = (EventImpl)addedNodes.get(id);
                            if (e == null || !e.isExternal()) {
                                log.error("Unable to index node " + id + ": does not exist");
                            }
                            log.info("Node no longer available {}, skipped.", (Object)id);
                        }
                        return item;
                    }
                } : Collections.emptyIterator();
                Iterator removedIds = removedNodes.iterator();
                this.getQueryHandler().updateNodes(removedIds, (Iterator)addedStates);
            }
        }
        catch (RepositoryException e) {
            log.error("Error indexing node.", (Throwable)e);
        }
        catch (IOException e) {
            log.error("Error indexing node.", (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("onEvent: indexing finished in {} ms.", (Object)(System.currentTimeMillis() - time));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addJahiaDependencies(final Set<NodeId> removedIds, final Map<NodeId, EventImpl> addedStates, List<EventImpl> propEvents, Set<NodeId> nodeEventRemovedIds) throws RepositoryException, IOException {
        Set<NodeId> hierarchyNodeIds = this.getReMovedOrRenamedHierarchicalNodes(nodeEventRemovedIds);
        if (!hierarchyNodeIds.isEmpty()) {
            final IndexReader reader = ((SearchIndex)this.getQueryHandler()).getIndexReader();
            IndexSearcher searcher = new IndexSearcher(reader);
            try {
                ArrayList<NodeId> removeList = new ArrayList<NodeId>(hierarchyNodeIds);
                int removeSubListEnd = Math.min(removeList.size(), BooleanQuery.getMaxClauseCount());
                for (int removeSubListStart = 0; removeSubListStart < removeList.size(); removeSubListStart += BooleanQuery.getMaxClauseCount()) {
                    long timer = System.currentTimeMillis();
                    BooleanQuery query = new BooleanQuery(true);
                    for (NodeId nodeId : new ArrayList(removeList.subList(removeSubListStart, removeSubListEnd))) {
                        TermQuery termQuery = new TermQuery(new Term(JahiaNodeIndexer.FACET_HIERARCHY, nodeId.toString()));
                        query.add(new BooleanClause((Query)termQuery, BooleanClause.Occur.SHOULD));
                    }
                    searcher.search((Query)query, (Collector)new AbstractHitCollector(){

                        public void collect(int doc, float score) {
                            try {
                                String uuid = reader.document(doc, FieldSelectors.UUID).get("_:UUID");
                                JahiaSearchManager.this.addIdToBeIndexed(new NodeId(uuid), removedIds, addedStates);
                            }
                            catch (Exception e) {
                                log.warn("Documents referencing moved/renamed hierarchy facet nodes may not be updated", (Throwable)e);
                            }
                        }
                    });
                    if (log.isDebugEnabled()) {
                        log.debug("Facet hierarchy search in {} ms", new Object[]{System.currentTimeMillis() - timer});
                    }
                    removeSubListEnd = Math.min(removeList.size(), removeSubListEnd + BooleanQuery.getMaxClauseCount());
                }
            }
            finally {
                searcher.close();
                Util.closeOrRelease((IndexReader)reader);
            }
        }
        if (!addedStates.isEmpty() && !this.areAllPropertiesCopyExcluded(propEvents)) {
            for (NodeId node : new HashSet<NodeId>(addedStates.keySet())) {
                if (!this.itemMgr.hasItemState((ItemId)node)) continue;
                try {
                    for (ChildNodeEntry childNodeEntry : ((NodeState)this.itemMgr.getItemState((ItemId)node)).getChildNodeEntries()) {
                        if (!childNodeEntry.getName().getLocalName().startsWith(TRANSLATION_LOCALNODENAME_PREFIX)) continue;
                        try {
                            this.addIdToBeIndexed(childNodeEntry.getId(), removedIds, addedStates);
                        }
                        catch (ItemStateException e) {
                            log.warn("Index of translation node may not be updated", (Throwable)e);
                        }
                    }
                }
                catch (ItemStateException e) {
                    log.warn("Index of translation node may not be updated", (Throwable)e);
                }
            }
        }
    }

    private void addIdToBeIndexed(NodeId id, Set<NodeId> removedIds, Map<NodeId, EventImpl> addedStates) throws ItemStateException {
        if (!removedIds.contains(id) && !addedStates.containsKey(id)) {
            removedIds.add(id);
        }
        if (!addedStates.containsKey(id)) {
            addedStates.put(id, null);
        }
    }

    private boolean areAllPropertiesCopyExcluded(List<EventImpl> propEvents) {
        Set<Name> excludes = ((JahiaIndexingConfigurationImpl)((SearchIndex)this.getQueryHandler()).getIndexingConfig()).getExcludesFromI18NCopy();
        for (EventImpl event : propEvents) {
            try {
                if (event != null && excludes.contains(event.getQPath().getLastElement().getName())) continue;
                return false;
            }
            catch (RepositoryException e) {
            }
        }
        return true;
    }

    private Set<NodeId> getReMovedOrRenamedHierarchicalNodes(Set<NodeId> nodeEventRemovedIds) {
        if (nodeEventRemovedIds.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<NodeId> hierarchicalNodes = new HashSet<NodeId>();
        Set<Name> hierarchicalNodeTypes = ((JahiaIndexingConfigurationImpl)((SearchIndex)this.getQueryHandler()).getIndexingConfig()).getHierarchicalNodetypes();
        for (NodeId nodeId : nodeEventRemovedIds) {
            try {
                if (!hierarchicalNodeTypes.contains(((NodeState)this.itemMgr.getItemState((ItemId)nodeId)).getNodeTypeName())) continue;
                hierarchicalNodes.add(nodeId);
            }
            catch (ItemStateException e) {
                hierarchicalNodes.add(nodeId);
            }
        }
        return hierarchicalNodes;
    }
}

