/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz;

import org.tukaani.xz.ArrayCache;
import org.tukaani.xz.BCJCoder;
import org.tukaani.xz.BCJOptions;
import org.tukaani.xz.FilterEncoder;
import org.tukaani.xz.FinishableOutputStream;

class BCJEncoder
extends BCJCoder
implements FilterEncoder {
    private final BCJOptions options;
    private final long filterID;
    private final byte[] props;

    BCJEncoder(BCJOptions bCJOptions, long l2) {
        assert (BCJEncoder.isBCJFilterID(l2));
        int n2 = bCJOptions.getStartOffset();
        if (n2 == 0) {
            this.props = new byte[0];
        } else {
            this.props = new byte[4];
            for (int i2 = 0; i2 < 4; ++i2) {
                this.props[i2] = (byte)(n2 >>> i2 * 8);
            }
        }
        this.filterID = l2;
        this.options = (BCJOptions)bCJOptions.clone();
    }

    @Override
    public long getFilterID() {
        return this.filterID;
    }

    @Override
    public byte[] getFilterProps() {
        return this.props;
    }

    @Override
    public boolean supportsFlushing() {
        return false;
    }

    @Override
    public FinishableOutputStream getOutputStream(FinishableOutputStream finishableOutputStream, ArrayCache arrayCache) {
        return this.options.getOutputStream(finishableOutputStream, arrayCache);
    }
}

