/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.shaded.com.ongres.scram.common;

import java.nio.charset.StandardCharsets;
import org.postgresql.shaded.com.ongres.scram.common.bouncycastle.base64.Base64;
import org.postgresql.shaded.com.ongres.scram.common.util.Preconditions;

public class ScramStringFormatting {
    public static String toSaslName(String value) {
        char[] originalChars;
        if (null == value || value.isEmpty()) {
            return value;
        }
        int nComma = 0;
        int nEqual = 0;
        for (char c2 : originalChars = value.toCharArray()) {
            if (',' == c2) {
                ++nComma;
                continue;
            }
            if ('=' != c2) continue;
            ++nEqual;
        }
        if (nComma == 0 && nEqual == 0) {
            return value;
        }
        char[] saslChars = new char[originalChars.length + nComma * 2 + nEqual * 2];
        int i2 = 0;
        for (char c3 : originalChars) {
            if (',' == c3) {
                saslChars[i2++] = 61;
                saslChars[i2++] = 50;
                saslChars[i2++] = 67;
                continue;
            }
            if ('=' == c3) {
                saslChars[i2++] = 61;
                saslChars[i2++] = 51;
                saslChars[i2++] = 68;
                continue;
            }
            saslChars[i2++] = c3;
        }
        return new String(saslChars);
    }

    public static String fromSaslName(String value) throws IllegalArgumentException {
        if (null == value || value.isEmpty()) {
            return value;
        }
        int nEqual = 0;
        char[] orig = value.toCharArray();
        for (int i2 = 0; i2 < orig.length; ++i2) {
            if (orig[i2] == ',') {
                throw new IllegalArgumentException("Invalid ',' character present in saslName");
            }
            if (orig[i2] != '=') continue;
            ++nEqual;
            if (i2 + 2 > orig.length - 1) {
                throw new IllegalArgumentException("Invalid '=' character present in saslName");
            }
            if (orig[i2 + 1] == '2' && orig[i2 + 2] == 'C' || orig[i2 + 1] == '3' && orig[i2 + 2] == 'D') continue;
            throw new IllegalArgumentException("Invalid char '=" + orig[i2 + 1] + orig[i2 + 2] + "' found in saslName");
        }
        if (nEqual == 0) {
            return value;
        }
        char[] replaced = new char[orig.length - nEqual * 2];
        int o2 = 0;
        for (int r2 = 0; r2 < replaced.length; ++r2) {
            if ('=' == orig[o2]) {
                if (orig[o2 + 1] == '2' && orig[o2 + 2] == 'C') {
                    replaced[r2] = 44;
                } else if (orig[o2 + 1] == '3' && orig[o2 + 2] == 'D') {
                    replaced[r2] = 61;
                }
                o2 += 3;
                continue;
            }
            replaced[r2] = orig[o2];
            ++o2;
        }
        return new String(replaced);
    }

    public static String base64Encode(byte[] value) throws IllegalArgumentException {
        return Base64.toBase64String(Preconditions.checkNotNull(value, "value"));
    }

    public static String base64Encode(String value) throws IllegalArgumentException {
        return ScramStringFormatting.base64Encode(Preconditions.checkNotEmpty(value, "value").getBytes(StandardCharsets.UTF_8));
    }

    public static byte[] base64Decode(String value) throws IllegalArgumentException {
        return Base64.decode(Preconditions.checkNotEmpty(value, "value"));
    }
}

