/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.util.exceptions;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLTimeoutException;
import java.sql.SQLTransactionRollbackException;
import java.sql.SQLTransientConnectionException;
import java.sql.Statement;
import org.mariadb.jdbc.MariaDbConnection;
import org.mariadb.jdbc.internal.util.exceptions.MariaDbSqlException;
import org.mariadb.jdbc.util.Options;

public final class ExceptionFactory {
    public static final ExceptionFactory INSTANCE = new ExceptionFactory(-1L, null);
    private final long threadId;
    private final Options options;
    private MariaDbConnection connection;
    private Statement statement;

    public ExceptionFactory(long threadId, Options options, MariaDbConnection connection, Statement statement) {
        this.threadId = threadId;
        this.options = options;
        this.connection = connection;
        this.statement = statement;
    }

    private ExceptionFactory(long threadId, Options options) {
        this.threadId = threadId;
        this.options = options;
    }

    public static ExceptionFactory of(long threadId, Options options) {
        return new ExceptionFactory(threadId, options);
    }

    private static SQLException createException(String initialMessage, String sqlState, int errorCode, long threadId, Options options, MariaDbConnection connection, Statement statement, Exception cause) {
        SQLException returnEx;
        String sqlClass;
        String msg = ExceptionFactory.buildMsgText(initialMessage, threadId, options, cause);
        if ("70100".equals(sqlState)) {
            return new SQLTimeoutException(msg, sqlState, errorCode);
        }
        switch (sqlClass = sqlState == null ? "42" : sqlState.substring(0, 2)) {
            case "0A": {
                returnEx = new SQLFeatureNotSupportedException(msg, sqlState, errorCode, cause);
                break;
            }
            case "22": 
            case "26": 
            case "2F": 
            case "20": 
            case "42": 
            case "XA": {
                returnEx = new SQLSyntaxErrorException(msg, sqlState, errorCode, cause);
                break;
            }
            case "25": 
            case "28": {
                returnEx = new SQLInvalidAuthorizationSpecException(msg, sqlState, errorCode, cause);
                break;
            }
            case "21": 
            case "23": {
                returnEx = new SQLIntegrityConstraintViolationException(msg, sqlState, errorCode, cause);
                break;
            }
            case "08": {
                returnEx = new SQLNonTransientConnectionException(msg, sqlState, errorCode, cause);
                break;
            }
            case "40": {
                returnEx = new SQLTransactionRollbackException(msg, sqlState, errorCode, cause);
                break;
            }
            default: {
                returnEx = new SQLTransientConnectionException(msg, sqlState, errorCode, cause);
            }
        }
        if (connection != null && connection.pooledConnection != null) {
            connection.pooledConnection.fireStatementErrorOccured(statement, returnEx);
        }
        return returnEx;
    }

    private static String buildMsgText(String initialMessage, long threadId, Options options, Exception cause) {
        StringBuilder msg = new StringBuilder();
        String deadLockException = null;
        String threadName = null;
        if (threadId != -1L) {
            msg.append("(conn=").append(threadId).append(") ").append(initialMessage);
        } else {
            msg.append(initialMessage);
        }
        if (cause instanceof MariaDbSqlException) {
            MariaDbSqlException exception = (MariaDbSqlException)cause;
            String sql = exception.getSql();
            if (options.dumpQueriesOnException && sql != null) {
                if (options != null && options.maxQuerySizeToLog != 0 && sql.length() > options.maxQuerySizeToLog - 3) {
                    msg.append("\nQuery is: ").append(sql, 0, options.maxQuerySizeToLog - 3).append("...");
                } else {
                    msg.append("\nQuery is: ").append(sql);
                }
            }
            deadLockException = exception.getDeadLockInfo();
            threadName = exception.getThreadName();
        }
        if (options != null && options.includeInnodbStatusInDeadlockExceptions && deadLockException != null) {
            msg.append("\ndeadlock information: ").append(deadLockException);
        }
        if (options != null && deadLockException != null && options.includeThreadDumpInDeadlockExceptions) {
            if (threadName != null) {
                msg.append("\nthread name: ").append(threadName);
            }
            msg.append("\ncurrent threads: ");
            Thread.getAllStackTraces().forEach((thread, traces) -> {
                msg.append("\n  name:\"").append(thread.getName()).append("\" pid:").append(thread.getId()).append(" status:").append((Object)thread.getState());
                for (int i2 = 0; i2 < ((StackTraceElement[])traces).length; ++i2) {
                    msg.append("\n    ").append(traces[i2]);
                }
            });
        }
        return msg.toString();
    }

    public ExceptionFactory raiseStatementError(MariaDbConnection connection, Statement stmt) {
        return new ExceptionFactory(this.threadId, this.options, connection, stmt);
    }

    public SQLException create(SQLException cause) {
        return ExceptionFactory.createException(cause.getMessage().contains("\n") ? cause.getMessage().substring(0, cause.getMessage().indexOf("\n")) : cause.getMessage(), cause.getSQLState(), cause.getErrorCode(), this.threadId, this.options, this.connection, this.statement, cause);
    }

    public SQLException notSupported(String message) {
        return ExceptionFactory.createException(message, "0A000", -1, this.threadId, this.options, this.connection, this.statement, null);
    }

    public SQLException create(String message) {
        return ExceptionFactory.createException(message, "42000", -1, this.threadId, this.options, this.connection, this.statement, null);
    }

    public SQLException create(String message, Exception cause) {
        return ExceptionFactory.createException(message, "42000", -1, this.threadId, this.options, this.connection, this.statement, cause);
    }

    public SQLException create(String message, String sqlState) {
        return ExceptionFactory.createException(message, sqlState, -1, this.threadId, this.options, this.connection, this.statement, null);
    }

    public SQLException create(String message, String sqlState, Exception cause) {
        return ExceptionFactory.createException(message, sqlState, -1, this.threadId, this.options, this.connection, this.statement, cause);
    }

    public SQLException create(String message, String sqlState, int errorCode) {
        return ExceptionFactory.createException(message, sqlState, errorCode, this.threadId, this.options, this.connection, this.statement, null);
    }

    public SQLException create(String message, String sqlState, int errorCode, Exception cause) {
        return ExceptionFactory.createException(message, sqlState, errorCode, this.threadId, this.options, this.connection, this.statement, cause);
    }

    public long getThreadId() {
        return this.threadId;
    }

    public Options getOptions() {
        return this.options;
    }

    public String toString() {
        return "ExceptionFactory{threadId=" + this.threadId + '}';
    }
}

