/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.protocol;

import java.io.IOException;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import org.mariadb.jdbc.internal.ColumnType;
import org.mariadb.jdbc.internal.com.read.dao.Results;
import org.mariadb.jdbc.internal.com.send.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.io.output.PacketOutputStream;
import org.mariadb.jdbc.internal.protocol.AsyncMultiRead;
import org.mariadb.jdbc.internal.protocol.AsyncMultiReadResult;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.util.BulkStatus;
import org.mariadb.jdbc.internal.util.SqlStates;
import org.mariadb.jdbc.internal.util.dao.ClientPrepareResult;
import org.mariadb.jdbc.internal.util.dao.PrepareResult;
import org.mariadb.jdbc.internal.util.dao.ServerPrepareResult;

public abstract class AbstractMultiSend {
    private final Protocol protocol;
    private final PacketOutputStream writer;
    private final Results results;
    private final boolean binaryProtocol;
    protected int statementId = -1;
    protected ColumnType[] parameterTypeHeader;
    private List<ParameterHolder[]> parametersList;
    private PrepareResult prepareResult;
    private List<String> queries;
    private String sql;
    private ThreadPoolExecutor readScheduler;

    public AbstractMultiSend(Protocol protocol, PacketOutputStream writer, Results results, ServerPrepareResult serverPrepareResult, List<ParameterHolder[]> parametersList, String sql, ThreadPoolExecutor readScheduler) {
        this.protocol = protocol;
        this.writer = writer;
        this.results = results;
        this.prepareResult = serverPrepareResult;
        this.parametersList = parametersList;
        this.binaryProtocol = true;
        this.sql = sql;
        this.readScheduler = readScheduler;
    }

    public AbstractMultiSend(Protocol protocol, PacketOutputStream writer, Results results, ClientPrepareResult clientPrepareResult, List<ParameterHolder[]> parametersList, ThreadPoolExecutor readScheduler) {
        this.protocol = protocol;
        this.writer = writer;
        this.results = results;
        this.prepareResult = clientPrepareResult;
        this.parametersList = parametersList;
        this.binaryProtocol = false;
        this.readScheduler = readScheduler;
    }

    public AbstractMultiSend(Protocol protocol, PacketOutputStream writer, Results results, List<String> queries, ThreadPoolExecutor readScheduler) {
        this.protocol = protocol;
        this.writer = writer;
        this.results = results;
        this.queries = queries;
        this.binaryProtocol = false;
        this.readScheduler = readScheduler;
    }

    public abstract void sendCmd(PacketOutputStream var1, Results var2, List<ParameterHolder[]> var3, List<String> var4, int var5, BulkStatus var6, PrepareResult var7) throws SQLException, IOException;

    public abstract SQLException handleResultException(SQLException var1, Results var2, List<ParameterHolder[]> var3, List<String> var4, int var5, int var6, int var7, PrepareResult var8);

    public abstract int getParamCount();

    public abstract int getTotalExecutionNumber();

    public PrepareResult getPrepareResult() {
        return this.prepareResult;
    }

    public void executeBatch() throws SQLException {
        int paramCount = this.getParamCount();
        if (this.binaryProtocol) {
            this.parameterTypeHeader = new ColumnType[paramCount];
            this.statementId = ((ServerPrepareResult)this.prepareResult).getStatementId();
        }
        this.executeBatchStandard(paramCount);
    }

    private void executeBatchStandard(int estimatedParameterCount) throws SQLException {
        int totalExecutionNumber = this.getTotalExecutionNumber();
        SQLException exception = null;
        BulkStatus status = new BulkStatus();
        FutureTask<AsyncMultiReadResult> futureReadTask = null;
        int paramCount = estimatedParameterCount;
        try {
            do {
                status.sendEnded = false;
                status.sendSubCmdCounter = 0;
                int requestNumberByBulk = Math.min(totalExecutionNumber - status.sendCmdCounter, this.protocol.getOptions().useBatchMultiSendNumber);
                this.protocol.changeSocketTcpNoDelay(false);
                boolean useCurrentThread = false;
                while (status.sendSubCmdCounter < requestNumberByBulk) {
                    this.sendCmd(this.writer, this.results, this.parametersList, this.queries, paramCount, status, this.prepareResult);
                    ++status.sendSubCmdCounter;
                    ++status.sendCmdCounter;
                    if (useCurrentThread) {
                        try {
                            this.protocol.getResult(this.results);
                        }
                        catch (SQLException qex) {
                            if (!this.protocol.getOptions().continueBatchOnError) {
                                throw qex;
                            }
                            if (exception != null) continue;
                            exception = qex;
                        }
                        continue;
                    }
                    if (futureReadTask != null) continue;
                    try {
                        futureReadTask = new FutureTask<AsyncMultiReadResult>(new AsyncMultiRead(status, this.protocol, this, paramCount, this.results, this.parametersList, this.queries, this.prepareResult));
                        this.readScheduler.execute(futureReadTask);
                    }
                    catch (RejectedExecutionException r2) {
                        useCurrentThread = true;
                        try {
                            this.protocol.getResult(this.results);
                        }
                        catch (SQLException qex) {
                            if (!this.protocol.getOptions().continueBatchOnError) {
                                throw qex;
                            }
                            if (exception != null) continue;
                            exception = qex;
                        }
                    }
                }
                status.sendEnded = true;
                if (!useCurrentThread) {
                    this.protocol.changeSocketTcpNoDelay(this.protocol.getOptions().tcpNoDelay);
                    try {
                        AsyncMultiReadResult asyncMultiReadResult = (AsyncMultiReadResult)futureReadTask.get();
                        if (asyncMultiReadResult.getException() != null && exception == null) {
                            exception = asyncMultiReadResult.getException();
                        }
                    }
                    catch (ExecutionException executionException) {
                        if (executionException.getCause() == null) {
                            throw new SQLException("Error reading results " + executionException.getMessage());
                        }
                        throw new SQLException("Error reading results " + executionException.getCause().getMessage());
                    }
                    catch (InterruptedException interruptedException) {
                        this.protocol.setActiveFutureTask(futureReadTask);
                        Thread.currentThread().interrupt();
                        throw new SQLException("Interrupted awaiting response ", SqlStates.INTERRUPTED_EXCEPTION.getSqlState(), interruptedException);
                    }
                    finally {
                        this.protocol.forceReleaseWaitingPrepareStatement();
                    }
                }
                if (this.protocol.isInterrupted()) {
                    futureReadTask.cancel(true);
                    throw new SQLTimeoutException("Timeout during batch execution");
                }
                futureReadTask = null;
            } while (status.sendCmdCounter < totalExecutionNumber);
            if (exception != null) {
                throw exception;
            }
        }
        catch (IOException e2) {
            status.sendEnded = true;
            status.sendCmdCounter = 0;
            throw this.protocol.handleIoException(e2);
        }
    }
}

