/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.failover;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.concurrent.locks.ReentrantLock;
import org.mariadb.jdbc.HostAddress;
import org.mariadb.jdbc.MariaDbConnection;
import org.mariadb.jdbc.MariaDbStatement;
import org.mariadb.jdbc.internal.failover.HandleErrorResult;
import org.mariadb.jdbc.internal.failover.Listener;
import org.mariadb.jdbc.internal.io.LruTraceCache;
import org.mariadb.jdbc.internal.logging.Logger;
import org.mariadb.jdbc.internal.logging.LoggerFactory;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.util.dao.ServerPrepareResult;
import org.mariadb.jdbc.internal.util.exceptions.ExceptionFactory;

public class FailoverProxy
implements InvocationHandler {
    private static final String METHOD_IS_EXPLICIT_CLOSED = "isExplicitClosed";
    private static final String METHOD_GET_OPTIONS = "getOptions";
    private static final String METHOD_GET_URLPARSER = "getUrlParser";
    private static final String METHOD_GET_PROXY = "getProxy";
    private static final String METHOD_EXECUTE_QUERY = "executeQuery";
    private static final String METHOD_SET_READ_ONLY = "setReadonly";
    private static final String METHOD_GET_READ_ONLY = "getReadonly";
    private static final String METHOD_IS_MASTER_CONNECTION = "isMasterConnection";
    private static final String METHOD_VERSION_GREATER_OR_EQUAL = "versionGreaterOrEqual";
    private static final String METHOD_SESSION_STATE_AWARE = "sessionStateAware";
    private static final String METHOD_CLOSED_EXPLICIT = "closeExplicit";
    private static final String METHOD_ABORT = "abort";
    private static final String METHOD_IS_CLOSED = "isClosed";
    private static final String METHOD_EXECUTE_PREPARED_QUERY = "executePreparedQuery";
    private static final String METHOD_COM_MULTI_PREPARE_EXECUTES = "prepareAndExecutesComMulti";
    private static final String METHOD_PROLOG_PROXY = "prologProxy";
    private static final String METHOD_RESET = "reset";
    private static final String METHOD_IS_VALID = "isValid";
    private static final String METHOD_GET_LOCK = "getLock";
    private static final String METHOD_GET_NO_BACKSLASH = "noBackslashEscapes";
    private static final String METHOD_GET_SERVER_THREAD_ID = "getServerThreadId";
    private static final String METHOD_PROLOG = "prolog";
    private static final String METHOD_GET_CATALOG = "getCatalog";
    private static final String METHOD_GET_TIMEOUT = "getTimeout";
    private static final String METHOD_GET_MAJOR_VERSION = "getMajorServerVersion";
    private static final String METHOD_IN_TRANSACTION = "inTransaction";
    private static final String METHOD_IS_MARIADB = "isServerMariaDb";
    private static final Logger logger = LoggerFactory.getLogger(FailoverProxy.class);
    public final ReentrantLock lock;
    public final LruTraceCache traceCache;
    private final Listener listener;

    public FailoverProxy(Listener listener, ReentrantLock lock, LruTraceCache traceCache) throws SQLException {
        this.lock = lock;
        this.listener = listener;
        this.listener.setProxy(this);
        this.traceCache = traceCache;
        this.listener.initializeConnection();
    }

    private static SQLException addHostInformationToException(SQLException exception, Protocol protocol) {
        if (protocol != null) {
            return new SQLException(exception.getMessage() + "\non " + protocol.getHostAddress().toString() + ",master=" + protocol.isMasterConnection(), exception.getSQLState(), exception.getErrorCode(), exception.getCause());
        }
        return exception;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName;
        switch (methodName = method.getName()) {
            case "getLock": {
                return this.lock;
            }
            case "noBackslashEscapes": {
                return this.listener.noBackslashEscapes();
            }
            case "isServerMariaDb": {
                return this.listener.isServerMariaDb();
            }
            case "getCatalog": {
                return this.listener.getCatalog();
            }
            case "getTimeout": {
                return this.listener.getTimeout();
            }
            case "versionGreaterOrEqual": {
                return this.listener.versionGreaterOrEqual((Integer)args[0], (Integer)args[1], (Integer)args[2]);
            }
            case "sessionStateAware": {
                return this.listener.sessionStateAware();
            }
            case "isExplicitClosed": {
                return this.listener.isExplicitClosed();
            }
            case "getOptions": {
                return this.listener.getUrlParser().getOptions();
            }
            case "getMajorServerVersion": {
                return this.listener.getMajorServerVersion();
            }
            case "getServerThreadId": {
                return this.listener.getServerThreadId();
            }
            case "getUrlParser": {
                return this.listener.getUrlParser();
            }
            case "getProxy": {
                return this;
            }
            case "isClosed": {
                return this.listener.isClosed();
            }
            case "isValid": {
                return this.listener.isValid((Integer)args[0]);
            }
            case "prolog": {
                this.listener.prolog((Long)args[0], (MariaDbConnection)args[2], (MariaDbStatement)args[3]);
                return null;
            }
            case "executeQuery": {
                boolean isClosed = this.listener.isClosed();
                try {
                    this.listener.preExecute();
                    break;
                }
                catch (SQLException e2) {
                    if (!this.hasToHandleFailover(e2)) break;
                    return this.handleFailOver(e2, method, args, this.listener.getCurrentProtocol(), isClosed);
                }
            }
            case "setReadonly": {
                this.listener.switchReadOnlyConnection((Boolean)args[0]);
                return null;
            }
            case "getReadonly": {
                return this.listener.isReadOnly();
            }
            case "inTransaction": {
                return this.listener.inTransaction();
            }
            case "isMasterConnection": {
                return this.listener.isMasterConnection();
            }
            case "abort": {
                this.listener.preAbort();
                return null;
            }
            case "closeExplicit": {
                this.listener.preClose();
                return null;
            }
            case "prepareAndExecutesComMulti": 
            case "executePreparedQuery": {
                boolean mustBeOnMaster = (Boolean)args[0];
                ServerPrepareResult serverPrepareResult = (ServerPrepareResult)args[1];
                if (serverPrepareResult == null) break;
                if (!mustBeOnMaster && serverPrepareResult.getUnProxiedProtocol().isMasterConnection() && !this.listener.hasHostFail()) {
                    try {
                        logger.trace("re-prepare query \"{}\" on replica (was temporary on master since failover)", (Object)serverPrepareResult.getSql());
                        this.listener.rePrepareOnReplica(serverPrepareResult, false);
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                boolean wasClosed = this.listener.isClosed();
                try {
                    return this.listener.invoke(method, args, serverPrepareResult.getUnProxiedProtocol());
                }
                catch (InvocationTargetException e3) {
                    if (e3.getTargetException() != null) {
                        if (e3.getTargetException() instanceof SQLException && this.hasToHandleFailover((SQLException)e3.getTargetException())) {
                            return this.handleFailOver((SQLException)e3.getTargetException(), method, args, serverPrepareResult.getUnProxiedProtocol(), wasClosed);
                        }
                        throw e3.getTargetException();
                    }
                    throw e3;
                }
            }
            case "prologProxy": {
                boolean wasClosed = this.listener.isClosed();
                try {
                    if (args[0] != null) {
                        return this.listener.invoke(method, args, ((ServerPrepareResult)args[0]).getUnProxiedProtocol());
                    }
                    return null;
                }
                catch (InvocationTargetException e4) {
                    if (e4.getTargetException() != null) {
                        if (e4.getTargetException() instanceof SQLException && this.hasToHandleFailover((SQLException)e4.getTargetException())) {
                            return this.handleFailOver((SQLException)e4.getTargetException(), method, args, ((ServerPrepareResult)args[0]).getUnProxiedProtocol(), wasClosed);
                        }
                        throw e4.getTargetException();
                    }
                    throw e4;
                }
            }
            case "reset": {
                this.listener.reset();
                return null;
            }
        }
        return this.executeInvocation(method, args, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeInvocation(Method method, Object[] args, boolean isSecondExecution) throws Throwable {
        boolean isClosed = this.listener.isClosed();
        try {
            return this.listener.invoke(method, args);
        }
        catch (InvocationTargetException e2) {
            if (e2.getTargetException() != null) {
                if (e2.getTargetException() instanceof SQLException) {
                    boolean killCmd;
                    SQLException queryException = (SQLException)e2.getTargetException();
                    Protocol protocol = this.listener.getCurrentProtocol();
                    boolean bl = killCmd = (queryException = FailoverProxy.addHostInformationToException(queryException, protocol)) != null && queryException.getSQLState() != null && queryException.getSQLState().equals("70100") && 1927 == queryException.getErrorCode();
                    if (killCmd) {
                        this.handleFailOver(queryException, method, args, protocol, isClosed);
                        return null;
                    }
                    if (this.hasToHandleFailover(queryException)) {
                        return this.handleFailOver(queryException, method, args, protocol, isClosed);
                    }
                    if (queryException.getErrorCode() == 1290 && !isSecondExecution && protocol != null && protocol.isMasterConnection() && !protocol.checkIfMaster()) {
                        boolean isReconnected;
                        boolean inTransaction = protocol.inTransaction();
                        this.lock.lock();
                        try {
                            protocol.close();
                            isReconnected = this.listener.primaryFail(null, null, (boolean)false, (boolean)isClosed).isReconnected;
                        }
                        finally {
                            this.lock.unlock();
                        }
                        if (isReconnected && !inTransaction) {
                            return this.executeInvocation(method, args, true);
                        }
                        return this.handleFailOver(queryException, method, args, this.listener.getCurrentProtocol(), isClosed);
                    }
                }
                throw e2.getTargetException();
            }
            throw e2;
        }
    }

    private Object handleFailOver(SQLException qe, Method method, Object[] args, Protocol protocol, boolean isClosed) throws Throwable {
        HostAddress failHostAddress = null;
        boolean failIsMaster = true;
        if (protocol != null) {
            failHostAddress = protocol.getHostAddress();
            failIsMaster = protocol.isMasterConnection();
        }
        HandleErrorResult handleErrorResult = this.listener.handleFailover(qe, method, args, protocol, isClosed);
        if (handleErrorResult.mustThrowError) {
            this.listener.throwFailoverMessage(failHostAddress, failIsMaster, qe, handleErrorResult.isReconnected);
        }
        return handleErrorResult.resultObject;
    }

    public boolean hasToHandleFailover(SQLException exception) {
        return exception.getSQLState() != null && (exception.getSQLState().startsWith("08") || exception.getSQLState().equals("70100") && 1927 == exception.getErrorCode());
    }

    public void reconnect() throws SQLException {
        try {
            this.listener.reconnect();
        }
        catch (SQLException e2) {
            throw ExceptionFactory.INSTANCE.create(e2);
        }
    }

    public Listener getListener() {
        return this.listener;
    }
}

