/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.com.send.authentication;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.mariadb.jdbc.authentication.AuthenticationPlugin;
import org.mariadb.jdbc.internal.com.read.Buffer;
import org.mariadb.jdbc.internal.io.input.PacketInputStream;
import org.mariadb.jdbc.internal.io.output.PacketOutputStream;
import org.mariadb.jdbc.internal.util.Utils;
import org.mariadb.jdbc.util.Options;

public class NativePasswordPlugin
implements AuthenticationPlugin {
    public static final String TYPE = "mysql_native_password";
    private String authenticationData;
    private String passwordCharacterEncoding;
    private byte[] seed;

    @Override
    public String name() {
        return "mysql native password";
    }

    @Override
    public String type() {
        return TYPE;
    }

    @Override
    public void initialize(String authenticationData, byte[] seed, Options options) {
        this.seed = seed;
        this.authenticationData = authenticationData;
        this.passwordCharacterEncoding = options.passwordCharacterEncoding;
    }

    @Override
    public Buffer process(PacketOutputStream out, PacketInputStream in, AtomicInteger sequence) throws IOException {
        if (this.authenticationData == null || this.authenticationData.isEmpty()) {
            out.writeEmptyPacket(sequence.incrementAndGet());
        } else {
            try {
                out.startPacket(sequence.incrementAndGet());
                byte[] truncatedSeed = this.seed.length > 0 ? Arrays.copyOfRange(this.seed, 0, this.seed.length - 1) : new byte[]{};
                out.write(Utils.encryptPassword(this.authenticationData, truncatedSeed, this.passwordCharacterEncoding));
                out.flush();
            }
            catch (NoSuchAlgorithmException e2) {
                throw new RuntimeException("Could not use SHA-1, failing", e2);
            }
        }
        Buffer buffer = in.getPacket(true);
        sequence.set(in.getLastPacketSeq());
        return buffer;
    }
}

