/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONTokener;
import org.json.XML;

public class XMLTokener
extends JSONTokener {
    public static final HashMap entity = new HashMap(8);

    public XMLTokener(String s2) {
        super(s2);
    }

    public String nextCDATA() throws JSONException {
        int i2;
        StringBuffer sb = new StringBuffer();
        do {
            char c2;
            if ((c2 = this.next()) == '\u0000') {
                throw this.syntaxError("Unclosed CDATA");
            }
            sb.append(c2);
        } while ((i2 = sb.length() - 3) < 0 || sb.charAt(i2) != ']' || sb.charAt(i2 + 1) != ']' || sb.charAt(i2 + 2) != '>');
        sb.setLength(i2);
        return sb.toString();
    }

    public Object nextContent() throws JSONException {
        char c2;
        while (Character.isWhitespace(c2 = this.next())) {
        }
        if (c2 == '\u0000') {
            return null;
        }
        if (c2 == '<') {
            return XML.LT;
        }
        StringBuffer sb = new StringBuffer();
        while (true) {
            if (c2 == '<' || c2 == '\u0000') {
                this.back();
                return sb.toString().trim();
            }
            if (c2 == '&') {
                sb.append(this.nextEntity(c2));
            } else {
                sb.append(c2);
            }
            c2 = this.next();
        }
    }

    public Object nextEntity(char a2) throws JSONException {
        char c2;
        StringBuffer sb = new StringBuffer();
        while (Character.isLetterOrDigit(c2 = this.next()) || c2 == '#') {
            sb.append(Character.toLowerCase(c2));
        }
        if (c2 != ';') {
            throw this.syntaxError("Missing ';' in XML entity: &" + sb);
        }
        String s2 = sb.toString();
        Object e2 = entity.get(s2);
        return e2 != null ? e2 : a2 + s2 + ";";
    }

    public Object nextMeta() throws JSONException {
        char c2;
        while (Character.isWhitespace(c2 = this.next())) {
        }
        switch (c2) {
            case '\u0000': {
                throw this.syntaxError("Misshaped meta tag");
            }
            case '<': {
                return XML.LT;
            }
            case '>': {
                return XML.GT;
            }
            case '/': {
                return XML.SLASH;
            }
            case '=': {
                return XML.EQ;
            }
            case '!': {
                return XML.BANG;
            }
            case '?': {
                return XML.QUEST;
            }
            case '\"': 
            case '\'': {
                char q2 = c2;
                do {
                    if ((c2 = this.next()) != '\u0000') continue;
                    throw this.syntaxError("Unterminated string");
                } while (c2 != q2);
                return Boolean.TRUE;
            }
        }
        while (!Character.isWhitespace(c2 = this.next())) {
            switch (c2) {
                case '\u0000': 
                case '!': 
                case '\"': 
                case '\'': 
                case '/': 
                case '<': 
                case '=': 
                case '>': 
                case '?': {
                    this.back();
                    return Boolean.TRUE;
                }
            }
        }
        return Boolean.TRUE;
    }

    public Object nextToken() throws JSONException {
        char c2;
        while (Character.isWhitespace(c2 = this.next())) {
        }
        switch (c2) {
            case '\u0000': {
                throw this.syntaxError("Misshaped element");
            }
            case '<': {
                throw this.syntaxError("Misplaced '<'");
            }
            case '>': {
                return XML.GT;
            }
            case '/': {
                return XML.SLASH;
            }
            case '=': {
                return XML.EQ;
            }
            case '!': {
                return XML.BANG;
            }
            case '?': {
                return XML.QUEST;
            }
            case '\"': 
            case '\'': {
                char q2 = c2;
                StringBuffer sb = new StringBuffer();
                while (true) {
                    if ((c2 = this.next()) == '\u0000') {
                        throw this.syntaxError("Unterminated string");
                    }
                    if (c2 == q2) {
                        return sb.toString();
                    }
                    if (c2 == '&') {
                        sb.append(this.nextEntity(c2));
                        continue;
                    }
                    sb.append(c2);
                }
            }
        }
        StringBuffer sb = new StringBuffer();
        while (true) {
            sb.append(c2);
            c2 = this.next();
            if (Character.isWhitespace(c2)) {
                return sb.toString();
            }
            switch (c2) {
                case '\u0000': 
                case '!': 
                case '/': 
                case '=': 
                case '>': 
                case '?': 
                case '[': 
                case ']': {
                    this.back();
                    return sb.toString();
                }
                case '\"': 
                case '\'': 
                case '<': {
                    throw this.syntaxError("Bad character in a name");
                }
            }
        }
    }

    static {
        entity.put("amp", XML.AMP);
        entity.put("apos", XML.APOS);
        entity.put("gt", XML.GT);
        entity.put("lt", XML.LT);
        entity.put("quot", XML.QUOT);
    }
}

