/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XMLTokener;

public class XML {
    public static final Character AMP = new Character('&');
    public static final Character APOS = new Character('\'');
    public static final Character BANG = new Character('!');
    public static final Character EQ = new Character('=');
    public static final Character GT = new Character('>');
    public static final Character LT = new Character('<');
    public static final Character QUEST = new Character('?');
    public static final Character QUOT = new Character('\"');
    public static final Character SLASH = new Character('/');

    public static String escape(String string) {
        StringBuffer sb = new StringBuffer();
        int len = string.length();
        block6: for (int i2 = 0; i2 < len; ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block6;
                }
                default: {
                    sb.append(c2);
                }
            }
        }
        return sb.toString();
    }

    private static boolean parse(XMLTokener x2, JSONObject context, String name) throws JSONException {
        String s2;
        JSONObject o2 = null;
        Object t2 = x2.nextToken();
        if (t2 == BANG) {
            char c2 = x2.next();
            if (c2 == '-') {
                if (x2.next() == '-') {
                    x2.skipPast("-->");
                    return false;
                }
                x2.back();
            } else if (c2 == '[') {
                t2 = x2.nextToken();
                if (t2.equals("CDATA") && x2.next() == '[') {
                    String s3 = x2.nextCDATA();
                    if (s3.length() > 0) {
                        context.accumulate("content", s3);
                    }
                    return false;
                }
                throw x2.syntaxError("Expected 'CDATA['");
            }
            int i2 = 1;
            do {
                if ((t2 = x2.nextMeta()) == null) {
                    throw x2.syntaxError("Missing '>' after '<!'.");
                }
                if (t2 == LT) {
                    ++i2;
                    continue;
                }
                if (t2 != GT) continue;
                --i2;
            } while (i2 > 0);
            return false;
        }
        if (t2 == QUEST) {
            x2.skipPast("?>");
            return false;
        }
        if (t2 == SLASH) {
            t2 = x2.nextToken();
            if (name == null) {
                throw x2.syntaxError("Mismatched close tag" + t2);
            }
            if (!t2.equals(name)) {
                throw x2.syntaxError("Mismatched " + name + " and " + t2);
            }
            if (x2.nextToken() != GT) {
                throw x2.syntaxError("Misshaped close tag");
            }
            return true;
        }
        if (t2 instanceof Character) {
            throw x2.syntaxError("Misshaped tag");
        }
        String n2 = (String)t2;
        t2 = null;
        o2 = new JSONObject();
        while (true) {
            if (t2 == null) {
                t2 = x2.nextToken();
            }
            if (!(t2 instanceof String)) break;
            s2 = (String)t2;
            t2 = x2.nextToken();
            if (t2 == EQ) {
                t2 = x2.nextToken();
                if (!(t2 instanceof String)) {
                    throw x2.syntaxError("Missing value");
                }
                o2.accumulate(s2, t2);
                t2 = null;
                continue;
            }
            o2.accumulate(s2, "");
        }
        if (t2 == SLASH) {
            if (x2.nextToken() != GT) {
                throw x2.syntaxError("Misshaped tag");
            }
            context.accumulate(n2, o2);
            return false;
        }
        if (t2 == GT) {
            while (true) {
                if ((t2 = x2.nextContent()) == null) {
                    if (n2 != null) {
                        throw x2.syntaxError("Unclosed tag " + n2);
                    }
                    return false;
                }
                if (t2 instanceof String) {
                    s2 = (String)t2;
                    if (s2.length() <= 0) continue;
                    o2.accumulate("content", s2);
                    continue;
                }
                if (t2 == LT && XML.parse(x2, o2, n2)) break;
            }
            if (o2.length() == 0) {
                context.accumulate(n2, "");
            } else if (o2.length() == 1 && o2.opt("content") != null) {
                context.accumulate(n2, o2.opt("content"));
            } else {
                context.accumulate(n2, o2);
            }
            return false;
        }
        throw x2.syntaxError("Misshaped tag");
    }

    public static JSONObject toJSONObject(String string) throws JSONException {
        JSONObject o2 = new JSONObject();
        XMLTokener x2 = new XMLTokener(string);
        while (x2.more() && x2.skipPast("<")) {
            XML.parse(x2, o2, null);
        }
        return o2;
    }

    public static String toString(Object o2) throws JSONException {
        return XML.toString(o2, null);
    }

    public static String toString(Object o2, String tagName) throws JSONException {
        String s2;
        StringBuffer b2 = new StringBuffer();
        if (o2 instanceof JSONObject) {
            if (tagName != null) {
                b2.append('<');
                b2.append(tagName);
                b2.append('>');
            }
            JSONObject jo = (JSONObject)o2;
            Iterator keys = jo.keys();
            while (keys.hasNext()) {
                int i2;
                int len;
                JSONArray ja;
                String k2 = keys.next().toString();
                Object v2 = jo.get(k2);
                String s3 = v2 instanceof String ? (String)v2 : null;
                if (k2.equals("content")) {
                    if (v2 instanceof JSONArray) {
                        ja = (JSONArray)v2;
                        len = ja.length();
                        for (i2 = 0; i2 < len; ++i2) {
                            if (i2 > 0) {
                                b2.append('\n');
                            }
                            b2.append(XML.escape(ja.get(i2).toString()));
                        }
                        continue;
                    }
                    b2.append(XML.escape(v2.toString()));
                    continue;
                }
                if (v2 instanceof JSONArray) {
                    ja = (JSONArray)v2;
                    len = ja.length();
                    for (i2 = 0; i2 < len; ++i2) {
                        b2.append(XML.toString(ja.get(i2), k2));
                    }
                    continue;
                }
                if (v2.equals("")) {
                    b2.append('<');
                    b2.append(k2);
                    b2.append("/>");
                    continue;
                }
                b2.append(XML.toString(v2, k2));
            }
            if (tagName != null) {
                b2.append("</");
                b2.append(tagName);
                b2.append('>');
            }
            return b2.toString();
        }
        if (o2 instanceof JSONArray) {
            JSONArray ja = (JSONArray)o2;
            int len = ja.length();
            for (int i3 = 0; i3 < len; ++i3) {
                b2.append(XML.toString(ja.opt(i3), tagName == null ? "array" : tagName));
            }
            return b2.toString();
        }
        String string = s2 = o2 == null ? "null" : XML.escape(o2.toString());
        return tagName == null ? "\"" + s2 + "\"" : (s2.length() == 0 ? "<" + tagName + "/>" : "<" + tagName + ">" + s2 + "</" + tagName + ">");
    }
}

